/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.starter.factory.impl;

import com.jdaz.sinosoftgz.apis.business.app.starter.config.HandlerFactoryProperties;
import com.jdaz.sinosoftgz.apis.business.app.starter.config.InsureHandlerRouteProperties;
import com.jdaz.sinosoftgz.apis.business.app.starter.factory.AbstractBusinessHandlerFactory;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderHeader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="insureHandlerFactory")
public class SpringBootPropertyBusinessHandlerFactory
extends AbstractBusinessHandlerFactory {
    private static final Logger log = LoggerFactory.getLogger(SpringBootPropertyBusinessHandlerFactory.class);
    private final HandlerFactoryProperties handlerFactoryProperties;

    @Autowired
    public SpringBootPropertyBusinessHandlerFactory(HandlerFactoryProperties handlerFactoryProperties) {
        this.handlerFactoryProperties = handlerFactoryProperties;
    }

    @Override
    public Optional<BusinessHandler> get(String bussinessType, StanderHeader requestHead) {
        List selectedRoutes;
        Map<String, List<InsureHandlerRouteProperties>> handlerRoutesMap = this.handlerFactoryProperties.getFactory();
        List<InsureHandlerRouteProperties> handlerRouteList = handlerRoutesMap.get(bussinessType);
        if (handlerRouteList != null && (selectedRoutes = handlerRouteList.stream().filter(route -> {
            List<String> keys = Arrays.asList(route.getChannelCodes().split(","));
            return route.getIsDefault() != false || keys.contains(requestHead.getChannelCode());
        }).collect(Collectors.toList())).size() > 0) {
            InsureHandlerRouteProperties route2 = (InsureHandlerRouteProperties)selectedRoutes.get(selectedRoutes.size() - 1);
            try {
                return super.getHandler(route2.getHandlerClass(), Class.forName(route2.getHandlerClass()));
            }
            catch (InstantiationException e) {
                log.error("error:", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error("error:", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                log.error("error:", (Throwable)e);
            }
        }
        return Optional.empty();
    }
}

