/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.starter.filter;

import com.jdaz.sinosoftgz.apis.business.app.starter.filter.InjectionAttackWrapper;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;

public class InjectionAttackFilter
implements Filter {
    private static final String X_FRAME_VALUE = "SAMEORIGIN";
    private static final String X_FRAME_HEADER = "X-FRAME-OPTIONS";
    public static final String FILTER_XSS_PARAM_NAME = "filter_xss";
    public static final String FILTER_SQL_INJECTION_PARAM_NAME = "filter_sql_injection";
    public static final String CLICK_JACKING_HEADER = "click_jacking_header";
    boolean filterXss = true;
    boolean filterSql = true;
    boolean clickJacking = true;

    public void setFilterXss(boolean filterXss) {
        this.filterXss = filterXss;
    }

    public void setFilterSql(boolean filterSql) {
        this.filterSql = filterSql;
    }

    public void setClickJacking(boolean clickJacking) {
        this.clickJacking = clickJacking;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest) {
            InjectionAttackWrapper wrapper = new InjectionAttackWrapper((HttpServletRequest)servletRequest, this.filterXss, this.filterSql);
            this.filterClickJack(servletResponse);
            filterChain.doFilter((ServletRequest)wrapper, servletResponse);
        } else {
            this.filterClickJack(servletResponse);
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    private void filterClickJack(ServletResponse servletResponse) {
        HttpServletResponse httpServletResponse;
        if (this.clickJacking && servletResponse instanceof HttpServletResponse && !(httpServletResponse = (HttpServletResponse)servletResponse).containsHeader(X_FRAME_HEADER)) {
            httpServletResponse.addHeader(X_FRAME_HEADER, X_FRAME_VALUE);
        }
    }

    public void init(FilterConfig config) throws ServletException {
        String filterXssParam = config.getInitParameter(FILTER_XSS_PARAM_NAME);
        String filterSqlParam = config.getInitParameter(FILTER_SQL_INJECTION_PARAM_NAME);
        String clickJackingParam = config.getInitParameter(CLICK_JACKING_HEADER);
        if (StringUtils.hasText((String)filterXssParam)) {
            this.filterXss = new Boolean(filterXssParam);
        }
        if (StringUtils.hasText((String)filterSqlParam)) {
            this.filterSql = new Boolean(filterSqlParam);
        }
        if (StringUtils.hasText((String)clickJackingParam)) {
            this.clickJacking = new Boolean(clickJackingParam);
        }
    }
}

