/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.starter.filter;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class InjectionAttackWrapper
extends HttpServletRequestWrapper {
    private static final String EVENTS = "((?i)onload|onunload|onchange|onsubmit|onreset|onselect|onblur|onfocus|onkeydown|onkeypress|onkeyup|onclick|ondblclick|onmousedown|onmousemove|onmouseout|onmouseover|onmouseup)";
    private static final String XSS_HTML_TAG = "(%3C)|(%3E)|[<>]+";
    private static final String XSS_INJECTION = "((%22%20)|(%22\\s)|('%22)|(%22\\+))\\w.*|(\\s|%20)((?i)onload|onunload|onchange|onsubmit|onreset|onselect|onblur|onfocus|onkeydown|onkeypress|onkeyup|onclick|ondblclick|onmousedown|onmousemove|onmouseout|onmouseover|onmouseup).*|(%3D)|(%7C)";
    private static final String XSS_REGEX = "(%3C)|(%3E)|[<>]+|((%22%20)|(%22\\s)|('%22)|(%22\\+))\\w.*|(\\s|%20)((?i)onload|onunload|onchange|onsubmit|onreset|onselect|onblur|onfocus|onkeydown|onkeypress|onkeyup|onclick|ondblclick|onmousedown|onmousemove|onmouseout|onmouseover|onmouseup).*|(%3D)|(%7C)";
    private static final String SQL_REGEX = "('.+--)|(--)|(\\|)|(%7C)";
    boolean filterXss = true;
    boolean filterSql = true;

    public InjectionAttackWrapper(HttpServletRequest request, boolean filterXss, boolean filterSql) {
        super(request);
        this.filterXss = filterXss;
        this.filterSql = filterSql;
    }

    public InjectionAttackWrapper(HttpServletRequest request) {
        this(request, true, true);
    }

    public String getParameter(String name) {
        String value = super.getParameter(name);
        return this.filterParamString(value);
    }

    public Map<String, String[]> getParameterMap() {
        Map rawMap = super.getParameterMap();
        HashMap<String, String[]> filteredMap = new HashMap<String, String[]>(rawMap.size());
        Set keys = rawMap.keySet();
        for (String key : keys) {
            String[] rawValue = (String[])rawMap.get(key);
            String[] filteredValue = this.filterStringArray(rawValue);
            filteredMap.put(key, filteredValue);
        }
        return filteredMap;
    }

    protected String[] filterStringArray(String[] rawValue) {
        String[] filteredArray = new String[rawValue.length];
        for (int i = 0; i < rawValue.length; ++i) {
            filteredArray[i] = this.filterParamString(rawValue[i]);
        }
        return filteredArray;
    }

    public String[] getParameterValues(String name) {
        String[] rawValues = super.getParameterValues(name);
        if (rawValues == null) {
            return null;
        }
        String[] filteredValues = new String[rawValues.length];
        for (int i = 0; i < rawValues.length; ++i) {
            filteredValues[i] = this.filterParamString(rawValues[i]);
        }
        return filteredValues;
    }

    protected String filterParamString(String rawValue) {
        if (rawValue == null) {
            return null;
        }
        if (this.filterXss()) {
            rawValue = rawValue.replaceAll(XSS_REGEX, "");
        }
        if (this.filterSql()) {
            rawValue = rawValue.replaceAll(SQL_REGEX, "");
        }
        return rawValue;
    }

    public Cookie[] getCookies() {
        Cookie[] existingCookies = super.getCookies();
        if (existingCookies != null) {
            for (int i = 0; i < existingCookies.length; ++i) {
                Cookie cookie = existingCookies[i];
                cookie.setValue(this.filterParamString(cookie.getValue()));
            }
        }
        return existingCookies;
    }

    public String getQueryString() {
        return this.filterParamString(super.getQueryString());
    }

    protected boolean filterXss() {
        return this.filterXss;
    }

    protected boolean filterSql() {
        return this.filterSql;
    }
}

