/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.starter.service.impl;

import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.BusinessHandlerNotFoundExcepiton;
import com.jdaz.sinosoftgz.apis.business.app.starter.factory.BudinessHandlerFactory;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiRequestRegistService;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.service.RuleExecutorService;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApisBusinessServiceImpl
implements ApisBusinessService {
    private final BudinessHandlerFactory budinessHandlerFactory;
    private final RuleExecutorService ruleExecutorService;
    @Autowired
    private ApisBusiRequestRegistService apisBusiRequestRegistService;

    @Autowired
    public ApisBusinessServiceImpl(BudinessHandlerFactory budinessHandlerFactory, RuleExecutorService ruleExecutorService) {
        this.budinessHandlerFactory = budinessHandlerFactory;
        this.ruleExecutorService = ruleExecutorService;
    }

    @Override
    public StanderResponse execute(String bussinessType, StanderRequest request) throws ApisBusinessException {
        Optional<BusinessHandler> handler = this.budinessHandlerFactory.get(bussinessType, request.getHeader());
        if (handler.isPresent()) {
            BusinessHandler businessHandler = handler.get();
            request = businessHandler.dataCompletion(request);
            StanderResponse response = businessHandler.execute(request);
            response = businessHandler.beforeReturn(request, response);
            return response;
        }
        throw BusinessHandlerNotFoundExcepiton.builder().build();
    }

    @Override
    public StanderResponse calculateExecute(String bussinessType, StanderRequest request) throws ApisBusinessException {
        Optional<BusinessHandler> handler = this.budinessHandlerFactory.get(bussinessType, request.getHeader());
        if (handler.isPresent()) {
            BusinessHandler businessHandler = handler.get();
            request = businessHandler.dataCompletion(request);
            StanderResponse response = businessHandler.execute(request);
            response = businessHandler.beforeReturn(request, response);
            return response;
        }
        throw BusinessHandlerNotFoundExcepiton.builder().build();
    }
}

