/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.starter.service.impl;

import com.jdaz.sinosoftgz.apis.business.app.starter.entity.WebResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.BusinessHandlerNotFoundExcepiton;
import com.jdaz.sinosoftgz.apis.business.app.starter.factory.EcifHandlerFactory;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.EcifHandler;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.EcifService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.ecif.resp.core.EcifResponse;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EcifServiceImpl
implements EcifService {
    private final EcifHandlerFactory budinessHandlerFactory;

    @Autowired
    public EcifServiceImpl(EcifHandlerFactory budinessHandlerFactory) {
        this.budinessHandlerFactory = budinessHandlerFactory;
    }

    @Override
    public WebResponse execute(String bussinessType, StanderRequest request) throws ApisBusinessException {
        Optional<EcifHandler> handler = this.budinessHandlerFactory.get(bussinessType, request.getHeader());
        if (handler.isPresent()) {
            EcifHandler businessHandler = handler.get();
            request = businessHandler.dataCompletion(request);
            EcifResponse response = businessHandler.execute(request);
            WebResponse webResponse = businessHandler.beforeReturn(request, response);
            return webResponse;
        }
        throw BusinessHandlerNotFoundExcepiton.builder().build();
    }
}

