/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.starter.utils;

import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.commons.model.channel.mapper.ApisChannelCodeMapper;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class BaseCodeConvertUtils {
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private ApisChannelCodeMapper apisChannelCodeMapper;

    public String convertLocationCode(String locType, String provinceCode, String cityCode, String subCityCode) {
        String newLocCode = null;
        String locCode = provinceCode;
        String upperValuePrefix = null;
        String upperValue = null;
        if ("city".equals(locType)) {
            if (ObjectUtil.isNotEmpty((Object)provinceCode)) {
                upperValuePrefix = provinceCode.substring(0, 2);
            }
            upperValue = provinceCode;
            locCode = cityCode;
        }
        if ("subCity".equals(locType)) {
            if (ObjectUtil.isNotEmpty((Object)cityCode)) {
                upperValuePrefix = cityCode.substring(0, 4);
            }
            upperValue = cityCode;
            locCode = subCityCode;
        }
        StringBuffer codeType = new StringBuffer();
        codeType.append("channel:code:");
        if ("province".equals(locType)) {
            codeType.append("/:");
        }
        codeType.append(locType);
        Map<String, String> map = null;
        if ("province".equals(locType)) {
            map = this.getCodeData(codeType.toString());
        }
        if (StringUtils.isNumeric((CharSequence)locCode)) {
            newLocCode = "province".equals(locType) && map.containsValue(locCode) ? locCode : this.apisChannelCodeMapper.getValueByCodeAndUpperValuePrefix(locType, locCode, upperValue, upperValuePrefix);
        } else if ("province".equals(locType) && map.containsKey(locCode)) {
            String obj = map.get(locCode);
            if (obj instanceof String) {
                newLocCode = obj;
            }
        } else {
            newLocCode = this.apisChannelCodeMapper.getCoreValueByProvinceCode(locType, locCode, upperValue, upperValuePrefix);
        }
        return newLocCode;
    }

    public Map<String, String> getCodeData(String codeType) {
        Map map = this.redisTemplate.getConnectionFactory().getConnection().hashCommands().hGetAll(codeType.getBytes());
        HashMap<String, String> newMap = new HashMap<String, String>();
        for (Map.Entry entry : map.entrySet()) {
            byte[] key = (byte[])entry.getKey();
            byte[] value = (byte[])entry.getValue();
            String keyStr = new String(key);
            String valueStr = new String(value);
            newMap.put(keyStr, valueStr);
        }
        return newMap;
    }
}

