/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.starter.utils;

import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.StanderPacket;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDAZAesUtils {
    private static final String CHARSET = "UTF-8";
    private static final Logger log = LoggerFactory.getLogger(JDAZAesUtils.class);

    public static String encryptBase64(String seed, String content) {
        try {
            byte[] rawKey = JDAZAesUtils.getRawKey(seed.getBytes(CHARSET));
            byte[] result = JDAZAesUtils.encrypt(rawKey, content.getBytes(CHARSET));
            return Base64.encodeBase64String((byte[])result);
        }
        catch (Exception e) {
            log.error("AES\u52a0\u5bc6base64\u7f16\u7801\u51fa\u9519: content={}", (Object)content, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static String decryptBase64(String seed, String content) {
        try {
            byte[] rawKey = JDAZAesUtils.getRawKey(seed.getBytes(CHARSET));
            byte[] enc = Base64.decodeBase64((String)content);
            byte[] result = JDAZAesUtils.decrypt(rawKey, enc);
            return new String(result, CHARSET);
        }
        catch (Exception e) {
            log.error("AES\u89e3\u5bc6base64\u51fa\u9519: content={}", (Object)content, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static String des3EncodeCbc(String userCode, String publicKey) {
        byte[] keyiv = new byte[]{2, 3, 4, 5, 6, 7, 8, 9};
        try {
            String keyStr = userCode + publicKey;
            if (keyStr.length() < 24) {
                keyStr = StringUtils.leftPad((String)keyStr, (int)24, (String)publicKey.substring(0, 1));
            }
            byte[] key = keyStr.getBytes(CHARSET);
            byte[] data = userCode.getBytes(CHARSET);
            byte[] str5 = JDAZAesUtils.des3EncodeCbc(key, keyiv, data);
            return new String(Base64.encodeBase64((byte[])str5));
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6AES\u53c2\u6570\u62a5\u9519", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static byte[] getRawKey(byte[] seed) throws NoSuchAlgorithmException {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
        sr.setSeed(seed);
        kgen.init(128, sr);
        SecretKey skey = kgen.generateKey();
        return skey.getEncoded();
    }

    private static byte[] encrypt(byte[] raw, byte[] clear) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, skeySpec);
        return cipher.doFinal(clear);
    }

    private static byte[] decrypt(byte[] raw, byte[] encrypted) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, skeySpec);
        return cipher.doFinal(encrypted);
    }

    private static byte[] des3EncodeCbc(byte[] key, byte[] keyiv, byte[] data) throws Exception {
        SecretKey deskey = null;
        DESedeKeySpec spec = new DESedeKeySpec(key);
        SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("desede");
        deskey = keyfactory.generateSecret(spec);
        Cipher cipher = Cipher.getInstance("desede/CBC/PKCS5Padding");
        IvParameterSpec ips = new IvParameterSpec(keyiv);
        cipher.init(1, (Key)deskey, ips);
        return cipher.doFinal(data);
    }

    public static void main(String[] args) {
        String userCode = "AC000061_01";
        String publicKey = "bc0TYXab4UjcZiOtX9XpdQ";
        String seed = JDAZAesUtils.des3EncodeCbc(userCode, publicKey);
        String plainText = "{\"claimOpenBillServiceRequest\": {\"body\": {\"damageResult\": \"81\",\"policyNo\": \"P4400C02104010200000067\",\"regist\": {\"registDamageInfo\": {\"accidentAddress\": \"\u6cb3\u5317\u7701\u90af\u90f8\u5e02\",\"cityCode\": \"130400\",\"cityName\": \"\u90af\u90f8\u5e02\",\"country\": \"\",\"countryCode\": \"\",\"countyCode\": \"130434\",\"countyName\": \"\u9b4f\u53bf\",\"damageReasonType\": \"9\",\"damageRemark\": \"\u597d\u561f\u561f\u561f\u597d\u591a\u597d\u591a\u8bdd\u7b28\u86cb\",\"damageResult\": \"81\",\"damageTime\": 1623377100000,\"nationFlag\": \"1\",\"provinceCode\": \"130000\",\"provinceName\": \"\u6cb3\u5317\u7701\",\"reportedLoss\": 1000},\"registDamagePersonInfo\": {\"damagePersonName\": \"fhyfhuh\",\"identifyNo\": \"111111111111111111\",\"identifyType\": \"2\",\"reportorRelation\": \"04\"},\"registInfo\": {\"callId\": \"oZx1A5aMF9CyOCRE0aR1rHolRLIA\",\"linkerEmail\": \"TianguiQiu.extern@allianz.cn\",\"linkerName\": \"\u5e72\u70b9\u522b\u7684\",\"linkerPhone\": \"15626592199\",\"reportTime\": 1623377191787,\"reportType\": \"05\",\"reportorEmail\": \"TianguiQiu.extern@allianz.cn\",\"reportorName\": \"\u90b1\u5929\u6842\",\"reportorPhone\": \"15626592199\",\"reportorRelation\": \"04\"}},\"remark\": \"\u597d\u561f\u561f\u561f\u597d\u591a\u597d\u591a\u8bdd\u7b28\u86cb\",\"reportType\": \"05\",\"status\": \"0\",\"step\": \"regist\"},\"head\": {\"transDate\": 1623377192369,\"transID\": \"55121f61-72c1-424a-8a04-2354f0a52c075\",\"transType\": \"C001\",\"user\": \"SSP_USER\"}},\"header\": {\"businessKey\": \"d63602fa746e4c389907d1e5a93799fa1\",\"bussinessType\": \"open\",\"channelCode\": \"DE000134\",\"userCode\": \"SSP_USER\"}}";
        String cipherText = JDAZAesUtils.encryptBase64(seed, plainText);
        System.out.println("cipherText is: " + cipherText);
        StanderPacket standerPacket = StanderPacket.builder().userCode(userCode).content(cipherText).build();
        System.out.println("stander packet is: " + JSON.toJSONString((Object)standerPacket));
        String plainTextAfterDes = JDAZAesUtils.decryptBase64(seed, cipherText);
        System.out.println("plainTextAfterDes is: " + plainTextAfterDes);
    }
}

