/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.starter.utils;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDAesUtils {
    private static final String CHARSET = "utf-8";
    private static final Logger log = LoggerFactory.getLogger(SDAesUtils.class);

    public static String encryptBase64(String seed, String content) {
        try {
            byte[] rawKey = SDAesUtils.getRawKey(seed.getBytes(CHARSET));
            byte[] result = SDAesUtils.encrypt(rawKey, content.getBytes(CHARSET));
            return Base64.encodeBase64String((byte[])result);
        }
        catch (Exception e) {
            log.error("AES\u52a0\u5bc6base64\u7f16\u7801\u51fa\u9519: content={}", (Object)content, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static String decryptBase64(String seed, String encrypted) {
        try {
            byte[] rawKey = SDAesUtils.getRawKey(seed.getBytes(CHARSET));
            byte[] enc = Base64.decodeBase64((String)encrypted);
            byte[] result = SDAesUtils.decrypt(rawKey, enc);
            return new String(result, CHARSET);
        }
        catch (Exception e) {
            log.error("AES\u89e3\u5bc6base64\u51fa\u9519: encrypted={}", (Object)encrypted, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private static byte[] getRawKey(byte[] seed) throws NoSuchAlgorithmException {
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
        sr.setSeed(seed);
        kgen.init(128, sr);
        SecretKey skey = kgen.generateKey();
        return skey.getEncoded();
    }

    private static byte[] encrypt(byte[] raw, byte[] clear) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, skeySpec);
        return cipher.doFinal(clear);
    }

    private static byte[] decrypt(byte[] raw, byte[] encrypted) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, skeySpec);
        return cipher.doFinal(encrypted);
    }

    public static String des3EncodeCbc(String aesKey, String dtKey) {
        byte[] keyiv = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        try {
            byte[] key = Base64.decodeBase64((String)dtKey);
            byte[] data = aesKey.getBytes("UTF-8");
            byte[] str5 = SDAesUtils.des3EncodeCbc(key, keyiv, data);
            return new String(Base64.encodeBase64((byte[])str5));
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6AES\u53c2\u6570\u62a5\u9519", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static byte[] des3EncodeCbc(byte[] key, byte[] keyiv, byte[] data) throws Exception {
        SecretKey deskey = null;
        DESedeKeySpec spec = new DESedeKeySpec(key);
        SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("desede");
        deskey = keyfactory.generateSecret(spec);
        Cipher cipher = Cipher.getInstance("desede/CBC/PKCS5Padding");
        IvParameterSpec ips = new IvParameterSpec(keyiv);
        cipher.init(1, (Key)deskey, ips);
        return cipher.doFinal(data);
    }

    public static String getStringRandom(int length) {
        String val = "";
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            String charOrNum;
            String string = charOrNum = random.nextInt(2) % 2 == 0 ? "char" : "num";
            if ("char".equalsIgnoreCase(charOrNum)) {
                int temp = random.nextInt(2) % 2 == 0 ? 65 : 97;
                val = val + (char)(random.nextInt(26) + temp);
                continue;
            }
            if (!"num".equalsIgnoreCase(charOrNum)) continue;
            val = val + String.valueOf(random.nextInt(10));
        }
        return val;
    }
}

