/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.starter.utils;

import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.Resource;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ValidatorsUtils {
    private static final Logger log = LoggerFactory.getLogger(ValidatorsUtils.class);
    @Resource
    Validator validator;

    public <T> void valid(T obj) throws ApisBusinessException {
        this.valid(obj, null);
    }

    public <T> void valid(T obj, Class<?> group) throws ApisBusinessException {
        Set violations = group == null ? this.validator.validate(obj, new Class[0]) : this.validator.validate(obj, new Class[]{group});
        if (violations.stream().findFirst().isPresent()) {
            String message = "";
            String code = "";
            ConstraintViolation constraintViolation = (ConstraintViolation)violations.stream().findFirst().get();
            Class<? extends Annotation> annotationType = constraintViolation.getConstraintDescriptor().getAnnotation().annotationType();
            if (NotBlank.class.equals(annotationType) || NotEmpty.class.equals(annotationType) || NotNull.class.equals(annotationType)) {
                message = ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", constraintViolation.getPropertyPath().toString());
                code = ChannelErrorCodeEnum.ERR_C10008.getKey();
            }
            if (Email.class.equals(annotationType)) {
                message = constraintViolation.getPropertyPath().toString() + ":" + ChannelErrorCodeEnum.ERR_C10144.getValue();
                code = ChannelErrorCodeEnum.ERR_C10144.getKey();
            }
            if (constraintViolation.getMessage().equals(constraintViolation.getMessageTemplate())) {
                message = constraintViolation.getMessage();
            }
            log.error("Validator Error: code: {}, message: {}", (Object)code, (Object)message);
            throw new ApisBusinessException(message, code);
        }
    }
}

