/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.coreapi.claims.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.CommonResponseHead;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.adjustingSyn.AdjustingSynServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.caseBarCode.CaseBarCodeServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.claimNoticeInfo.resp.ClaimNoticeInfoServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.evaluate.response.EvaluateQueryResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.evaluate.response.EvaluateSaveResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.inforSupplement.InforSupplementServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.payeeInfoReceive.response.ClaimPayeeInfoReceiveResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.response.ClaimOpenBillServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.response.ClaimRegistResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.riskInfo.resp.ClaimRiskInfoServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.ylFpDiscernDataFeedback.request.MedicalCostDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.ylFpDiscernDataFeedback.request.ReceiptInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.ylFpDiscernDataFeedback.request.YlFpDiscernDataFeedbackRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.ylFpDiscernDataFeedback.response.YlFpDiscernDataFeedbackResponse;
import com.jdaz.sinosoftgz.coreapi.claims.CoreClaimsApi;
import com.jdaz.sinosoftgz.coreapi.common.service.HttpRequestService;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CoreClaimsApiImpl
implements CoreClaimsApi {
    private static final Logger log = LoggerFactory.getLogger(CoreClaimsApiImpl.class);
    @Autowired
    HttpRequestService httpRequestService;

    @Override
    public StanderResponse claimsOpenBill(StanderRequest request) {
        ClaimOpenBillServiceResponse claimOpenBillServiceResponse = (ClaimOpenBillServiceResponse)this.httpRequestService.convertAndSend("claimsOpenBill", "claimsOpenBillService", (Object)request.getClaimOpenBillServiceRequest(), ClaimOpenBillServiceResponse.class);
        return StanderResponse.builder().header(request.getHeader()).claimOpenBillServiceResponse(claimOpenBillServiceResponse).build();
    }

    @Override
    public StanderResponse claimsRiskInfo(StanderRequest request) {
        ClaimRiskInfoServiceResponse claimRiskInfoServiceResponse = (ClaimRiskInfoServiceResponse)this.httpRequestService.convertAndSend("claimRiskInfo", null, (Object)request.getClaimRiskInfoServiceRequest(), ClaimRiskInfoServiceResponse.class);
        return StanderResponse.builder().header(request.getHeader()).claimRiskInfoServiceResponse(claimRiskInfoServiceResponse).build();
    }

    @Override
    public StanderResponse claimNoticeInfo(StanderRequest request) {
        ClaimNoticeInfoServiceResponse claimNoticeInfoServiceResponse = (ClaimNoticeInfoServiceResponse)this.httpRequestService.convertAndSend("claimNoticeInfo", null, (Object)request.getClaimNoticeInfoServiceRequest(), ClaimNoticeInfoServiceResponse.class);
        return StanderResponse.builder().header(request.getHeader()).claimNoticeInfoServiceResponse(claimNoticeInfoServiceResponse).build();
    }

    @Override
    public StanderResponse evaluateQuery(StanderRequest request) {
        EvaluateQueryResponse evaluateQueryResponse = (EvaluateQueryResponse)this.httpRequestService.convertAndSend("evaluateQuery", null, (Object)request.getEvaluateQueryRequest(), EvaluateQueryResponse.class);
        return StanderResponse.builder().header(request.getHeader()).evaluateQueryResponse(evaluateQueryResponse).build();
    }

    @Override
    public StanderResponse evaluateSave(StanderRequest request) {
        EvaluateSaveResponse evaluateSaveResponse = (EvaluateSaveResponse)this.httpRequestService.convertAndSend("evaluateSave", null, (Object)request.getEvaluateSaveRequest(), EvaluateSaveResponse.class);
        return StanderResponse.builder().header(request.getHeader()).evaluateSaveResponse(evaluateSaveResponse).build();
    }

    @Override
    public StanderResponse infoSupplement(StanderRequest request) {
        InforSupplementServiceResponse inforSupplementServiceResponse = (InforSupplementServiceResponse)this.httpRequestService.convertAndSend("sdinforSupple", null, (Object)request.getInforSupplementServiceRequest(), InforSupplementServiceResponse.class);
        return StanderResponse.builder().header(request.getHeader()).inforSupplementServiceResponse(inforSupplementServiceResponse).build();
    }

    @Override
    public StanderResponse claimRegist(StanderRequest request) {
        ClaimRegistResponse claimRegistResponse = (ClaimRegistResponse)this.httpRequestService.convertAndSend("claimRegist", null, (Object)request.getClaimRegistRequest(), ClaimRegistResponse.class);
        return StanderResponse.builder().header(request.getHeader()).claimRegistResponse(claimRegistResponse).build();
    }

    @Override
    public StanderResponse claimPayeeInfoReceive(StanderRequest request) {
        ClaimPayeeInfoReceiveResponse claimPayeeInfoReceiveResponse = (ClaimPayeeInfoReceiveResponse)this.httpRequestService.convertAndSend("payeeInfoReceive", null, (Object)request.getClaimPayeeInfoReceiveRequest(), ClaimPayeeInfoReceiveResponse.class);
        return StanderResponse.builder().header(request.getHeader()).claimPayeeInfoReceiveResponse(claimPayeeInfoReceiveResponse).build();
    }

    @Override
    public StanderResponse adjustingSyn(StanderRequest request) {
        AdjustingSynServiceResponse adjustingSynServiceResponse = (AdjustingSynServiceResponse)this.httpRequestService.convertAndSend("sdAdjustingSyn", null, (Object)request.getAdjustingSynServiceRequest(), AdjustingSynServiceResponse.class);
        return StanderResponse.builder().header(request.getHeader()).adjustingSynServiceResponse(adjustingSynServiceResponse).build();
    }

    @Override
    public StanderResponse ylFpDiscernDataFeedBack(StanderRequest request) {
        YlFpDiscernDataFeedbackRequest ylFpDiscernDataFeedbackRequest = request.getYlFpDiscernDataFeedbackRequest();
        String xmlRequest = this.conversionRequest(ylFpDiscernDataFeedbackRequest);
        String responseStr = this.httpRequestService.uwInfoQueryByQuestion("ylFpDiscernDataFeedBack", xmlRequest);
        YlFpDiscernDataFeedbackResponse ylFpDiscernDataFeedbackResponse = this.conversionResponse(ylFpDiscernDataFeedbackRequest, responseStr);
        return StanderResponse.builder().header(request.getHeader()).ylFpDiscernDataFeedbackResponse(ylFpDiscernDataFeedbackResponse).build();
    }

    @Override
    public StanderResponse caseBarCode(StanderRequest request) {
        CaseBarCodeServiceResponse caseBarCodeServiceResponse = (CaseBarCodeServiceResponse)this.httpRequestService.convertAndSend("caseBarCode", null, (Object)request.getCaseBarCodeServiceRequest(), CaseBarCodeServiceResponse.class);
        return StanderResponse.builder().header(request.getHeader()).caseBarCodeServiceResponse(caseBarCodeServiceResponse).build();
    }

    private YlFpDiscernDataFeedbackResponse conversionResponse(YlFpDiscernDataFeedbackRequest ylFpDiscernDataFeedbackRequest, String responseStr) {
        YlFpDiscernDataFeedbackResponse ylFpDiscernDataFeedbackResponse = YlFpDiscernDataFeedbackResponse.builder().build();
        if (StringUtils.isNotEmpty((CharSequence)responseStr)) {
            try {
                Document doc = DocumentHelper.parseText((String)responseStr);
                Element rootElt = doc.getRootElement();
                CommonResponseHead head = ((CommonResponseHead.CommonResponseHeadBuilder)((CommonResponseHead.CommonResponseHeadBuilder)CommonResponseHead.builder().transID(ylFpDiscernDataFeedbackRequest.getHead().getTransID())).transTime(ylFpDiscernDataFeedbackRequest.getHead().getTransTime())).build();
                if (ObjectUtil.isNotEmpty((Object)rootElt.element("Head").element("ResponseCode"))) {
                    head.setResponseCode(rootElt.element("Head").element("ResponseCode").getTextTrim());
                }
                if (ObjectUtil.isNotEmpty((Object)rootElt.element("Head").element("ErrorCode"))) {
                    head.setErrorCode(rootElt.element("Head").element("ErrorCode").getTextTrim());
                }
                if (ObjectUtil.isNotEmpty((Object)rootElt.element("Head").element("ErrorMessage"))) {
                    head.setErrorMessage(rootElt.element("Head").element("ErrorMessage").getTextTrim());
                }
                ylFpDiscernDataFeedbackResponse.setHead(head);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        return ylFpDiscernDataFeedbackResponse;
    }

    public String conversionRequest(YlFpDiscernDataFeedbackRequest ylFpDiscernDataFeedbackRequest) {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Packet><Head>";
        xml = xml + "<TransType>" + ylFpDiscernDataFeedbackRequest.getHead().getTransType() + "</TransType>";
        xml = xml + "<TransDate>" + DateUtil.format((Date)ylFpDiscernDataFeedbackRequest.getHead().getTransTime(), (String)"yyyy-MM-dd HH:mm:ss") + "</TransDate>";
        xml = xml + "<TransID>" + ylFpDiscernDataFeedbackRequest.getHead().getTransID() + "</TransID>";
        xml = xml + "<User>" + ylFpDiscernDataFeedbackRequest.getHead().getUser() + "</User>";
        xml = xml + "<Password>" + ylFpDiscernDataFeedbackRequest.getHead().getPassword() + "</Password>";
        xml = xml + "</Head><Body>";
        if (ObjectUtil.isNotEmpty((Object)ylFpDiscernDataFeedbackRequest.getBody().getReceiptList())) {
            xml = xml + "<Size>" + ylFpDiscernDataFeedbackRequest.getBody().getReceiptList().size() + "</Size>";
            xml = xml + "<ReceiptList>";
            if (ylFpDiscernDataFeedbackRequest.getBody().getReceiptList().size() > 0) {
                List receiptInfoDTOList = ylFpDiscernDataFeedbackRequest.getBody().getReceiptList();
                for (ReceiptInfoDTO receiptInfoDTO : receiptInfoDTOList) {
                    xml = xml + "<ReceiptInfo>";
                    if (StringUtils.isNotEmpty((CharSequence)receiptInfoDTO.getFileNo())) {
                        xml = xml + "<FileNo>" + receiptInfoDTO.getFileNo() + "</FileNo>";
                    }
                    if (StringUtils.isNotEmpty((CharSequence)receiptInfoDTO.getCaseNo())) {
                        xml = xml + "<CaseNo>" + receiptInfoDTO.getCaseNo() + "</CaseNo>";
                    }
                    if (StringUtils.isNotEmpty((CharSequence)receiptInfoDTO.getClaimNo())) {
                        xml = xml + "<ClaimNo>" + receiptInfoDTO.getClaimNo() + "</ClaimNo>";
                    }
                    if (StringUtils.isNotEmpty((CharSequence)receiptInfoDTO.getFileUrl())) {
                        xml = xml + "<FileUrl>" + receiptInfoDTO.getFileUrl() + "</FileUrl>";
                    }
                    if (StringUtils.isNotEmpty((CharSequence)receiptInfoDTO.getFileName())) {
                        xml = xml + "<FileName>" + receiptInfoDTO.getFileName() + "</FileName>";
                    }
                    if (StringUtils.isNotEmpty((CharSequence)receiptInfoDTO.getCompanyFlag())) {
                        xml = xml + "<CompanyFlag>" + receiptInfoDTO.getCompanyFlag() + "</CompanyFlag>";
                    }
                    if (StringUtils.isNotEmpty((CharSequence)receiptInfoDTO.getRequireFlag())) {
                        xml = xml + "<RequireFlag>" + receiptInfoDTO.getRequireFlag() + "</RequireFlag>";
                    }
                    if (StringUtils.isNotEmpty((CharSequence)receiptInfoDTO.getClearSensitive())) {
                        xml = xml + "<ClearSensitive>" + receiptInfoDTO.getClearSensitive() + "</ClearSensitive>";
                    }
                    if (StringUtils.isNotEmpty((CharSequence)receiptInfoDTO.getDistinguish())) {
                        xml = xml + "<Distinguish>" + receiptInfoDTO.getDistinguish() + "</Distinguish>";
                    }
                    if (StringUtils.isNotEmpty((CharSequence)receiptInfoDTO.getRemark())) {
                        xml = xml + "<Remark>" + receiptInfoDTO.getRemark() + "</Remark>";
                    }
                    if (StringUtils.isNotEmpty((CharSequence)receiptInfoDTO.getReceiptNo())) {
                        xml = xml + "<ReceiptNo>" + receiptInfoDTO.getReceiptNo() + "</ReceiptNo>";
                    }
                    if (StringUtils.isNotEmpty((CharSequence)receiptInfoDTO.getKind())) {
                        xml = xml + "<Kind>" + receiptInfoDTO.getKind() + "</Kind>";
                    }
                    if (StringUtils.isNotEmpty((CharSequence)receiptInfoDTO.getAgency())) {
                        xml = xml + "<Agency>" + receiptInfoDTO.getAgency() + "</Agency>";
                    }
                    if (ObjectUtil.isNotEmpty((Object)receiptInfoDTO.getIssueTime())) {
                        xml = xml + "<IssueTime>" + DateUtil.format((Date)receiptInfoDTO.getIssueTime(), (String)"yyyy-MM-dd HH:mm:ss") + "</IssueTime>";
                    }
                    if (ObjectUtil.isNotEmpty((Object)receiptInfoDTO.getMedicalInsuranceType())) {
                        xml = xml + "<MedicalInsuranceType>" + receiptInfoDTO.getMedicalInsuranceType() + "</MedicalInsuranceType>";
                    }
                    if (ObjectUtil.isNotEmpty((Object)receiptInfoDTO.getTotalAmount())) {
                        xml = xml + "<TotalAmount>" + receiptInfoDTO.getTotalAmount() + "</TotalAmount>";
                    }
                    if (ObjectUtil.isNotEmpty((Object)receiptInfoDTO.getCoordinationPay())) {
                        xml = xml + "<CoordinationPay>" + receiptInfoDTO.getCoordinationPay() + "</CoordinationPay>";
                    }
                    if (ObjectUtil.isNotEmpty((Object)receiptInfoDTO.getSelfPay())) {
                        xml = xml + "<SelfPay>" + receiptInfoDTO.getSelfPay() + "</SelfPay>";
                    }
                    if (ObjectUtil.isNotEmpty((Object)receiptInfoDTO.getThirdPartyPay())) {
                        xml = xml + "<ThirdPartyPay>" + receiptInfoDTO.getThirdPartyPay() + "</ThirdPartyPay>";
                    }
                    if (StringUtils.isNotEmpty((CharSequence)receiptInfoDTO.getCurrency())) {
                        xml = xml + "<Currency>" + receiptInfoDTO.getCurrency() + "</Currency>";
                    }
                    if (ObjectUtil.isNotEmpty((Object)receiptInfoDTO.getAdditionalPay())) {
                        xml = xml + "<AdditionalPay>" + receiptInfoDTO.getAdditionalPay() + "</AdditionalPay>";
                    }
                    if (ObjectUtil.isNotEmpty((Object)receiptInfoDTO.getClassifiedPayout())) {
                        xml = xml + "<ClassifiedPayout>" + receiptInfoDTO.getClassifiedPayout() + "</ClassifiedPayout>";
                    }
                    if (StringUtils.isNotEmpty((CharSequence)receiptInfoDTO.getThirdPartyNo())) {
                        xml = xml + "<ThirdPartyNo>" + receiptInfoDTO.getThirdPartyNo() + "</ThirdPartyNo>";
                    }
                    if (StringUtils.isNotEmpty((CharSequence)receiptInfoDTO.getRepeated())) {
                        xml = xml + "<Repeated>" + receiptInfoDTO.getRepeated() + "</Repeated>";
                    }
                    if (StringUtils.isNotEmpty((CharSequence)receiptInfoDTO.getAssociatedReceiptNo())) {
                        xml = xml + "<AssociatedReceiptNo>" + receiptInfoDTO.getAssociatedReceiptNo() + "</AssociatedReceiptNo>";
                    }
                    if (StringUtils.isNotEmpty((CharSequence)receiptInfoDTO.getTreatmentMode())) {
                        xml = xml + "<TreatmentMode>" + receiptInfoDTO.getTreatmentMode() + "</TreatmentMode>";
                    }
                    if (ObjectUtil.isNotEmpty((Object)receiptInfoDTO.getHospitalDate())) {
                        xml = xml + "<HospitalDate>" + DateUtil.format((Date)receiptInfoDTO.getHospitalDate(), (String)"yyyy-MM-dd HH:mm:ss") + "</HospitalDate>";
                    }
                    if (ObjectUtil.isNotEmpty((Object)receiptInfoDTO.getOutHospitalDate())) {
                        xml = xml + "<OutHospitalDate>" + DateUtil.format((Date)receiptInfoDTO.getOutHospitalDate(), (String)"yyyy-MM-dd HH:mm:ss") + "</OutHospitalDate>";
                    }
                    if (ObjectUtil.isNotEmpty((Object)receiptInfoDTO.getCashPay())) {
                        xml = xml + "<CashPay>" + receiptInfoDTO.getCashPay() + "</CashPay>";
                    }
                    if (ObjectUtil.isNotEmpty((Object)receiptInfoDTO.getUnReasonableFee())) {
                        xml = xml + "<UnReasonableFee>" + receiptInfoDTO.getUnReasonableFee() + "</UnReasonableFee>";
                    }
                    if (ObjectUtil.isNotEmpty((Object)receiptInfoDTO.getPersonalPay())) {
                        xml = xml + "<PersonalPay>" + receiptInfoDTO.getPersonalPay() + "</PersonalPay>";
                    }
                    if (ObjectUtil.isNotEmpty((Object)receiptInfoDTO.getMedicalCostList()) && receiptInfoDTO.getMedicalCostList().size() > 0) {
                        xml = xml + "<MedicalCostList>";
                        for (MedicalCostDTO medicalCostDTO : receiptInfoDTO.getMedicalCostList()) {
                            xml = xml + "<MedicalCost>";
                            if (StringUtils.isNotEmpty((CharSequence)medicalCostDTO.getCostType())) {
                                xml = xml + "<CostType>" + medicalCostDTO.getCostType() + "</CostType>";
                            }
                            if (StringUtils.isNotEmpty((CharSequence)medicalCostDTO.getMedicalDetailName())) {
                                xml = xml + "<MedicalDetailName>" + medicalCostDTO.getMedicalDetailName() + "</MedicalDetailName>";
                            }
                            if (StringUtils.isNotEmpty((CharSequence)medicalCostDTO.getMedicalDetailCode())) {
                                xml = xml + "<MedicalDetailCode>" + medicalCostDTO.getMedicalDetailCode() + "</MedicalDetailCode>";
                            }
                            if (StringUtils.isNotEmpty((CharSequence)medicalCostDTO.getDetailType())) {
                                xml = xml + "<DetailType>" + medicalCostDTO.getDetailType() + "</DetailType>";
                            }
                            if (ObjectUtil.isNotEmpty((Object)medicalCostDTO.getFeeAmount())) {
                                xml = xml + "<FeeAmount>" + medicalCostDTO.getFeeAmount() + "</FeeAmount>";
                            }
                            if (ObjectUtil.isNotEmpty((Object)medicalCostDTO.getFeedeDuctibleAmount())) {
                                xml = xml + "<FeedeDuctibleAmount>" + medicalCostDTO.getFeedeDuctibleAmount() + "</FeedeDuctibleAmount>";
                            }
                            if (ObjectUtil.isNotEmpty((Object)medicalCostDTO.getQuantity())) {
                                xml = xml + "<Quantity>" + medicalCostDTO.getQuantity() + "</Quantity>";
                            }
                            if (ObjectUtil.isNotEmpty((Object)medicalCostDTO.getUnitPrice())) {
                                xml = xml + "<UnitPrice>" + medicalCostDTO.getUnitPrice() + "</UnitPrice>";
                            }
                            if (StringUtils.isNotEmpty((CharSequence)medicalCostDTO.getUnit())) {
                                xml = xml + "<Unit>" + medicalCostDTO.getUnit() + "</Unit>";
                            }
                            if (StringUtils.isNotEmpty((CharSequence)medicalCostDTO.getInsuranceCategory())) {
                                xml = xml + "<InsuranceCategory>" + medicalCostDTO.getInsuranceCategory() + "</InsuranceCategory>";
                            }
                            if (ObjectUtil.isNotEmpty((Object)medicalCostDTO.getSelfPayRatio())) {
                                xml = xml + "<SelfPayRatio>" + medicalCostDTO.getSelfPayRatio() + "</SelfPayRatio>";
                            }
                            if (ObjectUtil.isNotEmpty((Object)medicalCostDTO.getSelfPayAmt())) {
                                xml = xml + "<SelfPayAmt>" + medicalCostDTO.getSelfPayAmt() + "</SelfPayAmt>";
                            }
                            if (StringUtils.isNotEmpty((CharSequence)medicalCostDTO.getSpecification())) {
                                xml = xml + "<Specification>" + medicalCostDTO.getSpecification() + "</Specification>";
                            }
                            if (StringUtils.isNotEmpty((CharSequence)medicalCostDTO.getFormulation())) {
                                xml = xml + "<Formulation>" + medicalCostDTO.getFormulation() + "</Formulation>";
                            }
                            if (StringUtils.isNotEmpty((CharSequence)medicalCostDTO.getThirdPartyCostNo())) {
                                xml = xml + "<ThirdPartyCostNo>" + medicalCostDTO.getThirdPartyCostNo() + "</ThirdPartyCostNo>";
                            }
                            xml = xml + "</MedicalCost>";
                        }
                        xml = xml + "</MedicalCostList>";
                    }
                    if (ObjectUtil.isNotEmpty((Object)receiptInfoDTO.getExtInfoDTO())) {
                        xml = xml + "<ExtInfo>";
                        if (ObjectUtil.isNotEmpty((Object)receiptInfoDTO.getExtInfoDTO().getOutpatientDate())) {
                            xml = xml + "<OutpatientDate>" + DateUtil.format((Date)receiptInfoDTO.getExtInfoDTO().getOutpatientDate(), (String)"yyyy-MM-dd HH:mm:ss") + "</OutpatientDate>";
                        }
                        if (ObjectUtil.isNotEmpty((Object)receiptInfoDTO.getExtInfoDTO().getHospitalDate())) {
                            xml = xml + "<HospitalDate>" + DateUtil.format((Date)receiptInfoDTO.getExtInfoDTO().getHospitalDate(), (String)"yyyy-MM-dd HH:mm:ss") + "</HospitalDate>";
                        }
                        if (ObjectUtil.isNotEmpty((Object)receiptInfoDTO.getExtInfoDTO().getDischardeDate())) {
                            xml = xml + "<DischardeDate>" + DateUtil.format((Date)receiptInfoDTO.getExtInfoDTO().getDischardeDate(), (String)"yyyy-MM-dd HH:mm:ss") + "</DischardeDate>";
                        }
                        if (StringUtils.isNotEmpty((CharSequence)receiptInfoDTO.getExtInfoDTO().getMedicalCategory())) {
                            xml = xml + "<MedicalCategory>" + receiptInfoDTO.getExtInfoDTO().getMedicalCategory() + "</MedicalCategory>";
                        }
                        if (StringUtils.isNotEmpty((CharSequence)receiptInfoDTO.getExtInfoDTO().getDiagnosisType())) {
                            xml = xml + "<DiagnosisType>" + receiptInfoDTO.getExtInfoDTO().getDiagnosisType() + "</DiagnosisType>";
                        }
                        if (StringUtils.isNotEmpty((CharSequence)receiptInfoDTO.getExtInfoDTO().getDiseaseName())) {
                            xml = xml + "<DiseaseName>" + receiptInfoDTO.getExtInfoDTO().getDiseaseName() + "</DiseaseName>";
                        }
                        if (StringUtils.isNotEmpty((CharSequence)receiptInfoDTO.getExtInfoDTO().getDiseaseCode())) {
                            xml = xml + "<DiseaseCode>" + receiptInfoDTO.getExtInfoDTO().getDiseaseCode() + "</DiseaseCode>";
                        }
                        if (StringUtils.isNotEmpty((CharSequence)receiptInfoDTO.getExtInfoDTO().getAgency())) {
                            xml = xml + "<Agency>" + receiptInfoDTO.getExtInfoDTO().getAgency() + "</Agency>";
                        }
                        if (StringUtils.isNotEmpty((CharSequence)receiptInfoDTO.getExtInfoDTO().getOperation())) {
                            xml = xml + "<Operation>" + receiptInfoDTO.getExtInfoDTO().getOperation() + "</Operation>";
                        }
                        if (StringUtils.isNotEmpty((CharSequence)receiptInfoDTO.getExtInfoDTO().getThirdPartyCostNo())) {
                            xml = xml + "<ThirdPartyCostNo>" + receiptInfoDTO.getExtInfoDTO().getThirdPartyCostNo() + "</ThirdPartyCostNo>";
                        }
                        xml = xml + "</ExtInfo>";
                    }
                    xml = xml + "</ReceiptInfo>";
                }
                xml = xml + "</ReceiptList></Body>";
            }
        }
        xml = xml + "</Packet>";
        return xml;
    }
}

