/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryDetail.response.PayPersonInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ClaimCollectInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ClaimCollectguideInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ClaimDataCompletionRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ClaimDataCompletionResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiRequestRegistService;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.claims.CoreClaimDataCompletionApi;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClaimDataCompletionHandler
implements BusinessHandler {
    private static Logger log = LoggerFactory.getLogger(ClaimDataCompletionHandler.class);
    @Autowired
    CoreClaimDataCompletionApi coreClaimDataCompletionApi;
    @Autowired
    ApisBusiRequestRegistService apisBusiRequestRegistService;
    TimeInterval timer = DateUtil.timer();

    public StanderRequest dataCompletion(StanderRequest request) throws ApisDataCompletionException {
        this.timer.intervalRestart();
        String uuid = UUID.fastUUID().toString().replaceAll("-", "");
        String businessKey = request.getHeader().getBusinessKey();
        String transID = request.getClaimDataCompletionServiceRequest().getHead().getTransID();
        request.getHeader().setBusinessKey(ObjectUtil.isNotEmpty((Object)businessKey) ? businessKey : uuid);
        request.getClaimDataCompletionServiceRequest().getHead().setTransID(ObjectUtil.isNotEmpty((Object)transID) ? transID : UUID.fastUUID().toString());
        request.getClaimDataCompletionServiceRequest().getHead().setTransDate(new Date());
        HashMap resultMap = new HashMap();
        DataCompletionUtil dataCompletionUtil = new DataCompletionUtil();
        log.warn("\u8d44\u6599\u8865\u4ea4\u524d\u671f\u51c6\u5907\uff0c\u7528\u65f6 :{}", (Object)this.timer.intervalRestart());
        String[] dataArray = new String[]{"ReportType", "SuplementType", "Status", "ExternalID"};
        Object[] dataEnumArray = new Object[]{ErrorNullValueCodeEnum.ERR_N60001, ErrorNullValueCodeEnum.ERR_N60002, ErrorNullValueCodeEnum.ERR_N60003, ErrorNullValueCodeEnum.ERR_N60005};
        ClaimDataCompletionRequestDTO requestBody = request.getClaimDataCompletionServiceRequest().getBody();
        dataCompletionUtil.checkNotNull((Object)requestBody, dataArray, dataEnumArray, resultMap);
        log.warn("\u8d44\u6599\u8865\u5168\u63a5\u53e3\u8865\u5145\u5fc5\u4f20\u5b57\u6bb5\u6821\u9a8c\uff0c\u7528\u65f6 :{}", (Object)this.timer.intervalRestart());
        if (resultMap.size() == 0) {
            String suplementType = request.getClaimDataCompletionServiceRequest().getBody().getSuplementType();
            String[] dataCompletionArray = new String[]{"RecoveryInfoList", "CollectInfoList", "ReturnTickteInfoList", "AfrInfo", "CompensateInfoList"};
            Object[] dataCompletionEnumArray = new Object[]{"01".equals(suplementType) ? ErrorNullValueCodeEnum.ERR_N60006 : new Object(), "02".equals(suplementType) ? ErrorNullValueCodeEnum.ERR_N60007 : new Object(), "03".equals(suplementType) ? ErrorNullValueCodeEnum.ERR_N60008 : new Object(), "04".equals(suplementType) ? ErrorNullValueCodeEnum.ERR_N60009 : new Object(), "05".equals(suplementType) ? ErrorNullValueCodeEnum.ERR_N60010 : new Object()};
            dataCompletionUtil.checkNotNull((Object)requestBody, dataCompletionArray, dataCompletionEnumArray, resultMap);
        }
        log.warn("\u8865\u5168\u4fe1\u606f\u6821\u9a8c\uff0c\u7528\u65f6 :{}", (Object)this.timer.intervalRestart());
        if (resultMap.size() > 0) {
            ErrorNullValueCodeEnum errorNullValueCodeEnum = null;
            Object obj = resultMap.get(1);
            if (obj instanceof ErrorNullValueCodeEnum) {
                errorNullValueCodeEnum = (ErrorNullValueCodeEnum)obj;
            }
            log.error("\n\u8d44\u6599\u8865\u5168\u63a5\u53e3\u89c4\u5219\u6821\u9a8c\u4e0d\u901a\u8fc7\uff1a{}", (Object)errorNullValueCodeEnum.getValue());
            throw ApisDataCompletionException.builder().errorCode(errorNullValueCodeEnum.getKey()).message(errorNullValueCodeEnum.getValue()).build();
        }
        log.warn("\u6821\u9a8c\u4fe1\u606f\u6355\u83b7\uff0c\u7528\u65f6 :{}", (Object)this.timer.intervalRestart());
        if ("02".equals(request.getClaimDataCompletionServiceRequest().getBody().getSuplementType()) && request.getClaimDataCompletionServiceRequest().getBody().getCollectInfoList() != null) {
            for (int i = 0; i < request.getClaimDataCompletionServiceRequest().getBody().getCollectInfoList().size(); ++i) {
                if (((ClaimCollectInfoDTO)request.getClaimDataCompletionServiceRequest().getBody().getCollectInfoList().get(i)).getPackageNo() == null) continue;
                ArrayList<ClaimCollectguideInfoDTO> claimCollectguideInfoDTOList = new ArrayList<ClaimCollectguideInfoDTO>();
                ClaimCollectguideInfoDTO claimCollectguideInfoDTO = new ClaimCollectguideInfoDTO();
                claimCollectguideInfoDTO.setDocCode("99930");
                claimCollectguideInfoDTO.setDocName("\u5176\u5b83");
                claimCollectguideInfoDTOList.add(claimCollectguideInfoDTO);
                ((ClaimCollectInfoDTO)request.getClaimDataCompletionServiceRequest().getBody().getCollectInfoList().get(i)).setCollectguideInfo(claimCollectguideInfoDTOList);
                ((ClaimCollectInfoDTO)request.getClaimDataCompletionServiceRequest().getBody().getCollectInfoList().get(i)).setSupRespTime(new Date());
            }
        }
        if ("06".equals(request.getClaimDataCompletionServiceRequest().getBody().getSuplementType()) && request.getClaimDataCompletionServiceRequest().getBody().getPayPersonVo() != null && request.getClaimDataCompletionServiceRequest().getBody().getPayPersonVo().getPayPersonInfoList() != null) {
            for (int i = 0; i < request.getClaimDataCompletionServiceRequest().getBody().getPayPersonVo().getPayPersonInfoList().size(); ++i) {
                if (!"1".equals(((PayPersonInfo)request.getClaimDataCompletionServiceRequest().getBody().getPayPersonVo().getPayPersonInfoList().get(i)).getPayObjectKind())) continue;
                ((PayPersonInfo)request.getClaimDataCompletionServiceRequest().getBody().getPayPersonVo().getPayPersonInfoList().get(i)).setPayObjectKind("01");
            }
        }
        return request;
    }

    public StanderResponse execute(StanderRequest request) {
        String registNoByRequestId;
        if (StringUtils.isNotEmpty((CharSequence)request.getClaimDataCompletionServiceRequest().getBody().getClaimTransactionId()) && StringUtils.isNotEmpty((CharSequence)(registNoByRequestId = this.apisBusiRequestRegistService.getRegistNoByRequestId(request.getClaimDataCompletionServiceRequest().getBody().getClaimTransactionId())))) {
            request.getClaimDataCompletionServiceRequest().getBody().setRegistNo(registNoByRequestId);
            if (request.getClaimDataCompletionServiceRequest().getBody().getCollectInfoList() != null && request.getClaimDataCompletionServiceRequest().getBody().getCollectInfoList().size() > 0) {
                ((ClaimCollectInfoDTO)request.getClaimDataCompletionServiceRequest().getBody().getCollectInfoList().get(0)).setRegistNo(registNoByRequestId);
            }
        }
        log.warn("\u6d41\u6c34\u53f7\u8f6c\u62a5\u6848\u53f7\uff0c\u7528\u65f6 :{}", (Object)this.timer.intervalRestart());
        StanderResponse standerResponse = this.coreClaimDataCompletionApi.claimDataCompletion(request);
        standerResponse.getClaimDataCompletionResponse();
        if (standerResponse.getClaimDataCompletionResponse().getBody() != null && StringUtils.isNotEmpty((CharSequence)standerResponse.getClaimDataCompletionResponse().getBody().getBusinessNo())) {
            standerResponse.getClaimDataCompletionResponse().getBody().setBusinessNo("0");
            standerResponse.getClaimDataCompletionResponse().getHead().setErrorMessage("\u8bbf\u95ee\u6210\u529f");
        } else {
            standerResponse.getClaimDataCompletionResponse().setBody(new ClaimDataCompletionResponseDTO("-1", "-1"));
            if (standerResponse.getClaimDataCompletionResponse().getHead().getErrorMessage() != null) {
                standerResponse.getClaimDataCompletionResponse().getHead().setErrorMessage(standerResponse.getClaimDataCompletionResponse().getHead().getErrorMessage());
            } else {
                standerResponse.getClaimDataCompletionResponse().getHead().setErrorMessage("\u8bbf\u95ee\u5931\u8d25,\u672a\u77e5\u539f\u56e0");
            }
        }
        log.warn("\u8bbf\u95ee\u8865\u5168\u63a5\u53e3\uff0c\u7528\u65f6 :{}", (Object)this.timer.intervalRestart());
        return standerResponse;
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) {
        return response;
    }
}

