/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.consts.ClaimErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.consts.ErrorCode;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryDetail.response.ClaimBaseInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryDetail.response.ClaimBaseInfoListBody;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryDetail.response.ClaimDetailListResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryDetail.response.ClaimDetailResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryDetail.response.ClaimInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryDetail.response.CollectguideInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryDetail.response.CompensateInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryDetail.response.DocCollectRecInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryDetail.response.PayPersonInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryDetail.response.RecaseInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.DocCodeAndName;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.request.ClaimListQueryServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.request.ClaimQueryInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.response.ClaimListInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.response.DisposeInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.response.ProcessNode;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.response.ProcessNodeEnum;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.response.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiRequestRegistService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.mapper.ApisChannelCodeMapper;
import com.jdaz.sinosoftgz.coreapi.claims.CoreClaimsDetailApi;
import com.jdaz.sinosoftgz.coreapi.claims.CoreClaimsQueryApi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClaimDetailHandler
implements BusinessHandler {
    private static Logger log = LoggerFactory.getLogger(ClaimDetailHandler.class);
    @Autowired
    private CoreClaimsDetailApi coreClaimsDetailApi;
    @Autowired
    private CoreClaimsQueryApi coreClaimsQueryApi;
    @Autowired
    ApisBusiRequestRegistService apisBusiRequestRegistService;
    @Autowired
    private DocCodeAndName docCodeAndName;
    @Autowired
    private ApisChannelCodeMapper apisChannelCodeMapper;
    TimeInterval timer = DateUtil.timer();
    boolean xmlReturnFlag = false;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisDataCompletionException {
        if (this.checkRequestHeadBodyIsNull(request)) {
            throw ApisDataCompletionException.builder().message(ClaimErrorCodeEnum.ERR_CL10001.getValue()).build();
        }
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        this.timer.intervalRestart();
        if (this.checkRequestHeadBodyIsNull(request)) {
            return StanderResponse.builder().header(request.getHeader()).claimDetailResponse(ClaimDetailResponse.builder().head(ResponseHeadDTO.builder().errorCode(ClaimErrorCodeEnum.ERR_CL10001.getKey()).errorMessage(ClaimErrorCodeEnum.ERR_CL10001.getValue()).build()).build()).build();
        }
        String uuid = cn.hutool.core.lang.UUID.fastUUID().toString().replaceAll("-", "");
        String businessKey = request.getHeader().getBusinessKey();
        request.getHeader().setBusinessKey(ObjectUtil.isNotEmpty((Object)businessKey) ? businessKey : uuid);
        RequestHeadDTO requestHeadDTO = request.getClaimDetailServiceRequest().getHead();
        requestHeadDTO.setTransDate(new Date());
        if (StringUtils.isBlank((CharSequence)requestHeadDTO.getTransID())) {
            requestHeadDTO.setTransID(UUID.randomUUID().toString().replace("-", ""));
        }
        request.getClaimDetailServiceRequest().getBody().setUserCode(request.getHeader().getUserCode());
        log.warn("\u6570\u636e\u6821\u9a8c\uff0c\u7528\u65f6 :{}", (Object)this.timer.intervalRestart());
        if (StringUtils.isNotEmpty((CharSequence)request.getClaimDetailServiceRequest().getBody().getClaimTransactionId())) {
            String registNoByRequestId = this.apisBusiRequestRegistService.getRegistNoByRequestId(request.getClaimDetailServiceRequest().getBody().getClaimTransactionId());
            if (StringUtils.isNotEmpty((CharSequence)registNoByRequestId)) {
                request.getClaimDetailServiceRequest().getBody().setRegistNo(registNoByRequestId);
            }
            log.warn("\u6d41\u6c34\u53f7\u8f6c\u6210\u62a5\u6848\u53f7\uff0c\u7528\u65f6 :{}", (Object)this.timer.intervalRestart());
        }
        if ("xml".equals(request.getClaimDetailServiceRequest().getHead().getXmlFlag())) {
            request.getHeader().setBussinessType("case");
            ClaimQueryInfoDTO claimQueryInfoDTO = new ClaimQueryInfoDTO();
            claimQueryInfoDTO.setPolicyNo(request.getClaimDetailServiceRequest().getBody().getPolicyNo());
            claimQueryInfoDTO.setInsuredName(request.getClaimDetailServiceRequest().getBody().getInsuredName());
            claimQueryInfoDTO.setIdentifyNo(request.getClaimDetailServiceRequest().getBody().getIdentifyNumber());
            claimQueryInfoDTO.setPageSize(15);
            ClaimListQueryServiceRequest thisClaimListQueryServiceRequest = new ClaimListQueryServiceRequest(request.getClaimDetailServiceRequest().getHead(), claimQueryInfoDTO);
            String thisRegistNo = "";
            if (!StringUtils.isNotEmpty((CharSequence)request.getClaimDetailServiceRequest().getBody().getRegistNo())) {
                request.setClaimListQueryServiceRequest(thisClaimListQueryServiceRequest);
                StanderResponse claimsList = this.coreClaimsQueryApi.claimsQuery(request);
                if (claimsList.getClaimListQueryResponse() != null && claimsList.getClaimListQueryResponse().getBody() != null && claimsList.getClaimListQueryResponse().getBody().getClaimInfoList().size() > 0) {
                    StanderResponse response = null;
                    StanderResponse responseTmp = null;
                    ClaimDetailListResponse claimDetailListResponse = ClaimDetailListResponse.builder().build();
                    ClaimBaseInfoListBody claimBaseInfoListBody = ClaimBaseInfoListBody.builder().build();
                    ArrayList claimBaseInfoList = new ArrayList();
                    claimBaseInfoListBody.setClaimBaseInfoList(claimBaseInfoList);
                    claimDetailListResponse.setBody(claimBaseInfoListBody);
                    for (ClaimListInfo claimTihs : claimsList.getClaimListQueryResponse().getBody().getClaimInfoList()) {
                        if (!StringUtils.isNotEmpty((CharSequence)claimTihs.getRegistNo())) continue;
                        request.getClaimDetailServiceRequest().getBody().setRegistNo(claimTihs.getRegistNo());
                        if (response == null) {
                            response = this.coreClaimsDetailApi.claimsDetail(request);
                            response.setClaimDetailListResponse(claimDetailListResponse);
                            response.getClaimDetailListResponse().getBody().getClaimBaseInfoList().add(response.getClaimDetailResponse().getBody());
                            continue;
                        }
                        responseTmp = this.coreClaimsDetailApi.claimsDetail(request);
                        response.getClaimDetailListResponse().getBody().getClaimBaseInfoList().add(responseTmp.getClaimDetailResponse().getBody());
                    }
                    return response;
                }
                this.xmlReturnFlag = true;
                throw ApisDataCompletionException.builder().errorCode(ErrorCode.SEARCH_IS_NULL.getCode()).message(ErrorCode.SEARCH_IS_NULL.getMessage()).build();
            }
            thisRegistNo = request.getClaimDetailServiceRequest().getBody().getRegistNo();
            request.getClaimDetailServiceRequest().getBody().setRegistNo(thisRegistNo);
            log.warn("\u8c03\u7528\u5217\u8868\u63a5\u53e3\u83b7\u53d6\u53c2\u6570\uff0c\u7528\u65f6 :{}", (Object)this.timer.intervalRestart());
        }
        return this.coreClaimsDetailApi.claimsDetail(request);
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisDataCompletionException {
        if ("xml".equals(request.getClaimDetailServiceRequest().getHead().getXmlFlag())) {
            if (ObjectUtil.isEmpty((Object)response.getClaimDetailListResponse()) || ObjectUtil.isEmpty((Object)response.getClaimDetailListResponse().getBody()) || ObjectUtil.isEmpty((Object)response.getClaimDetailListResponse().getBody().getClaimBaseInfoList())) {
                this.packageClaimDetailResponse(request, response);
                ClaimDetailListResponse claimDetailListResponse = ClaimDetailListResponse.builder().build();
                ClaimBaseInfoListBody claimBaseInfoListBody = ClaimBaseInfoListBody.builder().build();
                ArrayList claimBaseInfoList = new ArrayList();
                claimBaseInfoListBody.setClaimBaseInfoList(claimBaseInfoList);
                claimDetailListResponse.setBody(claimBaseInfoListBody);
                response.setClaimDetailListResponse(claimDetailListResponse);
                response.getClaimDetailListResponse().getBody().getClaimBaseInfoList().add(response.getClaimDetailResponse().getBody());
            } else {
                for (ClaimBaseInfo claimBaseInfo : response.getClaimDetailListResponse().getBody().getClaimBaseInfoList()) {
                    if (!ObjectUtil.isNotEmpty((Object)claimBaseInfo)) continue;
                    response.getClaimDetailResponse().setBody(claimBaseInfo);
                    this.packageClaimDetailResponse(request, response);
                }
            }
        } else {
            this.packageClaimDetailResponse(request, response);
        }
        return response;
    }

    public StanderResponse packageClaimDetailResponse(StanderRequest request, StanderResponse response) throws ApisDataCompletionException {
        if (this.checkRequestHeadBodyIsNull(request) || this.checkResponseBodyIsNull(response) || !this.checkResponseHeadSuccess(response)) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.SEARCH_IS_NULL.getCode()).message(ErrorCode.SEARCH_IS_NULL.getMessage()).build();
        }
        ClaimBaseInfo thisClaim = response.getClaimDetailResponse().getBody();
        if (response.getClaimDetailResponse().getBody().getCompensateInfo() != null) {
            ArrayList<CompensateInfo> compensateInfoList = new ArrayList<CompensateInfo>();
            for (CompensateInfo compensateInfo : response.getClaimDetailResponse().getBody().getCompensateInfo()) {
                if (!"1".equals(compensateInfo.getCompensateType()) && !"Y".equals(compensateInfo.getCompensateType())) continue;
                compensateInfoList.add(compensateInfo);
            }
            response.getClaimDetailResponse().getBody().setCompensateInfo(compensateInfoList);
        }
        String codeNameList = "";
        ArrayList<Object> cNameList = new ArrayList<Object>();
        request.getHeader().setBussinessType("caseDetail");
        ClaimQueryInfoDTO claimQueryInfoDTO = new ClaimQueryInfoDTO();
        claimQueryInfoDTO.setClaimNo(request.getClaimDetailServiceRequest().getBody().getClaimNo());
        claimQueryInfoDTO.setRegistNo(request.getClaimDetailServiceRequest().getBody().getRegistNo());
        ClaimListQueryServiceRequest thisClaimListQueryServiceRequest = new ClaimListQueryServiceRequest(request.getClaimDetailServiceRequest().getHead(), claimQueryInfoDTO);
        request.setClaimListQueryServiceRequest(thisClaimListQueryServiceRequest);
        StanderResponse claimsList = this.coreClaimsQueryApi.claimsQuery(request);
        if (claimsList.getClaimListQueryResponse() != null && claimsList.getClaimListQueryResponse().getBody() != null && claimsList.getClaimListQueryResponse().getBody().getClaimInfoList() != null && claimsList.getClaimListQueryResponse().getBody().getClaimInfoList().size() > 0) {
            ProcessNode newProcessNode;
            ProcessNode newProcessNode2;
            ClaimListInfo thisClaimInfo = (ClaimListInfo)claimsList.getClaimListQueryResponse().getBody().getClaimInfoList().get(0);
            if (thisClaimInfo.getStatus() != null) {
                String status = thisClaimInfo.getStatus();
                response.getClaimDetailResponse().getBody().setStatus(status);
            }
            ArrayList<ProcessNode> processNodeList = new ArrayList<ProcessNode>();
            if (thisClaim.getRegist().getRegistInfo() != null && (thisClaim.getRegist().getRegistInfo().getReportTime() != null || thisClaim.getRegist().getRegistInfo().getConsultationTime() != null)) {
                ProcessNode newProcessNode3 = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_00.getKey(), ProcessNodeEnum.PROCESS_NODE_00.getValue(), thisClaim.getRegist().getRegistInfo().getReportTime() != null ? thisClaim.getRegist().getRegistInfo().getReportTime() : thisClaim.getRegist().getRegistInfo().getConsultationTime());
                processNodeList.add(newProcessNode3);
            }
            Boolean claimFlag = false;
            Date claimTime = new Date();
            if (thisClaim.getClaimInfo() != null && thisClaim.getClaimInfo() != null && thisClaim.getClaimInfo().size() > 0 && ((ClaimInfo)thisClaim.getClaimInfo().get(0)).getClaimTime() != null) {
                newProcessNode2 = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_000.getKey(), ProcessNodeEnum.PROCESS_NODE_000.getValue() + ((ClaimInfo)thisClaim.getClaimInfo().get(0)).getClaimNo(), ((ClaimInfo)thisClaim.getClaimInfo().get(0)).getClaimTime());
                processNodeList.add(newProcessNode2);
                claimFlag = true;
                claimTime = ((ClaimInfo)thisClaim.getClaimInfo().get(0)).getClaimTime();
            }
            if (thisClaim.getClaimInfo() != null && thisClaim.getClaimInfo() != null && thisClaim.getClaimInfo().size() > 0 && ((ClaimInfo)thisClaim.getClaimInfo().get(0)).getClaimTime() != null) {
                newProcessNode2 = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_010.getKey(), ProcessNodeEnum.PROCESS_NODE_010.getValue(), ((ClaimInfo)thisClaim.getClaimInfo().get(0)).getClaimTime());
                processNodeList.add(newProcessNode2);
            }
            Date heipeiTime = new Date();
            Boolean heipeiFlag = false;
            int returnFlag = 0;
            for (DisposeInfo disInfo : thisClaimInfo.getDisposeInfoList()) {
                if (disInfo.getSubNodeCode().contains("\u6838\u8d54") && disInfo.getAcceptTime().getTime() < heipeiTime.getTime()) {
                    heipeiTime = disInfo.getAcceptTime();
                    heipeiFlag = true;
                }
                if (!disInfo.getSubNodeCode().contains("\u9000\u7968")) continue;
                ProcessNode newProcessNode22 = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_04.getKey(), ProcessNodeEnum.PROCESS_NODE_04.getValue(), disInfo.getAcceptTime());
                processNodeList.add(newProcessNode22);
                returnFlag = -1;
                if (disInfo.getOutOffTime() == null) continue;
                ProcessNode newProcessNode4 = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_01.getKey(), ProcessNodeEnum.PROCESS_NODE_01.getValue(), disInfo.getOutOffTime());
                processNodeList.add(newProcessNode4);
            }
            if (heipeiFlag.booleanValue()) {
                ProcessNode newProcessNode5 = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_011.getKey(), ProcessNodeEnum.PROCESS_NODE_011.getValue(), heipeiTime);
                processNodeList.add(newProcessNode5);
            }
            if (thisClaim.getCollectInfo() != null && thisClaim.getCollectInfo().getDocCollectRecInfo() != null) {
                for (DocCollectRecInfo docCollectRecInfo : thisClaim.getCollectInfo().getDocCollectRecInfo()) {
                    if ("0".equals(docCollectRecInfo.getSupType())) {
                        Object name;
                        String[] codeList;
                        if ("xml".equals(request.getClaimDetailServiceRequest().getHead().getXmlFlag())) {
                            if (StringUtils.isNotBlank((CharSequence)docCollectRecInfo.getDocFiles())) {
                                cNameList = new ArrayList();
                                codeNameList = "\u5c0a\u656c\u7684\u5ba2\u6237\uff0c\u60a8\u7684\u7d22\u8d54\u7533\u8bf7\u6211\u4eec\u5df2\u7ecf\u6536\u5230\uff0c\u7ecf\u5ba1\u6838\u9700\u8865\u5145\uff1a\u3010";
                                codeList = docCollectRecInfo.getDocFiles().split(",");
                                for (int i = 0; i < codeList.length - 1; ++i) {
                                    if (!StringUtils.isNotEmpty((CharSequence)codeList[i])) continue;
                                    name = "";
                                    if (codeList[i].startsWith("999")) {
                                        name = "\u5176\u4ed6";
                                        if (thisClaim.getCollectInfo() != null && thisClaim.getCollectInfo().getCollectguideInfo() != null) {
                                            for (CollectguideInfo collectguideInfo2 : thisClaim.getCollectInfo().getCollectguideInfo()) {
                                                if (!codeList[i].equals(collectguideInfo2.getDocCode())) continue;
                                                name = collectguideInfo2.getDocName();
                                            }
                                        }
                                    } else {
                                        name = (String)this.docCodeAndName.getDocMap().get(String.valueOf(Integer.parseInt(codeList[i])));
                                    }
                                    codeNameList = codeNameList + (i + 1) + "." + (String)name + "\uff1b";
                                    cNameList.add(name);
                                }
                                if (StringUtils.isNotEmpty((CharSequence)codeList[codeList.length - 1])) {
                                    if (codeList[codeList.length - 1].startsWith("999")) {
                                        String name2 = "\u5176\u4ed6";
                                        if (thisClaim.getCollectInfo() != null && thisClaim.getCollectInfo().getCollectguideInfo() != null) {
                                            for (CollectguideInfo collectguideInfo : thisClaim.getCollectInfo().getCollectguideInfo()) {
                                                if (!codeList[codeList.length - 1].equals(collectguideInfo.getDocCode())) continue;
                                                name2 = collectguideInfo.getDocName();
                                            }
                                        }
                                        codeNameList = codeNameList + codeList.length + "." + name2 + "\u3011\u3002";
                                        cNameList.add(name2);
                                    } else {
                                        codeNameList = codeNameList + codeList.length + "." + (String)this.docCodeAndName.getDocMap().get(String.valueOf(Integer.parseInt(codeList[codeList.length - 1]))) + "\u3011\u3002";
                                        cNameList.add(this.docCodeAndName.getDocMap().get(String.valueOf(Integer.parseInt(codeList[codeList.length - 1]))));
                                    }
                                }
                                if ("1".equals(docCollectRecInfo.getSource()) && docCollectRecInfo.getSupTime() != null) {
                                    codeNameList = codeNameList + "\u53ef\u5173\u6ce8\u6211\u53f8\u5b98\u65b9\u5fae\u4fe1\u516c\u4f17\u53f7\uff1a\u4eac\u4e1c\u5b89\u8054\u8d22\u9669\uff0c\u901a\u8fc7\u4fdd\u5355\u7ed1\u5b9a\u540e\uff0c\u4f7f\u7528\u3010\u8d44\u6599\u8865\u4ea4\u3011\u529f\u80fd\u8865\u5145\uff0c\u6216\u5728\u539f\u6e20\u9053\u8865\u5145\u3002\u611f\u8c22\u60a8\u7684\u652f\u6301\u548c\u914d\u5408\uff01\u5982\u6709\u7591\u95ee\uff0c\u8bf7\u8054\u7cfb4008002020\u4f5c\u8fdb\u4e00\u6b65\u54a8\u8be2\uff0c\u8c22\u8c22\uff01";
                                    ProcessNode newProcessNode6 = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_021.getKey(), codeNameList, docCollectRecInfo.getSupTime());
                                    processNodeList.add(newProcessNode6);
                                }
                                if ("2".equals(docCollectRecInfo.getSource()) && docCollectRecInfo.getSupTime() != null) {
                                    codeNameList = codeNameList + "\u8bf7\u5c06\u7406\u8d54\u8d44\u6599\u76f4\u63a5\u90ae\u5bc4\u81f3\uff1a\u5e7f\u5dde\u5e02\u5929\u6cb3\u533a\u73e0\u6c5f\u897f\u8def5\u53f7\u5e7f\u5dde\u56fd\u9645\u91d1\u878d\u4e2d\u5fc3\u4e3b\u5854\u5199\u5b57\u697c(\u897f\u5854)\u7b2c34\u5c4210\u5355\u5143\uff1b\uff08\u90ae\u8d39\u8bf7\u81ea\u4ed8\uff0c\u6211\u53f8\u4e0d\u63a5\u6536\u5230\u4ed8\u4ef6\uff09\u5e76\u6ce8\u660e\u88ab\u4fdd\u9669\u4eba\u7684\u59d3\u540d\u3001\u8054\u7cfb\u65b9\u5f0f\u3001\u7acb\u6848\u53f7\u6216\u4fdd\u5355\u53f7\u4ee5\u4fbf\u5904\u7406\uff0c\u8c22\u8c22\u3002";
                                    ProcessNode newProcessNode7 = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_022.getKey(), codeNameList, docCollectRecInfo.getSupTime());
                                    processNodeList.add(newProcessNode7);
                                }
                            }
                        } else if (StringUtils.isNotBlank((CharSequence)docCollectRecInfo.getDocFiles())) {
                            codeNameList = "";
                            codeList = docCollectRecInfo.getDocFiles().split(",");
                            for (int i = 0; i < codeList.length - 1; ++i) {
                                if (!StringUtils.isNotEmpty((CharSequence)codeList[i])) continue;
                                name = "";
                                if (codeList[i].startsWith("999")) {
                                    name = "\u5176\u4ed6";
                                    if (thisClaim.getCollectInfo() != null && thisClaim.getCollectInfo().getCollectguideInfo() != null) {
                                        CollectguideInfo collectguideInfo;
                                        collectguideInfo = thisClaim.getCollectInfo().getCollectguideInfo().iterator();
                                        while (collectguideInfo.hasNext()) {
                                            CollectguideInfo collectguideInfo2;
                                            collectguideInfo2 = (CollectguideInfo)collectguideInfo.next();
                                            if (!codeList[i].equals(collectguideInfo2.getDocCode())) continue;
                                            name = collectguideInfo2.getDocName();
                                        }
                                    }
                                } else {
                                    name = (String)this.docCodeAndName.getDocMap().get(String.valueOf(Integer.parseInt(codeList[i])));
                                }
                                codeNameList = codeNameList + (String)name + ",";
                            }
                            if (StringUtils.isNotEmpty((CharSequence)codeList[codeList.length - 1])) {
                                if (codeList[codeList.length - 1].startsWith("999")) {
                                    String name3 = "\u5176\u4ed6";
                                    if (thisClaim.getCollectInfo() != null && thisClaim.getCollectInfo().getCollectguideInfo() != null) {
                                        for (CollectguideInfo collectguideInfo : thisClaim.getCollectInfo().getCollectguideInfo()) {
                                            if (!codeList[codeList.length - 1].equals(collectguideInfo.getDocCode())) continue;
                                            name3 = collectguideInfo.getDocName();
                                        }
                                    }
                                    codeNameList = codeNameList + name3;
                                } else {
                                    codeNameList = codeNameList + (String)this.docCodeAndName.getDocMap().get(String.valueOf(Integer.parseInt(codeList[codeList.length - 1])));
                                }
                            }
                            if ("1".equals(docCollectRecInfo.getSource()) && docCollectRecInfo.getSupTime() != null) {
                                ProcessNode newProcessNode8 = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_021.getKey(), ProcessNodeEnum.PROCESS_NODE_021.getValue() + codeNameList, docCollectRecInfo.getSupTime());
                                processNodeList.add(newProcessNode8);
                            }
                            if ("2".equals(docCollectRecInfo.getSource()) && docCollectRecInfo.getSupTime() != null) {
                                codeNameList = "\u7ecf\u5ba1\u6838\uff0c\u6848\u4ef6\u9700\u8981\u63d0\u4f9b\u4ee5\u4e0b\u8d44\u6599\u539f\u4ef6: " + codeNameList;
                                codeNameList = codeNameList + "\u8bf7\u5c06\u8d44\u6599\u539f\u4ef6\u90ae\u5bc4\u81f3\u4ee5\u4e0b\u5730\u5740\uff08\u90ae\u8d39\u81ea\u7406\uff09\uff1a \u5bc4\u9001\u5730\u5740\uff1a\u5e7f\u5dde\u5e02\u5929\u6cb3\u533a\u73e0\u6c5f\u897f\u8def5\u53f7\u5e7f\u5dde\u56fd\u9645\u91d1\u878d\u4e2d\u5fc3\u4e3b\u5854\u5199\u5b57\u697c(\u897f\u5854)\u7b2c34\u5c4210\u5355\u5143  \u6536\u4ef6\u4eba\uff1a    \u4eac\u4e1c\u5b89\u8054\u8d22\u4ea7\u4fdd\u9669\u6709\u9650\u516c\u53f8  \u975e\u8f66\u7406\u8d54  \u7535\u8bdd\uff1a        020-85132900  \u82e5\u60a8\u5df2\u5bc4\u51fa\u6750\u6599\uff0c\u8bf7\u5c3d\u5feb\u8865\u5145\u5feb\u9012\u5355\u53f7\uff0c\u6b64\u9879\u53ef\u52a0\u5feb\u60a8\u7684\u6848\u4ef6\u5ba1\u7406\u3002";
                                ProcessNode newProcessNode9 = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_022.getKey(), codeNameList, docCollectRecInfo.getSupTime());
                                processNodeList.add(newProcessNode9);
                            }
                        }
                    }
                    if ("1".equals(docCollectRecInfo.getSupType()) && !"3".equals(thisClaim.getCollectInfo().getStatus()) && "1".equals(docCollectRecInfo.getSource()) && docCollectRecInfo.getSupTime() != null && claimFlag.booleanValue() && claimTime.getTime() <= docCollectRecInfo.getSupTime().getTime()) {
                        newProcessNode = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_012.getKey(), ProcessNodeEnum.PROCESS_NODE_012.getValue(), docCollectRecInfo.getSupTime());
                        processNodeList.add(newProcessNode);
                    }
                    if (!"2".equals(docCollectRecInfo.getSupType()) || !"2".equals(docCollectRecInfo.getSource()) || thisClaim.getCollectInfo() == null || !StringUtils.isNotEmpty((CharSequence)thisClaim.getCollectInfo().getPackageNo()) || docCollectRecInfo.getSupTime() == null) continue;
                    newProcessNode = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_023.getKey(), ProcessNodeEnum.PROCESS_NODE_023.getValue() + thisClaim.getCollectInfo().getPackageNo(), docCollectRecInfo.getSupTime());
                    processNodeList.add(newProcessNode);
                }
            }
            Date payFlagTime = null;
            ProcessNode returnNode = new ProcessNode();
            if (thisClaim.getCompensateInfo() != null) {
                for (CompensateInfo thisCompensateInfo : thisClaim.getCompensateInfo()) {
                    if (thisCompensateInfo.getUnderwriteDate() != null && ("3".equals(thisCompensateInfo.getUnderwriteFlag()) || "1".equals(thisCompensateInfo.getUnderwriteFlag())) && thisCompensateInfo.getPayPersonInfo() != null && thisCompensateInfo.getPayPersonInfo().size() > 0 && !"09".equals(thisClaimInfo.getStatus())) {
                        String accountNo = ((PayPersonInfo)thisCompensateInfo.getPayPersonInfo().get(0)).getAccountNo();
                        accountNo = ObjectUtil.isNotEmpty((Object)accountNo) && accountNo.length() > 4 ? accountNo.substring(accountNo.length() - 4, accountNo.length()) : accountNo;
                        ProcessNode newProcessNode10 = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_30.getKey(), "\u6848\u4ef6\u5df2\u901a\u8fc7\u5ba1\u6838\uff0c\u7406\u8d54\u6b3e\u5c06\u57283\u4e2a\u5de5\u4f5c\u65e5\u5185\u6253\u5165" + ((PayPersonInfo)thisCompensateInfo.getPayPersonInfo().get(0)).getPayeeName() + "\u5c3e\u53f7\u4e3a" + accountNo + "\u7684" + ((PayPersonInfo)thisCompensateInfo.getPayPersonInfo().get(0)).getBankName() + "\u8d26\u6237\u4e2d\uff0c\u8bf7\u6ce8\u610f\u67e5\u6536\u3002", thisCompensateInfo.getUnderwriteDate());
                        processNodeList.add(newProcessNode10);
                        if (thisClaim.getPrplcmainfo() != null && ("03".equals(thisClaimInfo.getStatus()) || "04".equals(thisClaimInfo.getStatus())) && "0".equals(thisClaim.getPrplcmainfo().getPremiumStatus())) {
                            ProcessNode newProcessNode3 = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_03.getKey(), ProcessNodeEnum.PROCESS_NODE_03.getValue(), new Date(thisCompensateInfo.getUnderwriteDate().getTime() + 1L));
                            processNodeList.add(newProcessNode3);
                        }
                    }
                    if (!ObjectUtil.isNotEmpty((Object)thisCompensateInfo.getPayPersonInfo()) || ((PayPersonInfo)thisCompensateInfo.getPayPersonInfo().get(0)).getPayTime() == null) continue;
                    payFlagTime = ((PayPersonInfo)thisCompensateInfo.getPayPersonInfo().get(0)).getPayTime();
                    ProcessNode newProcessNode23 = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_05.getKey(), "\u7406\u8d54\u6210\u529f! \u8d54\u4ed8\u91d1\u989d " + thisClaimInfo.getSumRealPayCny() + "\u5143 \u5df2\u652f\u4ed8\u6210\u529f\uff0c\u60a8\u53ef\u70b9\u51fb\u7406\u8d54\u901a\u77e5\u4e66\uff0c\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f\u3002\u611f\u8c22\u60a8\u9009\u62e9\u4eac\u4e1c\u5b89\u8054\u8d22\u9669\u3002", ((PayPersonInfo)thisCompensateInfo.getPayPersonInfo().get(0)).getPayTime());
                    processNodeList.add(newProcessNode23);
                }
            }
            if ("09".equals(thisClaimInfo.getStatus()) && thisClaim.getClaimInfo() != null && thisClaim.getClaimInfo().size() > 0 && ((ClaimInfo)thisClaim.getClaimInfo().get(0)).getEndCaseTime() != null) {
                newProcessNode = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_08.getKey(), ProcessNodeEnum.PROCESS_NODE_08.getValue(), ((ClaimInfo)thisClaim.getClaimInfo().get(0)).getEndCaseTime());
                processNodeList.add(newProcessNode);
            }
            if ("05".equals(thisClaimInfo.getStatus()) && thisClaim.getClaimInfo() != null && thisClaim.getClaimInfo().size() > 0 && ((ClaimInfo)thisClaim.getClaimInfo().get(0)).getCancelTime() != null) {
                newProcessNode = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_07.getKey(), ProcessNodeEnum.PROCESS_NODE_07.getValue(), ((ClaimInfo)thisClaim.getClaimInfo().get(0)).getCancelTime());
                processNodeList.add(newProcessNode);
            }
            if ("06".equals(thisClaimInfo.getStatus()) && thisClaim.getClaimInfo() != null && thisClaim.getClaimInfo().size() > 0 && ((ClaimInfo)thisClaim.getClaimInfo().get(0)).getCancelTime() != null) {
                newProcessNode = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_06.getKey(), ProcessNodeEnum.PROCESS_NODE_06.getValue(), ((ClaimInfo)thisClaim.getClaimInfo().get(0)).getCancelTime());
                processNodeList.add(newProcessNode);
            } else if (thisClaim.getRegist() != null && thisClaim.getRegist().getRegistInfo() != null && thisClaim.getRegist().getRegistInfo().getCancelFlag() != null && "2".equals(thisClaim.getRegist().getRegistInfo().getCancelFlag()) && thisClaim.getRegist().getRegistInfo().getCancelTime() != null) {
                newProcessNode = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_06.getKey(), ProcessNodeEnum.PROCESS_NODE_06.getValue(), thisClaim.getRegist().getRegistInfo().getCancelTime());
                processNodeList.add(newProcessNode);
            }
            if (!"xml".equals(request.getClaimDetailServiceRequest().getHead().getXmlFlag()) && thisClaim.getRecaseInfoList() != null) {
                for (RecaseInfo recaseInfo : thisClaim.getRecaseInfoList()) {
                    if (recaseInfo.getOpenCaseDate() == null) continue;
                    ProcessNode newProcessNode11 = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_99.getKey(), ProcessNodeEnum.PROCESS_NODE_99.getValue(), recaseInfo.getOpenCaseDate());
                    processNodeList.add(newProcessNode11);
                }
            }
            try {
                Collections.sort(processNodeList, Comparator.comparing(ProcessNode::getNodeTime));
            }
            catch (Exception e) {
                log.error("\u7406\u8d54\u8be6\u60c5--\u7406\u8d54\u6d41\u7a0b\u8282\u70b9\u6392\u5e8f\u5f02\u5e38\uff1a {}", (Object)e.toString());
                throw ApisDataCompletionException.builder().errorCode(ErrorCode.NODELISTSORT_ERR0R.getCode()).message(ErrorCode.NODELISTSORT_ERR0R.getMessage()).build();
            }
            if (payFlagTime != null) {
                if ("05".equals(((ProcessNode)processNodeList.get(processNodeList.size() - 1)).getNodeStatus())) {
                    ((ProcessNode)processNodeList.get(processNodeList.size() - 1)).setNodeTime(payFlagTime);
                } else {
                    ((ProcessNode)processNodeList.get(processNodeList.size() - 2)).setNodeTime(payFlagTime);
                }
            }
            if (processNodeList.size() == 0) {
                throw ApisDataCompletionException.builder().errorCode(ErrorCode.NODELIST_ERR0R.getCode()).message(ErrorCode.NODELIST_ERR0R.getMessage()).build();
            }
            response.getClaimDetailResponse().getBody().setProcessNode(processNodeList);
            response.getClaimDetailResponse().getBody().setStatus(((ProcessNode)processNodeList.get(processNodeList.size() - 1)).getNodeStatus());
            response.getClaimDetailResponse().getBody().setQdClaimNodeMessage(((ProcessNode)processNodeList.get(processNodeList.size() - 1)).getNodeMessage());
        } else {
            log.error("\u672a\u83b7\u53d6\u5230\u7406\u8d54\u5217\u8868\u4fe1\u606f");
        }
        log.warn("\u6d41\u7a0b\u8282\u70b9\u5904\u7406\uff0c\u7528\u65f6 :{}", (Object)this.timer.intervalRestart());
        if ("xml".equals(request.getClaimDetailServiceRequest().getHead().getXmlFlag())) {
            if (response.getClaimDetailResponse().getBody().getDamageResult() != null) {
                String oldDamageResult = this.apisChannelCodeMapper.getChannelValueDo(null, "DamageResult", response.getClaimDetailResponse().getBody().getDamageResult());
                if (ObjectUtil.isNotEmpty((Object)oldDamageResult)) {
                    response.getClaimDetailResponse().getBody().setOldDamageResult(oldDamageResult);
                } else {
                    response.getClaimDetailResponse().getBody().setOldDamageResult(response.getClaimDetailResponse().getBody().getDamageResult());
                }
            }
            if (response.getClaimDetailResponse().getBody().getRegist() != null && response.getClaimDetailResponse().getBody().getRegist().getRegistInfo() != null && response.getClaimDetailResponse().getBody().getRegist().getRegistInfo().getReportType() != null) {
                String oldReportType = this.apisChannelCodeMapper.getChannelValueDo(null, "reportWay", response.getClaimDetailResponse().getBody().getRegist().getRegistInfo().getReportType());
                response.getClaimDetailResponse().getBody().getRegist().getRegistInfo().setReportType(oldReportType);
            }
            if (response.getClaimDetailResponse().getBody().getRegist() != null && response.getClaimDetailResponse().getBody().getRegist().getRegistInfo() != null && response.getClaimDetailResponse().getBody().getRegist().getRegistInfo().getReportorRelation() != null) {
                String oldReportorRelation = this.apisChannelCodeMapper.getChannelValueDo(null, "InsuredIdentity_back", response.getClaimDetailResponse().getBody().getRegist().getRegistInfo().getReportorRelation());
                response.getClaimDetailResponse().getBody().getRegist().getRegistInfo().setReportorRelation(oldReportorRelation);
            }
            String nodeText = "";
            String qdNodeText = "";
            if (response.getClaimDetailResponse().getBody().getStatus() != null) {
                String status = response.getClaimDetailResponse().getBody().getStatus();
                if ("00".equals(status)) {
                    response.getClaimDetailResponse().getBody().setStatus("00");
                    nodeText = "\u5c0a\u656c\u7684\u5ba2\u6237\uff0c\u6211\u4eec\u5c06\u5728\u6536\u5230\u8d44\u6599\u768410\u4e2a\u5de5\u4f5c\u65e5\u5185\u5904\u7406\uff0c\u8bf7\u7559\u610f\u6211\u53f8\u53d1\u9001\u7684\u77ed\u4fe1\u6216\u90ae\u4ef6\u3002";
                    qdNodeText = "\u5ba2\u6237\u5df2\u6210\u529f\u62a5\u6848\u3002";
                } else if ("000".equals(status) || "011".equals(status) || "010".equals(status) || "012".equals(status) || "99".equals(status)) {
                    response.getClaimDetailResponse().getBody().setStatus("01");
                    nodeText = "\u5c0a\u656c\u7684\u5ba2\u6237\uff0c\u6848\u4ef6\u5ba1\u6838\u4e2d\uff0c\u5982\u8d44\u6599\u9f50\u5168\uff0c\u6211\u4eec\u5c06\u572810\u4e2a\u5de5\u4f5c\u65e5\u5185\u5b8c\u6210\u5ba1\u6838\u3002";
                    qdNodeText = "\u7406\u8d54\u90e8\u5df2\u6210\u529f\u7acb\u6848\u3002";
                } else if ("021".equals(status) || "022".equals(status) || "023".equals(status)) {
                    response.getClaimDetailResponse().getBody().setStatus("02");
                    nodeText = codeNameList;
                    qdNodeText = "\u7406\u8d54\u90e8\u5728\u5904\u7406\u8d54\u6848\u65f6\u53d1\u751f\u8d44\u6599\u7f3a\u5931\uff0c\u9700\u8981\u5ba2\u6237\u8fdb\u884c\u8865\u4ea4\u3002";
                } else if ("03".equals(status)) {
                    nodeText = "\u60a8\u7684\u6848\u4ef6\u5df2\u7ecf\u901a\u8fc7\u5ba1\u6838\uff0c\u6848\u4ef6\u6b63\u5728\u652f\u4ed8\u4e2d\u3002";
                    qdNodeText = "";
                } else if ("04".equals(status) || "01".equals(status)) {
                    response.getClaimDetailResponse().getBody().setStatus("04");
                    nodeText = "\u5c0a\u656c\u7684\u5ba2\u6237\uff0c\u60a8\u7684\u7d22\u8d54\u7533\u8bf7\u5df2\u901a\u8fc7\u5ba1\u6838\uff0c\u4f46\u56e0\u9886\u6b3e\u94f6\u884c\u4fe1\u606f\u6709\u8bef\u5bfc\u81f4\u652f\u4ed8\u5931\u8d25\uff0c\u8bf7\u5c06\u60a8\u7684\u7acb\u6848\u53f7\u6216\u4fdd\u5355\u53f7\u3001\u6b63\u786e\u7684\u94f6\u884c\u4fe1\u606f\u3001\u88ab\u4fdd\u9669\u4eba\u7684\u8054\u7cfb\u65b9\u5f0f\u53d1\u9001\u81f3CustomerExcellence@allianz.cn\u4ee5\u4fbf\u6211\u4eec\u5c3d\u5feb\u5904\u7406\uff0c\u8c22\u8c22\uff01";
                    qdNodeText = "\u7406\u8d54\u90e8\u5df2\u5b8c\u6210\u5ba1\u6838\uff0c\u4f46\u56e0\u9886\u6b3e\u94f6\u884c\u4fe1\u606f\u6709\u8bef\u5bfc\u81f4\u8d54\u6b3e\u652f\u4ed8\u5931\u8d25/\u8d54\u6b3e\u65e0\u6cd5\u652f\u4ed8\u3002";
                } else if ("05".equals(status)) {
                    nodeText = "\u5c0a\u656c\u7684\u5ba2\u6237\uff0c\u60a8\u7684\u7d22\u8d54\u7533\u8bf7\u5df2\u901a\u8fc7\u5ba1\u6838\u5e76\u652f\u4ed8\u6210\u529f\uff0c\u8d54\u6b3e\u5df2\u652f\u4ed8\u5230\u60a8\u63d0\u4f9b\u7684\u94f6\u884c\u8d26\u53f7\u4e0a\uff0c\u8bf7\u6ce8\u610f\u67e5\u6536\uff0c\u8c22\u8c22\uff01";
                    qdNodeText = "\u7406\u8d54\u90e8\u5df2\u5b8c\u6210\u5ba1\u6838\uff0c\u4e14\u8d54\u6b3e\u5df2\u6210\u529f\u652f\u4ed8\u3002";
                } else if ("06".equals(status)) {
                    nodeText = "\u5c0a\u656c\u7684\u5ba2\u6237\uff0c\u60a8\u7684\u7d22\u8d54\u7533\u8bf7\u6709\u5f02\u5e38\uff08\u53ef\u80fd\u56e0\u91cd\u590d\u62a5\u6848\u3001\u8d44\u6599\u4e0d\u9f50\u3001\u672a\u8fbe\u8d54\u4ed8\u6807\u51c6\u3001\u7533\u8bf7\u7684\u4fdd\u969c\u5229\u76ca\u6709\u8bef\u7b49\u539f\u56e0\u5bfc\u81f4\uff09\uff0c\u5982\u9700\u8fdb\u4e00\u6b65\u4e86\u89e3\u8bf7\u5c06\u60a8\u7684\u7acb\u6848\u53f7\u6216\u4fdd\u5355\u53f7\u3001\u8054\u7cfb\u65b9\u5f0f\u53d1\u9001\u81f3 CustomerExcellence@allianz.cn\u4ee5\u4fbf\u6211\u4eec\u5c3d\u5feb\u56de\u590d\uff0c\u8c22\u8c22\uff01";
                    qdNodeText = "\u7406\u8d54\u90e8\u5df2\u5b8c\u6210\u5ba1\u6838\uff0c\u4f46\u56e0\u7d22\u8d54\u7533\u8bf7\u5f02\u5e38\u800c\u6ce8\u9500\u6848\u4ef6\u3002";
                } else if ("07".equals(status)) {
                    nodeText = "\u5c0a\u656c\u7684\u5ba2\u6237\uff0c\u60a8\u7684\u7d22\u8d54\u7533\u8bf7\u5df2\u5ba1\u6838\u5b8c\u6bd5\u5e76\u7ed3\u6848\uff0c\u6211\u53f8\u5df2\u5c06\u3010\u7406\u8d54\u7ed3\u679c\u901a\u77e5\u4e66\u3011\u53d1\u9001\u5230\u60a8\u9884\u7559\u7684\u90ae\u7bb1\uff0c\u8bf7\u6ce8\u610f\u67e5\u6536\u3002\u5982\u6709\u4efb\u4f55\u7591\u95ee\u6216\u67e5\u8be2\u53ef\u53d1\u9001\u90ae\u4ef6\u81f3CustomerExcellence@allianz.cn\u4ee5\u4fbf\u6c9f\u901a\uff0c\u8c22\u8c22\uff01";
                    qdNodeText = "\u7406\u8d54\u90e8\u5df2\u5b8c\u6210\u5ba1\u6838\uff0c\u4e14\u5df2\u4f5c\u51fa\u62d2\u8d54\u5904\u7406\u3002";
                } else if ("08".equals(status)) {
                    nodeText = "\u5c0a\u656c\u7684\u5ba2\u6237\uff0c\u60a8\u7684\u7d22\u8d54\u7533\u8bf7\u5df2\u5ba1\u6838\u5b8c\u6bd5\u5e76\u7ed3\u6848\uff0c\u672c\u6b21\u8d54\u4ed8\u91d1\u989d\u4e3a0\u3002\u5982\u6709\u4efb\u4f55\u7591\u95ee\u8bf7\u81f4\u7535400-800-2020\u6216\u53ef\u53d1\u9001\u90ae\u4ef6\u81f3CustomerExcellence@allianz.cn\u67e5\u8be2\uff0c\u8c22\u8c22\uff01";
                    qdNodeText = "\u7406\u8d54\u90e8\u5df2\u5b8c\u6210\u5ba1\u6838\uff0c\u8d54\u4ed8\u91d1\u989d\u4e3a0\u3002";
                } else if ("30".equals(status)) {
                    nodeText = "\u7cfb\u7edf\u72b6\u6001\u66f4\u65b0\u4e2d\uff0c\u8bf7\u7ea6\u4e00\u5c0f\u65f6\u540e\u518d\u6b21\u67e5\u8be2\uff01";
                    qdNodeText = "\u7406\u8d54\u90e8\u5df2\u5b8c\u6210\u5ba1\u6838\uff0c\u5728\u89e6\u53d1\u652f\u4ed8\u4e4b\u95f4\u7ea6\u670910\u5206\u949f\u7684\u95f4\u9694\u65f6\u95f4\u3002";
                }
            }
            if (response.getClaimDetailResponse().getBody().getProcessNode() != null && response.getClaimDetailResponse().getBody().getProcessNode().size() > 0) {
                ArrayList<ProcessNode> processNodeList = new ArrayList<ProcessNode>();
                ProcessNode processNode = (ProcessNode)response.getClaimDetailResponse().getBody().getProcessNode().get(response.getClaimDetailResponse().getBody().getProcessNode().size() - 1);
                processNode.setNodeStatus(response.getClaimDetailResponse().getBody().getStatus());
                processNode.setNodeMessage(nodeText);
                processNodeList.add(processNode);
                response.getClaimDetailResponse().getBody().setProcessNode(processNodeList);
                response.getClaimDetailResponse().getBody().setQdClaimNodeMessage(qdNodeText);
                if (response.getClaimDetailResponse().getBody().getCollectInfo() != null) {
                    if ("021".equals(processNode.getNodeStatus())) {
                        response.getClaimDetailResponse().getBody().getCollectInfo().setRemark("1");
                    } else if ("022".equals(processNode.getNodeStatus())) {
                        response.getClaimDetailResponse().getBody().getCollectInfo().setRemark("2");
                    } else {
                        response.getClaimDetailResponse().getBody().getCollectInfo().setRemark("0");
                    }
                }
            }
            if (response.getClaimDetailResponse().getBody().getCollectInfo() != null && response.getClaimDetailResponse().getBody().getCollectInfo().getStatus() != null) {
                String thisStatus = response.getClaimDetailResponse().getBody().getCollectInfo().getStatus();
                if ("1".equals(thisStatus)) {
                    thisStatus = "2";
                } else if ("2".equals(thisStatus)) {
                    thisStatus = "1";
                } else if ("3".equals(thisStatus)) {
                    thisStatus = "0";
                } else if ("4".equals(thisStatus)) {
                    thisStatus = "3";
                }
                response.getClaimDetailResponse().getBody().getCollectInfo().setStatus(thisStatus);
                if (cNameList.size() > 0) {
                    response.getClaimDetailResponse().getBody().getCollectInfo().setCNameList(cNameList);
                }
            }
        }
        if ("xcxml".equals(request.getClaimDetailServiceRequest().getHead().getXmlFlag())) {
            if (response.getClaimDetailResponse().getBody().getStatus() != null) {
                String status = response.getClaimDetailResponse().getBody().getStatus();
                if ("".equals(status)) {
                    response.getClaimDetailResponse().getBody().setStatus("2");
                }
                if ("00".equals(status) || "000".equals(status)) {
                    response.getClaimDetailResponse().getBody().setStatus("2");
                }
                if ("012".equals(status) || "99".equals(status)) {
                    response.getClaimDetailResponse().getBody().setStatus("3");
                }
                if ("011".equals(status) || "010".equals(status) || "023".equals(status)) {
                    response.getClaimDetailResponse().getBody().setStatus("4");
                }
                if ("01".equals(status) || "30".equals(status) || "03".equals(status) || "04".equals(status) || "08".equals(status) || "07".equals(status) || "06".equals(status)) {
                    response.getClaimDetailResponse().getBody().setStatus("5");
                }
                if ("05".equals(status)) {
                    response.getClaimDetailResponse().getBody().setStatus("6");
                }
                if ("021".equals(status) || "022".equals(status)) {
                    response.getClaimDetailResponse().getBody().setStatus("8");
                }
            } else {
                response.getClaimDetailResponse().getBody().setStatus("2");
            }
        }
        log.warn("\u6807\u51c6\u6e20\u9053\u7c7b\u578b\u8f6c\u5316\uff0c\u7528\u65f6 :{}", (Object)this.timer.intervalRestart());
        try {
            if (response.getClaimDetailResponse().getBody().getPrplcmainfo() != null && response.getClaimDetailResponse().getBody().getPrplcmainfo().getInsuredUserList() != null && response.getClaimDetailResponse().getBody().getPrplcmainfo().getInsuredUserList().size() == 0) {
                response.getClaimDetailResponse().getBody().getPrplcmainfo().setInsuredUserList(null);
            }
            if (response.getClaimDetailResponse().getBody().getCollectInfo() != null && response.getClaimDetailResponse().getBody().getCollectInfo().getDocCollectRecInfo() != null && response.getClaimDetailResponse().getBody().getCollectInfo().getDocCollectRecInfo().size() == 0) {
                response.getClaimDetailResponse().getBody().getCollectInfo().setDocCollectRecInfo(null);
            }
            if (response.getClaimDetailResponse().getBody().getCollectInfo() != null && response.getClaimDetailResponse().getBody().getCollectInfo().getCollectguideInfo() != null && response.getClaimDetailResponse().getBody().getCollectInfo().getCollectguideInfo().size() == 0) {
                response.getClaimDetailResponse().getBody().getCollectInfo().setCollectguideInfo(null);
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u6838\u5fc3\u6570\u636e\u53d1\u751f\u9519\u8bef\uff0c\u4e0d\u5b58\u5728\u6570\u636e\u8fd4\u56de", (Throwable)e);
        }
        return response;
    }

    private boolean checkRequestHeadBodyIsNull(StanderRequest request) {
        return ObjectUtil.isEmpty((Object)request) || ObjectUtil.isEmpty((Object)request.getClaimDetailServiceRequest()) || ObjectUtil.isEmpty((Object)request.getClaimDetailServiceRequest().getHead()) || ObjectUtil.isEmpty((Object)request.getClaimDetailServiceRequest().getBody());
    }

    private boolean checkResponseBodyIsNull(StanderResponse standerResponse) {
        return standerResponse.getClaimDetailResponse() == null || standerResponse.getClaimDetailResponse().getBody() == null;
    }

    private boolean checkResponseHeadSuccess(StanderResponse standerResponse) {
        return standerResponse.getClaimDetailResponse() != null && standerResponse.getClaimDetailResponse().getHead() != null && String.valueOf(1).equals(standerResponse.getClaimDetailResponse().getHead().getResponseCode());
    }
}

