/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.handler.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.consts.ClaimErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.ImageQueryDownRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.ImageQueryDownRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.ImageQueryDownResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.ImageRequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.ImageResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.ImageSystemBaseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.ImageSystemMetaDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiRequestRegistService;
import com.jdaz.sinosoftgz.apis.commons.utils.ImageUtils;
import java.util.ArrayList;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class ClaimFindHandler
implements BusinessHandler {
    private static final Logger log = LoggerFactory.getLogger(ClaimFindHandler.class);
    final Logger logger = LoggerFactory.getLogger(ClaimFindHandler.class);
    @Value(value="${ePolicy.down.url}")
    private String ePolicyDownUrl;
    @Value(value="${ePolicy.down.newUrl}")
    private String ePolicyDownNewUrl;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    ApisBusiRequestRegistService apisBusiRequestRegistService;
    @Autowired
    private ImageUtils imageUtils;

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        String registNoByRequestId;
        StanderResponse standerResponse = new StanderResponse();
        if (request.getImageQueryDownRequest() == null) {
            return StanderResponse.builder().header(request.getHeader()).imageQueryDownResponse(ImageQueryDownResponse.builder().responseHead(ImageResponseHeadDTO.builder().errorCode("0").errorMessage("\u672a\u63a5\u53d7\u5230\u4f20\u53c2").build()).build()).build();
        }
        String business = "";
        List imgId = new ArrayList();
        if (request.getImageQueryDownRequest().getRequestBody() != null && request.getImageQueryDownRequest().getRequestBody().getMetaData() != null && request.getImageQueryDownRequest().getRequestBody().getMetaData().getBusinessNo() != null && StringUtils.isNotEmpty((CharSequence)(registNoByRequestId = this.apisBusiRequestRegistService.getRegistNoByRequestId(business = request.getImageQueryDownRequest().getRequestBody().getMetaData().getBusinessNo())))) {
            business = registNoByRequestId;
        }
        if (request.getImageQueryDownRequest().getRequestBody() != null && request.getImageQueryDownRequest().getRequestBody().getMetaData() != null && request.getImageQueryDownRequest().getRequestBody().getMetaData().getImgIds() != null && request.getImageQueryDownRequest().getRequestBody().getMetaData().getImgIds().size() > 0) {
            imgId = request.getImageQueryDownRequest().getRequestBody().getMetaData().getImgIds();
        }
        ImageQueryDownRequest imageQueryDownRequest = new ImageQueryDownRequest();
        boolean encFlag = this.imageUtils.imgConsumerPwdEncFlag();
        ImageRequestHeadDTO headDto = this.imageUtils.initImageRequestHead(encFlag);
        ImageQueryDownRequestDTO requestDto = new ImageQueryDownRequestDTO();
        ImageSystemBaseDTO baseData = new ImageSystemBaseDTO();
        baseData.setComCode("000000");
        baseData.setNetType("http.inner");
        baseData.setOperator("test001");
        baseData.setOperatorName("\u67e5\u8be2\u4eba\u5458");
        baseData.setOperatorRole("CLA_R01");
        ImageSystemMetaDTO metaData = new ImageSystemMetaDTO();
        metaData.setAppCode("CL");
        metaData.setClassCode("CLA");
        metaData.setBusinessNo(business);
        if (imgId.size() > 0) {
            metaData.setImgIds(imgId);
        }
        requestDto.setBaseData(baseData);
        requestDto.setMetaData(metaData);
        imageQueryDownRequest.setRequestHead(headDto);
        imageQueryDownRequest.setRequestBody(requestDto);
        String apiUrl = encFlag ? this.ePolicyDownNewUrl : this.ePolicyDownUrl;
        String jsonData = JSONObject.toJSONString((Object)imageQueryDownRequest);
        log.warn("\u7406\u8d54\u5f71\u50cf\u8d44\u6599\u67e5\u8be2,URL:{},\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)apiUrl, (Object)jsonData);
        try {
            OkHttpClient okHttpClient = new OkHttpClient();
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)JSON.toJSONString((Object)imageQueryDownRequest));
            Request okRequest = new Request.Builder().url(apiUrl).post(requestBody).build();
            Response okResponse = okHttpClient.newCall(okRequest).execute();
            String responseStr = okResponse.body().string();
            ImageQueryDownResponse response = (ImageQueryDownResponse)JSON.parseObject((String)responseStr, ImageQueryDownResponse.class);
            log.warn("\u7406\u8d54\u5f71\u50cf\u8d44\u6599\u67e5\u8be2\u8fd4\u56de\uff1a{}", (Object)okResponse.toString());
            if (response == null || response.getResponseBody() == null) {
                return StanderResponse.builder().header(request.getHeader()).imageQueryDownResponse(ImageQueryDownResponse.builder().responseHead(ImageResponseHeadDTO.builder().errorCode(ClaimErrorCodeEnum.ERR_CL10002.getKey()).errorMessage(ClaimErrorCodeEnum.ERR_CL10002.getValue()).build()).build()).build();
            }
            standerResponse.setImageQueryDownResponse(response);
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u5f71\u50cf\u67e5\u8be2\u4e0b\u8f7d\u5f02\u5e38,", (Throwable)e);
        }
        return standerResponse;
    }
}

