/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.jdh.AesUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderHeader;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.CommonRequestHead;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.jdh.JdhQuestionRequestDTO;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ClaimJdhQuestionnaireHandler
implements BusinessHandler {
    private static Logger log = LoggerFactory.getLogger(ClaimJdhQuestionnaireHandler.class);
    @Value(value="${jdh.aesIvStr}")
    private String aesIvStr;
    @Value(value="${jdh.aesKey}")
    private String aesKey;
    TimeInterval timer = DateUtil.timer();

    public StanderRequest dataCompletion(StanderRequest request) throws ApisDataCompletionException {
        String uid = UUID.randomUUID().toString().replaceAll("-", "");
        request.getJdhQuestionServiceRequest().setHead(CommonRequestHead.builder().transID(uid).build());
        log.warn("\u4eac\u4e1c\u5065\u5eb7\u95ee\u8bca\u4fe1\u606fUUID\u4e3a\uff1a{}", (Object)uid);
        JdhQuestionRequestDTO dto = request.getJdhQuestionServiceRequest().getBody();
        String idNumber = AesUtil.decrypt((String)dto.getPatientCardId(), (String)this.aesKey, (String)this.aesIvStr);
        dto.setPatientCardId(idNumber);
        log.warn("\u4eac\u4e1c\u5065\u5eb7\u89e3\u5bc6\u540e\u8eab\u4efd\u8bc1\u53f7\u4e3a\uff1a{}", (Object)idNumber);
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        log.warn("\u5165\u5e93\u6570\u636e\u4e3a:{}", (Object)JSON.toJSONString((Object)request.getJdhQuestionServiceRequest().getBody()));
        StanderResponse standerResponse = StanderResponse.builder().build();
        return standerResponse;
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) {
        response.setHeader(StanderHeader.builder().businessKey(request.getJdhQuestionServiceRequest().getHead().getTransID()).build());
        return response;
    }
}

