/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.consts.ClaimErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderHeader;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.request.ClaimMedia;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.request.ClaimMediaCommitResult;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiRequestRegistService;
import com.jdaz.sinosoftgz.coreapi.claims.CoreClaimDataCompletionApi;
import com.jdaz.sinosoftgz.coreapi.common.configs.CoreApiProperties;
import com.jdaz.sinosoftgz.coreapi.common.configs.CoreApiServProperties;
import com.jdaz.sinosoftgz.coreapi.h5img.MediaUploadApi;
import com.sinosoft.image.client.dto.ImgBatchUploadMetaDTO;
import com.sinosoft.image.client.dto.ImgBatchUploadRequestDTO;
import com.sinosoft.image.client.dto.ImgBusiDTO;
import com.sinosoft.image.client.dto.RequestHeadDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ClaimMediaSubmitHandler
implements BusinessHandler {
    private static final Logger log = LoggerFactory.getLogger(ClaimMediaSubmitHandler.class);
    final Logger logger = LoggerFactory.getLogger(ClaimMediaSubmitHandler.class);
    @Autowired
    MediaUploadApi mediaUploadApi;
    @Autowired
    CoreClaimDataCompletionApi coreClaimDataCompletionApi;
    @Autowired
    CoreApiProperties coreApiProperties;
    @Autowired
    ApisBusinessService apisBusinessService;
    @Autowired
    ApisBusiRequestRegistService apisBusiRequestRegistService;
    TimeInterval timer = DateUtil.timer();

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)request.getClaimMediaCommitRequest().getClaimTransactionId())) {
            String registNoByRequestId = this.apisBusiRequestRegistService.getRegistNoByRequestId(request.getClaimMediaCommitRequest().getClaimTransactionId());
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)registNoByRequestId)) {
                request.getClaimMediaCommitRequest().setBussNo(registNoByRequestId);
            }
            if ("xcxml".equals(request.getClaimMediaCommitRequest().getXmlFlag())) {
                try {
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)((ClaimMedia)request.getClaimMediaCommitRequest().getMediaList().get(0)).getExtendName())) {
                        throw new ApisBusinessException(ClaimErrorCodeEnum.ERR_CL10003.getValue(), ClaimErrorCodeEnum.ERR_CL10003.getKey());
                    }
                    ((ClaimMedia)request.getClaimMediaCommitRequest().getMediaList().get(0)).setFileOrgName(((ClaimMedia)request.getClaimMediaCommitRequest().getMediaList().get(0)).getFileOrgName() + "." + ((ClaimMedia)request.getClaimMediaCommitRequest().getMediaList().get(0)).getExtendName());
                }
                catch (Exception e) {
                    throw new ApisBusinessException(ClaimErrorCodeEnum.ERR_CL10004.getValue(), ClaimErrorCodeEnum.ERR_CL10004.getKey());
                }
            }
            log.warn("\u6d41\u6c34\u53f7\u8f6c\u62a5\u6848\u53f7\uff0c\u7528\u65f6 :{}", (Object)this.timer.intervalRestart());
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)request.getClaimMediaCommitRequest().getBussNo())) {
            throw new ApisBusinessException(ClaimErrorCodeEnum.ERR_CL10005.getValue(), ClaimErrorCodeEnum.ERR_CL10005.getKey());
        }
        this.timer.intervalRestart();
        log.warn("\u672c\u6b21\u4e0a\u4f20\u8bf7\u6c42\u4e1a\u52a1\u53f7\uff1a{}", (Object)request.getClaimMediaCommitRequest().getBussNo());
        StanderResponse standerResponse = new StanderResponse();
        ImgBatchUploadRequestDTO imgBatchUploadRequestDTO = new ImgBatchUploadRequestDTO();
        RequestHeadDTO requestHeadDTO = new RequestHeadDTO();
        if (request.getHeader() != null) {
            StanderHeader header = request.getHeader();
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)request.getHeader().getBusinessKey())) {
                requestHeadDTO.setSeqNo(request.getHeader().getBusinessKey());
            }
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)requestHeadDTO.getSeqNo())) {
            requestHeadDTO.setSeqNo(UUID.randomUUID().toString().replace("-", ""));
        }
        requestHeadDTO.setRequestTime(new Date());
        requestHeadDTO.setOptComCode("apis");
        requestHeadDTO.setOptUserCode("apis");
        requestHeadDTO.setOptUserName("apis");
        imgBatchUploadRequestDTO.setHeadDto(requestHeadDTO);
        ImgBusiDTO imgBusiDTO = new ImgBusiDTO();
        imgBusiDTO.setAppCode("CL");
        imgBusiDTO.setClassCode("CLA");
        imgBusiDTO.setBusinessNo(request.getClaimMediaCommitRequest().getBussNo());
        imgBusiDTO.setBusiComCode("apis");
        imgBatchUploadRequestDTO.setBusiDto(imgBusiDTO);
        Optional<String> linkId = request.getClaimMediaCommitRequest().getMediaList().stream().map(ClaimMedia::getLinkNo).filter(Objects::nonNull).findFirst();
        if (linkId.isPresent()) {
            imgBatchUploadRequestDTO.getBusiDto().setLinkNo(linkId.get());
        }
        ArrayList<ImgBatchUploadMetaDTO> uploadMetaDTOList = new ArrayList<ImgBatchUploadMetaDTO>();
        for (ClaimMedia m : request.getClaimMediaCommitRequest().getMediaList()) {
            ImgBatchUploadMetaDTO imgBatchUploadMetaDTO = new ImgBatchUploadMetaDTO();
            imgBatchUploadMetaDTO.setBase64FileContent(m.getBase64FileContent());
            imgBatchUploadMetaDTO.setFileURL(m.getFileUrl());
            imgBatchUploadMetaDTO.setCovered(m.getIsCovered() == null ? false : m.getIsCovered());
            imgBatchUploadMetaDTO.setFileOrgName(m.getFileOrgName());
            log.warn("\u8bf7\u6c42\u6587\u4ef6\u7684\u540d\u79f0\uff1a{}", (Object)m.getFileOrgName());
            imgBatchUploadMetaDTO.setShootModel(m.getShootModel());
            imgBatchUploadMetaDTO.setShootTime(m.getShootTime());
            if (StringUtils.isEmpty((Object)m.getImgType()) || StringUtils.isEmpty((Object)m.getImgTypeName()) || "99930".equals(m.getImgType())) {
                this.logger.warn("\u672a\u4f20\u5165\u7406\u8d54\u5355\u8bc1\u7c7b\u578b\u548c\u7406\u8d54\u5355\u8bc1\u540d\u79f0\uff01\u5df2\u7ecf\u8bbe\u7f6e\u4e3a\u9ed8\u8ba4\u7684\u5176\u5b83\u7c7b\u578b");
                imgBatchUploadMetaDTO.setImgType("|999|");
                imgBatchUploadMetaDTO.setImgTypeName("|\u5176\u4ed6|");
            } else {
                imgBatchUploadMetaDTO.setImgType(ObjectUtil.isNotEmpty((Object)m.getImgType()) && !m.getImgType().startsWith("|") && !m.getImgType().endsWith("|") ? "|" + m.getImgType() + "|" : m.getImgType());
                imgBatchUploadMetaDTO.setImgTypeName(ObjectUtil.isNotEmpty((Object)m.getImgTypeName()) && !m.getImgTypeName().startsWith("|") && !m.getImgTypeName().endsWith("|") ? "|" + m.getImgTypeName() + "|" : m.getImgTypeName());
            }
            uploadMetaDTOList.add(imgBatchUploadMetaDTO);
        }
        imgBatchUploadRequestDTO.setUploadMetas(uploadMetaDTOList);
        Optional properties = this.coreApiProperties.getServProperties("batchUploadFile");
        if (!properties.isPresent()) {
            throw new ApisBusinessException(ClaimErrorCodeEnum.ERR_CL10006.getValue(), ClaimErrorCodeEnum.ERR_CL10006.getKey());
        }
        requestHeadDTO.setConsumerID(((CoreApiServProperties)properties.get()).getUser());
        requestHeadDTO.setConsumerPWD(((CoreApiServProperties)properties.get()).getUserPwd());
        if (null != request.getClaimMediaCommitRequest().getBussNo()) {
            log.warn("\u8d44\u6599\u4e0a\u4f20\u6848\u4ef6\u53f7\uff1a{}", (Object)request.getClaimMediaCommitRequest().getBussNo());
        }
        ClaimMediaCommitResult responseDTO = this.mediaUploadApi.batchUpload(((CoreApiServProperties)properties.get()).getUrl(), imgBatchUploadRequestDTO, null);
        if (null != request.getClaimMediaCommitRequest().getBussNo()) {
            log.warn("\u6848\u4ef6\u53f7\u4e3a: {}, \u5f71\u50cf\u7cfb\u7edf\u8fd4\u56de\u62a5\u6587\uff1a{}", (Object)request.getClaimMediaCommitRequest().getBussNo(), (Object)responseDTO);
        } else {
            log.warn("\u5f71\u50cf\u7cfb\u7edf\u8fd4\u56de\u62a5\u6587\uff1a{}", (Object)responseDTO);
        }
        log.warn("\u8bbf\u95ee\u5f71\u50cf\u4e0a\u4f20\u63a5\u53e3\uff0c\u7528\u65f6 :{}", (Object)this.timer.intervalRestart());
        if (responseDTO.getImgNodes() != null) {
            responseDTO.setImgNodeList(responseDTO.getImgNodes());
            responseDTO.setSize(responseDTO.getImgNodes().size());
        }
        if (responseDTO == null || responseDTO.getHeadDto() == null) {
            throw new ApisBusinessException(ClaimErrorCodeEnum.ERR_CL10007.getValue(), ClaimErrorCodeEnum.ERR_CL10007.getKey());
        }
        if (responseDTO.getHeadDto().getStatus() >= 0) {
            standerResponse.setHeader(request.getHeader());
            standerResponse.setClaimMediaCommitResult(responseDTO);
            return standerResponse;
        }
        throw new ApisBusinessException("\u5f71\u50cf\u7cfb\u7edf\u8c03\u7528\u5931\u8d25\uff1a" + responseDTO.getHeadDto().getErrorMessage(), responseDTO.getHeadDto().getErrorCode());
    }
}

