/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.consts.ClaimErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.consts.ErrorCode;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryDetail.response.DocCollectRecInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryDetail.response.PayPersonInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryDetail.response.UnderWriteInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.DocCodeAndName;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.response.ClaimListInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.response.ClaimListQueryResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.response.DisposeInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.response.ProcessNode;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.response.ProcessNodeEnum;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.response.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.channel.mapper.ApisChannelCodeMapper;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.ApisPfpProductMainService;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.ApisPfpRationKindService;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.impl.ApisPfpKindClaimExchangeServiceImpl;
import com.jdaz.sinosoftgz.coreapi.claims.CoreClaimsDetailApi;
import com.jdaz.sinosoftgz.coreapi.claims.CoreClaimsQueryApi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class ClaimQueryHandler
implements BusinessHandler {
    private Logger log = LoggerFactory.getLogger(ClaimQueryHandler.class);
    @Autowired
    private CoreClaimsQueryApi coreClaimsQueryApi;
    @Autowired
    private ApisPfpProductMainService apisPfpProductMainService;
    @Autowired
    private ApisPfpRationKindService apisPfpRationKindService;
    @Autowired
    ApisPfpKindClaimExchangeServiceImpl apisPfpKindClaimExchangeServiceImpl;
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${policyListAddress}")
    private String policyListAddress;
    @Autowired
    private CoreClaimsDetailApi coreClaimsDetailApi;
    @Autowired
    private DocCodeAndName docCodeAndName;
    @Autowired
    private ApisChannelCodeMapper apisChannelCodeMapper;
    TimeInterval timer = DateUtil.timer();

    public StanderRequest dataCompletion(StanderRequest request) throws ApisDataCompletionException {
        if (this.checkRequestHeadBodyIsNull(request)) {
            throw ApisDataCompletionException.builder().message("\u975e\u8f66\u7406\u8d54\u5217\u8868\u67e5\u8be2\u8bf7\u6c42\u5934\u548c\u8bf7\u6c42\u4f53\u4e0d\u80fd\u4e3a\u7a7a").build();
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getClaimListQueryServiceRequest().getBody().getLossTypes())) {
            String newDamageResult = this.apisChannelCodeMapper.getValue("DamageResult", request.getClaimListQueryServiceRequest().getBody().getLossTypes());
            if (StringUtils.isEmpty((CharSequence)newDamageResult)) {
                newDamageResult = "99999";
            }
            request.getClaimListQueryServiceRequest().getBody().setDamageResult(newDamageResult);
        }
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        this.timer.intervalRestart();
        if (this.checkRequestHeadBodyIsNull(request)) {
            return StanderResponse.builder().header(request.getHeader()).claimListQueryResponse(ClaimListQueryResponse.builder().head(ResponseHeadDTO.builder().errorCode(ClaimErrorCodeEnum.ERR_CL10009.getKey()).errorMessage(ClaimErrorCodeEnum.ERR_CL10009.getValue()).build()).build()).build();
        }
        String uuid = cn.hutool.core.lang.UUID.fastUUID().toString().replaceAll("-", "");
        String businessKey = request.getHeader().getBusinessKey();
        request.getHeader().setBusinessKey(ObjectUtil.isNotEmpty((Object)businessKey) ? businessKey : uuid);
        RequestHeadDTO requestHeadDTO = request.getClaimListQueryServiceRequest().getHead();
        requestHeadDTO.setTransDate(new Date());
        if (StringUtils.isBlank((CharSequence)requestHeadDTO.getTransID())) {
            requestHeadDTO.setTransID(UUID.randomUUID().toString().replace("-", ""));
        }
        request.getClaimListQueryServiceRequest().getBody().setUserCode(request.getHeader().getUserCode());
        if ("DE000134".equals(request.getHeader().getChannelCode())) {
            request.getClaimListQueryServiceRequest().getBody().setReportType("05");
        }
        this.log.warn("\u6570\u636e\u6821\u9a8c\uff0c\u7528\u65f6 :{}", (Object)this.timer.intervalRestart());
        return this.coreClaimsQueryApi.claimsQuery(request);
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) {
        block41: {
            if (this.checkRequestHeadBodyIsNull(request) || this.checkResponseBodyIsNull(response) || !this.checkResponseHeadSuccess(response)) {
                return response;
            }
            this.log.warn("\u8bf7\u6c42\u4f53\u6216\u8005\u54cd\u5e94\u4f53\u4e3a\u7a7a\u5224\u65ad\uff0c\u7528\u65f6 :{}", (Object)this.timer.intervalRestart());
            try {
                for (ClaimListInfo thisClaimInfo : response.getClaimListQueryResponse().getBody().getClaimInfoList()) {
                    ProcessNode newProcessNode;
                    ProcessNode newProcessNode2;
                    ProcessNode newProcessNode22;
                    ProcessNode newProcessNode3;
                    ArrayList<ProcessNode> processNodeList = new ArrayList<ProcessNode>();
                    if (thisClaimInfo.getReportDate() != null || thisClaimInfo.getConsultationTime() != null) {
                        ProcessNode newProcessNode4 = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_00.getKey(), ProcessNodeEnum.PROCESS_NODE_00.getValue(), thisClaimInfo.getReportDate() != null ? thisClaimInfo.getReportDate() : thisClaimInfo.getConsultationTime());
                        processNodeList.add(newProcessNode4);
                    }
                    Boolean claimFlag = false;
                    Date claimTime = new Date();
                    if (thisClaimInfo.getClaimTime() != null) {
                        newProcessNode3 = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_000.getKey(), ProcessNodeEnum.PROCESS_NODE_000.getValue(), thisClaimInfo.getClaimTime());
                        processNodeList.add(newProcessNode3);
                        claimFlag = true;
                        claimTime = thisClaimInfo.getClaimTime();
                    }
                    if (thisClaimInfo.getClaimTime() != null) {
                        newProcessNode3 = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_010.getKey(), ProcessNodeEnum.PROCESS_NODE_010.getValue(), thisClaimInfo.getClaimTime());
                        processNodeList.add(newProcessNode3);
                    }
                    Date heipeiTime = new Date();
                    Boolean heipeiFlag = false;
                    int returnFlag = 0;
                    for (DisposeInfo disInfo : thisClaimInfo.getDisposeInfoList()) {
                        if (disInfo.getSubNodeCode().contains("\u6838\u8d54") && disInfo.getAcceptTime().getTime() < heipeiTime.getTime()) {
                            heipeiTime = disInfo.getAcceptTime();
                            heipeiFlag = true;
                        }
                        if (!disInfo.getSubNodeCode().contains("\u9000\u7968") || disInfo.getAcceptTime() == null) continue;
                        newProcessNode22 = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_04.getKey(), ProcessNodeEnum.PROCESS_NODE_04.getValue(), disInfo.getAcceptTime());
                        processNodeList.add(newProcessNode22);
                        returnFlag = -1;
                        if (disInfo.getOutOffTime() == null) continue;
                        newProcessNode2 = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_01.getKey(), ProcessNodeEnum.PROCESS_NODE_01.getValue(), disInfo.getOutOffTime());
                        processNodeList.add(newProcessNode2);
                    }
                    if (heipeiFlag.booleanValue()) {
                        ProcessNode newProcessNode5 = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_011.getKey(), ProcessNodeEnum.PROCESS_NODE_011.getValue(), heipeiTime);
                        processNodeList.add(newProcessNode5);
                    }
                    if (thisClaimInfo.getCollectInfo() != null && thisClaimInfo.getCollectInfo().getDocCollectRecInfo() != null) {
                        for (DocCollectRecInfo docCollectRecInfo : thisClaimInfo.getCollectInfo().getDocCollectRecInfo()) {
                            if ("0".equals(docCollectRecInfo.getSupType())) {
                                String codeNameList = "\u5217\u8868\u7528";
                                if ("1".equals(docCollectRecInfo.getSource()) && docCollectRecInfo.getSupTime() != null) {
                                    newProcessNode2 = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_021.getKey(), codeNameList, docCollectRecInfo.getSupTime());
                                    processNodeList.add(newProcessNode2);
                                }
                                if ("2".equals(docCollectRecInfo.getSource()) && docCollectRecInfo.getSupTime() != null) {
                                    codeNameList = "\u5217\u8868\u7528";
                                    newProcessNode2 = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_022.getKey(), codeNameList, docCollectRecInfo.getSupTime());
                                    processNodeList.add(newProcessNode2);
                                }
                            }
                            if ("1".equals(docCollectRecInfo.getSupType()) && !"3".equals(thisClaimInfo.getCollectInfo().getStatus()) && "1".equals(docCollectRecInfo.getSource()) && docCollectRecInfo.getSupTime() != null && claimFlag.booleanValue() && claimTime.getTime() <= docCollectRecInfo.getSupTime().getTime()) {
                                newProcessNode = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_012.getKey(), ProcessNodeEnum.PROCESS_NODE_012.getValue(), docCollectRecInfo.getSupTime());
                                processNodeList.add(newProcessNode);
                            }
                            if (!"2".equals(docCollectRecInfo.getSupType()) || !"2".equals(docCollectRecInfo.getSource()) || thisClaimInfo.getCollectInfo() == null || !StringUtils.isNotEmpty((CharSequence)thisClaimInfo.getCollectInfo().getPackageNo()) || docCollectRecInfo.getSupTime() == null) continue;
                            newProcessNode = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_023.getKey(), ProcessNodeEnum.PROCESS_NODE_023.getValue() + thisClaimInfo.getCollectInfo().getPackageNo(), docCollectRecInfo.getSupTime());
                            processNodeList.add(newProcessNode);
                        }
                    }
                    Date payFlagTime = null;
                    ProcessNode returnNode = new ProcessNode();
                    for (UnderWriteInfo underWriteInfo : thisClaimInfo.getUnderWriteInfoList()) {
                        if (underWriteInfo.getUnderWriteDate() == null || !"1".equals(underWriteInfo.getUnderWriteFlag()) && !"3".equals(underWriteInfo.getUnderWriteFlag())) continue;
                        ProcessNode newProcessNode6 = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_30.getKey(), "\u6848\u4ef6\u5df2\u901a\u8fc7\u5ba1\u6838\uff0c\u7406\u8d54\u6b3e\u5c06\u57283\u4e2a\u5de5\u4f5c\u65e5\u5185\u6253\u5165" + ((PayPersonInfo)thisClaimInfo.getPayPersonInfoList().get(0)).getPayeeName() + "\u5c3e\u53f7\u4e3aXXXX\u7684" + ((PayPersonInfo)thisClaimInfo.getPayPersonInfoList().get(0)).getBankName() + "\u8d26\u6237\u4e2d\uff0c\u8bf7\u6ce8\u610f\u67e5\u6536\u3002", underWriteInfo.getUnderWriteDate());
                        processNodeList.add(newProcessNode6);
                        if (!"0".equals(thisClaimInfo.getPremiumStatus()) || !"03".equals(thisClaimInfo.getStatus()) && !"04".equals(thisClaimInfo.getStatus())) continue;
                        ProcessNode newProcessNode23 = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_03.getKey(), ProcessNodeEnum.PROCESS_NODE_03.getValue(), new Date(underWriteInfo.getUnderWriteDate().getTime() + 1L));
                        processNodeList.add(newProcessNode23);
                    }
                    if (thisClaimInfo.getPayPersonInfoList() != null && thisClaimInfo.getPayPersonInfoList().size() > 0 && ((PayPersonInfo)thisClaimInfo.getPayPersonInfoList().get(0)).getPayTime() != null) {
                        payFlagTime = ((PayPersonInfo)thisClaimInfo.getPayPersonInfoList().get(0)).getPayTime();
                        newProcessNode22 = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_05.getKey(), "\u7406\u8d54\u6210\u529f! \u8d54\u4ed8\u91d1\u989d " + thisClaimInfo.getSumRealPayCny() + "\u5143 \u5df2\u652f\u4ed8\u6210\u529f\uff0c\u60a8\u53ef\u70b9\u51fb\u7406\u8d54\u901a\u77e5\u4e66\uff0c\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f\u3002\u611f\u8c22\u60a8\u9009\u62e9\u4eac\u4e1c\u5b89\u8054\u8d22\u9669\u3002", ((PayPersonInfo)thisClaimInfo.getPayPersonInfoList().get(0)).getPayTime());
                        processNodeList.add(newProcessNode22);
                    }
                    if ("09".equals(thisClaimInfo.getStatus()) && thisClaimInfo.getEndCaseTime() != null) {
                        newProcessNode = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_08.getKey(), ProcessNodeEnum.PROCESS_NODE_08.getValue(), thisClaimInfo.getEndCaseTime());
                        processNodeList.add(newProcessNode);
                    }
                    if ("05".equals(thisClaimInfo.getStatus()) && thisClaimInfo.getCanceloRejectTime() != null) {
                        newProcessNode = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_07.getKey(), ProcessNodeEnum.PROCESS_NODE_07.getValue(), thisClaimInfo.getCanceloRejectTime());
                        processNodeList.add(newProcessNode);
                    }
                    if ("06".equals(thisClaimInfo.getStatus()) && thisClaimInfo.getCanceloRejectTime() != null) {
                        newProcessNode = new ProcessNode(ProcessNodeEnum.PROCESS_NODE_06.getKey(), ProcessNodeEnum.PROCESS_NODE_06.getValue(), thisClaimInfo.getCanceloRejectTime());
                        processNodeList.add(newProcessNode);
                    }
                    try {
                        Collections.sort(processNodeList, Comparator.comparing(ProcessNode::getNodeTime));
                    }
                    catch (Exception e) {
                        this.log.error("\u7406\u8d54\u5217\u8868\u4e2d \u7406\u8d54\u6d41\u7a0b\u8282\u70b9\u6392\u5e8f\u95ee\u9898", (Throwable)e);
                    }
                    try {
                        if (payFlagTime != null) {
                            if ("05".equals(((ProcessNode)processNodeList.get(processNodeList.size() - 1)).getNodeStatus())) {
                                ((ProcessNode)processNodeList.get(processNodeList.size() - 1)).setNodeTime(payFlagTime);
                            } else {
                                ((ProcessNode)processNodeList.get(processNodeList.size() - 2)).setNodeTime(payFlagTime);
                            }
                        }
                    }
                    catch (Exception e) {
                        this.log.error("\u6570\u7ec4\u754c\u9650\u95ee\u9898", (Throwable)e);
                    }
                    if (processNodeList.size() == 0) {
                        throw ApisDataCompletionException.builder().errorCode(ErrorCode.NODELIST_ERR0R.getCode()).message(ErrorCode.NODELIST_ERR0R.getMessage()).build();
                    }
                    thisClaimInfo.setStatus(((ProcessNode)processNodeList.get(processNodeList.size() - 1)).getNodeStatus());
                }
            }
            catch (Exception e) {
                this.log.error("\u6d41\u7a0b\u8282\u70b9\u5904\u7406\u51fa\u9519", (Throwable)e);
            }
            this.log.warn("\u6d41\u7a0b\u8282\u70b9\u5904\u7406\uff0c\u7528\u65f6 :{}", (Object)this.timer.intervalRestart());
            try {
                if (!StringUtils.isNotEmpty((CharSequence)request.getClaimListQueryServiceRequest().getBody().getBusinessChannel()) || response.getClaimListQueryResponse().getBody().getClaimInfoList() == null) break block41;
                for (int i = 0; i < response.getClaimListQueryResponse().getBody().getClaimInfoList().size(); ++i) {
                    if (((ClaimListInfo)response.getClaimListQueryResponse().getBody().getClaimInfoList().get(i)).getPayPersonInfoList() != null && ((ClaimListInfo)response.getClaimListQueryResponse().getBody().getClaimInfoList().get(i)).getPayPersonInfoList().size() > 0) {
                        int payStatusNumber = 0;
                        for (PayPersonInfo payPersonInfo : ((ClaimListInfo)response.getClaimListQueryResponse().getBody().getClaimInfoList().get(i)).getPayPersonInfoList()) {
                            if (payPersonInfo.getPayTime() == null) continue;
                            ((ClaimListInfo)response.getClaimListQueryResponse().getBody().getClaimInfoList().get(i)).setPayStatus("1");
                            ++payStatusNumber;
                        }
                        if (payStatusNumber > 0 && payStatusNumber != ((ClaimListInfo)response.getClaimListQueryResponse().getBody().getClaimInfoList().get(i)).getPayPersonInfoList().size()) {
                            ((ClaimListInfo)response.getClaimListQueryResponse().getBody().getClaimInfoList().get(i)).setPayStatus("3");
                        }
                    }
                    try {
                        if (((ClaimListInfo)response.getClaimListQueryResponse().getBody().getClaimInfoList().get(i)).getDamageResult() != null) {
                            String oldDamageResult = this.apisChannelCodeMapper.getChannelValueDo(null, "DamageResult", ((ClaimListInfo)response.getClaimListQueryResponse().getBody().getClaimInfoList().get(i)).getDamageResult());
                            this.log.warn("\u635f\u5931\u7c7b\u578b\u8f6c\u5316\u4e3a:{}", (Object)oldDamageResult);
                            ((ClaimListInfo)response.getClaimListQueryResponse().getBody().getClaimInfoList().get(i)).setDamageResult(oldDamageResult);
                        }
                    }
                    catch (Exception e) {
                        this.log.error("\u635f\u5931\u7c7b\u578b\u8f6c\u5316\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Throwable)e);
                    }
                    if (((ClaimListInfo)response.getClaimListQueryResponse().getBody().getClaimInfoList().get(i)).getStatus() == null) continue;
                    String status = ((ClaimListInfo)response.getClaimListQueryResponse().getBody().getClaimInfoList().get(i)).getStatus();
                    if ("00".equals(status)) {
                        ((ClaimListInfo)response.getClaimListQueryResponse().getBody().getClaimInfoList().get(i)).setStatus("00");
                        continue;
                    }
                    if ("000".equals(status) || "011".equals(status) || "010".equals(status) || "012".equals(status) || "99".equals(status)) {
                        ((ClaimListInfo)response.getClaimListQueryResponse().getBody().getClaimInfoList().get(i)).setStatus("01");
                        continue;
                    }
                    if ("021".equals(status) || "022".equals(status) || "023".equals(status)) {
                        ((ClaimListInfo)response.getClaimListQueryResponse().getBody().getClaimInfoList().get(i)).setStatus("02");
                        continue;
                    }
                    if (!"04".equals(status) && !"01".equals(status)) continue;
                    ((ClaimListInfo)response.getClaimListQueryResponse().getBody().getClaimInfoList().get(i)).setStatus("04");
                    ((ClaimListInfo)response.getClaimListQueryResponse().getBody().getClaimInfoList().get(i)).setPayStatus("2");
                }
            }
            catch (Exception e) {
                this.log.error("PP\u7cfb\u7edf\u904d\u5386\u7406\u8d54\u5217\u8868\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Throwable)e);
            }
        }
        return response;
    }

    private boolean checkRequestHeadBodyIsNull(StanderRequest request) {
        return ObjectUtil.isEmpty((Object)request) || ObjectUtil.isEmpty((Object)request.getClaimListQueryServiceRequest()) || ObjectUtil.isEmpty((Object)request.getClaimListQueryServiceRequest().getHead()) || ObjectUtil.isEmpty((Object)request.getClaimListQueryServiceRequest().getBody());
    }

    private boolean checkResponseBodyIsNull(StanderResponse standerResponse) {
        return standerResponse.getClaimListQueryResponse() == null || standerResponse.getClaimListQueryResponse().getBody() == null;
    }

    private boolean checkResponseHeadSuccess(StanderResponse standerResponse) {
        return standerResponse.getClaimListQueryResponse() != null && standerResponse.getClaimListQueryResponse().getHead() != null && String.valueOf(1).equals(standerResponse.getClaimListQueryResponse().getHead().getResponseCode());
    }

    public boolean hasIntersectionByHashMap(List<String> array1, List<String> array2) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String str : array2) {
            map.put(str, str);
        }
        for (String str : array1) {
            if (map.get(str) == null) continue;
            return true;
        }
        return false;
    }
}

