/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.consts.ClaimErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.handler.impl.ClaimDataCompletionHandler;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.handler.impl.ClaimMediaSubmitHandler;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.RedisTemplateUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderHeader;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.request.ClaimListQueryServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.request.ClaimQueryInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.request.ClaimMedia;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.request.ClaimMediaCommitRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.request.ClaimMediaCommitResult;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ClaimCollectInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ClaimCollectguideInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ClaimDataCompletionRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ClaimDataCompletionServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ClaimRequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ClaimDataCompletionResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ClaimRelateResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ClaimRelateResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiRequestRegistService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelCode;
import com.jdaz.sinosoftgz.apis.commons.model.channel.mapper.ApisChannelCodeMapper;
import com.jdaz.sinosoftgz.apis.commons.model.channel.mapper.ApisChannelUserMapper;
import com.jdaz.sinosoftgz.apis.constants.ApisCommonConstantsEnum;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.coreapi.claims.CoreClaimsQueryApi;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClaimRelateHandler
implements BusinessHandler {
    private static Logger log = LoggerFactory.getLogger(ClaimRelateHandler.class);
    @Autowired
    ClaimMediaSubmitHandler claimMediaSubmitHandler;
    @Autowired
    ClaimDataCompletionHandler claimDataCompletionHandler;
    @Autowired
    ApisBusiRequestRegistService apisBusiRequestRegistService;
    @Autowired
    ApisChannelUserMapper apisChannelUserMapper;
    @Autowired
    private CoreClaimsQueryApi coreClaimsQueryApi;
    private DataCompletionUtil dataCompletionUtil = new DataCompletionUtil();
    @Autowired
    private RedisTemplateUtil redisTemplateUtil;
    @Autowired
    private ApisChannelCodeMapper apisChannelCodeMapper;
    TimeInterval timer = DateUtil.timer();

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        ClaimMediaCommitRequest claimMediaCommitRequest = new ClaimMediaCommitRequest();
        BeanUtils.copyProperties((Object)request.getClaimRelateServiceRequest(), (Object)claimMediaCommitRequest);
        if (ObjectUtil.isNotEmpty((Object)claimMediaCommitRequest) && ObjectUtil.isNotEmpty((Object)claimMediaCommitRequest.getMediaList())) {
            List imageTypeList = claimMediaCommitRequest.getMediaList().stream().map(t -> t.getImgType()).collect(Collectors.toList());
            imageTypeList.removeIf(ObjectUtil::isEmpty);
            List claimImgTypeList = null;
            List<Object> claimImgType = new ArrayList();
            if (ObjectUtil.isNotEmpty(imageTypeList)) {
                claimImgTypeList = this.apisChannelCodeMapper.getByCodeAndValueList("claimImgType", imageTypeList);
            }
            for (ClaimMedia t2 : claimMediaCommitRequest.getMediaList()) {
                if (ObjectUtil.isEmpty((Object)t2.getImgType())) {
                    if (!"1".equals(this.redisTemplateUtil.getApisChannelConfigsByConfigCode("SWITCH_NOT_NULL_IMG_TYPE", RedisTemplateUtil.RedisConfigCodePrefix.SWITCH_NOT_NULL_IMG_TYPE.code))) {
                        t2.setImgType("999");
                        t2.setImgTypeName("\u5176\u4ed6");
                        continue;
                    }
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10678.getValue(), ChannelErrorCodeEnum.ERR_C10678.getKey());
                }
                claimImgType.clear();
                if (ObjectUtil.isNotEmpty((Object)claimImgTypeList)) {
                    claimImgType = claimImgTypeList.stream().filter(p -> p.getValue().equals(t2.getImgType())).collect(Collectors.toList());
                }
                if (ObjectUtil.isNotEmpty(claimImgType)) {
                    t2.setImgTypeName(((ApisChannelCode)claimImgType.get(0)).getValueDesc().trim());
                    continue;
                }
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10678.getValue(), ChannelErrorCodeEnum.ERR_C10678.getKey());
            }
        }
        request.setClaimMediaCommitRequest(claimMediaCommitRequest);
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        String registNoByRequestId;
        this.timer.intervalRestart();
        if (StringUtils.isNotEmpty((CharSequence)request.getClaimRelateServiceRequest().getClaimTransactionId()) && StringUtils.isNotEmpty((CharSequence)(registNoByRequestId = this.apisBusiRequestRegistService.getRegistNoByRequestId(request.getClaimRelateServiceRequest().getClaimTransactionId())))) {
            request.getClaimRelateServiceRequest().setBussNo(registNoByRequestId);
            request.getClaimMediaCommitRequest().setBussNo(registNoByRequestId);
        }
        if ("xml".equals(request.getClaimRelateServiceRequest().getXmlFlag()) && StringUtils.isNotEmpty((CharSequence)request.getClaimRelateServiceRequest().getBussNo())) {
            String registNo = request.getClaimRelateServiceRequest().getBussNo();
            request.getHeader().setBussinessType("case");
            ClaimQueryInfoDTO claimQueryInfoDTO = new ClaimQueryInfoDTO();
            claimQueryInfoDTO.setRegistNo(registNo);
            RequestHeadDTO thisHead = new RequestHeadDTO();
            thisHead.setPassword("bc0TYXab4UjcZiOtX9XpdQ");
            thisHead.setTransDate(new Date());
            thisHead.setUser("AC000039");
            thisHead.setTransType("0007");
            ClaimListQueryServiceRequest thisClaimListQueryServiceRequest = new ClaimListQueryServiceRequest(thisHead, claimQueryInfoDTO);
            request.setClaimListQueryServiceRequest(thisClaimListQueryServiceRequest);
            StanderResponse claimsList = this.coreClaimsQueryApi.claimsQuery(request);
            if (claimsList.getClaimListQueryResponse() == null || claimsList.getClaimListQueryResponse().getBody().getClaimInfoList() == null || claimsList.getClaimListQueryResponse().getBody().getClaimInfoList().size() <= 0) {
                throw new ApisBusinessException(ClaimErrorCodeEnum.ERR_CL10010.getValue(), ClaimErrorCodeEnum.ERR_CL10010.getKey());
            }
        }
        log.warn("\u6d41\u6c34\u53f7\u8f6c\u62a5\u6848\u53f7\uff0c\u7528\u65f6 :{}", (Object)this.timer.intervalRestart());
        StanderResponse claimMediaSubmitResponse = this.claimMediaSubmitHandler.execute(request);
        log.warn("\u8d44\u6599\u63d0\u4ea4\uff0c\u7528\u65f6 :{}", (Object)this.timer.intervalRestart());
        DataCompletionUtil.verificationMediaSubmit((ClaimMediaCommitResult)claimMediaSubmitResponse.getClaimMediaCommitResult());
        log.warn("\u8fd4\u56de\u503c\u6821\u9a8c\uff0c\u7528\u65f6 :{}", (Object)this.timer.intervalRestart());
        this.complementDate(request);
        StanderResponse claimDataCompletionResponse = this.claimDataCompletionHandler.execute(request);
        log.warn("\u6570\u636e\u8865\u5168\uff0c\u7528\u65f6 :{}", (Object)this.timer.intervalRestart());
        claimDataCompletionResponse.setClaimMediaCommitResult(claimMediaSubmitResponse.getClaimMediaCommitResult());
        return claimDataCompletionResponse;
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) {
        ClaimMediaCommitResult claimMediaCommit = response.getClaimMediaCommitResult();
        ClaimDataCompletionResponse claimDataCompletion = response.getClaimDataCompletionResponse();
        ClaimRelateResponse claimRelateResponse = new ClaimRelateResponse();
        if (ObjectUtil.isNotEmpty((Object)claimMediaCommit) && ObjectUtil.isNotEmpty((Object)claimDataCompletion)) {
            claimRelateResponse.setHead(claimDataCompletion.getHead());
            if (ObjectUtil.isNotEmpty((Object)claimDataCompletion.getBody())) {
                ClaimRelateResponseDTO claimRelateResponseDTO = new ClaimRelateResponseDTO();
                claimRelateResponseDTO.setBusinessNo(claimDataCompletion.getBody().getBusinessNo());
                claimRelateResponseDTO.setExternalID(claimDataCompletion.getBody().getExternalID());
                claimRelateResponseDTO.setSize(claimMediaCommit.getSize());
                claimRelateResponseDTO.setImgNodes(claimMediaCommit.getImgNodes());
                claimRelateResponse.setBody(claimRelateResponseDTO);
            }
        }
        response.setClaimMediaCommitResult(null);
        response.setClaimDataCompletionResponse(null);
        response.setClaimRelateResponse(claimRelateResponse);
        return response;
    }

    private void complementDate(StanderRequest request) {
        ClaimMediaCommitRequest claimMediaCommitRequest = request.getClaimMediaCommitRequest();
        StanderHeader standerHeader = request.getHeader();
        String userCode = ObjectUtil.isNotEmpty((Object)standerHeader) ? standerHeader.getUserCode() : "";
        String pwd = this.apisChannelUserMapper.queryPwdByCode(userCode);
        ClaimDataCompletionServiceRequest claimDataCompletionServiceRequest = new ClaimDataCompletionServiceRequest();
        ClaimRequestHeadDTO claimRequestHeadDTO = new ClaimRequestHeadDTO();
        claimRequestHeadDTO.setTransID(UUID.randomUUID().toString().replace("-", ""));
        claimRequestHeadDTO.setTransType("apis");
        claimRequestHeadDTO.setTransDate(new Date());
        claimRequestHeadDTO.setUser(userCode);
        claimRequestHeadDTO.setPassword(pwd);
        claimDataCompletionServiceRequest.setHead(claimRequestHeadDTO);
        ClaimDataCompletionRequestDTO claimDataCompletionRequestDTO = new ClaimDataCompletionRequestDTO();
        claimDataCompletionRequestDTO.setReportType(ApisCommonConstantsEnum.CLAIM_COMPLETION_COLLECTION_CHANNEL_08.getKey());
        claimDataCompletionRequestDTO.setSuplementType(ApisCommonConstantsEnum.CLAIM_COMPLETION_SUPLEMENTTYPE_02.getKey());
        claimDataCompletionRequestDTO.setStatus(ApisCommonConstantsEnum.CLAIM_COMPLETION_STATUS_2.getKey());
        claimDataCompletionRequestDTO.setRegistNo(claimMediaCommitRequest.getBussNo());
        claimDataCompletionRequestDTO.setExternalID(UUID.randomUUID().toString().replace("-", ""));
        ClaimCollectInfoDTO claimCollectInfoDTO = new ClaimCollectInfoDTO();
        claimCollectInfoDTO.setRegistNo(claimMediaCommitRequest.getBussNo());
        claimCollectInfoDTO.setClaimApplyTime(new Date());
        claimCollectInfoDTO.setNotifyTime(new Date());
        claimCollectInfoDTO.setSource(ApisCommonConstantsEnum.CLAIM_COMPLETION_COLLECTION_SOURCE_1.getKey());
        claimCollectInfoDTO.setStatus(ApisCommonConstantsEnum.CLAIM_COMPLETION_COLLECTION_STATUS_1.getKey());
        ArrayList<ClaimCollectguideInfoDTO> collectguideInfoList = new ArrayList<ClaimCollectguideInfoDTO>();
        if (ObjectUtil.isNotEmpty((Object)claimMediaCommitRequest.getMediaList())) {
            for (int i = 0; i < claimMediaCommitRequest.getMediaList().size(); ++i) {
                ClaimCollectguideInfoDTO claimCollectguideInfoDTO = new ClaimCollectguideInfoDTO();
                if (StringUtils.isEmpty((CharSequence)((ClaimMedia)claimMediaCommitRequest.getMediaList().get(i)).getImgType())) {
                    claimCollectguideInfoDTO.setDocCode("99930");
                } else {
                    claimCollectguideInfoDTO.setDocCode(((ClaimMedia)claimMediaCommitRequest.getMediaList().get(i)).getImgType());
                    claimCollectguideInfoDTO.setDocName(((ClaimMedia)claimMediaCommitRequest.getMediaList().get(i)).getImgTypeName());
                }
                collectguideInfoList.add(claimCollectguideInfoDTO);
            }
        }
        claimCollectInfoDTO.setCollectguideInfo(collectguideInfoList);
        ArrayList<ClaimCollectInfoDTO> collectInfoList = new ArrayList<ClaimCollectInfoDTO>();
        collectInfoList.add(claimCollectInfoDTO);
        claimDataCompletionRequestDTO.setCollectInfoList(collectInfoList);
        claimDataCompletionServiceRequest.setBody(claimDataCompletionRequestDTO);
        request.setClaimDataCompletionServiceRequest(claimDataCompletionServiceRequest);
    }
}

