/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.consts.EcoErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.EcoRegistDataCompletion;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.EcoExtendInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.response.ClaimOpenBillEcoResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.response.EcoClaimInfoReturn;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.response.EcoGeneralInfoReturn;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiUploadAttachment;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiUploadAttachmentService;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.coreapi.claims.CoreClaimOpenBillApi;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class EcoClaimsOpenBillHandler
implements BusinessHandler {
    private static final Logger log = LoggerFactory.getLogger(EcoClaimsOpenBillHandler.class);
    @Autowired
    EcoRegistDataCompletion ecoRegistDataCompletion;
    @Autowired
    CoreClaimOpenBillApi coreClaimsApi;
    @Autowired
    ApisBusiUploadAttachmentService apisBusiUploadAttachmentService;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        this.ecoRegistDataCompletion.checkRequest(request);
        this.ecoRegistDataCompletion.checkData(request.getClaimOpenBillEcoRequest());
        this.ecoRegistDataCompletion.completion(request);
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        StanderResponse standerResponse = this.coreClaimsApi.claimsOpenBill(request);
        if (ObjectUtil.isEmpty((Object)standerResponse)) {
            throw new ApisBusinessException(EcoErrorCodeEnum.ERROR_C01.getValue(), EcoErrorCodeEnum.ERROR_C01.getKey());
        }
        if (StringUtils.isBlank((CharSequence)standerResponse.getClaimOpenBillServiceResponse().getHead().getErrorCode())) {
            this.asyncUploadMedia(request, standerResponse);
        }
        return standerResponse;
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        if (!StringUtils.isBlank((CharSequence)response.getClaimOpenBillServiceResponse().getHead().getErrorCode())) {
            throw new ApisBusinessException(response.getClaimOpenBillServiceResponse().getHead().getErrorMessage(), EcoErrorCodeEnum.ERROR_C01.getKey());
        }
        EcoGeneralInfoReturn generalInfoReturn = EcoGeneralInfoReturn.builder().uuid(request.getClaimOpenBillEcoRequest().getGeneralInfo().getUuid()).errorCode(EcoErrorCodeEnum.SUCCESS_C00.getKey()).errorMessage(EcoErrorCodeEnum.SUCCESS_C00.getValue()).build();
        EcoClaimInfoReturn claimInfoReturn = EcoClaimInfoReturn.builder().saveResult(EcoErrorCodeEnum.SUCCESS_C00.getKey()).saveMessage(EcoErrorCodeEnum.SUCCESS_C00.getValue()).saveTimes(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss")).registNo(response.getClaimOpenBillServiceResponse().getBody().getRegistNo()).damageFlag(request.getClaimOpenBillEcoRequest().getClaimOpenBillEco().getDamageFlag()).build();
        ClaimOpenBillEcoResponse ecoResponse = ClaimOpenBillEcoResponse.builder().generalInfoReturn(generalInfoReturn).claimInfoReturn(claimInfoReturn).build();
        response.setClaimOpenBillEcoResponse(ecoResponse);
        response.setHeader(request.getHeader());
        return response;
    }

    public void asyncUploadMedia(StanderRequest request, StanderResponse response) {
        List attachments = this.convertAttachment(request, response);
        ApisBusiTaskLog taskLog = new ApisBusiTaskLog();
        taskLog.setPushType(ApisAutoTaskConstantsEnum.CLAIM_ATTACHMENTS_UPLOAD_YAO_LIAN.getValue());
        this.apisBusiUploadAttachmentService.saveWithTask(attachments, taskLog);
    }

    private List<ApisBusiUploadAttachment> convertAttachment(StanderRequest request, StanderResponse response) {
        List extendInfos;
        String payeeIdNoBackUrl;
        String payeeIdNoFrontUrl;
        ArrayList<ApisBusiUploadAttachment> list = new ArrayList<ApisBusiUploadAttachment>();
        String businessLicenseUrl = request.getClaimOpenBillEcoRequest().getClaimOpenBillEco().getBusinessLicense();
        if (StringUtils.isNotBlank((CharSequence)businessLicenseUrl)) {
            ApisBusiUploadAttachment businessLicense = new ApisBusiUploadAttachment();
            businessLicense.setCreator(request.getHeader().getUserCode());
            businessLicense.setBusinessNo(response.getClaimOpenBillServiceResponse().getBody().getRegistNo());
            businessLicense.setAttaThirdPath(businessLicenseUrl);
            businessLicense.setBusinessType("C");
            businessLicense.setStatus("1");
            businessLicense.setAttaName("\u8425\u4e1a\u6267\u7167");
            list.add(businessLicense);
        }
        if (StringUtils.isNotBlank((CharSequence)(payeeIdNoFrontUrl = request.getClaimOpenBillEcoRequest().getClaimOpenBillEco().getPayeeIdNoFront()))) {
            ApisBusiUploadAttachment payeeIdNoFront = new ApisBusiUploadAttachment();
            payeeIdNoFront.setCreator(request.getHeader().getUserCode());
            payeeIdNoFront.setBusinessNo(response.getClaimOpenBillServiceResponse().getBody().getRegistNo());
            payeeIdNoFront.setAttaThirdPath(payeeIdNoFrontUrl);
            payeeIdNoFront.setBusinessType("C");
            payeeIdNoFront.setStatus("1");
            payeeIdNoFront.setAttaName("\u8eab\u4efd\u8bc1\u6b63\u9762");
            list.add(payeeIdNoFront);
        }
        if (StringUtils.isNotBlank((CharSequence)(payeeIdNoBackUrl = request.getClaimOpenBillEcoRequest().getClaimOpenBillEco().getPayeeIdNoBack()))) {
            ApisBusiUploadAttachment payeeIdNoBack = new ApisBusiUploadAttachment();
            payeeIdNoBack.setCreator(request.getHeader().getUserCode());
            payeeIdNoBack.setBusinessNo(response.getClaimOpenBillServiceResponse().getBody().getRegistNo());
            payeeIdNoBack.setAttaThirdPath(payeeIdNoBackUrl);
            payeeIdNoBack.setBusinessType("C");
            payeeIdNoBack.setStatus("1");
            payeeIdNoBack.setAttaName("\u8eab\u4efd\u8bc1\u53cd\u9762");
            list.add(payeeIdNoBack);
        }
        if (ObjectUtils.isNotEmpty((Object)(extendInfos = request.getClaimOpenBillEcoRequest().getExtendInfos()))) {
            for (int i = 0; i < extendInfos.size(); ++i) {
                EcoExtendInfoDTO ecoExtendInfoDTO = (EcoExtendInfoDTO)extendInfos.get(i);
                ApisBusiUploadAttachment extend = new ApisBusiUploadAttachment();
                extend.setCreator(request.getHeader().getUserCode());
                extend.setBusinessNo(response.getClaimOpenBillServiceResponse().getBody().getRegistNo());
                extend.setAttaThirdPath(ecoExtendInfoDTO.getUrl());
                extend.setBusinessType("C");
                extend.setStatus("1");
                StringBuilder sb = new StringBuilder("\u7406\u8d54\u6240\u9700\u6587\u4ef6-");
                extend.setAttaName(sb.append(i).append(".csv").toString());
                list.add(extend);
            }
        }
        return list;
    }
}

