/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.consts.ErrorCode;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.DflossPersBillDetailInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.DflossPersBillFeeInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.DflossPersBillInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.DisabilityDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.LossHealthInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.PayPersonInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.SDAdjustingSynRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiRequestRegist;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiRequestRegistService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.coreapi.claims.CoreSDClaimApi;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class SDAdjustingSynHandler
implements BusinessHandler {
    private static Logger log = LoggerFactory.getLogger(SDAdjustingSynHandler.class);
    @Autowired
    CoreSDClaimApi coreSoClaimApi;
    @Autowired
    ApisBusiRequestRegistService apisBusiRequestRegistService;
    private static final String[] PAY_PERSON_INFO_NAMES = new String[]{"certifyType", "certifyNo", "payObjectKind", "payeeName", "nationFlag", "bankCode", "accountNo", "paymentTyoe", "payObjectType", "payNowFlag", "insuredName", "insuredSex", "employerName", "annualIncomeCurrency", "annualIncomeAmount", "insuredNationality", "insuredOccupation", "insuredAddressType", "insuredAddress", "insuredMobile", "insuredCertifyType", "insuredCertifyNo", "insuredCertifyValidDate", "InsuredRelationCode", "InsuredRelationDetail", "payeeRelationCode", "payeeRelationDetail"};
    String[] letter = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
    TimeInterval timer = DateUtil.timer();

    public StanderRequest dataCompletion(StanderRequest request) throws ApisDataCompletionException {
        this.timer.intervalRestart();
        SDAdjustingSynRequestDTO sdAdjustingSynRequestDTO = request.getSdAdjustingSynServiceRequest().getBody();
        this.defaultDataValue(sdAdjustingSynRequestDTO);
        this.verifyNotNull(request);
        this.convertCurrencyUnit(sdAdjustingSynRequestDTO);
        this.groupLossHealthInfoList(sdAdjustingSynRequestDTO);
        this.groupDamageResult(sdAdjustingSynRequestDTO);
        return request;
    }

    private void groupDamageResult(SDAdjustingSynRequestDTO sd) {
        StringBuffer damageResult = new StringBuffer();
        int index = 0;
        for (DisabilityDTO dto : sd.getDisabilityList()) {
            if (index != 0) {
                damageResult.append(",");
            }
            damageResult.append(dto.getSdDamageResult());
            ++index;
        }
        sd.setDamageResult(damageResult.toString());
    }

    private void groupLossHealthInfoList(SDAdjustingSynRequestDTO sd) {
        HashMap<String, Map<String, LossHealthInfoDTO>> goodMap = new HashMap<String, Map<String, LossHealthInfoDTO>>();
        BigDecimal totalSum = new BigDecimal(0);
        for (LossHealthInfoDTO dto : sd.getLossHealthInfoList()) {
            Map<String, LossHealthInfoDTO> kindMap;
            totalSum = totalSum.add(dto.getThisAdjustmentAmount());
            if (goodMap.containsKey(dto.getGoodsCode())) {
                kindMap = (Map)goodMap.get(dto.getGoodsCode());
                if (kindMap.containsKey(dto.getKindCode())) {
                    LossHealthInfoDTO lossHealthInfoDTO = (LossHealthInfoDTO)kindMap.get(dto.getKindCode());
                    if (ObjectUtil.isEmpty((Object)lossHealthInfoDTO.getDflossPersBillInfoList())) {
                        ArrayList list = new ArrayList();
                        lossHealthInfoDTO.setDflossPersBillInfoList(list);
                    }
                    if (!ObjectUtil.isNotEmpty((Object)dto.getDflossPersBillInfoList())) continue;
                    lossHealthInfoDTO.setSumRealPay(lossHealthInfoDTO.getThisAdjustmentAmount().add(dto.getThisAdjustmentAmount()));
                    lossHealthInfoDTO.setThisDeduct(lossHealthInfoDTO.getThisDeduct().add(dto.getThisDeduct()));
                    lossHealthInfoDTO.getDflossPersBillInfoList().addAll(dto.getDflossPersBillInfoList());
                    continue;
                }
                kindMap.put(dto.getKindCode(), dto);
                continue;
            }
            kindMap = new HashMap<String, LossHealthInfoDTO>();
            kindMap.put(dto.getKindCode(), dto);
            goodMap.put(dto.getGoodsCode(), kindMap);
        }
        ArrayList list = new ArrayList();
        for (String goodKey : goodMap.keySet()) {
            for (String kindKey : ((Map)goodMap.get(goodKey)).keySet()) {
                list.add(((Map)goodMap.get(goodKey)).get(kindKey));
            }
        }
        sd.setLossHealthInfoList(list);
        sd.setSumRealPay(totalSum);
    }

    private void convertCurrencyUnit(SDAdjustingSynRequestDTO sd) {
        if (ObjectUtil.isEmpty((Object)sd.getLossHealthInfoList())) {
            return;
        }
        for (LossHealthInfoDTO lossHealthInfoDTO : sd.getLossHealthInfoList()) {
            if (ObjectUtil.isEmpty((Object)lossHealthInfoDTO)) continue;
            lossHealthInfoDTO.setThisAdjustmentAmount(this.getCurrency(lossHealthInfoDTO.getThisAdjustmentAmount()));
            lossHealthInfoDTO.setThisDeduct(this.getCurrency(lossHealthInfoDTO.getThisDeduct()));
            if (ObjectUtil.isEmpty((Object)lossHealthInfoDTO.getDflossPersBillInfoList())) continue;
            for (DflossPersBillInfoDTO dflossPersBillInfoDTO : lossHealthInfoDTO.getDflossPersBillInfoList()) {
                if (ObjectUtil.isNotEmpty((Object)dflossPersBillInfoDTO.getPaymentRatio())) {
                    dflossPersBillInfoDTO.setPayRate(new BigDecimal(dflossPersBillInfoDTO.getPaymentRatio()));
                }
                if ("\u62d2\u8d54".equals(lossHealthInfoDTO.getDutyResult())) {
                    dflossPersBillInfoDTO.setSumBillAmount(this.getCurrency(dflossPersBillInfoDTO.getSumBillAmount()));
                    dflossPersBillInfoDTO.setUnReasonableFee(dflossPersBillInfoDTO.getSumBillAmount());
                    dflossPersBillInfoDTO.setAccountPayAmount(new BigDecimal(0));
                    dflossPersBillInfoDTO.setOwnPay(new BigDecimal(0));
                    dflossPersBillInfoDTO.setOwnExpense(new BigDecimal(0));
                    dflossPersBillInfoDTO.setSocialInsPay(new BigDecimal(0));
                    dflossPersBillInfoDTO.setExtraPay(new BigDecimal(0));
                    dflossPersBillInfoDTO.setThirdPartyPay(new BigDecimal(0));
                } else {
                    dflossPersBillInfoDTO.setSumBillAmount(this.getCurrency(dflossPersBillInfoDTO.getSumBillAmount()));
                    dflossPersBillInfoDTO.setAccountPayAmount(this.getCurrency(dflossPersBillInfoDTO.getAccountPayAmount()));
                    dflossPersBillInfoDTO.setOwnPay(this.getCurrency(dflossPersBillInfoDTO.getOwnPay()));
                    dflossPersBillInfoDTO.setOwnExpense(this.getCurrency(dflossPersBillInfoDTO.getOwnExpense()));
                    dflossPersBillInfoDTO.setSocialInsPay(this.getCurrency(dflossPersBillInfoDTO.getSocialInsPay()));
                    dflossPersBillInfoDTO.setExtraPay(this.getCurrency(dflossPersBillInfoDTO.getExtraPay()));
                    dflossPersBillInfoDTO.setThirdPartyPay(this.getCurrency(dflossPersBillInfoDTO.getThirdPartyPay()));
                    dflossPersBillInfoDTO.setUnReasonableFee(this.getCurrency(dflossPersBillInfoDTO.getUnReasonableFee()));
                }
                if (ObjectUtil.isNotEmpty((Object)dflossPersBillInfoDTO.getDflossPersBillFeeInfo())) {
                    for (DflossPersBillFeeInfoDTO dflossPersBillFeeInfoDTO : dflossPersBillInfoDTO.getDflossPersBillFeeInfo()) {
                        dflossPersBillFeeInfoDTO.setOwnPay(this.getCurrency(dflossPersBillFeeInfoDTO.getOwnPay()));
                        dflossPersBillFeeInfoDTO.setOwnExpense(this.getCurrency(dflossPersBillFeeInfoDTO.getOwnExpense()));
                        dflossPersBillFeeInfoDTO.setSumAmount(this.getCurrency(dflossPersBillFeeInfoDTO.getSumAmount()));
                    }
                }
                if (!ObjectUtil.isNotEmpty((Object)dflossPersBillInfoDTO.getDflossPersBillDetailInfo())) continue;
                for (DflossPersBillDetailInfoDTO dflossPersBillDetailInfoDTO : dflossPersBillInfoDTO.getDflossPersBillDetailInfo()) {
                    dflossPersBillDetailInfoDTO.setMedicineFee(this.getCurrency(dflossPersBillDetailInfoDTO.getMedicineFee()));
                    dflossPersBillDetailInfoDTO.setUnitprice(this.getCurrency(dflossPersBillDetailInfoDTO.getUnitprice()));
                    dflossPersBillDetailInfoDTO.setOwnExpense(this.getCurrency(dflossPersBillDetailInfoDTO.getOwnExpense()));
                }
            }
        }
    }

    private BigDecimal getCurrency(BigDecimal value) {
        if (ObjectUtil.isEmpty((Object)value)) {
            return new BigDecimal(0);
        }
        return value.divide(new BigDecimal(100));
    }

    private void defaultDataValue(SDAdjustingSynRequestDTO sd) throws ApisDataCompletionException {
        ApisBusiRequestRegist apisBusiRequestRegist = this.apisBusiRequestRegistService.getByRegistNo(sd.getRegistNo());
        if (ObjectUtil.isEmpty((Object)sd.getCurrency())) {
            sd.setCurrency("RMB");
        }
        if (StringUtils.isEmpty((Object)sd.getCompensateType())) {
            sd.setCompensateType("1");
        }
        for (PayPersonInfoDTO payPersonInfoDTO : sd.getPayPersonInfoList()) {
            if (!StringUtils.isEmpty((Object)payPersonInfoDTO.getNationFlag())) continue;
            payPersonInfoDTO.setNationFlag("1");
        }
        sd.getPcustomerInfo().setInsuredNationality("CHN");
        sd.getPcustomerInfo().setInsuredCertifyType("01");
        for (PayPersonInfoDTO payPersonInfoDTO : sd.getPayPersonInfoList()) {
            payPersonInfoDTO.setPayObjectType("1");
            payPersonInfoDTO.setPayNowFlag("0");
            payPersonInfoDTO.setPaymentType("02");
            payPersonInfoDTO.setOtherCause("09");
        }
        for (LossHealthInfoDTO lossHealthInfoDTO : sd.getLossHealthInfoList()) {
            if (!ObjectUtil.isNotEmpty((Object)lossHealthInfoDTO.getDflossPersBillInfoList())) continue;
            int index = 1;
            for (DflossPersBillInfoDTO dflossPersBillInfoDTO : lossHealthInfoDTO.getDflossPersBillInfoList()) {
                if (ObjectUtil.isEmpty((Object)dflossPersBillInfoDTO.getBillDate())) {
                    dflossPersBillInfoDTO.setBillDate(apisBusiRequestRegist.getDamageTime());
                }
                if (ObjectUtil.isEmpty((Object)dflossPersBillInfoDTO.getNationFlag())) {
                    dflossPersBillInfoDTO.setNationFlag("1");
                }
                if (ObjectUtil.isEmpty((Object)dflossPersBillInfoDTO.getCurrency())) {
                    dflossPersBillInfoDTO.setCurrency("RMB");
                }
                if (ObjectUtil.isEmpty((Object)dflossPersBillInfoDTO.getBillNo())) {
                    dflossPersBillInfoDTO.setBillNo(sd.getRegistNo() + index);
                }
                ++index;
            }
        }
        if (ObjectUtil.isNotEmpty((Object)sd.getDisabilityList())) {
            for (DisabilityDTO dto : sd.getDisabilityList()) {
                dto.setIdentifyCriteria("01");
                dto.setDisabilityEvaluationCode(this.converEvaluationCode(dto.getDisabilityEvaluationCode()));
            }
        }
    }

    private String converEvaluationCode(String value) {
        String[] list = value.split("\\.");
        if (list.length >= 3) {
            int index = Integer.valueOf(list[2]);
            list[2] = index >= 10 ? this.letter[index - 10] : list[2];
        }
        StringBuilder ss = new StringBuilder();
        for (int i = 0; i < list.length; ++i) {
            ss.append(list[i]);
        }
        return ss.toString();
    }

    private void verifyNotNull(StanderRequest request) throws ApisDataCompletionException {
        SDAdjustingSynRequestDTO dto = request.getSdAdjustingSynServiceRequest().getBody();
        if (ObjectUtil.isEmpty((Object)dto.getRegistNo())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_NULL.getCode()).message("\u62a5\u6848\u53f7" + ErrorCode.NOT_NULL.getMessage()).build();
        }
        List payPersonInfoDTOList = dto.getPayPersonInfoList();
        for (PayPersonInfoDTO payPersonInfoDTO : payPersonInfoDTOList) {
            String result = SDAdjustingSynHandler.isAllFieldNull((Object)payPersonInfoDTO, Arrays.asList(PAY_PERSON_INFO_NAMES));
            if ("-1".equals(result)) {
                throw ApisDataCompletionException.builder().errorCode(ChannelErrorCodeEnum.ERR_C10006.getKey()).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).build();
            }
            if ("1".equals(result)) continue;
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_NULL.getCode()).message(result + ErrorCode.NOT_NULL.getMessage()).build();
        }
    }

    public static String isAllFieldNull(Object o, List<String> fieldNameList) {
        try {
            for (Field field : o.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                Object object = field.get(o);
                if (object != null || !fieldNameList.contains(field.getName())) continue;
                return field.getName();
            }
        }
        catch (Exception e) {
            log.error("\u53cd\u5c04\u8f6c\u6362\u9519\u8bef\uff1a{}", (Object)e.getMessage());
            return "-1";
        }
        return "1";
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        this.timer.intervalRestart();
        StanderResponse standerResponse = this.coreSoClaimApi.adjustingSyn(request);
        log.warn("\u7406\u7b97\u4fe1\u606f\u540c\u6b65\u63a5\u53e3\uff0c\u7528\u65f6 :{}", (Object)this.timer.intervalRestart());
        if (!this.checkResponseHeadSuccess(standerResponse)) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.INTERACTION_ERR0R.getCode()).message(ErrorCode.INTERACTION_ERR0R.getMessage() + "\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a" + standerResponse.getSdAdjustingSynServiceResponse().getHead().getErrorMessage()).build();
        }
        return standerResponse;
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) {
        return response;
    }

    private boolean checkResponseHeadSuccess(StanderResponse standerResponse) {
        return standerResponse.getSdAdjustingSynServiceResponse() != null && standerResponse.getSdAdjustingSynServiceResponse().getHead() != null && String.valueOf(1).equals(standerResponse.getSdAdjustingSynServiceResponse().getHead().getResponseCode());
    }
}

