/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.consts.ErrorCode;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.SDRegistDataCompletion;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.response.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.request.SDClaimNoticeRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiRequestRegistService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.coreapi.claims.CoreSDClaimApi;
import java.util.Arrays;
import java.util.Objects;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SDClaimCaseSupplyHandler
implements BusinessHandler {
    private static Logger log = LoggerFactory.getLogger(SDClaimCaseSupplyHandler.class);
    @Autowired
    CoreSDClaimApi coreSdClaimApi;
    @Autowired
    ApisBusiRequestRegistService apisBusiRequestRegistService;
    @Autowired
    SDRegistDataCompletion sdRegistDataCompletion;
    TimeInterval timer = DateUtil.timer();

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        this.timer.intervalRestart();
        SDClaimNoticeRequestDTO sdClaimNoticeRequestDTO = request.getSdClaimCaseSupplyServiceRequest().getBody();
        if (ObjectUtil.isEmpty((Object)sdClaimNoticeRequestDTO.getRegistNo())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_NULL.getCode()).message("\u62a5\u6848\u53f7\u4e0d\u80fd" + ErrorCode.NOT_NULL.getMessage()).build();
        }
        if (ObjectUtil.isEmpty((Object)sdClaimNoticeRequestDTO.getMajorCaseFlag()) && ObjectUtil.isEmpty((Object)sdClaimNoticeRequestDTO.getSpecialMedicinesFlag())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_NULL.getCode()).message("\u91cd\u5927\u6848\u4ef6\u6807\u8bc6\u548c\u7279\u836f\u6807\u8bc6\u4e0d\u80fd\u540c\u65f6" + ErrorCode.NOT_NULL.getMessage()).build();
        }
        String requestId = this.apisBusiRequestRegistService.getRequestIdByRegistNo(sdClaimNoticeRequestDTO.getRegistNo());
        if (ObjectUtil.isEmpty((Object)requestId)) {
            throw ApisDataCompletionException.builder().errorCode(ChannelErrorCodeEnum.ERR_C10006.getKey()).message("\u62a5\u6848\u53f7\u4e0d\u5b58\u5728").build();
        }
        if (ObjectUtil.isNotEmpty((Object)sdClaimNoticeRequestDTO.getAudioFileUrl())) {
            sdClaimNoticeRequestDTO.setAudioFileUrl(Arrays.asList(((String)sdClaimNoticeRequestDTO.getAudioFileUrl().get(0)).substring(1, ((String)sdClaimNoticeRequestDTO.getAudioFileUrl().get(0)).length() - 1).split(",")));
            sdClaimNoticeRequestDTO.getAudioFileUrl().removeIf(Strings::isBlank);
            sdClaimNoticeRequestDTO.getAudioFileUrl().removeIf(Objects::isNull);
        }
        this.sdRegistDataCompletion.lock(request.getHeader().getUserCode(), request.getSdClaimCaseSupplyServiceRequest().getHead().getTransType() + request.getSdClaimCaseSupplyServiceRequest().getHead().getTransID());
        return request;
    }

    public StanderResponse execute(StanderRequest request) {
        this.timer.intervalRestart();
        StanderResponse standerResponse = this.coreSdClaimApi.caseSupply(request);
        log.warn("\u8bbf\u95ee\u7406\u8d54\u6848\u4ef6\u4fe1\u606f\u8865\u5145\u63a5\u53e3\uff0c\u7528\u65f6 :{}", (Object)this.timer.intervalRestart());
        ResponseHeadDTO responseHead = standerResponse.getSdClaimOpenBillServiceResponse().getHead();
        if (ObjectUtil.isNotEmpty((Object)responseHead) && ObjectUtil.isEmpty((Object)responseHead.getErrorCode()) && "1".equals(responseHead.getResponseCode()) && ObjectUtil.isNotEmpty((Object)request.getSdClaimCaseSupplyServiceRequest().getBody().getAudioFileUrl())) {
            SDClaimNoticeRequestDTO sdClaimNoticeRequestDTO = request.getSdClaimCaseSupplyServiceRequest().getBody();
            this.sdRegistDataCompletion.uploadImage(sdClaimNoticeRequestDTO.getAudioFileUrl(), sdClaimNoticeRequestDTO.getRegistNo(), request.getHeader().getUserCode(), request.getSdClaimCaseSupplyServiceRequest().getHead().getTransID(), "mp3");
        }
        return standerResponse;
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) {
        return response;
    }
}

