/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.consts.ErrorCode;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.SDRegistDataCompletion;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.response.ClaimOpenBillServiceResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.request.SDClaimOpenBillRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiRequestRegistService;
import com.jdaz.sinosoftgz.coreapi.claims.CoreSDClaimApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SDClaimOpenBillHandler
implements BusinessHandler {
    private static final Logger log = LoggerFactory.getLogger(SDClaimOpenBillHandler.class);
    @Autowired
    CoreSDClaimApi coreSdClaimApi;
    @Autowired
    SDRegistDataCompletion sdRegistDataCompletion;
    @Autowired
    private ApisBusiRequestRegistService apisBusiRequestRegistService;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        TimeInterval timer = DateUtil.timer();
        this.sdRegistDataCompletion.checkRequestHeadBody(request);
        log.warn("\u524d\u7f6e\u8bf7\u6c42\u4f53\u5224\u7a7a\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.sdRegistDataCompletion.lock(request.getHeader().getUserCode(), request.getSdClaimOpenBillServiceRequest().getHead().getReqPartyBizNo());
        this.sdRegistDataCompletion.lock(request.getSdClaimOpenBillServiceRequest().getBody().getPolicyNo(), request.getSdClaimOpenBillServiceRequest().getBody().getIdentifyNo() + request.getSdClaimOpenBillServiceRequest().getBody().getDamageTime().getTime() + request.getSdClaimOpenBillServiceRequest().getBody().getDamageResult());
        this.sdRegistDataCompletion.dataCompletionClaimOpenBillRequestDTO(request);
        log.warn("\u6570\u636e\u8865\u5168\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisDataCompletionException {
        StanderResponse claimOpenBillServiceResponse = this.coreSdClaimApi.openBill(request);
        if (ObjectUtil.isEmpty((Object)claimOpenBillServiceResponse)) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.INTERACTION_ERR0R.getCode()).message(ErrorCode.INTERACTION_ERR0R.getMessage()).build();
        }
        return claimOpenBillServiceResponse;
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) {
        SDClaimOpenBillRequestDTO sdClaimOpenBillRequestDTO = request.getSdClaimOpenBillServiceRequest().getBody();
        ClaimOpenBillServiceResponseDTO claimOpenBillServiceResponseDTO = response.getSdClaimOpenBillServiceResponse().getBody();
        if (ObjectUtil.isNotEmpty((Object)claimOpenBillServiceResponseDTO)) {
            claimOpenBillServiceResponseDTO.setPolicyNo(sdClaimOpenBillRequestDTO.getPolicyNo());
            claimOpenBillServiceResponseDTO.setInsuredCardNo(sdClaimOpenBillRequestDTO.getIdentifyNo());
            claimOpenBillServiceResponseDTO.setInsuredName(sdClaimOpenBillRequestDTO.getDamagePersonName());
            claimOpenBillServiceResponseDTO.setInsCompanyId("ALCX20210205");
        }
        return response;
    }
}

