/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.consts.ErrorCode;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.SDRegistDataCompletion;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.response.ClaimOpenBillServiceResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.request.SDClaimPolicyItemRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDetailResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDetailResponseDTO;
import com.jdaz.sinosoftgz.coreapi.claims.CoreSDClaimApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SDClaimPolicyItemInfoHandler
implements BusinessHandler {
    private static final Logger log = LoggerFactory.getLogger(SDClaimPolicyItemInfoHandler.class);
    @Autowired
    CoreSDClaimApi coreSdClaimApi;
    @Autowired
    SDRegistDataCompletion sdRegistDataCompletion;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        TimeInterval timer = DateUtil.timer();
        this.checkRequestHeadBody(request);
        this.sdRegistDataCompletion.validSdPolicyItemInfoRequestNotNull(request.getSdClaimPolicyItemServiceRequest().getBody());
        log.warn("\u524d\u7f6e\u8bf7\u6c42\u4f53\u5224\u7a7a\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.getPolicyDetailByInsureds(request);
        log.warn("\u83b7\u53d6\u4fdd\u5355\u8be6\u60c5\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        StanderResponse response = this.coreSdClaimApi.sdPolicyItemInfo(request);
        response.setPolicyDetailResponse(PolicyDetailResponse.builder().responseBody(PolicyDetailResponseDTO.builder().policy(request.getPolicyDetail()).build()).build());
        return response;
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        if (ObjectUtil.isEmpty((Object)response) || ObjectUtil.isEmpty((Object)response.getSdClaimOpenBillServiceResponse()) || ObjectUtil.isEmpty((Object)response.getSdClaimOpenBillServiceResponse().getHead())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.INTERACTION_ERR0R.getCode()).message(ErrorCode.INTERACTION_ERR0R.getMessage()).build();
        }
        if (!"1".equals(response.getSdClaimOpenBillServiceResponse().getHead().getResponseCode())) {
            throw ApisDataCompletionException.builder().errorCode(response.getSdClaimOpenBillServiceResponse().getHead().getErrorCode()).message(response.getSdClaimOpenBillServiceResponse().getHead().getErrorMessage()).build();
        }
        ClaimOpenBillServiceResponseDTO claimOpenBillServiceResponseDTO = response.getSdClaimOpenBillServiceResponse().getBody();
        if (ObjectUtil.isNotEmpty((Object)claimOpenBillServiceResponseDTO)) {
            claimOpenBillServiceResponseDTO.setInsCompanyId("ALCX20210205");
        }
        return response;
    }

    private void checkRequestHeadBody(StanderRequest request) throws ApisDataCompletionException {
        this.sdRegistDataCompletion.judgeNotNull((Object)request, "\u8bf7\u6c42\u62a5\u6587 " + ErrorCode.NOT_NULL.getMessage());
        this.sdRegistDataCompletion.judgeNotNull((Object)request.getSdClaimPolicyItemServiceRequest(), "\u8bf7\u6c42 " + ErrorCode.NOT_NULL.getMessage());
        this.sdRegistDataCompletion.judgeNotNull((Object)request.getSdClaimPolicyItemServiceRequest().getBody(), "\u8bf7\u6c42\u5934[head] " + ErrorCode.NOT_NULL.getMessage());
        this.sdRegistDataCompletion.judgeNotNull((Object)request.getSdClaimPolicyItemServiceRequest().getHead(), "\u8bf7\u6c42\u4f53[body] " + ErrorCode.NOT_NULL.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PolicyDTO getPolicyDetailByInsureds(StanderRequest request) throws ApisBusinessException {
        PolicyDTO policyDTO;
        SDClaimPolicyItemRequestDTO body = request.getSdClaimPolicyItemServiceRequest().getBody();
        String oldUserCode = request.getHeader().getUserCode();
        request.getHeader().setUserCode("JME_USER");
        try {
            policyDTO = this.sdRegistDataCompletion.getPolicyDetailByInsureds(request, body.getPolicyNo(), body.getInsuredName(), body.getInsuredCertifyNo(), null);
        }
        finally {
            request.getHeader().setUserCode(oldUserCode);
        }
        request.setPolicyDetail(policyDTO);
        return policyDTO;
    }
}

