/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.consts.ErrorCode;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.SDRegistDataCompletion;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.request.ClaimListQueryServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.request.ClaimQueryInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.response.ClaimOpenBillServiceResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiRequestRegistService;
import com.jdaz.sinosoftgz.coreapi.claims.CoreClaimsQueryApi;
import com.jdaz.sinosoftgz.coreapi.claims.CoreSDClaimApi;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SDClaimSurveyHandler
implements BusinessHandler {
    private static final Logger log = LoggerFactory.getLogger(SDClaimSurveyHandler.class);
    @Autowired
    CoreSDClaimApi coreSdClaimApi;
    @Autowired
    SDRegistDataCompletion sdRegistDataCompletion;
    @Autowired
    private CoreClaimsQueryApi coreClaimsQueryApi;
    @Autowired
    private ApisBusiRequestRegistService apisBusiRequestRegistService;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        TimeInterval timer = DateUtil.timer();
        this.checkRequestHeadBody(request);
        this.verifyNotNull(request);
        log.warn("\u524d\u7f6e\u8bf7\u6c42\u4f53\u5224\u7a7a\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.verifyClaimNo(request);
        this.dataCompletionClaimOpenBillRequestDTO(request);
        log.warn("\u6570\u636e\u8865\u5168\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        StanderResponse response = this.coreSdClaimApi.sdClaimSurvey(request);
        return response;
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        if (ObjectUtil.isEmpty((Object)response) || ObjectUtil.isEmpty((Object)response.getSdClaimOpenBillServiceResponse()) || ObjectUtil.isEmpty((Object)response.getSdClaimOpenBillServiceResponse().getHead())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.INTERACTION_ERR0R.getCode()).message(ErrorCode.INTERACTION_ERR0R.getMessage()).build();
        }
        if (!"1".equals(response.getSdClaimOpenBillServiceResponse().getHead().getResponseCode())) {
            throw ApisDataCompletionException.builder().errorCode(response.getSdClaimOpenBillServiceResponse().getHead().getErrorCode()).message(response.getSdClaimOpenBillServiceResponse().getHead().getErrorMessage()).build();
        }
        ClaimOpenBillServiceResponseDTO claimOpenBillServiceResponseDTO = response.getSdClaimOpenBillServiceResponse().getBody();
        if (ObjectUtil.isNotEmpty((Object)claimOpenBillServiceResponseDTO)) {
            claimOpenBillServiceResponseDTO.setInsCompanyId("ALCX20210205");
        }
        String inspectUniqueId = UUID.fastUUID().toString().replaceAll("-", "");
        claimOpenBillServiceResponseDTO.setInspectUniqueId(inspectUniqueId);
        try {
            this.apisBusiRequestRegistService.updateInspectUniqueId(request.getSdClaimSurveyServiceRequest().getBody().getRegistNo(), inspectUniqueId);
        }
        catch (Exception e) {
            log.error("\u7406\u8d54\u8c03\u67e5\u53d1\u8d77\uff0c\u66f4\u65b0\u62a5\u6848\u53f7 {},\u8c03\u67e5\u552f\u4e00ID {}\u51fa\u9519\uff01", new Object[]{request.getSdClaimSurveyServiceRequest().getBody().getRegistNo(), inspectUniqueId, e});
        }
        return response;
    }

    private void checkRequestHeadBody(StanderRequest request) throws ApisDataCompletionException {
        this.sdRegistDataCompletion.judgeNotNull((Object)request, "\u8bf7\u6c42\u62a5\u6587 " + ErrorCode.NOT_NULL.getMessage());
        this.sdRegistDataCompletion.judgeNotNull((Object)request.getSdClaimSurveyServiceRequest(), "\u8bf7\u6c42 " + ErrorCode.NOT_NULL.getMessage());
        this.sdRegistDataCompletion.judgeNotNull((Object)request.getSdClaimSurveyServiceRequest().getBody(), "\u8bf7\u6c42\u5934[head] " + ErrorCode.NOT_NULL.getMessage());
        this.sdRegistDataCompletion.judgeNotNull((Object)request.getSdClaimSurveyServiceRequest().getHead(), "\u8bf7\u6c42\u4f53[body] " + ErrorCode.NOT_NULL.getMessage());
    }

    private void dataCompletionClaimOpenBillRequestDTO(StanderRequest request) {
    }

    private void verifyNotNull(StanderRequest request) {
    }

    private void verifyClaimNo(StanderRequest request) throws ApisBusinessException {
        RequestHeadDTO thisHead = new RequestHeadDTO();
        thisHead.setTransDate(new Date());
        thisHead.setUser(request.getHeader().getUserCode());
        thisHead.setTransType("0007");
        ClaimQueryInfoDTO claimQueryInfoDTO = new ClaimQueryInfoDTO();
        claimQueryInfoDTO.setRegistNo(request.getSdClaimSurveyServiceRequest().getBody().getRegistNo());
        claimQueryInfoDTO.setPolicyNo(request.getSdClaimSurveyServiceRequest().getBody().getPolicyNo());
        claimQueryInfoDTO.setPageSize(1);
        ClaimListQueryServiceRequest thisClaimListQueryServiceRequest = new ClaimListQueryServiceRequest(thisHead, claimQueryInfoDTO);
        request.setClaimListQueryServiceRequest(thisClaimListQueryServiceRequest);
        StanderResponse claimListResponse = this.coreClaimsQueryApi.claimsQuery(request);
        if (claimListResponse.getClaimListQueryResponse() == null || claimListResponse.getClaimListQueryResponse().getBody() == null || ObjectUtil.isEmpty((Object)claimListResponse.getClaimListQueryResponse().getBody().getClaimInfoList())) {
            throw new ApisBusinessException("\u67e5\u8be2\u4e0d\u5230\u8be5\u6848\u4ef6\uff0c\u8bf7\u6838\u5b9e\u6848\u4ef6\u662f\u5426\u5b58\u5728", "404");
        }
    }
}

