/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.consts.ErrorCode;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.ClaimMediaUploadUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.SDCollectInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.SDInforSupplementRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgBatchUploadRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgBatchUploadServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiInforSuppleLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiInforSuppleLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiRequestRegistService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelCode;
import com.jdaz.sinosoftgz.apis.commons.model.channel.mapper.ApisChannelCodeMapper;
import com.jdaz.sinosoftgz.coreapi.claims.CoreSDClaimApi;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SDInformationSupplementHandler
implements BusinessHandler {
    private static Logger log = LoggerFactory.getLogger(SDInformationSupplementHandler.class);
    @Autowired
    CoreSDClaimApi coreSdClaimApi;
    @Autowired
    ApisBusiRequestRegistService apisBusiRequestRegistService;
    @Autowired
    ClaimMediaUploadUtil claimMediaUploadUtil;
    @Autowired
    ApisChannelCodeMapper apisChannelCodeMapper;
    @Autowired
    ApisBusiInforSuppleLogService apisBusiInforSuppleLogService;
    private static String defaultClaimCode = "99930";
    private static String defaultImageCode = "999";
    TimeInterval timer = DateUtil.timer();

    public StanderRequest dataCompletion(StanderRequest request) throws ApisDataCompletionException {
        this.timer.intervalRestart();
        SDInforSupplementRequestDTO sdInforSupplementRequestDTO = request.getSdInforSupplementServiceRequest().getBody();
        this.verifyNotNull(request);
        if (ObjectUtil.isEmpty((Object)sdInforSupplementRequestDTO.getSupRespTime())) {
            sdInforSupplementRequestDTO.setSupRespTime(new Date());
        }
        sdInforSupplementRequestDTO.setSource("2");
        for (SDCollectInfoDTO sdCollectInfoDTO : sdInforSupplementRequestDTO.getCollectInfoList()) {
            String value = this.apisChannelCodeMapper.getValue("sdClaimMediatype", sdCollectInfoDTO.getSectionType());
            if (StringUtils.isEmpty((CharSequence)value)) {
                value = defaultImageCode;
                log.warn("\u4e3a\u5339\u914d\u5230\u5bf9\u5e94\u5355\u8bc1\u9ed8\u8ba4\u4e3a\u5176\u4ed6\uff0c\u62a5\u6848\u53f7\u4e3a:{}", (Object)sdInforSupplementRequestDTO.getRegistNo());
            }
            sdCollectInfoDTO.setDocCode(value.equals(defaultImageCode) ? defaultClaimCode : value);
            sdCollectInfoDTO.setPicCount("1");
            sdCollectInfoDTO.setSectionName(sdCollectInfoDTO.getSectionName() + ".jpg");
            if (!ObjectUtil.isEmpty((Object)sdCollectInfoDTO.getDocName()) || !sdCollectInfoDTO.getDocCode().equals(defaultClaimCode)) continue;
            sdCollectInfoDTO.setDocName("\u5176\u4ed6");
        }
        return request;
    }

    private void verifyNotNull(StanderRequest request) throws ApisDataCompletionException {
        SDInforSupplementRequestDTO dto = request.getSdInforSupplementServiceRequest().getBody();
        if (ObjectUtil.isEmpty((Object)dto.getRegistNo())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_NULL.getCode()).message("\u62a5\u6848\u53f7" + ErrorCode.NOT_NULL.getMessage()).build();
        }
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        this.timer.intervalRestart();
        StanderResponse standerResponse = this.coreSdClaimApi.infoSupplement(request);
        log.warn("\u7406\u7b97\u8d44\u6599\u4fe1\u606f\u8865\u5145\u63a5\u53e3\uff0c\u7528\u65f6 :{}", (Object)this.timer.intervalRestart());
        if (!this.checkResponseHeadSuccess(standerResponse)) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.INTERACTION_ERR0R.getCode()).message(ErrorCode.INTERACTION_ERR0R.getMessage()).build();
        }
        this.saveInfoLog(request);
        ImgBatchUploadServiceRequest imgBatchUploadServiceRequest = ImgBatchUploadServiceRequest.builder().build();
        ImgBatchUploadRequestDTO imgBatchUploadRequestDTO = ImgBatchUploadRequestDTO.builder().build();
        imgBatchUploadServiceRequest.setRequestBody(imgBatchUploadRequestDTO);
        request.setImgBatchUploadServiceRequest(imgBatchUploadServiceRequest);
        this.claimMediaUploadUtil.syncUploadGuaranteeMaterial(request);
        return standerResponse;
    }

    private void saveInfoLog(StanderRequest request) {
        SDInforSupplementRequestDTO dto = request.getSdInforSupplementServiceRequest().getBody();
        for (SDCollectInfoDTO sdCollectInfoDTO : dto.getCollectInfoList()) {
            ApisBusiInforSuppleLog apisBusiInforSuppleLog = new ApisBusiInforSuppleLog();
            apisBusiInforSuppleLog.setRegistNo(dto.getRegistNo());
            apisBusiInforSuppleLog.setFileName(sdCollectInfoDTO.getSectionName());
            apisBusiInforSuppleLog.setSdType(sdCollectInfoDTO.getSectionType());
            String value = this.apisChannelCodeMapper.getValue("sdClaimMediatype", sdCollectInfoDTO.getSectionType());
            if (StringUtils.isEmpty((CharSequence)value)) {
                value = defaultImageCode;
            }
            log.warn("\u6d4b\u8bd5\u63a8\u9001\u5355\u8bc1\u7c7b\u578b\u6253\u5370\uff0c\u6c34\u6ef4code\u4e3a:{}", (Object)sdCollectInfoDTO.getSectionType());
            QueryWrapper qw = new QueryWrapper();
            qw.eq((Object)"code", (Object)"sdClaimMediatype");
            qw.eq((Object)"value", (Object)value);
            List apisBusiInforSuppleLogList = this.apisChannelCodeMapper.selectList((Wrapper)qw);
            if (apisBusiInforSuppleLogList.size() > 0) {
                String valueDesc = ((ApisChannelCode)apisBusiInforSuppleLogList.get(0)).getValueDesc();
                apisBusiInforSuppleLog.setImgTypeDesc(valueDesc);
            }
            apisBusiInforSuppleLog.setImgType(value);
            apisBusiInforSuppleLog.setClaimType(sdCollectInfoDTO.getDocCode());
            apisBusiInforSuppleLog.setPushStatus(Integer.valueOf(-1));
            apisBusiInforSuppleLog.setPushTime(LocalDateTime.now());
            this.apisBusiInforSuppleLogService.save((Object)apisBusiInforSuppleLog);
        }
    }

    private boolean checkResponseHeadSuccess(StanderResponse standerResponse) {
        return standerResponse.getSdInforSupplementServiceResponse() != null && standerResponse.getSdInforSupplementServiceResponse().getHead() != null && String.valueOf(1).equals(standerResponse.getSdInforSupplementServiceResponse().getHead().getResponseCode());
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) {
        return response;
    }
}

