/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.consts.ErrorCode;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.adjustingSyn.AdjustingSynRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.adjustingSyn.DlossPropFee;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.adjustingSyn.LossPropInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.PayPersonInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiRequestRegistService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.coreapi.claims.CoreClaimsApi;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class StanderClaimAdjustingSynHandler
implements BusinessHandler {
    private static Logger log = LoggerFactory.getLogger(StanderClaimAdjustingSynHandler.class);
    @Autowired
    CoreClaimsApi coreClaimsApi;
    @Autowired
    ApisBusiRequestRegistService apisBusiRequestRegistService;
    private static final String[] PAY_PERSON_INFO_NAMES = new String[]{"certifyType", "certifyNo", "payObjectKind", "payeeName", "bankCode", "accountNo"};
    TimeInterval timer = DateUtil.timer();

    public StanderRequest dataCompletion(StanderRequest request) throws ApisDataCompletionException {
        this.timer.intervalRestart();
        AdjustingSynRequestDTO adjustingSynRequestDTO = request.getAdjustingSynServiceRequest().getBody();
        this.defaultDataValue(adjustingSynRequestDTO);
        this.verifyNotNull(request);
        return request;
    }

    private void defaultDataValue(AdjustingSynRequestDTO adjustingSynRequestDTO) throws ApisDataCompletionException {
        if (ObjectUtil.isEmpty((Object)adjustingSynRequestDTO.getCurrency())) {
            adjustingSynRequestDTO.setCurrency("RMB");
        }
        for (PayPersonInfoDTO payPersonInfoDTO : adjustingSynRequestDTO.getPayPersonInfoList()) {
            if (!StringUtils.isEmpty((Object)payPersonInfoDTO.getNationFlag())) continue;
            payPersonInfoDTO.setNationFlag("1");
        }
        if (ObjectUtil.isNotEmpty((Object)adjustingSynRequestDTO.getLossPropInfoList())) {
            for (LossPropInfo dto : adjustingSynRequestDTO.getLossPropInfoList()) {
                if (!ObjectUtil.isNotEmpty((Object)dto)) continue;
                for (DlossPropFee vo : dto.getDlossPropFeeVoList()) {
                    if (!ObjectUtil.isNotEmpty((Object)vo)) continue;
                    vo.setLossItemName(ObjectUtil.isEmpty((Object)vo.getLossItemName()) ? "\u7269\u635f" : vo.getLossItemName());
                    vo.setCurrencyL(ObjectUtil.isEmpty((Object)vo.getCurrencyL()) ? "RMB" : vo.getCurrencyL());
                    vo.setLossQuantity(ObjectUtil.isEmpty((Object)vo.getLossQuantity()) ? new BigDecimal(1) : vo.getLossQuantity());
                    vo.setVeriUnitPrice(ObjectUtil.isEmpty((Object)vo.getVeriUnitPrice()) ? vo.getUnitPrice() : vo.getVeriUnitPrice());
                    vo.setVeriLossQuantity(ObjectUtil.isEmpty((Object)vo.getVeriLossQuantity()) ? new BigDecimal(1) : vo.getVeriLossQuantity());
                    vo.setUnitCode(ObjectUtil.isEmpty((Object)vo.getUnitCode()) ? "02" : vo.getUnitCode());
                    vo.setDepreRate(ObjectUtil.isEmpty((Object)vo.getDepreRate()) ? new BigDecimal(0) : vo.getDepreRate());
                    vo.setLossLevel(ObjectUtil.isEmpty((Object)vo.getLossLevel()) ? new BigDecimal(100) : vo.getLossLevel());
                    vo.setRecyclePrice(ObjectUtil.isEmpty((Object)vo.getRecyclePrice()) ? new BigDecimal(0) : vo.getRecyclePrice());
                }
            }
        }
        if (ObjectUtil.isNotEmpty((Object)adjustingSynRequestDTO.getLossPersonInfoList())) {
            for (LossPropInfo dto : adjustingSynRequestDTO.getLossPersonInfoList()) {
                if (!ObjectUtil.isNotEmpty((Object)dto)) continue;
                dto.setPersonName(ObjectUtil.isEmpty((Object)dto.getPersonName()) ? "XXX" : dto.getPersonName());
                dto.setCertiType(ObjectUtil.isEmpty((Object)dto.getCertiType()) ? "03" : dto.getCertiType());
                dto.setCertiCode(ObjectUtil.isEmpty((Object)dto.getCertiCode()) ? "999999999999999999" : dto.getCertiCode());
                for (DlossPropFee vo : dto.getLossPersonFeeInfoList()) {
                    if (!ObjectUtil.isNotEmpty((Object)vo)) continue;
                    vo.setChargeCode(ObjectUtil.isEmpty((Object)vo.getChargeCode()) ? "03" : vo.getChargeCode());
                    vo.setCurrencyL(ObjectUtil.isEmpty((Object)vo.getCurrencyL()) ? "RMB" : vo.getCurrencyL());
                    vo.setFeeOffLoss(ObjectUtil.isEmpty((Object)vo.getFeeOffLoss()) ? new BigDecimal(0) : vo.getFeeOffLoss());
                    vo.setRemark(ObjectUtil.isEmpty((Object)vo.getRemark()) ? "\u7b2c\u4e09\u8005\u8d39\u7528" : vo.getRemark());
                }
            }
        }
    }

    private void verifyNotNull(StanderRequest request) throws ApisDataCompletionException {
        AdjustingSynRequestDTO dto = request.getAdjustingSynServiceRequest().getBody();
        if (ObjectUtil.isEmpty((Object)dto.getRegistNo())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_NULL.getCode()).message("\u62a5\u6848\u53f7" + ErrorCode.NOT_NULL.getMessage()).build();
        }
        List payPersonInfoDTOList = dto.getPayPersonInfoList();
        for (PayPersonInfoDTO payPersonInfoDTO : payPersonInfoDTOList) {
            String result = StanderClaimAdjustingSynHandler.isAllFieldNull((Object)payPersonInfoDTO, Arrays.asList(PAY_PERSON_INFO_NAMES));
            if ("-1".equals(result)) {
                throw ApisDataCompletionException.builder().errorCode(ChannelErrorCodeEnum.ERR_C10006.getKey()).message(ChannelErrorCodeEnum.ERR_C10006.getValue()).build();
            }
            if ("1".equals(result)) continue;
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_NULL.getCode()).message(result + ErrorCode.NOT_NULL.getMessage()).build();
        }
    }

    public static String isAllFieldNull(Object o, List<String> fieldNameList) {
        try {
            for (Field field : o.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                Object object = field.get(o);
                if (object != null || !fieldNameList.contains(field.getName())) continue;
                return field.getName();
            }
        }
        catch (Exception e) {
            log.error("\u53cd\u5c04\u8f6c\u6362\u9519\u8bef\uff1a{}", (Throwable)e);
            return "-1";
        }
        return "1";
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        this.timer.intervalRestart();
        StanderResponse standerResponse = this.coreClaimsApi.adjustingSyn(request);
        log.warn("\u7406\u7b97\u4fe1\u606f\u540c\u6b65\u63a5\u53e3\uff0c\u7528\u65f6 :{}", (Object)this.timer.intervalRestart());
        if (ObjectUtil.isEmpty((Object)standerResponse)) {
            throw new ApisBusinessException(ErrorCode.INTERACTION_ERR0R.getMessage(), ErrorCode.INTERACTION_ERR0R.getCode());
        }
        if (String.valueOf(0).equals(standerResponse.getAdjustingSynServiceResponse().getHead().getResponseCode())) {
            if (StringUtils.isEmpty((Object)standerResponse.getAdjustingSynServiceResponse().getHead().getErrorMessage())) {
                throw new ApisBusinessException(ErrorCode.FAIL.getMessage(), !StringUtils.isEmpty((Object)standerResponse.getAdjustingSynServiceResponse().getHead().getErrorCode()) ? standerResponse.getAdjustingSynServiceResponse().getHead().getErrorCode() : ErrorCode.FAIL.getCode());
            }
            throw new ApisBusinessException(standerResponse.getAdjustingSynServiceResponse().getHead().getErrorMessage(), standerResponse.getAdjustingSynServiceResponse().getHead().getErrorCode());
        }
        return standerResponse;
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) {
        return response;
    }

    private boolean checkResponseHeadSuccess(StanderResponse standerResponse) {
        return standerResponse.getAdjustingSynServiceResponse() != null && standerResponse.getAdjustingSynServiceResponse().getHead() != null && String.valueOf(1).equals(standerResponse.getAdjustingSynServiceResponse().getHead().getResponseCode());
    }
}

