/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.consts.ErrorCode;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.caseBarCode.CaseBarCodeRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiRequestRegistService;
import com.jdaz.sinosoftgz.coreapi.claims.CoreClaimsApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class StanderClaimBarCodeHandler
implements BusinessHandler {
    private static Logger log = LoggerFactory.getLogger(StanderClaimBarCodeHandler.class);
    @Autowired
    CoreClaimsApi coreClaimsApi;
    @Autowired
    ApisBusiRequestRegistService apisBusiRequestRegistService;
    TimeInterval timer = DateUtil.timer();

    public StanderRequest dataCompletion(StanderRequest request) throws ApisDataCompletionException {
        CaseBarCodeRequestDTO dto = request.getCaseBarCodeServiceRequest().getBody();
        if (ObjectUtil.isEmpty((Object)dto.getRegistNo())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_NULL.getCode()).message("\u62a5\u6848\u53f7" + ErrorCode.NOT_NULL.getMessage()).build();
        }
        return request;
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        this.timer.intervalRestart();
        StanderResponse standerResponse = this.coreClaimsApi.caseBarCode(request);
        log.warn("\u6761\u5f62\u7801\u8865\u5145\u63a5\u53e3\uff0c\u7528\u65f6 :{}", (Object)this.timer.intervalRestart());
        if (ObjectUtil.isEmpty((Object)standerResponse)) {
            throw new ApisBusinessException(ErrorCode.INTERACTION_ERR0R.getMessage(), ErrorCode.INTERACTION_ERR0R.getCode());
        }
        if (String.valueOf(0).equals(standerResponse.getCaseBarCodeServiceResponse().getHead().getResponseCode())) {
            if (StringUtils.isEmpty((Object)standerResponse.getCaseBarCodeServiceResponse().getHead().getErrorMessage())) {
                throw new ApisBusinessException(ErrorCode.FAIL.getMessage(), !StringUtils.isEmpty((Object)standerResponse.getCaseBarCodeServiceResponse().getHead().getErrorCode()) ? standerResponse.getCaseBarCodeServiceResponse().getHead().getErrorCode() : ErrorCode.FAIL.getCode());
            }
            throw new ApisBusinessException(standerResponse.getCaseBarCodeServiceResponse().getHead().getErrorMessage(), standerResponse.getCaseBarCodeServiceResponse().getHead().getErrorCode());
        }
        return standerResponse;
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) {
        return response;
    }
}

