/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.handler.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.consts.ErrorCode;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.ClaimMediaUploadUtil;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.OkHttpUtils;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.inforSupplement.CollectInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.inforSupplement.InforSupplementRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.DocCodeAndName;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.response.DocResultDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.request.ClaimMediaCommitResult;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.request.ImgNode;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgBatchUploadRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgBatchUploadServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgMetaDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiInforSuppleLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiInforSuppleLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiRequestRegistService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.mapper.ApisChannelCodeMapper;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.coreapi.claims.CoreClaimsApi;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StanderClaimInformationComplementHandler
implements BusinessHandler {
    private static Logger log = LoggerFactory.getLogger(StanderClaimInformationComplementHandler.class);
    @Autowired
    CoreClaimsApi coreClaimsApi;
    @Autowired
    ApisBusiRequestRegistService apisBusiRequestRegistService;
    @Autowired
    ClaimMediaUploadUtil claimMediaUploadUtil;
    @Autowired
    ApisChannelCodeMapper apisChannelCodeMapper;
    @Autowired
    ApisBusiInforSuppleLogService apisBusiInforSuppleLogService;
    @Autowired
    private ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    private DocCodeAndName docCodeAndName;
    TimeInterval timer = DateUtil.timer();

    public StanderRequest dataCompletion(StanderRequest request) throws ApisDataCompletionException {
        this.timer.intervalRestart();
        InforSupplementRequestDTO inforSupplementRequestDTO = request.getInforSupplementServiceRequest().getBody();
        this.verifyNotNull(request);
        if (ObjectUtil.isEmpty((Object)inforSupplementRequestDTO.getSupRespTime())) {
            inforSupplementRequestDTO.setSupRespTime(new Date());
        }
        if (ObjectUtil.isEmpty((Object)inforSupplementRequestDTO.getSource())) {
            inforSupplementRequestDTO.setSource("2");
        }
        for (CollectInfoDTO collectInfoDTO : inforSupplementRequestDTO.getCollectInfoList()) {
            collectInfoDTO.setPicCount("1");
        }
        if (!this.isCompensatable(request.getHeader().getUserCode())) {
            inforSupplementRequestDTO.setIfAutoClaim("0");
        }
        return request;
    }

    private void verifyNotNull(StanderRequest request) throws ApisDataCompletionException {
        InforSupplementRequestDTO dto = request.getInforSupplementServiceRequest().getBody();
        if (ObjectUtil.isEmpty((Object)dto.getRegistNo())) {
            throw ApisDataCompletionException.builder().errorCode(ErrorCode.NOT_NULL.getCode()).message("\u62a5\u6848\u53f7" + ErrorCode.NOT_NULL.getMessage()).build();
        }
    }

    public StanderResponse execute(StanderRequest request) throws ApisBusinessException {
        this.timer.intervalRestart();
        StanderResponse standerResponse = this.coreClaimsApi.infoSupplement(request);
        log.warn("\u7406\u7b97\u8d44\u6599\u4fe1\u606f\u8865\u5145\u63a5\u53e3\uff0c\u7528\u65f6 :{}", (Object)this.timer.intervalRestart());
        if (ObjectUtil.isEmpty((Object)standerResponse)) {
            throw new ApisBusinessException(ErrorCode.INTERACTION_ERR0R.getMessage(), ErrorCode.INTERACTION_ERR0R.getCode());
        }
        if (String.valueOf(0).equals(standerResponse.getInforSupplementServiceResponse().getHead().getResponseCode())) {
            if (StringUtils.isNotEmpty((CharSequence)standerResponse.getInforSupplementServiceResponse().getHead().getErrorMessage())) {
                throw new ApisBusinessException(standerResponse.getInforSupplementServiceResponse().getHead().getErrorMessage(), standerResponse.getInforSupplementServiceResponse().getHead().getErrorCode());
            }
            throw new ApisBusinessException(ErrorCode.FAIL.getMessage(), StringUtils.isNotEmpty((CharSequence)standerResponse.getInforSupplementServiceResponse().getHead().getErrorCode()) ? standerResponse.getInforSupplementServiceResponse().getHead().getErrorCode() : ErrorCode.FAIL.getCode());
        }
        this.saveInfoLog(request);
        ImgBatchUploadServiceRequest imgBatchUploadServiceRequest = ImgBatchUploadServiceRequest.builder().build();
        ImgBatchUploadRequestDTO imgBatchUploadRequestDTO = ImgBatchUploadRequestDTO.builder().build();
        imgBatchUploadServiceRequest.setRequestBody(imgBatchUploadRequestDTO);
        request.setImgBatchUploadServiceRequest(imgBatchUploadServiceRequest);
        this.uploadGuaranteeMaterial(request, standerResponse);
        return standerResponse;
    }

    public void uploadGuaranteeMaterial(StanderRequest request, StanderResponse standerResponse) throws ApisBusinessException {
        try {
            this.beforeMaterialUploadProcess(request, standerResponse);
        }
        catch (Exception e) {
            log.error("\u7406\u8d54\u4e0a\u4f20\u8d44\u6599\u5931\u8d25\uff0c{}", (Throwable)e);
        }
    }

    private void beforeMaterialUploadProcess(StanderRequest request, StanderResponse standerResponse) throws ApisBusinessException {
        ArrayList<DocResultDTO> docList = new ArrayList<DocResultDTO>();
        List collectInfodtos = request.getInforSupplementServiceRequest().getBody().getCollectInfoList();
        ClaimMediaCommitResult imageResult = null;
        for (CollectInfoDTO collectInfoDTO : collectInfodtos) {
            if (StringUtils.isEmpty((CharSequence)collectInfoDTO.getSectionUrl()) && StringUtils.isEmpty((CharSequence)collectInfoDTO.getDocBase64FileContent()) || StringUtils.isEmpty((CharSequence)collectInfoDTO.getSectionName())) continue;
            if (!ObjectUtil.isEmpty((Object)collectInfoDTO.getDocBase64FileContent())) {
                String fileName = collectInfoDTO.getSectionName();
                String base64Str = collectInfoDTO.getDocBase64FileContent();
                log.warn("\u7406\u8d54\u63a8\u9001base64\uff0c\u6587\u4ef6\u540d:{}", (Object)collectInfoDTO.getSectionName());
                if (StringUtils.isEmpty((CharSequence)base64Str)) {
                    log.error("\u7406\u8d54base64\u4e3a\u7a7a,\u6587\u4ef6\u540d:{}", (Object)collectInfoDTO.getSectionName());
                    continue;
                }
                String defaultClaimCode = "99930";
                String defaultImageCode = "999";
                String code = collectInfoDTO.getDocCode().equals(defaultClaimCode) ? defaultImageCode : collectInfoDTO.getDocCode();
                String codeName = (String)this.docCodeAndName.getDocMap().get(String.valueOf(Integer.parseInt(code)));
                if (StringUtils.isEmpty((CharSequence)codeName) || StringUtils.isEmpty((CharSequence)code)) {
                    log.error("\u7406\u8d54\u6ca1\u627e\u5230\u5f71\u50cf\u6620\u5c04\u7c7b\u578b\uff0c\u6587\u4ef6\u540d:{}", (Object)collectInfoDTO.getSectionName());
                    continue;
                }
                ImgMetaDTO imgMetaDTO = ImgMetaDTO.builder().fileOrgName(fileName).imgType(code).imgTypeName(codeName).fileContentWithBase64Encode(base64Str).build();
                ArrayList<ImgMetaDTO> tarList = new ArrayList<ImgMetaDTO>();
                tarList.add(imgMetaDTO);
                request.getImgBatchUploadServiceRequest().getRequestBody().setImgList(tarList);
                imageResult = this.claimMediaUploadUtil.imgBatchUpload(request, request.getInforSupplementServiceRequest().getBody().getRegistNo());
                ImgNode imgNode = (ImgNode)imageResult.getImgNodes().get(0);
                docList.add(DocResultDTO.builder().docId(imgNode.getFileId()).docName(imgNode.getFileName()).docUrl(imgNode.getImgUrl()).build());
                continue;
            }
            String url = collectInfoDTO.getSectionUrl();
            String fileName = collectInfoDTO.getSectionName();
            String base64Str = OkHttpUtils.getBase64EncodeByUrl((String)url);
            log.warn("\u7406\u8d54\u4e0b\u8f7d\u6587\u4ef6\uff0c\u6587\u4ef6\u540d:{}", (Object)collectInfoDTO.getSectionName());
            if (StringUtils.isEmpty((CharSequence)base64Str)) {
                log.error("\u7406\u8d54\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25,\u6587\u4ef6\u540d:{}", (Object)collectInfoDTO.getSectionName());
                log.error("\u7406\u8d54\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25,url:{}", (Object)collectInfoDTO.getSectionUrl());
                continue;
            }
            String defaultClaimCode = "99930";
            String defaultImageCode = "999";
            String code = collectInfoDTO.getDocCode().equals(defaultClaimCode) ? defaultImageCode : collectInfoDTO.getDocCode();
            String codeName = (String)this.docCodeAndName.getDocMap().get(String.valueOf(Integer.parseInt(code)));
            if (StringUtils.isEmpty((CharSequence)codeName) || StringUtils.isEmpty((CharSequence)code)) {
                log.error("\u7406\u8d54\u6ca1\u627e\u5230\u5f71\u50cf\u6620\u5c04\u7c7b\u578b\uff0c\u6587\u4ef6\u540d:" + collectInfoDTO.getSectionName());
                continue;
            }
            ImgMetaDTO imgMetaDTO = ImgMetaDTO.builder().fileOrgName(fileName).imgType(code).imgTypeName(codeName).fileContentWithBase64Encode(base64Str).build();
            ArrayList<ImgMetaDTO> tarList = new ArrayList<ImgMetaDTO>();
            tarList.add(imgMetaDTO);
            request.getImgBatchUploadServiceRequest().getRequestBody().setImgList(tarList);
            imageResult = this.claimMediaUploadUtil.imgBatchUpload(request, request.getInforSupplementServiceRequest().getBody().getRegistNo());
            ImgNode imgNode = (ImgNode)imageResult.getImgNodes().get(0);
            docList.add(DocResultDTO.builder().docId(imgNode.getFileId()).docName(imgNode.getFileName()).docUrl(imgNode.getImgUrl()).build());
        }
        standerResponse.getInforSupplementServiceResponse().getBody().setDocList(docList);
        standerResponse.getInforSupplementServiceResponse().getBody().setSize(docList.size());
    }

    private void saveInfoLog(StanderRequest request) {
        InforSupplementRequestDTO dto = request.getInforSupplementServiceRequest().getBody();
        for (CollectInfoDTO collectInfoDTO : dto.getCollectInfoList()) {
            ApisBusiInforSuppleLog apisBusiInforSuppleLog = new ApisBusiInforSuppleLog();
            apisBusiInforSuppleLog.setRegistNo(dto.getRegistNo());
            apisBusiInforSuppleLog.setSdType(collectInfoDTO.getDocCode());
            String defaultClaimCode = "99930";
            String defaultImageCode = "999";
            String code = collectInfoDTO.getDocCode().equals(defaultClaimCode) ? defaultImageCode : collectInfoDTO.getDocCode();
            String codeName = (String)this.docCodeAndName.getDocMap().get(String.valueOf(Integer.parseInt(code)));
            apisBusiInforSuppleLog.setImgType(code);
            apisBusiInforSuppleLog.setImgTypeDesc(codeName);
            apisBusiInforSuppleLog.setClaimType(collectInfoDTO.getDocCode());
            apisBusiInforSuppleLog.setPushStatus(Integer.valueOf(-1));
            apisBusiInforSuppleLog.setPushTime(LocalDateTime.now());
            apisBusiInforSuppleLog.setFileName(collectInfoDTO.getSectionName());
            this.apisBusiInforSuppleLogService.save((Object)apisBusiInforSuppleLog);
        }
    }

    private boolean checkResponseHeadSuccess(StanderResponse standerResponse) {
        return standerResponse.getInforSupplementServiceResponse() != null && standerResponse.getInforSupplementServiceResponse().getHead() != null && String.valueOf(1).equals(standerResponse.getInforSupplementServiceResponse().getHead().getResponseCode());
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) {
        return response;
    }

    private boolean isCompensatable(String user) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"config_code", (Object)"open_step");
        queryWrapper.eq((Object)"user_code", (Object)user);
        queryWrapper.like((Object)"config_value", (Object)"compensate");
        List list = this.apisChannelConfigsService.list((Wrapper)queryWrapper);
        return ObjectUtil.isNotEmpty((Object)list);
    }
}

