/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.handler.impl;

import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.consts.ErrorCode;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.payeeInfoReceive.request.ClaimPayeeInfoReceiveRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.payeeInfoReceive.request.PayeeInfoDTO;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.claims.CoreClaimsApi;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StanderClaimPayeeInfoReceiveHandler
implements BusinessHandler {
    private static final Logger log = LoggerFactory.getLogger(StanderClaimPayeeInfoReceiveHandler.class);
    @Autowired
    CoreClaimsApi coreClaimsApi;
    @Autowired
    ApisBusinessService apisBusinessService;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        if (ObjectUtil.isEmpty((Object)request.getClaimPayeeInfoReceiveRequest())) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N00001.getValue(), ErrorNullValueCodeEnum.ERR_N00001.getKey());
        }
        request.getClaimPayeeInfoReceiveRequest().getHead().setTransType("AC005");
        this.verifyNull(request.getClaimPayeeInfoReceiveRequest());
        return request;
    }

    private void verifyNull(ClaimPayeeInfoReceiveRequest claimPayeeInfoReceiveRequest) throws ApisBusinessException {
        if (StringUtils.isEmpty((CharSequence)claimPayeeInfoReceiveRequest.getBody().getRegistNo())) {
            throw new ApisBusinessException("\u62a5\u6848\u53f7\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)claimPayeeInfoReceiveRequest.getBody().getPayPersonInfoList()) || claimPayeeInfoReceiveRequest.getBody().getPayPersonInfoList().size() == 0) {
            throw new ApisBusinessException("\u9886\u6b3e\u4eba\u4fe1\u606f\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        for (PayeeInfoDTO payeeInfoDTO : claimPayeeInfoReceiveRequest.getBody().getPayPersonInfoList()) {
            if (StringUtils.isEmpty((CharSequence)payeeInfoDTO.getPayObjectKind())) {
                throw new ApisBusinessException("\u6536\u6b3e\u4eba\u7c7b\u578b\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (StringUtils.isEmpty((CharSequence)payeeInfoDTO.getPayeeName())) {
                throw new ApisBusinessException("\u6536\u6b3e\u4eba\u59d3\u540d\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (StringUtils.isEmpty((CharSequence)payeeInfoDTO.getBankCode())) {
                throw new ApisBusinessException("\u6536\u6b3e\u4eba\u5f00\u6237\u94f6\u884c\u7f16\u53f7\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (!StringUtils.isEmpty((CharSequence)payeeInfoDTO.getAccountNo())) continue;
            throw new ApisBusinessException("\u6536\u6b3e\u65b9\u8d26\u53f7\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
    }

    public StanderResponse execute(StanderRequest request) {
        StanderResponse standerResponse = this.coreClaimsApi.claimPayeeInfoReceive(request);
        return standerResponse;
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        if (ObjectUtil.isEmpty((Object)response)) {
            throw new ApisBusinessException(ErrorCode.INTERACTION_ERR0R.getMessage(), ErrorCode.INTERACTION_ERR0R.getCode());
        }
        if (String.valueOf(0).equals(response.getClaimPayeeInfoReceiveResponse().getHead().getResponseCode())) {
            if (StringUtils.isNotEmpty((CharSequence)response.getClaimPayeeInfoReceiveResponse().getHead().getErrorMessage())) {
                throw new ApisBusinessException(response.getClaimPayeeInfoReceiveResponse().getHead().getErrorMessage(), response.getClaimPayeeInfoReceiveResponse().getHead().getErrorCode());
            }
            throw new ApisBusinessException(ErrorCode.FAIL.getMessage(), StringUtils.isNotEmpty((CharSequence)response.getClaimRegistResponse().getHead().getErrorCode()) ? response.getClaimRegistResponse().getHead().getErrorCode() : ErrorCode.FAIL.getCode());
        }
        return response;
    }
}

