/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.handler.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.consts.ErrorCode;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.RegistDataCompletion;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.WebResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderHeader;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.ClaimRegistRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.ClaimRegistRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.response.ClaimRegistResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyListQueryRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyListServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyListDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyListQueryResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiRequestRegist;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiRequestRegistService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.RiskCodeEnum;
import com.jdaz.sinosoftgz.coreapi.claims.CoreClaimsApi;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.client.RestTemplate;

public class StanderClaimRegistHandler
implements BusinessHandler {
    private static final Logger log = LoggerFactory.getLogger(StanderClaimRegistHandler.class);
    @Autowired
    CoreClaimsApi coreClaimsApi;
    @Autowired
    ApisBusinessService apisBusinessService;
    @Autowired
    RegistDataCompletion registDataCompletion;
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${policyListAddress}")
    private String policyListAddress;
    @Autowired
    private ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private ApisBusiRequestRegistService apisBusiRequestRegistService;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        if (ObjectUtil.isEmpty((Object)request.getClaimRegistRequest())) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N00001.getValue(), ErrorNullValueCodeEnum.ERR_N00001.getKey());
        }
        request.getClaimRegistRequest().getHead().setTransType("AC001");
        this.lock(request.getClaimRegistRequest().getHead().getUser(), request.getClaimRegistRequest().getHead().getTransID());
        this.verifyNull(request);
        this.verifyPower(request);
        return request;
    }

    private void verifyPower(StanderRequest request) throws ApisBusinessException {
        ApisChannelConfigs apisChannelConfigs = new ApisChannelConfigs();
        apisChannelConfigs.setConfigCode("open_step");
        apisChannelConfigs.setConfigValue("regist");
        apisChannelConfigs.setUserCode(request.getClaimRegistRequest().getHead().getUser());
        ApisChannelConfigs registerConfig = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigs);
        if (ObjectUtil.isEmpty((Object)registerConfig)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10004.getValue(), ChannelErrorCodeEnum.ERR_C10004.getKey());
        }
    }

    private void verifyNull(StanderRequest request) throws ApisBusinessException {
        ClaimRegistRequest claimRegistRequest = request.getClaimRegistRequest();
        if (StringUtils.isEmpty((CharSequence)claimRegistRequest.getBody().getPreRegistFlag())) {
            throw new ApisBusinessException("\u9884\u62a5\u6848\u6807\u8bc6\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (StringUtils.isEmpty((CharSequence)claimRegistRequest.getBody().getPolicyNo())) {
            throw new ApisBusinessException("\u4fdd\u5355\u53f7\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)claimRegistRequest.getBody().getDamageTime())) {
            throw new ApisBusinessException("\u51fa\u9669\u65f6\u95f4\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (StringUtils.isEmpty((CharSequence)claimRegistRequest.getBody().getReportorName())) {
            throw new ApisBusinessException("\u62a5\u6848\u4eba\u59d3\u540d\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (StringUtils.isEmpty((CharSequence)claimRegistRequest.getBody().getReportorPhone())) {
            throw new ApisBusinessException("\u62a5\u6848\u4eba\u7535\u8bdd\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (StringUtils.isEmpty((CharSequence)claimRegistRequest.getBody().getDamageCode())) {
            throw new ApisBusinessException("\u51fa\u9669\u539f\u56e0\u4ee3\u7801\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (StringUtils.isEmpty((CharSequence)claimRegistRequest.getBody().getNationFlag())) {
            throw new ApisBusinessException("\u5883\u5185\u5916\u6807\u8bc6\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (StringUtils.isEmpty((CharSequence)claimRegistRequest.getBody().getDamageArea())) {
            throw new ApisBusinessException("\u51fa\u9669\u533a\u57df\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (StringUtils.isEmpty((CharSequence)claimRegistRequest.getBody().getCurrency())) {
            throw new ApisBusinessException("\u62a5\u635f\u5e01\u522b\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)claimRegistRequest.getBody().getReportedLoss())) {
            throw new ApisBusinessException("\u62a5\u635f\u91d1\u989d\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        PolicyListQueryResponse policyListQueryResponse = this.getPolicyInfo(claimRegistRequest.getBody().getPolicyNo(), request.getHeader());
        PolicyListDTO policy = (PolicyListDTO)policyListQueryResponse.getResponseBody().getPolicyList().get(0);
        if (ObjectUtil.isNotEmpty((Object)policy) && RiskCodeEnum.getType((String)policy.getRiskCode()) == 1) {
            if (StringUtils.isEmpty((CharSequence)claimRegistRequest.getBody().getDamagePersonName())) {
                throw new ApisBusinessException("\u51fa\u9669\u4eba\u59d3\u540d\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (StringUtils.isEmpty((CharSequence)claimRegistRequest.getBody().getIdentifyType())) {
                throw new ApisBusinessException("\u51fa\u9669\u4eba\u8bc1\u4ef6\u7c7b\u578b\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (StringUtils.isEmpty((CharSequence)claimRegistRequest.getBody().getIdentifyNo())) {
                throw new ApisBusinessException("\u51fa\u9669\u4eba\u8bc1\u4ef6\u53f7\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (StringUtils.isEmpty((CharSequence)claimRegistRequest.getBody().getReportorRelation())) {
                throw new ApisBusinessException("\u51fa\u9669\u4eba\u548c\u88ab\u4fdd\u9669\u4eba\u5173\u7cfb\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (StringUtils.isEmpty((CharSequence)claimRegistRequest.getBody().getDamageResult())) {
                throw new ApisBusinessException("\u7406\u8d54\u7c7b\u578b\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (StringUtils.isEmpty((CharSequence)claimRegistRequest.getBody().getDiagnosis())) {
                throw new ApisBusinessException("\u8bca\u65ad\u4fe1\u606f\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
        }
    }

    private PolicyListQueryResponse getPolicyInfo(String policyNo, StanderHeader standerHeader) throws ApisBusinessException {
        PolicyListQueryRequestDTO requestBody = PolicyListQueryRequestDTO.builder().businessNature2(standerHeader.getChannelCode()).operateCode(standerHeader.getUserCode()).policyNo(policyNo).build();
        PolicyListServiceRequest policyListServiceRequest = PolicyListServiceRequest.builder().requestBody(requestBody).build();
        StanderHeader header = StanderHeader.builder().userCode(standerHeader.getUserCode()).bussinessType("policyList").channelCode(standerHeader.getChannelCode()).build();
        StanderRequest request = StanderRequest.builder().policyListServiceRequest(policyListServiceRequest).header(header).build();
        RegistDataCompletion.restTemplateInstance((RestTemplate)this.restTemplate);
        log.warn("\u8c03\u7528\u4fdd\u5355\u5217\u8868\u63a5\u53e3\uff0c\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString((Object)request));
        String json = (String)this.restTemplate.postForObject(this.policyListAddress, (Object)request, String.class, new Object[0]);
        log.warn("\u8c03\u7528\u4fdd\u5355\u5217\u8868\u63a5\u53e3\uff0c\u8fd4\u56de\uff1a{}", (Object)json);
        WebResponse webResponse = (WebResponse)JSON.parseObject((String)json, WebResponse.class);
        if (ObjectUtil.isNotEmpty((Object)webResponse) && ObjectUtil.isNotEmpty((Object)webResponse.getResult())) {
            StanderResponse standerResponse = (StanderResponse)JSON.parseObject((String)webResponse.getResult().toString(), StanderResponse.class);
            log.warn("\u8c03\u7528\u4fdd\u5355\u5217\u8868\u63a5\u53e3\uff0c\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString((Object)standerResponse));
            if (ObjectUtil.isNotEmpty((Object)standerResponse) && ObjectUtil.isNotEmpty((Object)standerResponse.getPolicyListQueryResponse()) && 1 == standerResponse.getPolicyListQueryResponse().getResponseHead().getStatus()) {
                return standerResponse.getPolicyListQueryResponse();
            }
            throw new ApisBusinessException("\u6ca1\u6709\u67e5\u8be2\u5230\u6b64\u4fdd\u5355\u8bb0\u5f55\uff0c\u4fdd\u5355\u53f7\uff1a" + policyNo, ChannelErrorCodeEnum.ERR_C10014.getKey());
        }
        throw new ApisBusinessException("\u6ca1\u6709\u67e5\u8be2\u5230\u6b64\u4fdd\u5355\u8bb0\u5f55\uff0c\u4fdd\u5355\u53f7\uff1a" + policyNo, ChannelErrorCodeEnum.ERR_C10014.getKey());
    }

    public StanderResponse execute(StanderRequest request) {
        StanderResponse standerResponse = this.coreClaimsApi.claimRegist(request);
        return standerResponse;
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        if (ObjectUtil.isEmpty((Object)response)) {
            throw new ApisBusinessException(ErrorCode.INTERACTION_ERR0R.getMessage(), ErrorCode.INTERACTION_ERR0R.getCode());
        }
        if (String.valueOf(0).equals(response.getClaimRegistResponse().getHead().getResponseCode())) {
            if (StringUtils.isNotEmpty((CharSequence)response.getClaimRegistResponse().getHead().getErrorMessage())) {
                throw new ApisBusinessException(response.getClaimRegistResponse().getHead().getErrorMessage(), response.getClaimRegistResponse().getHead().getErrorCode());
            }
            throw new ApisBusinessException(ErrorCode.FAIL.getMessage(), StringUtils.isNotEmpty((CharSequence)response.getClaimRegistResponse().getHead().getErrorCode()) ? response.getClaimRegistResponse().getHead().getErrorCode() : ErrorCode.FAIL.getCode());
        }
        if (!this.isExistRegist(response.getClaimRegistResponse())) {
            this.saveRecord(request, response.getClaimRegistResponse());
        }
        return response;
    }

    private void saveRecord(StanderRequest request, ClaimRegistResponse claimRegistResponse) {
        ApisBusiRequestRegist apisBusiRequestRegist = new ApisBusiRequestRegist();
        ClaimRegistRequestDTO claimRegistRequestDTO = request.getClaimRegistRequest().getBody();
        apisBusiRequestRegist.setRequestId(request.getClaimRegistRequest().getHead().getTransID());
        apisBusiRequestRegist.setPolicyNo(claimRegistRequestDTO.getPolicyNo());
        apisBusiRequestRegist.setRegistNo(claimRegistResponse.getBody().getRegistNo());
        apisBusiRequestRegist.setDamageResult(claimRegistRequestDTO.getDamageResult());
        apisBusiRequestRegist.setDamageTime(claimRegistRequestDTO.getDamageTime());
        apisBusiRequestRegist.setCurrency(claimRegistRequestDTO.getCurrency());
        apisBusiRequestRegist.setSumRealPay(claimRegistRequestDTO.getReportedLoss());
        apisBusiRequestRegist.setUserCode(request.getClaimRegistRequest().getHead().getUser());
        apisBusiRequestRegist.setChannelCode(request.getHeader().getChannelCode());
        apisBusiRequestRegist.setChannelType(claimRegistRequestDTO.getReportType());
        this.apisBusiRequestRegistService.save((Object)apisBusiRequestRegist);
    }

    public void lock(String userCode, String key) throws ApisBusinessException {
        if (!this.redisTemplate.opsForValue().setIfAbsent((Object)(userCode + key), (Object)(userCode + key), 3L, TimeUnit.MINUTES).booleanValue()) {
            throw new ApisBusinessException("\u4ea4\u6613\u6d41\u6c34\u53f7\u3010" + key + "\u3011\u8bf7\u6c42\u6b63\u5728\u5904\u7406,\u8bf7\u7a0d\u540e\u518d\u8bd5", ChannelErrorCodeEnum.ERR_C10007.getKey());
        }
    }

    private boolean isExistRegist(ClaimRegistResponse claimRegistResponse) {
        ApisBusiRequestRegist apisBusiRequestRegist = this.apisBusiRequestRegistService.getByRegistNo(claimRegistResponse.getBody().getRegistNo());
        return ObjectUtil.isNotEmpty((Object)apisBusiRequestRegist);
    }
}

