/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.handler.impl;

import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.evaluate.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.evaluate.request.EvaluateQueryRequest;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.claims.CoreClaimsApi;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StanderEvaluateQueryHandler
implements BusinessHandler {
    private static final Logger log = LoggerFactory.getLogger(StanderEvaluateQueryHandler.class);
    @Autowired
    CoreClaimsApi coreClaimsApi;
    @Autowired
    ApisBusinessService apisBusinessService;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        if (ObjectUtil.isEmpty((Object)request.getEvaluateQueryRequest())) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N00001.getValue(), ErrorNullValueCodeEnum.ERR_N00001.getKey());
        }
        EvaluateQueryRequest evaluateQueryRequest = request.getEvaluateQueryRequest();
        evaluateQueryRequest.setHead(RequestHeadDTO.builder().transID(UUID.randomUUID().toString()).transType("AC021").transTime(new Date()).reqParty("apis").build());
        this.verifyNull(evaluateQueryRequest);
        return request;
    }

    private void verifyNull(EvaluateQueryRequest evaluateQueryRequest) throws ApisBusinessException {
        if (StringUtils.isEmpty((CharSequence)evaluateQueryRequest.getBody().getClaimNo())) {
            throw new ApisBusinessException("\u7acb\u6848\u53f7\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (StringUtils.isEmpty((CharSequence)evaluateQueryRequest.getBody().getTemplateCode())) {
            throw new ApisBusinessException("\u6a21\u677f\u4ee3\u7801\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
    }

    public StanderResponse execute(StanderRequest request) {
        StanderResponse standerResponse = this.coreClaimsApi.evaluateQuery(request);
        return standerResponse;
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        if (ObjectUtil.isEmpty((Object)response) || ObjectUtil.isEmpty((Object)response.getEvaluateQueryResponse().getBody())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10014.getValue(), ChannelErrorCodeEnum.ERR_C10014.getKey());
        }
        return response;
    }
}

