/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.handler.impl;

import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.handler.BusinessHandler;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.evaluate.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.evaluate.request.EvaluateDetailDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.evaluate.request.EvaluateSaveRequest;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.claims.CoreClaimsApi;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StanderEvaluateSaveHandler
implements BusinessHandler {
    private static final Logger log = LoggerFactory.getLogger(StanderEvaluateSaveHandler.class);
    @Autowired
    CoreClaimsApi coreClaimsApi;
    @Autowired
    ApisBusinessService apisBusinessService;

    public StanderRequest dataCompletion(StanderRequest request) throws ApisBusinessException {
        if (ObjectUtil.isEmpty((Object)request.getEvaluateSaveRequest())) {
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N00001.getValue(), ErrorNullValueCodeEnum.ERR_N00001.getKey());
        }
        EvaluateSaveRequest evaluateSaveRequest = request.getEvaluateSaveRequest();
        evaluateSaveRequest.setHead(RequestHeadDTO.builder().transID(UUID.randomUUID().toString()).transType("AC020").transTime(new Date()).reqParty("apis").build());
        return request;
    }

    private void verifyNull(EvaluateSaveRequest evaluateSaveRequest) throws ApisBusinessException {
        if (StringUtils.isEmpty((CharSequence)evaluateSaveRequest.getBody().getRegistNo())) {
            throw new ApisBusinessException("\u62a5\u6848\u53f7\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (StringUtils.isEmpty((CharSequence)evaluateSaveRequest.getBody().getClaimNo())) {
            throw new ApisBusinessException("\u7acb\u6848\u53f7\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (StringUtils.isEmpty((CharSequence)evaluateSaveRequest.getBody().getPolicyNo())) {
            throw new ApisBusinessException("\u4fdd\u5355\u53f7\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (StringUtils.isEmpty((CharSequence)evaluateSaveRequest.getBody().getTemplateCode())) {
            throw new ApisBusinessException("\u6a21\u677f\u4ee3\u7801\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (StringUtils.isEmpty((CharSequence)evaluateSaveRequest.getBody().getTemplateName())) {
            throw new ApisBusinessException("\u6a21\u677f\u540d\u79f0\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)evaluateSaveRequest.getBody().getBeEvaluateScore())) {
            throw new ApisBusinessException("\u7efc\u5408\u8bc4\u5206\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (StringUtils.isEmpty((CharSequence)evaluateSaveRequest.getBody().getEvaluateChannel())) {
            throw new ApisBusinessException("\u8bc4\u4ef7\u6e20\u9053\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)evaluateSaveRequest.getBody().getEvaluateDate())) {
            throw new ApisBusinessException("\u8bc4\u4ef7\u65f6\u95f4\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)evaluateSaveRequest.getBody().getEvaluateDetailList())) {
            throw new ApisBusinessException("\u8bc4\u4ef7\u8be6\u60c5\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        List evaluateDetailDTOList = evaluateSaveRequest.getBody().getEvaluateDetailList();
        for (EvaluateDetailDTO detailDTO : evaluateDetailDTOList) {
            if (ObjectUtil.isEmpty((Object)detailDTO.getEvaluateTemplateDetailId())) {
                throw new ApisBusinessException("\u8bc4\u4ef7\u95ee\u9898\u5185\u5bb9\u7f16\u7801\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (StringUtils.isEmpty((CharSequence)detailDTO.getSerialNo())) {
                throw new ApisBusinessException("\u8bc4\u4ef7\u95ee\u9898\u5e8f\u53f7\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (StringUtils.isEmpty((CharSequence)detailDTO.getEvaluateContent())) {
                throw new ApisBusinessException("\u8bc4\u4ef7\u95ee\u9898\u5185\u5bb9\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
            }
            if (!ObjectUtil.isEmpty((Object)detailDTO.getBeEvaluateScore())) continue;
            throw new ApisBusinessException("\u8bc4\u4ef7\u5206\u6570\u662f\u5fc5\u4f20\u9879", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
    }

    public StanderResponse execute(StanderRequest request) {
        StanderResponse standerResponse = this.coreClaimsApi.evaluateSave(request);
        return standerResponse;
    }

    public StanderResponse beforeReturn(StanderRequest request, StanderResponse response) throws ApisBusinessException {
        if (ObjectUtil.isEmpty((Object)response)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10006.getValue(), ChannelErrorCodeEnum.ERR_C10006.getKey());
        }
        if (ObjectUtil.isNotEmpty((Object)response.getEvaluateSaveResponse().getHead().getErrorMesage())) {
            throw new ApisBusinessException(response.getEvaluateSaveResponse().getHead().getErrorMesage(), response.getEvaluateSaveResponse().getHead().getErrorCode());
        }
        return response;
    }
}

