/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.jms;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.consts.ErrorCode;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.handler.impl.ClaimDetailHandler;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.handler.impl.ClaimNoticeFileHandler;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.CommonPushUtil;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.HuiZeUtil;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.JdazGatewayUtil;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.SDClaimInfoNotifyUtil;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.YaoPinBaoUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.constants.BusinessConstants;
import com.jdaz.sinosoftgz.apis.business.app.starter.constants.ClaimBusinessConstants;
import com.jdaz.sinosoftgz.apis.business.app.starter.entity.WebResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderHeader;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.claimCaseStatus.ClaimCaseStatusRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.claimCaseStatus.ClaimCaseStatusServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.claimNoticeFile.request.ClaimNoticeFileServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.claimNoticeFile.request.ClaimNoticeFileServiceRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.claimNoticeFile.resp.ClaimNoticeFileInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.huiZe.GatewayData;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryDetail.request.ClaimDetailServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryDetail.request.ClaimQueryInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.pushAgent.ClaimCommonsExecutorResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.InsuredDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDetailRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyDetailServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.InsuredIdvDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.PolicyDetailResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiRequestRegist;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiRequestRegistService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.msg.entity.ApisMsgMqlogs;
import com.jdaz.sinosoftgz.apis.commons.service.msg.service.ApisMsgMqlogsService;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;

@Service
@RocketMQMessageListener(topic="allclaimTopic", selectorExpression="caseStatusInfoTags", consumerGroup="apis-CaseStatus-Group")
public class ClaimCaseStatusReceiveListener
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(ClaimCaseStatusReceiveListener.class);
    @Autowired
    ApisMsgMqlogsService apisMsgMqlogsService;
    @Autowired
    ApisBusiRequestRegistService apisBusiRequestRegistService;
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    SDClaimInfoNotifyUtil sdClaimInfoNotifyUtil;
    @Autowired
    private ClaimNoticeFileHandler claimNoticeFileHandler;
    @Autowired
    private ClaimDetailHandler claimDetailHandler;
    @Autowired
    private YaoPinBaoUtil yaoPinBaoUtil;
    @Autowired
    private HuiZeUtil huiZeUtil;
    @Value(value="${policyDetailAddress}")
    private String policyDetailAddress;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private JdazGatewayUtil jdazGatewayUtil;
    @Autowired
    private CommonPushUtil commonPushUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(String message) {
        log.warn("received allclaimTopic:caseStatusInfoTags message: {}", (Object)message);
        DateTime currentDate = DateUtil.date();
        try {
            Thread.sleep(5000L);
            log.warn("\u63a5\u6536MQ\u6d88\u606f\u5ef6\u65f65\u79d2\u518d\u5904\u7406.");
        }
        catch (Exception e) {
            log.error("\u5ef6\u65f6\u51fa\u9519\uff1a", (Throwable)e);
        }
        String flag = "0";
        ApisMsgMqlogs apisMsgMqlogs = new ApisMsgMqlogs();
        try {
            ClaimCaseStatusServiceRequest mqAll = (ClaimCaseStatusServiceRequest)JSON.parseObject((String)message, ClaimCaseStatusServiceRequest.class);
            ClaimCaseStatusRequestDTO mqBody = mqAll.getBody();
            Assert.notNull((Object)mqBody.getRegistNo(), (String)"\u9519\u8bef\u6570\u636e\uff0c\u62a5\u6848\u53f7\u4e3a\u7a7a\uff01");
            ApisBusiRequestRegist apisBusiRequestRegist = this.apisBusiRequestRegistService.getByRegistNo(mqBody.getRegistNo());
            if (ObjectUtil.isEmpty((Object)apisBusiRequestRegist) || ObjectUtil.isEmpty((Object)apisBusiRequestRegist.getRegistNo())) {
                log.warn("\u6570\u636e\u6709\u8bef\uff0c\u6848\u4ef6\u4e0d\u5b58\u5728\uff0c\u62a5\u6848\u53f7\uff1a{}", (Object)mqBody.getRegistNo());
                return;
            }
            apisMsgMqlogs.setCreateTime((Date)currentDate);
            apisMsgMqlogs.setMessage(message);
            apisMsgMqlogs.setTopic("allclaimTopic:caseStatusInfoTags");
            apisMsgMqlogs.setConsumerGroup("apis-CaseStatus-Group");
            apisMsgMqlogs.setErrorFlag(flag);
            this.apisMsgMqlogsService.save((Object)apisMsgMqlogs);
            this.pushCaseStatus(apisBusiRequestRegist, mqBody, apisMsgMqlogs, "0");
        }
        catch (Exception e) {
            flag = "1";
            log.error("CaseStatusReceiveListener \u5f02\u5e38: ", (Throwable)e);
        }
        finally {
            if (ObjectUtil.isNotEmpty((Object)apisMsgMqlogs.getId())) {
                apisMsgMqlogs.setErrorFlag(flag);
                apisMsgMqlogs.setReleaseTime(LocalDateTime.now());
                this.apisMsgMqlogsService.updateById((Object)apisMsgMqlogs);
            }
        }
    }

    public void pushCaseStatus(ApisBusiRequestRegist apisBusiRequestRegist, ClaimCaseStatusRequestDTO mqBody, ApisMsgMqlogs apisMsgMqlogs, String businessType) throws ApisBusinessException {
        if (!this.isPushCase(apisBusiRequestRegist, businessType).booleanValue()) {
            log.warn("\u975e\u9700\u8981\u63a8\u9001\u6570\u636e\uff0c\u672c\u6b21\u4e0d\u63a8\u9001...,\u62a5\u6848\u53f7\uff1a{}", (Object)mqBody.getRegistNo());
            return;
        }
        if (ObjectUtil.isNotEmpty((Object)mqBody.getClaimNo()) || ObjectUtil.isNotEmpty((Object)mqBody.getEndCaseNo())) {
            apisBusiRequestRegist.setClaimNo(mqBody.getClaimNo());
            apisBusiRequestRegist.setEndCaseNo(mqBody.getEndCaseNo());
            this.apisBusiRequestRegistService.updateById((Object)apisBusiRequestRegist);
        }
        ApisChannelConfigs channelConfig = new ApisChannelConfigs();
        channelConfig.setConfigCode(this.getPushUrl(apisBusiRequestRegist) + "Url");
        channelConfig = this.apisChannelConfigsService.getChannelConfig(channelConfig);
        String pushContent = null;
        int pushResultType = this.getPushResultType(apisBusiRequestRegist);
        if (this.isCustomization(apisBusiRequestRegist.getChannelType(), apisBusiRequestRegist.getChannelCode()).booleanValue()) {
            pushContent = this.yaoPinBaoUtil.dealMessage(apisBusiRequestRegist, mqBody, businessType);
            if (ObjectUtil.isEmpty((Object)pushContent)) {
                pushContent = this.huiZeUtil.dealMessage(apisBusiRequestRegist, mqBody, businessType);
            }
            if (ObjectUtil.isEmpty((Object)pushContent)) {
                log.warn("\u6ca1\u6709\u9002\u5408\u5904\u7406\u7684\u63a8\u9001\u6570\u636e\uff0c\u672c\u6b21\u4e0d\u63a8\u9001\u3002\u3002\u3002\u3002");
                return;
            }
            log.warn("\u5904\u7406\u4e4b\u540e\u63a8\u9001\u62a5\u6587\u4e3a\uff0c{}", (Object)pushContent);
        } else {
            if ("05".equals(mqBody.getCaseStatus()) || "08".equals(mqBody.getCaseStatus()) || "10".equals(mqBody.getCaseStatus())) {
                com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.RequestHeadDTO requestHeadDTO = com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.RequestHeadDTO.initRequestHead();
                requestHeadDTO.setUser(ObjectUtil.isNotEmpty((Object)apisBusiRequestRegist.getUserCode()) ? apisBusiRequestRegist.getUserCode() : (ObjectUtil.isEmpty((Object)channelConfig) ? "" : channelConfig.getUserCode()));
                ClaimNoticeFileServiceRequest claimNoticeFileServiceRequest = ClaimNoticeFileServiceRequest.builder().head(requestHeadDTO).body(ClaimNoticeFileServiceRequestDTO.builder().claimNo(mqBody.getClaimNo()).policyNo(mqBody.getPolicyNo()).build()).build();
                try {
                    StanderResponse standerResponse = this.claimNoticeFileHandler.claimNoticeQuery(StanderRequest.builder().claimNoticeFileServiceRequest(claimNoticeFileServiceRequest).build());
                    if (ObjectUtil.isNotEmpty((Object)standerResponse) && ObjectUtil.isNotEmpty((Object)standerResponse.getClaimNoticeFileServiceResponse()) && ObjectUtil.isNotEmpty((Object)standerResponse.getClaimNoticeFileServiceResponse().getBody()) && ObjectUtil.isNotEmpty((Object)standerResponse.getClaimNoticeFileServiceResponse().getBody().getDocumentList())) {
                        mqBody.setNoticeUrl(((ClaimNoticeFileInfoDTO)standerResponse.getClaimNoticeFileServiceResponse().getBody().getDocumentList().get(0)).getDocumentUrl());
                    }
                }
                catch (Exception e) {
                    log.error("\u83b7\u53d6\u7406\u8d54\u901a\u77e5\u4e66\u51fa\u9519\uff1a", (Throwable)e);
                }
            }
            mqBody.setCaseStatus(this.getCaseStatus(apisBusiRequestRegist));
            if (this.isJdazGateway(apisBusiRequestRegist)) {
                GatewayData gatewayData = GatewayData.builder().paramType(Arrays.asList("com.jd.insurance.dto.report.al.ClaimCaseStatusDto")).param(Arrays.asList(JSONObject.parseObject((String)JSON.toJSONString((Object)mqBody)))).build();
                pushContent = this.jdazGatewayUtil.getGateWayContent(JSON.toJSONString((Object)gatewayData), "com.jdaz.fuwujia.guzhu.claim.status");
            }
            if (ObjectUtil.isEmpty((Object)pushContent)) {
                pushContent = JSON.toJSONString((Object)mqBody);
            }
        }
        ApisBusiTaskLog apisBusiTaskLog = new ApisBusiTaskLog();
        apisBusiTaskLog.setPushStep(Integer.valueOf(0));
        apisBusiTaskLog.setPushStatus("0");
        apisBusiTaskLog.setBusinessKey(mqBody.getRegistNo());
        apisBusiTaskLog.setPushType(this.getPushUrl(apisBusiRequestRegist));
        apisBusiTaskLog.setPushContent(pushContent);
        apisBusiTaskLog.setRelatedId(apisMsgMqlogs.getId());
        if (ObjectUtil.isNotEmpty((Object)channelConfig) && ObjectUtil.isNotEmpty((Object)channelConfig.getConfigValue())) {
            apisBusiTaskLog.setPushTargetUrl(channelConfig.getConfigValue());
            apisBusiTaskLog.setCreator(channelConfig.getUserCode());
        }
        this.apisBusiTaskLogService.save((Object)apisBusiTaskLog);
        if (pushResultType == ClaimBusinessConstants.CLAIM_STATUS_PUSH_TOTAL_TYPE_1) {
            this.commonPushUtil.asyncNoticeAgent(apisBusiTaskLog, ClaimCommonsExecutorResponse.class);
        } else if (pushResultType == ClaimBusinessConstants.CLAIM_STATUS_PUSH_TOTAL_TYPE_2) {
            this.commonPushUtil.asyncNoticeComment(apisBusiTaskLog);
        } else if (this.huiZeUtil.isHuiZeCase(apisBusiRequestRegist.getChannelCode())) {
            this.huiZeUtil.notify(apisBusiTaskLog);
        }
    }

    private int getPushResultType(ApisBusiRequestRegist apisBusiRequestRegist) {
        if ("17".equals(apisBusiRequestRegist.getChannelType())) {
            return ClaimBusinessConstants.CLAIM_STATUS_PUSH_TOTAL_TYPE_1;
        }
        if (this.yaoPinBaoUtil.isYaoPinBaoCase(apisBusiRequestRegist.getChannelCode())) {
            return ClaimBusinessConstants.CLAIM_STATUS_PUSH_TOTAL_TYPE_2;
        }
        if (this.huiZeUtil.isHuiZeCase(apisBusiRequestRegist.getChannelCode())) {
            return ClaimBusinessConstants.CLAIM_STATUS_PUSH_TOTAL_TYPE_3;
        }
        return ClaimBusinessConstants.CLAIM_STATUS_PUSH_TOTAL_TYPE_1;
    }

    private boolean isJdazGateway(ApisBusiRequestRegist apisBusiRequestRegist) {
        return "17".equals(apisBusiRequestRegist.getChannelType());
    }

    private String getPushUrl(ApisBusiRequestRegist apisBusiRequestRegist) {
        if (this.yaoPinBaoUtil.isYaoPinBaoCase(apisBusiRequestRegist.getChannelCode())) {
            return ApisAutoTaskConstantsEnum.CLAIM_CASE_STATUS_NOTIFY_YI_YAO_BAO.getValue();
        }
        if (this.huiZeUtil.isHuiZeCase(apisBusiRequestRegist.getChannelCode())) {
            return ApisAutoTaskConstantsEnum.CLAIM_CASE_STATUS_NOTIFY_HUI_ZE.getValue();
        }
        return (String)BusinessConstants.CLAIM_CASE_STATUS_MQ.TYPE_TO_URL.get(apisBusiRequestRegist.getChannelType());
    }

    private String getCaseStatus(ApisBusiRequestRegist apisBusiRequestRegist) throws ApisBusinessException {
        StanderResponse response = this.getClaimDetail(apisBusiRequestRegist);
        log.warn("\u67e5\u8be2\u6848\u4ef6\u72b6\u6001\u54cd\u5e94\u62a5\u6587\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)response));
        return response.getClaimDetailResponse().getBody().getStatus();
    }

    public StanderResponse getClaimDetail(ApisBusiRequestRegist apisBusiRequestRegist) throws ApisBusinessException {
        PolicyDTO policyDTO = this.getPolicyDetailByPoicyNo(apisBusiRequestRegist.getPolicyNo());
        Boolean flag = this.isCommercialInsurance(policyDTO);
        String insuredName = flag != false ? ((InsuredDTO)policyDTO.getInsuredList().get(0)).getInsuredName() : ((InsuredIdvDTO)((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getInsuredIdvList().get(0)).getInsuredName();
        String insuredId = flag != false ? ((InsuredDTO)policyDTO.getInsuredList().get(0)).getIdentifyNumber() : ((InsuredIdvDTO)((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getInsuredIdvList().get(0)).getIdentifyNumber();
        StanderRequest request = StanderRequest.builder().header(StanderHeader.builder().businessKey("caseDetail").build()).claimDetailServiceRequest(ClaimDetailServiceRequest.builder().body(ClaimQueryInfo.builder().claimNo(apisBusiRequestRegist.getClaimNo()).registNo(apisBusiRequestRegist.getRegistNo()).insuredName(insuredName).identifyNumber(insuredId).build()).head(RequestHeadDTO.builder().build()).build()).build();
        StanderResponse response = this.claimDetailHandler.execute(request);
        response = this.claimDetailHandler.beforeReturn(request, response);
        return response;
    }

    private Boolean isCommercialInsurance(PolicyDTO policyDTO) {
        Boolean flag = true;
        try {
            if (ObjectUtil.isNotEmpty((Object)((ItemMainDTO)policyDTO.getCoverage().getItemList().get(0)).getInsuredIdvList())) {
                flag = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flag;
    }

    public PolicyDTO getPolicyDetailByPoicyNo(String policyNo) throws ApisBusinessException {
        String userCode = "JME_USER";
        StanderRequest request = StanderRequest.builder().header(StanderHeader.builder().userCode(userCode).build()).build();
        PolicyDetailRequestDTO policyDetailRequestDTO = PolicyDetailRequestDTO.builder().policyNo(policyNo).businessNature2("all").operateCode(userCode).isStatusQueryFlag("N").build();
        PolicyDetailServiceRequest policyDetailServiceRequest = PolicyDetailServiceRequest.builder().requestHead(com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO.initRequestHead()).requestBody(policyDetailRequestDTO).build();
        request.setPolicyDetailServiceRequest(policyDetailServiceRequest);
        log.warn("\u4fdd\u5355\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString((Object)policyDetailServiceRequest));
        WebResponse webResponse = (WebResponse)this.restTemplate.postForObject(this.policyDetailAddress, (Object)request, WebResponse.class, new Object[0]);
        String resStr = null;
        if (null != webResponse) {
            resStr = JSON.toJSONString((Object)webResponse);
        }
        log.warn("\u4fdd\u5355\u8be6\u60c5\u67e5\u8be2\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)resStr);
        if (ObjectUtil.isEmpty((Object)webResponse) || ObjectUtil.isEmpty((Object)webResponse.getResult())) {
            throw new ApisBusinessException(ErrorCode.POLICY_DETAIL_FAIL.getMessage(), ErrorCode.POLICY_DETAIL_FAIL.getCode());
        }
        if (webResponse.getSuccess().booleanValue()) {
            StanderResponse standerResponse = (StanderResponse)JSON.parseObject((String)JSON.toJSONString((Object)webResponse.getResult()), StanderResponse.class);
            PolicyDetailResponse policyDetailResponse = standerResponse.getPolicyDetailResponse();
            if (ObjectUtil.isEmpty((Object)policyDetailResponse) || ObjectUtil.isEmpty((Object)policyDetailResponse.getResponseHead()) || ObjectUtil.isEmpty((Object)policyDetailResponse.getResponseBody())) {
                throw new ApisBusinessException(ErrorCode.POLICY_DETAIL_FAIL.getMessage(), ErrorCode.POLICY_DETAIL_FAIL.getCode());
            }
            if (1 != policyDetailResponse.getResponseHead().getStatus() || ObjectUtil.isEmpty((Object)policyDetailResponse.getResponseBody().getPolicy())) {
                String appCode = policyDetailResponse.getResponseHead().getAppCode();
                String appMessage = policyDetailResponse.getResponseHead().getAppMessage();
                log.error("\u83b7\u53d6\u4fdd\u5355\u8be6\u60c5\u63a5\u53e3\u5931\u8d25\uff1a" + appMessage + ",\u9519\u8bef\u4ee3\u7801\uff1a" + appCode);
                throw new ApisBusinessException(appMessage, appCode);
            }
            return policyDetailResponse.getResponseBody().getPolicy();
        }
        throw new ApisBusinessException(webResponse.getMessage(), webResponse.getCode());
    }

    public Boolean isPushCase(ApisBusiRequestRegist apisBusiRequestRegist, String businessType) {
        if ("17".equals(apisBusiRequestRegist.getChannelType())) {
            return true;
        }
        if (this.yaoPinBaoUtil.isYaoPinBaoPush(businessType, apisBusiRequestRegist.getChannelCode())) {
            return true;
        }
        if (this.huiZeUtil.isHuiZePush(businessType, apisBusiRequestRegist.getChannelCode())) {
            return true;
        }
        return false;
    }

    public Boolean isCustomization(String channelType, String channelCode) {
        if (this.yaoPinBaoUtil.isYaoPinBaoCase(channelCode)) {
            return true;
        }
        if (this.huiZeUtil.isHuiZeCase(channelCode)) {
            return true;
        }
        return false;
    }
}

