/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.jms;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.jms.ClaimCaseStatusReceiveListener;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.HuiZeUtil;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.claimCaseStatus.ClaimCaseStatusRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.claimDocCollectInfo.ClaimDocCollectInfoServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.claimDocCollectInfo.ClaimDocInforRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiRequestRegist;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiRequestRegistService;
import com.jdaz.sinosoftgz.apis.commons.model.msg.entity.ApisMsgMqlogs;
import com.jdaz.sinosoftgz.apis.commons.service.msg.service.ApisMsgMqlogsService;
import java.time.LocalDateTime;
import java.util.Date;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
@RocketMQMessageListener(topic="allclaimTopic", selectorExpression="docCollectInfoTags", consumerGroup="apis-docInfo-Group")
public class ClaimDocInfoReceiveListener
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(ClaimDocInfoReceiveListener.class);
    @Autowired
    ApisMsgMqlogsService apisMsgMqlogsService;
    @Autowired
    ApisBusiRequestRegistService apisBusiRequestRegistService;
    @Autowired
    ClaimCaseStatusReceiveListener claimCaseStatusReceiveListener;
    @Autowired
    HuiZeUtil huiZeUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(String message) {
        log.warn("received allclaimTopic:claimDocCollectInfoTags message: {}", (Object)message);
        DateTime currentDate = DateUtil.date();
        try {
            Thread.sleep(5000L);
            log.warn("\u63a5\u6536MQ\u6d88\u606f\u5ef6\u65f65\u79d2\u518d\u5904\u7406.");
        }
        catch (Exception e) {
            log.error("\u5ef6\u65f6\u51fa\u9519\uff1a", (Throwable)e);
        }
        String flag = "0";
        ApisMsgMqlogs apisMsgMqlogs = new ApisMsgMqlogs();
        try {
            ClaimDocCollectInfoServiceRequest mqAll = (ClaimDocCollectInfoServiceRequest)JSON.parseObject((String)message, ClaimDocCollectInfoServiceRequest.class);
            ClaimDocInforRequestDTO mqBody = mqAll.getBody();
            Assert.notNull((Object)mqBody.getRegistNo(), (String)"\u9519\u8bef\u6570\u636e\uff0c\u62a5\u6848\u53f7\u4e3a\u7a7a\uff01");
            ApisBusiRequestRegist apisBusiRequestRegist = this.apisBusiRequestRegistService.getByRegistNo(mqBody.getRegistNo());
            if (ObjectUtil.isEmpty((Object)apisBusiRequestRegist) || ObjectUtil.isEmpty((Object)apisBusiRequestRegist.getRegistNo())) {
                log.warn("\u6570\u636e\u6709\u8bef\uff0c\u6848\u4ef6\u4e0d\u5b58\u5728\uff0c\u62a5\u6848\u53f7\uff1a{}", (Object)mqBody.getRegistNo());
                return;
            }
            apisMsgMqlogs.setCreateTime((Date)currentDate);
            apisMsgMqlogs.setMessage(message);
            apisMsgMqlogs.setTopic("allclaimTopic:docCollectInfoTags");
            apisMsgMqlogs.setConsumerGroup("apis-docInfo-Group");
            apisMsgMqlogs.setErrorFlag(flag);
            this.apisMsgMqlogsService.save((Object)apisMsgMqlogs);
            if ("3".equals(mqBody.getStatus()) || "1".equals(mqBody.getStatus())) {
                this.claimCaseStatusReceiveListener.pushCaseStatus(apisBusiRequestRegist, this.getCaseStatusNotifyObject(mqBody, apisBusiRequestRegist), apisMsgMqlogs, "1");
            }
        }
        catch (Exception e) {
            flag = "1";
            log.error("ClaimDocInfoReceiveListener \u5f02\u5e38: ", (Throwable)e);
        }
        finally {
            if (ObjectUtil.isNotEmpty((Object)apisMsgMqlogs.getId())) {
                apisMsgMqlogs.setErrorFlag(flag);
                apisMsgMqlogs.setReleaseTime(LocalDateTime.now());
                this.apisMsgMqlogsService.updateById((Object)apisMsgMqlogs);
            }
        }
    }

    private ClaimCaseStatusRequestDTO getCaseStatusNotifyObject(ClaimDocInforRequestDTO mqBody, ApisBusiRequestRegist apisBusiRequestRegist) {
        if (this.huiZeUtil.isHuiZeCase(apisBusiRequestRegist.getChannelCode())) {
            return ClaimCaseStatusRequestDTO.builder().registNo(mqBody.getRegistNo()).policyNo(apisBusiRequestRegist.getPolicyNo()).caseStatus(mqBody.getSource() + mqBody.getStatus()).collectInfoList(mqBody.getCollectInfoList()).build();
        }
        return ClaimCaseStatusRequestDTO.builder().registNo(mqBody.getRegistNo()).policyNo(apisBusiRequestRegist.getPolicyNo()).reportTime(apisBusiRequestRegist.getCreateTime()).caseStatus(mqBody.getStatus()).build();
    }
}

