/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.jms;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.jms.ClaimCaseStatusReceiveListener;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.HuiZeUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.claimCaseStatus.ClaimCaseStatusRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.claimPayeeInfo.ClaimPayeeInfoRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.claimPayeeInfo.ClaimPayeeInfoServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryDetail.response.CompensateInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.request.PayeeInfo;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiRequestRegist;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiRequestRegistService;
import com.jdaz.sinosoftgz.apis.commons.model.msg.entity.ApisMsgMqlogs;
import com.jdaz.sinosoftgz.apis.commons.service.msg.service.ApisMsgMqlogsService;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
@RocketMQMessageListener(topic="allclaimTopic", selectorExpression="payeeInfoTags", consumerGroup="apis-payeeInfoTags-Group")
public class ClaimPayeeInfoReceiveListener
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(ClaimPayeeInfoReceiveListener.class);
    @Autowired
    ApisMsgMqlogsService apisMsgMqlogsService;
    @Autowired
    ApisBusiRequestRegistService apisBusiRequestRegistService;
    @Autowired
    ClaimCaseStatusReceiveListener claimCaseStatusReceiveListener;
    @Autowired
    HuiZeUtil huiZeUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(String message) {
        log.warn("received allclaimTopic:payeeInfoTags message: {}", (Object)message);
        DateTime currentDate = DateUtil.date();
        try {
            Thread.sleep(5000L);
            log.warn("\u63a5\u6536MQ\u6d88\u606f\u5ef6\u65f65\u79d2\u518d\u5904\u7406.");
        }
        catch (Exception e) {
            log.error("\u5ef6\u65f6\u51fa\u9519\uff1a", (Throwable)e);
        }
        String flag = "0";
        ApisMsgMqlogs apisMsgMqlogs = new ApisMsgMqlogs();
        try {
            ClaimPayeeInfoServiceRequest mqAll = (ClaimPayeeInfoServiceRequest)JSON.parseObject((String)message, ClaimPayeeInfoServiceRequest.class);
            ClaimPayeeInfoRequestDTO mqBody = mqAll.getBody();
            Assert.notNull((Object)mqBody.getRegistNo(), (String)"\u9519\u8bef\u6570\u636e\uff0c\u62a5\u6848\u53f7\u4e3a\u7a7a\uff01");
            ApisBusiRequestRegist apisBusiRequestRegist = this.apisBusiRequestRegistService.getByRegistNo(mqBody.getRegistNo());
            if (ObjectUtil.isEmpty((Object)apisBusiRequestRegist) || ObjectUtil.isEmpty((Object)apisBusiRequestRegist.getRegistNo())) {
                log.warn("\u6570\u636e\u6709\u8bef\uff0c\u6848\u4ef6\u4e0d\u5b58\u5728\uff0c\u62a5\u6848\u53f7\uff1a{}", (Object)mqBody.getRegistNo());
                return;
            }
            apisMsgMqlogs.setCreateTime((Date)currentDate);
            apisMsgMqlogs.setMessage(message);
            apisMsgMqlogs.setTopic("allclaimTopic:payeeInfoTags");
            apisMsgMqlogs.setConsumerGroup("apis-payeeInfo-Group");
            apisMsgMqlogs.setErrorFlag(flag);
            this.apisMsgMqlogsService.save((Object)apisMsgMqlogs);
            if (ObjectUtil.isNotEmpty((Object)mqBody.getPayeeInfoList()) && "1".equals(mqBody.getCompensateType())) {
                PayeeInfo payeeInfo = (PayeeInfo)mqBody.getPayeeInfoList().get(0);
                BigDecimal sumPay = new BigDecimal(0);
                for (PayeeInfo dto : mqBody.getPayeeInfoList()) {
                    sumPay = sumPay.add(dto.getSumRealPay());
                }
                payeeInfo.setSumRealPay(sumPay);
                this.claimCaseStatusReceiveListener.pushCaseStatus(apisBusiRequestRegist, this.getCaseStatusNotifyObject(mqBody, apisBusiRequestRegist, payeeInfo), apisMsgMqlogs, "2");
            }
        }
        catch (Exception e) {
            flag = "1";
            log.error("ClaimDocInfoReceiveListener \u5f02\u5e38: ", (Throwable)e);
        }
        finally {
            if (ObjectUtil.isNotEmpty((Object)apisMsgMqlogs.getId())) {
                apisMsgMqlogs.setErrorFlag(flag);
                apisMsgMqlogs.setReleaseTime(LocalDateTime.now());
                this.apisMsgMqlogsService.updateById((Object)apisMsgMqlogs);
            }
        }
    }

    private ClaimCaseStatusRequestDTO getCaseStatusNotifyObject(ClaimPayeeInfoRequestDTO mqBody, ApisBusiRequestRegist apisBusiRequestRegist, PayeeInfo payeeInfo) throws ApisBusinessException {
        if (this.huiZeUtil.isHuiZeCase(apisBusiRequestRegist.getChannelCode())) {
            StanderResponse response = this.claimCaseStatusReceiveListener.getClaimDetail(apisBusiRequestRegist);
            log.warn("\u4fdd\u5355\u8be6\u60c5\u67e5\u8be2\u7406\u7b97\u4fe1\u606f\u4e3a {}", (Object)response.getClaimDetailResponse().getBody().getCompensateInfo());
            return ClaimCaseStatusRequestDTO.builder().registNo(mqBody.getRegistNo()).policyNo(apisBusiRequestRegist.getPolicyNo()).caseStatus("5").payStatus(payeeInfo.getPayStatus()).sumRealPay(payeeInfo.getSumRealPay()).icText(((CompensateInfo)response.getClaimDetailResponse().getBody().getCompensateInfo().get(0)).getLcText()).build();
        }
        return ClaimCaseStatusRequestDTO.builder().registNo(mqBody.getRegistNo()).policyNo(apisBusiRequestRegist.getPolicyNo()).reportTime(apisBusiRequestRegist.getCreateTime()).caseStatus(payeeInfo.getPayStatus()).payeeName(payeeInfo.getPayeeName()).accountNo(payeeInfo.getAccountNo()).sumRealPay(payeeInfo.getSumRealPay()).endCaseAmount(payeeInfo.getSumRealPay()).build();
    }
}

