/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.jms;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.CommonPushUtil;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.HuiZeUtil;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.SDClaimInfoNotifyUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.constants.ClaimBusinessConstants;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.claimRegistInfo.ClaimRegistInfoRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.claimRegistInfo.ClaimRegistInfoServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.pushAgent.ClaimCommonsExecutorResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiRequestRegist;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiRequestRegistService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.msg.entity.ApisMsgMqlogs;
import com.jdaz.sinosoftgz.apis.commons.service.msg.service.ApisMsgMqlogsService;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import java.time.LocalDateTime;
import java.util.Date;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
@RocketMQMessageListener(topic="allclaimTopic", selectorExpression="registInfoTags", consumerGroup="apis-ClaimRegistInfo-Group")
public class ClaimRegistInfoReceiveListener
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(ClaimRegistInfoReceiveListener.class);
    @Autowired
    ApisMsgMqlogsService apisMsgMqlogsService;
    @Autowired
    ApisBusiRequestRegistService apisBusiRequestRegistService;
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    SDClaimInfoNotifyUtil sdClaimInfoNotifyUtil;
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    HuiZeUtil huiZeUtil;
    @Autowired
    private CommonPushUtil commonPushUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(String message) {
        log.warn("\u6807\u51c6\u7406\u8d54\u62a5\u6848\u63a5\u6536\u3002received allclaimTopic:registInfoTags message: {}", (Object)message);
        Long startTimeStamp = System.currentTimeMillis();
        try {
            Thread.sleep(5000L);
            log.warn("\u63a5\u6536MQ\u6d88\u606f\u5ef6\u65f65\u79d2\u518d\u5904\u7406.");
        }
        catch (Exception e) {
            log.error("\u5ef6\u65f6\u51fa\u9519\uff1a", (Throwable)e);
        }
        DateTime currentDate = DateUtil.date();
        String flag = "0";
        ApisMsgMqlogs apisMsgMqlogs = new ApisMsgMqlogs();
        try {
            ClaimRegistInfoServiceRequest mqAll = (ClaimRegistInfoServiceRequest)JSON.parseObject((String)message, ClaimRegistInfoServiceRequest.class);
            ClaimRegistInfoRequestDTO mqBody = mqAll.getBody();
            while (ObjectUtil.isNotEmpty((Object)this.redisTemplate.opsForValue().get((Object)(mqBody.getPolicyNo() + mqBody.getIdentifyNo() + mqBody.getDamageTime().getTime() + mqBody.getDamageResult())))) {
                try {
                    Thread.sleep(500L);
                    log.warn("\u62a5\u6848\u63a5\u53e3\u672a\u54cd\u5e94\u5b8c\u6bd5\uff0c\u63a5\u6536MQ\u6d88\u606f\u5ef6\u65f60.5\u79d2\u518d\u5904\u7406\uff0c\u6700\u591a\u5ef6\u65f630\u79d2.");
                    if (System.currentTimeMillis() - startTimeStamp < 30000L) continue;
                    break;
                }
                catch (Exception e) {
                    log.error("\u5ef6\u65f6\u51fa\u9519\uff1a", (Throwable)e);
                }
            }
            Assert.notNull((Object)mqBody.getRegistNo(), (String)"\u9519\u8bef\u6570\u636e\uff0c\u62a5\u6848\u53f7\u4e3a\u7a7a\uff01");
            ApisBusiRequestRegist apisBusiRequestRegist = this.apisBusiRequestRegistService.getByRegistNo(mqBody.getRegistNo());
            if (ObjectUtil.isNotEmpty((Object)apisBusiRequestRegist) && ObjectUtil.isNotEmpty((Object)apisBusiRequestRegist.getRegistNo())) {
                log.warn("\u7406\u8d54\u63a8\u9001\u91cd\u590d\u7684\u7406\u8d54\u62a5\u6848\u6570\u636e\uff0c\u62a5\u6848\u53f7\uff1a{}", (Object)mqBody.getRegistNo());
                return;
            }
            apisMsgMqlogs.setCreateTime((Date)currentDate);
            apisMsgMqlogs.setMessage(message);
            apisMsgMqlogs.setTopic("allclaimTopic:registInfoTags");
            apisMsgMqlogs.setConsumerGroup("apis-ClaimRegistInfo-Group");
            apisMsgMqlogs.setErrorFlag(flag);
            apisBusiRequestRegist = new ApisBusiRequestRegist();
            apisBusiRequestRegist.setPolicyNo(mqBody.getPolicyNo());
            apisBusiRequestRegist.setChannelType(mqBody.getReportType());
            apisBusiRequestRegist.setDamageResult(mqBody.getDamageResult());
            apisBusiRequestRegist.setCurrency(mqBody.getCurrency());
            apisBusiRequestRegist.setRegistNo(mqBody.getRegistNo());
            apisBusiRequestRegist.setChannelCode(mqBody.getReportChannel());
            apisBusiRequestRegist.setDamageTime(mqBody.getDamageTime());
            if (!this.isPushCase(apisBusiRequestRegist, mqBody.getPolicyNo())) {
                log.warn("\u6807\u51c6\u7406\u8d54\u62a5\u6848\u63a5\u53e3\uff0c\u975e\u63a8\u9001\u6848\u4ef6\uff0c\u62a5\u6848\u53f7\u4e3a:{}", (Object)mqBody.getRegistNo());
                return;
            }
            this.apisMsgMqlogsService.save((Object)apisMsgMqlogs);
            try {
                this.apisBusiRequestRegistService.addRequestRegistNo(apisBusiRequestRegist);
            }
            catch (Exception e) {
                log.error("\u4fdd\u5b58\u62a5\u6848\u6570\u636e\u51fa\u9519\uff0c\u62a5\u6848\u53f7\uff1a{}", (Object)mqBody.getRegistNo(), (Object)e);
                if (ObjectUtil.isNotEmpty((Object)apisMsgMqlogs.getId())) {
                    apisMsgMqlogs.setErrorFlag(flag);
                    apisMsgMqlogs.setReleaseTime(LocalDateTime.now());
                    this.apisMsgMqlogsService.updateById((Object)apisMsgMqlogs);
                }
                return;
            }
            this.pushRegist(apisBusiRequestRegist, mqBody, apisMsgMqlogs);
        }
        catch (Exception e) {
            flag = "1";
            log.error("ClaimRegistInfoReceiveListener \u5f02\u5e38: ", (Throwable)e);
        }
        finally {
            if (ObjectUtil.isNotEmpty((Object)apisMsgMqlogs.getId())) {
                apisMsgMqlogs.setErrorFlag(flag);
                apisMsgMqlogs.setReleaseTime(LocalDateTime.now());
                this.apisMsgMqlogsService.updateById((Object)apisMsgMqlogs);
            }
        }
    }

    public void pushRegist(ApisBusiRequestRegist apisBusiRequestRegist, ClaimRegistInfoRequestDTO mqBody, ApisMsgMqlogs apisMsgMqlogs) throws ApisBusinessException {
        ApisChannelConfigs channelConfig = new ApisChannelConfigs();
        channelConfig.setConfigCode(this.getPushUrl(apisBusiRequestRegist) + "Url");
        channelConfig = this.apisChannelConfigsService.getChannelConfig(channelConfig);
        String pushContent = null;
        int pushResultType = this.getPushResultType(apisBusiRequestRegist);
        if (this.isCustomization(apisBusiRequestRegist.getChannelType(), apisBusiRequestRegist.getChannelCode()).booleanValue()) {
            pushContent = this.huiZeUtil.dealRegistPushMessage(apisBusiRequestRegist, mqBody);
            if (ObjectUtil.isEmpty((Object)pushContent)) {
                log.warn("\u6ca1\u6709\u9002\u5408\u5904\u7406\u7684\u63a8\u9001\u6570\u636e\uff0c\u672c\u6b21\u4e0d\u63a8\u9001\u3002\u3002\u3002\u3002");
                return;
            }
            log.warn("\u5904\u7406\u4e4b\u540e\u63a8\u9001\u62a5\u6587\u4e3a\uff0c{}", (Object)pushContent);
        } else {
            pushContent = JSON.toJSONString((Object)mqBody);
        }
        ApisBusiTaskLog apisBusiTaskLog = new ApisBusiTaskLog();
        apisBusiTaskLog.setPushStep(Integer.valueOf(0));
        apisBusiTaskLog.setPushStatus("0");
        apisBusiTaskLog.setBusinessKey(mqBody.getRegistNo());
        apisBusiTaskLog.setPushType(this.getPushUrl(apisBusiRequestRegist));
        apisBusiTaskLog.setPushContent(pushContent);
        apisBusiTaskLog.setRelatedId(apisMsgMqlogs.getId());
        if (ObjectUtil.isNotEmpty((Object)channelConfig) && ObjectUtil.isNotEmpty((Object)channelConfig.getConfigValue())) {
            apisBusiTaskLog.setPushTargetUrl(channelConfig.getConfigValue());
            apisBusiTaskLog.setCreator(channelConfig.getUserCode());
        }
        this.apisBusiTaskLogService.save((Object)apisBusiTaskLog);
        if (pushResultType == ClaimBusinessConstants.CLAIM_STATUS_PUSH_TOTAL_TYPE_1) {
            this.commonPushUtil.asyncNoticeAgent(apisBusiTaskLog, ClaimCommonsExecutorResponse.class);
        } else if (pushResultType == ClaimBusinessConstants.CLAIM_STATUS_PUSH_TOTAL_TYPE_2) {
            this.commonPushUtil.asyncNoticeComment(apisBusiTaskLog);
        } else if (this.huiZeUtil.isHuiZeCase(apisBusiRequestRegist.getChannelCode())) {
            this.huiZeUtil.notify(apisBusiTaskLog);
        }
    }

    private int getPushResultType(ApisBusiRequestRegist apisBusiRequestRegist) {
        if (this.huiZeUtil.isHuiZeCase(apisBusiRequestRegist.getChannelCode())) {
            return ClaimBusinessConstants.CLAIM_STATUS_PUSH_TOTAL_TYPE_3;
        }
        return ClaimBusinessConstants.CLAIM_STATUS_PUSH_TOTAL_TYPE_1;
    }

    public Boolean isCustomization(String channelType, String channelCode) {
        if (this.huiZeUtil.isHuiZeCase(channelCode)) {
            return true;
        }
        return false;
    }

    private String getPushUrl(ApisBusiRequestRegist apisBusiRequestRegist) {
        if (this.huiZeUtil.isHuiZeCase(apisBusiRequestRegist.getChannelCode())) {
            return ApisAutoTaskConstantsEnum.CLAIM_CASE_INFO_NOTIFY_HUI_ZE.getValue();
        }
        return null;
    }

    public boolean isPushCase(ApisBusiRequestRegist apisBusiRequestRegist, String policyNo) {
        if (ObjectUtils.isEmpty((Object)apisBusiRequestRegist.getChannelCode())) {
            ApisBusiChannelOrder order = this.apisBusiChannelOrderService.findOneByPolicyNo(policyNo);
            if (ObjectUtils.isEmpty((Object)order)) {
                log.warn("\u62a5\u6848\u63a8\u9001\uff0c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u4fdd\u5355\u8bb0\u5f55\uff0c\u4fdd\u5355\u53f7\u4e3a\uff1a{}", (Object)policyNo);
                return false;
            }
            apisBusiRequestRegist.setChannelCode(order.getChannelCode());
        }
        return this.huiZeUtil.isHuiZeCase(apisBusiRequestRegist.getChannelCode());
    }
}

