/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.jms.shuidi;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.SDClaimInfoNotifyUtil;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.request.SDClaimSurveyInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.request.SDClaimSurveyInfoNotifyRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.request.SDClaimSurveyInfoNotifyRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.request.SDClaimSurveyInfoServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.request.SDClaimSurveyInfoServiceRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiRequestRegist;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiRequestRegistService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.msg.entity.ApisMsgMqlogs;
import com.jdaz.sinosoftgz.apis.commons.service.msg.service.ApisMsgMqlogsService;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import java.time.LocalDateTime;
import java.util.Date;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@RocketMQMessageListener(topic="allclaimTopic", selectorExpression="surveyInfoTags", consumerGroup="consumeSDClaimSurveyGroup")
public class SDClaimSurveyReceiveListener
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(SDClaimSurveyReceiveListener.class);
    @Autowired
    ApisMsgMqlogsService apisMsgMqlogsService;
    @Autowired
    ApisBusiRequestRegistService apisBusiRequestRegistService;
    @Autowired
    SDClaimInfoNotifyUtil sdClaimInfoNotifyUtil;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(String message) {
        log.warn("received allclaimTopic:surveyInfoTags message: {}", (Object)message);
        String flag = "0";
        ApisMsgMqlogs apisMsgMqlogs = new ApisMsgMqlogs();
        try {
            SDClaimSurveyInfoServiceRequest request = (SDClaimSurveyInfoServiceRequest)JSON.parseObject((String)message, SDClaimSurveyInfoServiceRequest.class);
            SDClaimSurveyInfoServiceRequestDTO mqBody = request.getBody();
            apisMsgMqlogs = new ApisMsgMqlogs();
            apisMsgMqlogs.setCreateTime((Date)DateUtil.date());
            apisMsgMqlogs.setMessage(message);
            apisMsgMqlogs.setTopic("allclaimTopic");
            apisMsgMqlogs.setConsumerGroup("consumeSDClaimSurveyGroup");
            apisMsgMqlogs.setErrorFlag(flag);
            this.apisMsgMqlogsService.save((Object)apisMsgMqlogs);
            if (ObjectUtil.isEmpty((Object)mqBody.getSurveyInfoList())) {
                throw new Exception("\u9519\u8bef\u6570\u636e\uff0c\u8c03\u67e5\u4fe1\u606f\u5217\u8868\u4e3a\u7a7a\uff01");
            }
            ApisBusiRequestRegist apisBusiRequestRegist = this.apisBusiRequestRegistService.getByRegistNo(mqBody.getRegistNo());
            if (ObjectUtil.isEmpty((Object)apisBusiRequestRegist) || ObjectUtil.isEmpty((Object)apisBusiRequestRegist.getRegistNo())) {
                log.warn("\u6570\u636e\u6709\u8bef\uff0c\u6848\u4ef6\u4e0d\u5b58\u5728\uff0c\u62a5\u6848\u53f7\uff1a{}", (Object)mqBody.getRegistNo());
                flag = "1";
                return;
            }
            if (!this.sdClaimInfoNotifyUtil.isShuiDiCase(apisBusiRequestRegist).booleanValue()) {
                flag = "1";
                return;
            }
            int i = 0;
            boolean isMany = mqBody.getSurveyInfoList().size() > 1;
            for (SDClaimSurveyInfoDTO sdClaimSurveyInfoDTO : mqBody.getSurveyInfoList()) {
                if (!"1".equals(sdClaimSurveyInfoDTO.getTaskStatus())) continue;
                String inspectStage = "3";
                if (null != sdClaimSurveyInfoDTO.getTaskStatus() && !"1".equals(sdClaimSurveyInfoDTO.getTaskStatus())) {
                    inspectStage = sdClaimSurveyInfoDTO.getTaskStatus();
                }
                SDClaimSurveyInfoNotifyRequestDTO bizContent = SDClaimSurveyInfoNotifyRequestDTO.builder().claimNo(mqBody.getRegistNo()).policyNo(apisBusiRequestRegist.getPolicyNo()).inspectConclusion("4").inspectStage(inspectStage).inspectResultAuditOpinion(sdClaimSurveyInfoDTO.getSurveyConclution()).inspectHandleTime(sdClaimSurveyInfoDTO.getSurveyEndDate()).inspectUniqueId(apisBusiRequestRegist.getInspectUniqueId()).build();
                SDClaimSurveyInfoNotifyRequest sdClaimSurveyInfoNotifyRequest = SDClaimSurveyInfoNotifyRequest.builder().uuid(UUID.fastUUID().toString()).timestamp(Long.valueOf(DateUtil.current())).bizContent(bizContent).build();
                ApisBusiTaskLog apisBusiTaskLog = new ApisBusiTaskLog();
                apisBusiTaskLog.setPushStep(Integer.valueOf(0));
                apisBusiTaskLog.setPushStatus("0");
                String businessKey = mqBody.getRegistNo();
                if (isMany) {
                    businessKey = businessKey + "-" + i;
                }
                apisBusiTaskLog.setBusinessKey(businessKey);
                apisBusiTaskLog.setPushType(ApisAutoTaskConstantsEnum.SD_CLAIM_SURVEY_INFO_NOTIFY.getValue());
                apisBusiTaskLog.setPushContent(JSON.toJSONString((Object)sdClaimSurveyInfoNotifyRequest));
                apisBusiTaskLog.setRelatedId(apisMsgMqlogs.getId());
                ApisChannelConfigs channelConfig = new ApisChannelConfigs();
                channelConfig.setConfigCode(ApisAutoTaskConstantsEnum.SD_CLAIM_SURVEY_INFO_NOTIFY.getValue() + "_url");
                channelConfig = this.apisChannelConfigsService.getChannelConfig(channelConfig);
                if (ObjectUtil.isNotEmpty((Object)channelConfig) && ObjectUtil.isNotEmpty((Object)channelConfig.getConfigValue())) {
                    apisBusiTaskLog.setPushTargetUrl(channelConfig.getConfigValue());
                    apisBusiTaskLog.setCreator(channelConfig.getUserCode());
                }
                this.apisBusiTaskLogService.save((Object)apisBusiTaskLog);
                this.sdClaimInfoNotifyUtil.asyncNotice(apisBusiTaskLog);
                ++i;
            }
        }
        catch (Exception e) {
            flag = "1";
            log.error("SDClaimSurveyReceiveListener\u6d88\u606f\u63a8\u9001\u5f02\u5e38\uff1a", (Throwable)e);
        }
        finally {
            if (ObjectUtil.isNotEmpty((Object)apisMsgMqlogs.getId())) {
                apisMsgMqlogs.setErrorFlag(flag);
                apisMsgMqlogs.setReleaseTime(LocalDateTime.now());
                this.apisMsgMqlogsService.updateById((Object)apisMsgMqlogs);
            }
        }
    }
}

