/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.jms.shuidi;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.SDClaimInfoNotifyUtil;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.request.SDClaimCaseStatusNotifyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.request.SDClaimCaseStatusNotifyRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.request.SDCompensateInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.request.SDCompensateInfoMQ;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiRequestRegist;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiRequestRegistService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.msg.entity.ApisMsgMqlogs;
import com.jdaz.sinosoftgz.apis.commons.service.constants.CommonConstant;
import com.jdaz.sinosoftgz.apis.commons.service.msg.service.ApisMsgMqlogsService;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
@RocketMQMessageListener(topic="allclaimTopic", selectorExpression="compensateInfoTags", consumerGroup="apis-sdCompensateInfo-Group")
public class SDCompensateInfoReceiveListener
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(SDCompensateInfoReceiveListener.class);
    @Autowired
    ApisMsgMqlogsService apisMsgMqlogsService;
    @Autowired
    ApisBusiRequestRegistService apisBusiRequestRegistService;
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    SDClaimInfoNotifyUtil sdClaimInfoNotifyUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(String message) {
        log.warn("received allclaimTopic:compensateInfoTags message: {}", (Object)message);
        DateTime currentDate = DateUtil.date();
        try {
            Thread.sleep(5000L);
            log.warn("\u63a5\u6536MQ\u6d88\u606f\u5ef6\u65f65\u79d2\u518d\u5904\u7406.");
        }
        catch (Exception e) {
            log.error("\u5ef6\u65f6\u51fa\u9519\uff1a", (Throwable)e);
        }
        String flag = "0";
        ApisMsgMqlogs apisMsgMqlogs = new ApisMsgMqlogs();
        try {
            SDCompensateInfoMQ mqAll = (SDCompensateInfoMQ)JSON.parseObject((String)message, SDCompensateInfoMQ.class);
            SDCompensateInfoDTO mqBody = mqAll.getBody();
            Assert.notNull((Object)mqBody.getRegistNo(), (String)"\u9519\u8bef\u6570\u636e\uff0c\u62a5\u6848\u53f7\u4e3a\u7a7a\uff01");
            ApisBusiRequestRegist apisBusiRequestRegist = this.apisBusiRequestRegistService.getByRegistNo(mqBody.getRegistNo());
            if (ObjectUtil.isEmpty((Object)apisBusiRequestRegist) || ObjectUtil.isEmpty((Object)apisBusiRequestRegist.getRegistNo())) {
                log.error("\u6570\u636e\u6709\u8bef\uff0c\u6848\u4ef6\u4e0d\u5b58\u5728\uff0c\u62a5\u6848\u53f7\uff1a{}", (Object)mqBody.getRegistNo());
                return;
            }
            apisMsgMqlogs.setCreateTime((Date)currentDate);
            apisMsgMqlogs.setMessage(message);
            apisMsgMqlogs.setTopic("allclaimTopic:compensateInfoTags");
            apisMsgMqlogs.setConsumerGroup("apis-sdCompensateInfo-Group");
            apisMsgMqlogs.setErrorFlag(flag);
            this.apisMsgMqlogsService.save((Object)apisMsgMqlogs);
            if (ObjectUtil.isNotEmpty((Object)mqBody.getClaimNo()) && ObjectUtil.isEmpty((Object)apisBusiRequestRegist.getClaimNo())) {
                apisBusiRequestRegist.setClaimNo(mqBody.getClaimNo());
                this.apisBusiRequestRegistService.updateById((Object)apisBusiRequestRegist);
            }
            if (!this.sdClaimInfoNotifyUtil.isShuiDiCase(apisBusiRequestRegist).booleanValue()) {
                log.warn("\u975e\u6c34\u6ef4\u6848\u4ef6\u4e0d\u4fdd\u5b58\u4e0d\u63a8\u9001...,\u62a5\u6848\u53f7\uff1a{}", (Object)mqBody.getRegistNo());
                return;
            }
            if (!"2".equals(mqBody.getUnderwriteFlag())) {
                log.warn("\u6838\u8d54\u72b6\u6001\u975e\u6838\u8d54\u9000\u56de\u4e0d\u63a8\u9001...\u62a5\u6848\u53f7\uff1a{},\u6838\u8d54\u72b6\u6001\uff1a{}", (Object)mqBody.getRegistNo(), (Object)mqBody.getUnderwriteFlag());
                return;
            }
            SDClaimCaseStatusNotifyRequest sdClaimCaseStatusNotifyRequest = SDClaimCaseStatusNotifyRequest.builder().uuid(UUID.fastUUID().toString()).timestamp(Long.valueOf(DateUtil.current())).bizContent(SDClaimCaseStatusNotifyDTO.builder().policyNo(apisBusiRequestRegist.getPolicyNo()).claimNo(mqBody.getRegistNo()).status(CommonConstant.ShuiDiCaseStatus.UNDERWRITE_BACK).processRemark(mqBody.getAudiStateExplain()).processTime(DateUtil.formatDateTime((Date)new Date())).noticeUrl(null).chkClmUserNm(mqBody.getAudiUserName()).chkClmUserId(mqBody.getAudiUserCode()).payTime(null).paySuccessTime(null).payFailTime(null).claimUpConfirmType(null).build()).build();
            ApisChannelConfigs channelConfig = new ApisChannelConfigs();
            channelConfig.setConfigCode(ApisAutoTaskConstantsEnum.SD_CLAIM_CASE_STATUS_NOTIFY.getValue() + "_url");
            channelConfig = this.apisChannelConfigsService.getChannelConfig(channelConfig);
            ApisBusiTaskLog apisBusiTaskLog = new ApisBusiTaskLog();
            apisBusiTaskLog.setPushStep(Integer.valueOf(BigDecimal.ZERO.intValue()));
            apisBusiTaskLog.setPushStatus("0");
            apisBusiTaskLog.setBusinessKey(mqBody.getRegistNo());
            apisBusiTaskLog.setPushType(ApisAutoTaskConstantsEnum.SD_CLAIM_CASE_STATUS_NOTIFY.getValue());
            apisBusiTaskLog.setPushContent(JSON.toJSONString((Object)sdClaimCaseStatusNotifyRequest));
            apisBusiTaskLog.setRelatedId(apisMsgMqlogs.getId());
            if (ObjectUtil.isNotEmpty((Object)channelConfig) && ObjectUtil.isNotEmpty((Object)channelConfig.getConfigValue())) {
                apisBusiTaskLog.setPushTargetUrl(channelConfig.getConfigValue());
                apisBusiTaskLog.setCreator(channelConfig.getUserCode());
            }
            this.apisBusiTaskLogService.save((Object)apisBusiTaskLog);
            this.sdClaimInfoNotifyUtil.asyncNotice(apisBusiTaskLog);
        }
        catch (Exception e) {
            flag = "1";
            log.error("SDCompensateInfoReceiveListener \u5f02\u5e38: ", (Throwable)e);
        }
        finally {
            if (ObjectUtil.isNotEmpty((Object)apisMsgMqlogs.getId())) {
                apisMsgMqlogs.setErrorFlag(flag);
                apisMsgMqlogs.setReleaseTime(LocalDateTime.now());
                this.apisMsgMqlogsService.updateById((Object)apisMsgMqlogs);
            }
        }
    }
}

