/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.jms.shuidi;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.ClaimMediaUploadUtil;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.SDClaimInfoNotifyUtil;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.SDCollectInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.SDInforSupplementRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.SDInforSupplementServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.request.SDClaimCaseStatusNotifyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.request.SDClaimCaseStatusNotifyRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.request.SDClaimInfoSupplementNotifyRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.request.SDClaimInforSupplementNotifyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.request.SDClaimSectionTypeAndPathDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.ImageQueryDownResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiInforSuppleLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiRequestRegist;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiInforSuppleLogMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiRequestRegistMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiInforSuppleLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiRequestRegistService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelCode;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.mapper.ApisChannelCodeMapper;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.msg.entity.ApisMsgMqlogs;
import com.jdaz.sinosoftgz.apis.commons.service.msg.service.ApisMsgMqlogsService;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
@RocketMQMessageListener(topic="allclaimTopic", selectorExpression="docCollectInfoTags", consumerGroup="apis-sdDocInfo-Group")
public class SDDocInfoReceiveListener
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(SDDocInfoReceiveListener.class);
    @Autowired
    ApisMsgMqlogsService apisMsgMqlogsService;
    @Autowired
    ApisBusiRequestRegistService apisBusiRequestRegistService;
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    SDClaimInfoNotifyUtil sdClaimInfoNotifyUtil;
    @Autowired
    ClaimMediaUploadUtil claimMediaUploadUtil;
    @Autowired
    ApisChannelCodeMapper apisChannelCodeMapper;
    @Autowired
    ApisBusiInforSuppleLogMapper apisBusiInforSuppleLogMapper;
    @Autowired
    ApisBusiRequestRegistMapper apisBusiRequestRegistMapper;
    @Autowired
    ApisBusiInforSuppleLogService apisBusiInforSuppleLogService;
    @Value(value="${claim.noticeFile.interface.claimImageJPGDownURL}")
    private String claimImageJpgDownUrl;
    private static String defaultClaimCode = "99930";
    private static String defaultImageCode = "999";
    private static String getDefaultSDCode = "99";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(String message) {
        SDDocInfoReceiveListener.log.warn("received allclaimTopic:docCollectInfoTags message: {}", (Object)message);
        DateTime currentDate = DateUtil.date();
        String flag = "0";
        ApisMsgMqlogs apisMsgMqlogs = new ApisMsgMqlogs();
        try {
            SDInforSupplementServiceRequest mqAll = (SDInforSupplementServiceRequest)JSON.parseObject((String)message, SDInforSupplementServiceRequest.class);
            SDInforSupplementRequestDTO mqBody = mqAll.getBody();
            Assert.notNull((Object)mqBody.getRegistNo(), (String)"\u9519\u8bef\u6570\u636e\uff0c\u62a5\u6848\u53f7\u4e3a\u7a7a\uff01");
            ApisBusiRequestRegist apisBusiRequestRegist = this.apisBusiRequestRegistService.getByRegistNo(mqBody.getRegistNo());
            if (ObjectUtil.isEmpty((Object)apisBusiRequestRegist) || ObjectUtil.isEmpty((Object)apisBusiRequestRegist.getRegistNo())) {
                SDDocInfoReceiveListener.log.warn("\u7406\u8d54\u63a8\u9001\u6570\u636e\u6709\u8bef\uff0c\u6848\u53f7\u4e0d\u5b58\u5728\u3002\u62a5\u6848\u53f7\uff1a{}", (Object)mqBody.getRegistNo());
                return;
            }
            if (!this.sdClaimInfoNotifyUtil.isShuiDiCase(apisBusiRequestRegist).booleanValue()) {
                SDDocInfoReceiveListener.log.warn("\u975e\u6c34\u6ef4\u6848\u4ef6\u4e0d\u4fdd\u5b58\u4e0d\u63a8\u9001...,\u62a5\u6848\u53f7\uff1a{}", (Object)mqBody.getRegistNo());
                return;
            }
            apisMsgMqlogs.setCreateTime((Date)currentDate);
            apisMsgMqlogs.setMessage(message);
            apisMsgMqlogs.setTopic("allclaimTopic:docCollectInfoTags");
            apisMsgMqlogs.setConsumerGroup("apis-sdDocInfo-Group");
            apisMsgMqlogs.setErrorFlag(flag);
            this.apisMsgMqlogsService.save((Object)apisMsgMqlogs);
            if (!StringUtils.isEmpty((Object)mqBody.getClaimUpConfirmType()) && ("1".equals(mqBody.getClaimUpConfirmType()) || "2".equals(mqBody.getClaimUpConfirmType()))) {
                SDDocInfoReceiveListener.log.warn("\u6838\u8d54\u6302\u8d77\uff0c\u8f6c\u7406\u8d54\u72b6\u6001\u540c\u6b65\u63a5\u53e3\uff0c\u62a5\u6848\u53f7\uff0c{}", (Object)mqBody.getRegistNo());
                this.sdCaseStatus(mqAll, apisBusiRequestRegist.getPolicyNo(), apisMsgMqlogs.getId().longValue());
                return;
            }
            if (ObjectUtil.isEmpty((Object)mqBody.getCollectInfoList())) {
                SDDocInfoReceiveListener.log.warn("\u5355\u8bc1\u5217\u8868\u4e3a\u7a7a");
                return;
            }
            ImageQueryDownResponseDTO imageQueryDownResponseDTO = this.claimMediaUploadUtil.getImageDown(mqBody.getRegistNo());
            if (ObjectUtil.isEmpty((Object)imageQueryDownResponseDTO)) {
                SDDocInfoReceiveListener.log.warn("\u5f71\u50cf\u4e0b\u8f7d\u5931\u8d25\uff0c\u62a5\u6848\u53f7\uff1a{}", (Object)mqBody.getRegistNo());
                return;
            }
            QueryWrapper qw = new QueryWrapper();
            qw.ne((Object)"pushStatus", (Object)2);
            qw.eq((Object)"registNo", (Object)mqBody.getRegistNo());
            List apisBusiInforSuppleLogList = this.apisBusiInforSuppleLogMapper.selectList((Wrapper)qw);
            HashMap docAndUrls = new HashMap();
            for (Object imageNodeDTO : imageQueryDownResponseDTO.getImageNodes()) {
                String sdCode;
                List docToFileName;
                String docCode;
                List docs = mqBody.getCollectInfoList().stream().map(SDCollectInfoDTO::getDocCode).collect(Collectors.toList());
                if (!docs.contains(docCode = imageNodeDTO.getImgTypePath().equals(defaultImageCode) ? defaultClaimCode : imageNodeDTO.getImgTypePath()) || (docToFileName = apisBusiInforSuppleLogList.stream().filter(log -> log.getClaimType().equals(docCode)).map(ApisBusiInforSuppleLog::getFileName).collect(Collectors.toList())).contains(imageNodeDTO.getFileName())) continue;
                QueryWrapper codeQw = new QueryWrapper();
                codeQw.eq((Object)"code", (Object)"claimToSD");
                codeQw.eq((Object)"value", (Object)imageNodeDTO.getImgTypePath());
                List apisChannelCodeList = this.apisChannelCodeMapper.selectList((Wrapper)codeQw);
                if (ObjectUtil.isEmpty((Object)apisChannelCodeList)) {
                    sdCode = getDefaultSDCode;
                    SDDocInfoReceiveListener.log.warn("\u6ca1\u627e\u5230\u5bf9\u5e94\u7684\u5355\u8bc1\u7c7b\u578b,\u9ed8\u8ba4\u4e3a\u6c34\u6ef4\u5176\u4ed6\u7c7b\u578b,\u62a5\u6848\u53f7\uff1a{}", (Object)mqBody.getRegistNo());
                } else {
                    sdCode = ((ApisChannelCode)apisChannelCodeList.get(0)).getChannelValue();
                }
                if (ObjectUtil.isEmpty(docAndUrls.get(sdCode))) {
                    ArrayList<String> urls = new ArrayList<String>();
                    urls.add(imageNodeDTO.getImgUrl());
                    ArrayList<String> fileNames = new ArrayList<String>();
                    fileNames.add(imageNodeDTO.getFileName());
                    ArrayList<String> imageCodes = new ArrayList<String>();
                    imageCodes.add(imageNodeDTO.getImgTypePath());
                    docAndUrls.put(sdCode, urls);
                    docAndUrls.put(sdCode + "FileName", fileNames);
                    docAndUrls.put(sdCode + "ImageCodes", imageCodes);
                    continue;
                }
                ((List)docAndUrls.get(sdCode)).add(imageNodeDTO.getImgUrl());
                ((List)docAndUrls.get(sdCode + "FileName")).add(imageNodeDTO.getFileName());
                ((List)docAndUrls.get(sdCode + "ImageCodes")).add(imageNodeDTO.getImgTypePath());
            }
            if (docAndUrls.size() == 0) {
                SDDocInfoReceiveListener.log.warn("\u8d44\u6599\u6536\u96c6\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4e0d\u63a8\u9001\u6570\u636e");
                return;
            }
            ArrayList<SDClaimSectionTypeAndPathDTO> paths = new ArrayList<SDClaimSectionTypeAndPathDTO>();
            for (String key : docAndUrls.keySet()) {
                if (key.contains("FileName") || key.contains("ImageCodes")) continue;
                ArrayList<String> pathList = new ArrayList<String>();
                for (int i = 0; i < ((List)docAndUrls.get(key)).size(); ++i) {
                    pathList.add(this.getImageUrl((String)((List)docAndUrls.get(key)).get(i), (String)((List)docAndUrls.get(key + "FileName")).get(i)));
                }
                SDClaimSectionTypeAndPathDTO sdClaimSectionTypeAndPathDTO = SDClaimSectionTypeAndPathDTO.builder().sectionNameType(key).sectionPaths(pathList).build();
                paths.add(sdClaimSectionTypeAndPathDTO);
                docAndUrls.put(key, pathList);
                SDDocInfoReceiveListener.log.warn("\u6c34\u6ef4\u8d44\u6599\u63a8\u9001\uff0c\u8f6c\u6362\u540eurl:{}", (Object)JSON.toJSONString(pathList));
            }
            SDClaimInfoSupplementNotifyRequest sdClaimInfoSupplementNotifyRequest = SDClaimInfoSupplementNotifyRequest.builder().uuid(UUID.fastUUID().toString()).timestamp(Long.valueOf(DateUtil.current())).bizContent(SDClaimInforSupplementNotifyDTO.builder().claimNo(mqBody.getRegistNo()).sectionTypeAndPathParam(paths).build()).build();
            ApisBusiTaskLog apisBusiTaskLog = new ApisBusiTaskLog();
            apisBusiTaskLog.setPushStep(Integer.valueOf(0));
            apisBusiTaskLog.setPushStatus("0");
            apisBusiTaskLog.setBusinessKey(mqBody.getRegistNo());
            apisBusiTaskLog.setPushType(ApisAutoTaskConstantsEnum.SD_CLAIM_INFOR_SUPPLEMENT_NOTIFY.getValue());
            apisBusiTaskLog.setPushContent(JSON.toJSONString((Object)sdClaimInfoSupplementNotifyRequest));
            apisBusiTaskLog.setRelatedId(apisMsgMqlogs.getId());
            ApisChannelConfigs channelConfig = new ApisChannelConfigs();
            channelConfig.setConfigCode(ApisAutoTaskConstantsEnum.SD_CLAIM_INFOR_SUPPLEMENT_NOTIFY.getValue() + "_url");
            channelConfig = this.apisChannelConfigsService.getChannelConfig(channelConfig);
            if (ObjectUtil.isNotEmpty((Object)channelConfig) && ObjectUtil.isNotEmpty((Object)channelConfig.getConfigValue())) {
                apisBusiTaskLog.setPushTargetUrl(channelConfig.getConfigValue());
                apisBusiTaskLog.setCreator(channelConfig.getUserCode());
            }
            this.apisBusiTaskLogService.save((Object)apisBusiTaskLog);
            this.sdClaimInfoNotifyUtil.asyncNotice(apisBusiTaskLog);
            for (String key : docAndUrls.keySet()) {
                if (key.contains("FileName") || key.contains("ImageCodes")) continue;
                List fileName = (List)docAndUrls.get(key + "FileName");
                List imageCodes = (List)docAndUrls.get(key + "ImageCodes");
                try {
                    for (int i = 0; i < fileName.size(); ++i) {
                        String imageType = (String)imageCodes.get(i);
                        String claimType = imageType.equals(defaultImageCode) ? defaultClaimCode : imageType;
                        ApisBusiInforSuppleLog inforSuppleLog = new ApisBusiInforSuppleLog();
                        inforSuppleLog.setClaimType(claimType);
                        inforSuppleLog.setRegistNo(mqBody.getRegistNo());
                        inforSuppleLog.setImgType(imageType);
                        inforSuppleLog.setSdType(key);
                        inforSuppleLog.setFileName((String)fileName.get(i));
                        inforSuppleLog.setPushStatus(Integer.valueOf(1));
                        inforSuppleLog.setPushTime(LocalDateTime.now());
                        this.apisBusiInforSuppleLogService.save((Object)inforSuppleLog);
                    }
                }
                catch (Exception e) {
                    SDDocInfoReceiveListener.log.error("\u6ca1\u627e\u5230\u5bf9\u5e94\u7684\u5355\u8bc1\u7c7b\u578b,\u62a5\u6848\u53f7\uff1a{}", (Object)mqBody.getRegistNo());
                    SDDocInfoReceiveListener.log.error("\u8d44\u6599\u63a8\u9001\u5f02\u5e38\uff0c\u4fe1\u606f\u4e3a\uff1a{}", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            flag = "1";
            SDDocInfoReceiveListener.log.error("SDDocInfoReceiveListener \u5f02\u5e38: ", (Throwable)e);
        }
        finally {
            if (ObjectUtil.isNotEmpty((Object)apisMsgMqlogs.getId())) {
                apisMsgMqlogs.setErrorFlag(flag);
                apisMsgMqlogs.setReleaseTime(LocalDateTime.now());
                this.apisMsgMqlogsService.updateById((Object)apisMsgMqlogs);
            }
        }
    }

    private String getImageUrl(String url, String fileName) {
        if (StringUtils.isEmpty((Object)url)) {
            return url;
        }
        String encodeHexStr = HexUtil.encodeHexStr((String)(url + "/" + fileName));
        String returnUrl = this.claimImageJpgDownUrl + "/" + encodeHexStr;
        return returnUrl;
    }

    private void sdCaseStatus(SDInforSupplementServiceRequest sdInforSupplementServiceRequest, String policyNo, long mqID) {
        if (StringUtils.isEmpty((Object)policyNo)) {
            log.warn("\u8be5\u62a5\u6848\u53f7\u7684\u4fdd\u5355\u53f7\u4e3a\u7a7a, \u62a5\u6848\u53f7\u4e3a{}", (Object)sdInforSupplementServiceRequest.getBody().getRegistNo());
            return;
        }
        SDClaimCaseStatusNotifyRequest sdClaimCaseStatusNotifyRequest = SDClaimCaseStatusNotifyRequest.builder().uuid(UUID.fastUUID().toString()).timestamp(Long.valueOf(DateUtil.current())).bizContent(SDClaimCaseStatusNotifyDTO.builder().claimNo(sdInforSupplementServiceRequest.getBody().getRegistNo()).policyNo(policyNo).status(Integer.valueOf(13)).processTime(DateUtil.formatDateTime((Date)new Date())).claimUpConfirmType(Integer.valueOf(sdInforSupplementServiceRequest.getBody().getClaimUpConfirmType())).build()).build();
        ApisBusiTaskLog apisBusiTaskLog = new ApisBusiTaskLog();
        apisBusiTaskLog.setPushStep(Integer.valueOf(0));
        apisBusiTaskLog.setPushStatus("0");
        apisBusiTaskLog.setBusinessKey(sdInforSupplementServiceRequest.getBody().getRegistNo());
        apisBusiTaskLog.setPushType(ApisAutoTaskConstantsEnum.SD_CLAIM_CASE_STATUS_NOTIFY.getValue());
        apisBusiTaskLog.setPushContent(JSON.toJSONString((Object)sdClaimCaseStatusNotifyRequest));
        apisBusiTaskLog.setRelatedId(Long.valueOf(mqID));
        ApisChannelConfigs channelConfig = new ApisChannelConfigs();
        channelConfig.setConfigCode(ApisAutoTaskConstantsEnum.SD_CLAIM_CASE_STATUS_NOTIFY.getValue() + "_url");
        channelConfig = this.apisChannelConfigsService.getChannelConfig(channelConfig);
        if (ObjectUtil.isNotEmpty((Object)channelConfig) && ObjectUtil.isNotEmpty((Object)channelConfig.getConfigValue())) {
            apisBusiTaskLog.setPushTargetUrl(channelConfig.getConfigValue());
            apisBusiTaskLog.setCreator(channelConfig.getUserCode());
        }
        this.apisBusiTaskLogService.save((Object)apisBusiTaskLog);
        this.sdClaimInfoNotifyUtil.asyncNotice(apisBusiTaskLog);
    }
}

