/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.jms.shuidi;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.SDClaimInfoNotifyUtil;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.request.PayeeInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.request.SDCaseStatusServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.request.SDClaimCaseStatusNotifyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.request.SDClaimCaseStatusNotifyRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.request.SDClaimCaseStatusRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiRequestRegist;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiRequestRegistService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.msg.entity.ApisMsgMqlogs;
import com.jdaz.sinosoftgz.apis.commons.service.msg.service.ApisMsgMqlogsService;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
@RocketMQMessageListener(topic="allclaimTopic", selectorExpression="payeeInfoTags", consumerGroup="apis-sdPayeeInfo-Group")
public class SDPayeeInfoReceiveListener
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(SDPayeeInfoReceiveListener.class);
    @Autowired
    ApisMsgMqlogsService apisMsgMqlogsService;
    @Autowired
    ApisBusiRequestRegistService apisBusiRequestRegistService;
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    SDClaimInfoNotifyUtil sdClaimInfoNotifyUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(String message) {
        log.warn("received allclaimTopic:payeeInfoTags message: {}", (Object)message);
        DateTime currentDate = DateUtil.date();
        try {
            Thread.sleep(5000L);
            log.warn("\u63a5\u6536MQ\u6d88\u606f\u5ef6\u65f65\u79d2\u518d\u5904\u7406.");
        }
        catch (Exception e) {
            log.error("\u5ef6\u65f6\u51fa\u9519\uff1a", (Throwable)e);
        }
        String flag = "0";
        ApisMsgMqlogs apisMsgMqlogs = new ApisMsgMqlogs();
        try {
            SDCaseStatusServiceRequest mqAll = (SDCaseStatusServiceRequest)JSON.parseObject((String)message, SDCaseStatusServiceRequest.class);
            SDClaimCaseStatusRequestDTO mqBody = mqAll.getBody();
            Assert.notNull((Object)mqBody.getRegistNo(), (String)"\u9519\u8bef\u6570\u636e\uff0c\u62a5\u6848\u53f7\u4e3a\u7a7a\uff01");
            ApisBusiRequestRegist apisBusiRequestRegist = this.apisBusiRequestRegistService.getByRegistNo(mqBody.getRegistNo());
            if (ObjectUtil.isEmpty((Object)apisBusiRequestRegist) || ObjectUtil.isEmpty((Object)apisBusiRequestRegist.getRegistNo())) {
                log.warn("\u6570\u636e\u6709\u8bef\uff0c\u6848\u4ef6\u4e0d\u5b58\u5728\uff0c\u62a5\u6848\u53f7\uff1a{}", (Object)mqBody.getRegistNo());
                return;
            }
            if (ObjectUtil.isEmpty((Object)mqBody.getPayeeInfoList())) {
                log.warn("\u9886\u6b3e\u4eba\u4fe1\u606f\u4e3a\u7a7a\uff0c\u4e0d\u5904\u7406\uff0c\u62a5\u6848\u53f7\uff1a{}", (Object)mqBody.getRegistNo());
                return;
            }
            if (!"1".equals(mqBody.getCompensateType())) {
                log.warn("\u6c34\u6ef4\u9886\u6b3e\u4ebaMQ\uff0c\u975e\u8d54\u6b3e\u573a\u666f\u4e0d\u5904\u7406");
                return;
            }
            apisMsgMqlogs.setCreateTime((Date)currentDate);
            apisMsgMqlogs.setMessage(message);
            apisMsgMqlogs.setTopic("allclaimTopic:payeeInfoTags");
            apisMsgMqlogs.setConsumerGroup("apis-sdPayeeInfo-Group");
            apisMsgMqlogs.setErrorFlag(flag);
            this.apisMsgMqlogsService.save((Object)apisMsgMqlogs);
            BigDecimal totalSumRealPay = mqBody.getPayeeInfoList().stream().map(PayeeInfo::getSumRealPay).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (ObjectUtil.isNotEmpty((Object)totalSumRealPay)) {
                apisBusiRequestRegist.setSumRealPay(totalSumRealPay);
                this.apisBusiRequestRegistService.updateById((Object)apisBusiRequestRegist);
            }
            if (!this.sdClaimInfoNotifyUtil.isShuiDiCase(apisBusiRequestRegist).booleanValue()) {
                log.warn("\u975e\u6c34\u6ef4\u6848\u4ef6\u4e0d\u4fdd\u5b58\u4e0d\u63a8\u9001...,\u62a5\u6848\u53f7\uff1a{}", (Object)mqBody.getRegistNo());
                return;
            }
            PayeeInfo payeeInfo = (PayeeInfo)mqBody.getPayeeInfoList().get(0);
            SDClaimCaseStatusNotifyRequest sdClaimCaseStatusNotifyRequest = SDClaimCaseStatusNotifyRequest.builder().uuid(UUID.fastUUID().toString()).timestamp(Long.valueOf(DateUtil.current())).bizContent(SDClaimCaseStatusNotifyDTO.builder().policyNo(apisBusiRequestRegist.getPolicyNo()).claimNo(mqBody.getRegistNo()).payAmount(Integer.valueOf(totalSumRealPay.multiply(new BigDecimal("100")).intValue())).processRemark(payeeInfo.getErrorMessage()).processTime(DateUtil.formatDateTime((Date)(ObjectUtil.isNotEmpty((Object)mqBody.getStatusUpdateTime()) ? mqBody.getStatusUpdateTime() : new Date()))).noticeUrl(null).chkClmUserNm(null).chkClmUserId(null).claimUpConfirmType(null).build()).build();
            if ("01".equals(payeeInfo.getSendPayStatus()) && "00".equals(payeeInfo.getPayStatus())) {
                sdClaimCaseStatusNotifyRequest.getBizContent().setStatus(Integer.valueOf(34));
                sdClaimCaseStatusNotifyRequest.getBizContent().setPayTime(ObjectUtil.isNotEmpty((Object)payeeInfo.getPayTime()) ? DateUtil.formatDateTime((Date)payeeInfo.getPayTime()) : null);
            } else if ("01".equals(payeeInfo.getSendPayStatus()) && "01".equals(payeeInfo.getPayStatus())) {
                sdClaimCaseStatusNotifyRequest.getBizContent().setStatus(Integer.valueOf(36));
                sdClaimCaseStatusNotifyRequest.getBizContent().setPaySuccessTime(ObjectUtil.isNotEmpty((Object)payeeInfo.getPayTime()) ? DateUtil.formatDateTime((Date)payeeInfo.getPayTime()) : null);
            }
            if ("01".equals(payeeInfo.getSendPayStatus()) && "02".equals(payeeInfo.getPayStatus())) {
                sdClaimCaseStatusNotifyRequest.getBizContent().setStatus(Integer.valueOf(35));
                sdClaimCaseStatusNotifyRequest.getBizContent().setPayFailTime(ObjectUtil.isNotEmpty((Object)payeeInfo.getPayTime()) ? DateUtil.formatDateTime((Date)payeeInfo.getPayTime()) : null);
            }
            if (ObjectUtil.isEmpty((Object)sdClaimCaseStatusNotifyRequest.getBizContent().getStatus())) {
                log.warn("\u6848\u4ef6\u72b6\u6001\u7a7a\u4e0d\u4fdd\u5b58\u4e0d\u63a8\u9001...\u62a5\u6848\u53f7\uff1a{} ,\u6848\u4ef6\u72b6\u6001\uff1a{}", (Object)mqBody.getRegistNo(), (Object)mqBody.getCaseStatus());
                return;
            }
            ApisBusiTaskLog apisBusiTaskLog = new ApisBusiTaskLog();
            apisBusiTaskLog.setPushStep(Integer.valueOf(0));
            apisBusiTaskLog.setPushStatus("0");
            apisBusiTaskLog.setBusinessKey(mqBody.getRegistNo());
            apisBusiTaskLog.setPushType(ApisAutoTaskConstantsEnum.SD_CLAIM_CASE_STATUS_NOTIFY.getValue());
            apisBusiTaskLog.setPushContent(JSON.toJSONString((Object)sdClaimCaseStatusNotifyRequest));
            apisBusiTaskLog.setRelatedId(apisMsgMqlogs.getId());
            ApisChannelConfigs channelConfig = new ApisChannelConfigs();
            channelConfig.setConfigCode(ApisAutoTaskConstantsEnum.SD_CLAIM_CASE_STATUS_NOTIFY.getValue() + "_url");
            channelConfig = this.apisChannelConfigsService.getChannelConfig(channelConfig);
            if (ObjectUtil.isNotEmpty((Object)channelConfig) && ObjectUtil.isNotEmpty((Object)channelConfig.getConfigValue())) {
                apisBusiTaskLog.setPushTargetUrl(channelConfig.getConfigValue());
                apisBusiTaskLog.setCreator(channelConfig.getUserCode());
            }
            this.apisBusiTaskLogService.save((Object)apisBusiTaskLog);
            this.sdClaimInfoNotifyUtil.asyncNotice(apisBusiTaskLog);
        }
        catch (Exception e) {
            flag = "1";
            log.error("SDPayeeInfoReceiveListener \u5f02\u5e38: ", (Throwable)e);
        }
        finally {
            if (ObjectUtil.isNotEmpty((Object)apisMsgMqlogs.getId())) {
                apisMsgMqlogs.setErrorFlag(flag);
                apisMsgMqlogs.setReleaseTime(LocalDateTime.now());
                this.apisMsgMqlogsService.updateById((Object)apisMsgMqlogs);
            }
        }
    }
}

