/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.jms.shuidi;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.jms.shuidi.SDRegistInfoReceiveListener;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.SDClaimInfoNotifyUtil;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.request.SDClaimOpenBillRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.request.SDClaimOpenBillServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.request.SDClaimRegistInfoNotifyDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.shuidi.request.SDClaimRegistInfoNotifyRequest;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiRequestRegist;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiRequestRegistService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelCode;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.mapper.ApisChannelCodeMapper;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.msg.entity.ApisMsgMqlogs;
import com.jdaz.sinosoftgz.apis.commons.service.constants.CommonConstant;
import com.jdaz.sinosoftgz.apis.commons.service.msg.service.ApisMsgMqlogsService;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import java.time.LocalDateTime;
import java.util.Date;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
@RocketMQMessageListener(topic="allclaimTopic", selectorExpression="registInfoTags", consumerGroup="apis-sdRegistInfo-Group")
public class SDRegistInfoReceiveListener
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(SDRegistInfoReceiveListener.class);
    @Autowired
    ApisMsgMqlogsService apisMsgMqlogsService;
    @Autowired
    ApisBusiRequestRegistService apisBusiRequestRegistService;
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    SDClaimInfoNotifyUtil sdClaimInfoNotifyUtil;
    @Autowired
    private ApisChannelCodeMapper apisChannelCodeMapper;
    @Autowired
    RedisTemplate redisTemplate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(String message) {
        log.warn("received allclaimTopic:registInfoTags message: {}", (Object)message);
        Long startTimeStamp = System.currentTimeMillis();
        try {
            Thread.sleep(5000L);
            log.warn("\u63a5\u6536MQ\u6d88\u606f\u5ef6\u65f65\u79d2\u518d\u5904\u7406.");
        }
        catch (Exception e) {
            log.error("\u5ef6\u65f6\u51fa\u9519\uff1a", (Throwable)e);
        }
        DateTime currentDate = DateUtil.date();
        String flag = "0";
        ApisMsgMqlogs apisMsgMqlogs = new ApisMsgMqlogs();
        try {
            ApisChannelCode hospital;
            SDClaimOpenBillServiceRequest mqAll = (SDClaimOpenBillServiceRequest)JSON.parseObject((String)message, SDClaimOpenBillServiceRequest.class);
            SDClaimOpenBillRequestDTO mqBody = mqAll.getBody();
            while (ObjectUtil.isNotEmpty((Object)this.redisTemplate.opsForValue().get((Object)(mqBody.getPolicyNo() + mqBody.getIdentifyNo() + mqBody.getDamageTime().getTime() + mqBody.getDamageResult())))) {
                try {
                    Thread.sleep(500L);
                    log.warn("\u62a5\u6848\u63a5\u53e3\u672a\u54cd\u5e94\u5b8c\u6bd5\uff0c\u63a5\u6536MQ\u6d88\u606f\u5ef6\u65f60.5\u79d2\u518d\u5904\u7406\uff0c\u6700\u591a\u5ef6\u65f630\u79d2.");
                    if (System.currentTimeMillis() - startTimeStamp < 30000L) continue;
                    break;
                }
                catch (Exception e) {
                    log.error("\u5ef6\u65f6\u51fa\u9519\uff1a", (Throwable)e);
                }
            }
            Assert.notNull((Object)mqBody.getRegistNo(), (String)"\u9519\u8bef\u6570\u636e\uff0c\u62a5\u6848\u53f7\u4e3a\u7a7a\uff01");
            ApisBusiRequestRegist apisBusiRequestRegist = this.apisBusiRequestRegistService.getByRegistNo(mqBody.getRegistNo());
            if (ObjectUtil.isNotEmpty((Object)apisBusiRequestRegist) && ObjectUtil.isNotEmpty((Object)apisBusiRequestRegist.getRegistNo())) {
                log.warn("\u7406\u8d54\u63a8\u9001\u91cd\u590d\u7684\u7406\u8d54\u62a5\u6848\u6570\u636e\uff0c\u62a5\u6848\u53f7\uff1a{}", (Object)mqBody.getRegistNo());
                return;
            }
            apisMsgMqlogs.setCreateTime((Date)currentDate);
            apisMsgMqlogs.setMessage(message);
            apisMsgMqlogs.setTopic("allclaimTopic:registInfoTags");
            apisMsgMqlogs.setConsumerGroup("apis-sdRegistInfo-Group");
            apisMsgMqlogs.setErrorFlag(flag);
            apisBusiRequestRegist = new ApisBusiRequestRegist();
            apisBusiRequestRegist.setPolicyNo(mqBody.getPolicyNo());
            apisBusiRequestRegist.setChannelType(mqBody.getReportType());
            apisBusiRequestRegist.setDamageResult(mqBody.getDamageResult());
            apisBusiRequestRegist.setCurrency(mqBody.getCurrency());
            apisBusiRequestRegist.setRegistNo(mqBody.getRegistNo());
            apisBusiRequestRegist.setChannelCode(mqBody.getReportChannel());
            apisBusiRequestRegist.setDamageTime(mqBody.getDamageTime());
            if (!this.sdClaimInfoNotifyUtil.isShuiDiCase(apisBusiRequestRegist).booleanValue()) {
                log.warn("\u975e\u6c34\u6ef4\u6848\u4ef6\u4e0d\u4fdd\u5b58\u4e0d\u63a8\u9001...,\u62a5\u6848\u53f7\uff1a{}", (Object)mqBody.getRegistNo());
                return;
            }
            this.apisMsgMqlogsService.save((Object)apisMsgMqlogs);
            try {
                this.apisBusiRequestRegistService.addRequestRegistNo(apisBusiRequestRegist);
            }
            catch (Exception e) {
                log.error("\u4fdd\u5b58\u62a5\u6848\u6570\u636e\u51fa\u9519\uff0c\u62a5\u6848\u53f7\uff1a{}", (Object)mqBody.getRegistNo(), (Object)e);
                if (ObjectUtil.isNotEmpty((Object)apisMsgMqlogs.getId())) {
                    apisMsgMqlogs.setErrorFlag(flag);
                    apisMsgMqlogs.setReleaseTime(LocalDateTime.now());
                    this.apisMsgMqlogsService.updateById((Object)apisMsgMqlogs);
                }
                return;
            }
            1 relTypeMap = new /* Unavailable Anonymous Inner Class!! */;
            String damageType = null;
            String damageTypeName = null;
            if (ObjectUtil.isNotEmpty((Object)mqBody.getDamageResult())) {
                if (mqBody.getDamageResult().contains("07")) {
                    if (ObjectUtil.isNotEmpty((Object)mqBody.getDamageReasonType()) && mqBody.getDamageReasonType().contains("1")) {
                        damageType = "SN002";
                        damageTypeName = "\u75be\u75c5\u533b\u7597";
                    } else {
                        damageType = "SN001";
                        damageTypeName = "\u610f\u5916\u533b\u7597";
                    }
                } else if (mqBody.getDamageResult().contains("03")) {
                    damageType = "SN003";
                    damageTypeName = "\u4f24\u6b8b";
                } else if (mqBody.getDamageResult().contains("01")) {
                    damageType = "SN004";
                    damageTypeName = "\u8eab\u6545";
                } else if (mqBody.getDamageResult().contains("04")) {
                    damageType = "SN001";
                    damageTypeName = "\u91cd\u5927\u75be\u75c5";
                }
            }
            String damageAddressCode = "";
            String damageAddressDesc = "";
            if ("1".equals(mqBody.getNationFlag())) {
                damageAddressCode = mqBody.getProvinceCode() + "," + mqBody.getCityCode() + "," + mqBody.getCountyCode();
                String provinceName = this.apisChannelCodeMapper.getValueDesc(null, "province", mqBody.getProvinceCode());
                String cityName = this.apisChannelCodeMapper.getValueDesc(null, "city", mqBody.getCityCode());
                String countyName = this.apisChannelCodeMapper.getValueDesc(null, "subCity", mqBody.getCountyCode());
                damageAddressDesc = (ObjectUtil.isEmpty((Object)provinceName) ? "\u4e2d\u56fd" : provinceName) + "," + (ObjectUtil.isEmpty((Object)cityName) ? "\u4e2d\u56fd" : cityName) + "," + (ObjectUtil.isEmpty((Object)countyName) ? "\u4e2d\u56fd" : countyName);
            } else {
                damageAddressCode = mqBody.getCountryCode() + "," + mqBody.getCitysCode();
                String countryName = this.apisChannelCodeMapper.getValueDesc(null, "PRPDCOUNTRY", mqBody.getCountryCode());
                damageAddressDesc = ObjectUtil.isEmpty((Object)countryName) ? "\u56fd\u5916" : countryName;
            }
            String hospitalName = null;
            if (ObjectUtil.isNotEmpty((Object)mqBody.getHospitalCode()) && ObjectUtil.isNotEmpty((Object)(hospital = this.apisChannelCodeMapper.getByCodeAndValue("SD_HOSP_MAP", mqBody.getHospitalCode())))) {
                hospitalName = hospital.getChannelValueDesc();
            }
            SDClaimRegistInfoNotifyRequest sdClaimRegistInfoNotifyRequest = SDClaimRegistInfoNotifyRequest.builder().uuid(UUID.fastUUID().toString()).timestamp(Long.valueOf(DateUtil.current())).bizContent(SDClaimRegistInfoNotifyDTO.builder().claimNo(mqBody.getRegistNo()).inscompanyId("ALCX20210205").policyNo(mqBody.getPolicyNo()).relType(Integer.valueOf(ObjectUtil.isEmpty(relTypeMap.get(mqBody.getReportorRelation())) ? 0 : (Integer)relTypeMap.get(mqBody.getReportorRelation()))).reporterName(mqBody.getReportorName()).reporterMobile(mqBody.getReportorPhone()).reporterEmail(mqBody.getReportorEmail()).reporterIdCardNo(null).accdntTime(DateUtil.formatDateTime((Date)mqBody.getDamageTime())).accdntAddress(damageAddressDesc + (ObjectUtil.isEmpty((Object)mqBody.getDamageAddress()) ? "" : mqBody.getDamageAddress())).accdntAddressCode(damageAddressCode).accdntReason(damageTypeName).accdntType(damageType).accdntDesc(mqBody.getDamageRemark()).jobDesc(null).hospitalInfo(hospitalName).treatStatus(Integer.valueOf(3)).exceptCost(Integer.valueOf(mqBody.getReportedLoss().multiply(CommonConstant.ONE_HUNDRED).intValue())).caseLevel(Boolean.valueOf("1".equals(mqBody.getIsMajorCase()))).reportMark(null).adjustmentType(null).build()).build();
            ApisBusiTaskLog apisBusiTaskLog = new ApisBusiTaskLog();
            apisBusiTaskLog.setPushStep(Integer.valueOf(0));
            apisBusiTaskLog.setPushStatus("0");
            apisBusiTaskLog.setBusinessKey(mqBody.getRegistNo());
            apisBusiTaskLog.setPushType(ApisAutoTaskConstantsEnum.SD_CLAIM_REGIST_INFO_NOTIFY.getValue());
            apisBusiTaskLog.setPushContent(JSON.toJSONString((Object)sdClaimRegistInfoNotifyRequest));
            apisBusiTaskLog.setRelatedId(apisMsgMqlogs.getId());
            ApisChannelConfigs channelConfig = new ApisChannelConfigs();
            channelConfig.setConfigCode(ApisAutoTaskConstantsEnum.SD_CLAIM_REGIST_INFO_NOTIFY.getValue() + "_url");
            channelConfig = this.apisChannelConfigsService.getChannelConfig(channelConfig);
            if (ObjectUtil.isNotEmpty((Object)channelConfig) && ObjectUtil.isNotEmpty((Object)channelConfig.getConfigValue())) {
                apisBusiTaskLog.setPushTargetUrl(channelConfig.getConfigValue());
                apisBusiTaskLog.setCreator(channelConfig.getUserCode());
            }
            this.apisBusiTaskLogService.save((Object)apisBusiTaskLog);
            this.sdClaimInfoNotifyUtil.asyncNotice(apisBusiTaskLog);
        }
        catch (Exception e) {
            flag = "1";
            log.error("SDRegistInfoReceiveListener \u5f02\u5e38: ", (Throwable)e);
        }
        finally {
            if (ObjectUtil.isNotEmpty((Object)apisMsgMqlogs.getId())) {
                apisMsgMqlogs.setErrorFlag(flag);
                apisMsgMqlogs.setReleaseTime(LocalDateTime.now());
                this.apisMsgMqlogsService.updateById((Object)apisMsgMqlogs);
            }
        }
    }
}

