/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.job;

import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.SDClaimInfoNotifyUtil;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@ConditionalOnProperty(prefix="scheduling", name={"enabled"}, havingValue="true")
public class SDClaimTask {
    private static final Logger log = LoggerFactory.getLogger(SDClaimTask.class);
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    SDClaimInfoNotifyUtil sdClaimInfoNotifyUtil;
    @Value(value="${scheduling.sdclaim_max_push_times}")
    private Integer maxPushTimes = 3;

    public boolean lock(String key) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)key, 10L, TimeUnit.MINUTES);
    }

    public void deleteByKey(String key) {
        this.redisTemplate.delete((Object)key);
    }

    @Scheduled(cron="0 */5 * * * ?")
    public void pushRegistInfoToShuiDiTask() {
        if (this.lock(ApisAutoTaskConstantsEnum.SD_CLAIM_REGIST_INFO_NOTIFY.getKey())) {
            try {
                List taskList = this.apisBusiTaskLogService.getNeedPushInstallmentPayRecord(ApisAutoTaskConstantsEnum.SD_CLAIM_REGIST_INFO_NOTIFY.getValue(), this.maxPushTimes);
                log.warn("\u63a8\u9001\u4fdd\u53f8\u5411\u6c34\u6ef4\u62a5\u6848\u4efb\u52a1\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb=={}", (Object)taskList.size());
                taskList.forEach(t -> this.sdClaimInfoNotifyUtil.pushContentToUrl(t));
            }
            catch (Exception e) {
                log.error("pushRegistInfoToShuiDiTask error: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.SD_CLAIM_REGIST_INFO_NOTIFY.getKey());
            }
        }
    }

    @Scheduled(cron="0 */6 * * * ?")
    public void pushCaseStatusToShuiDiTask() {
        if (this.lock(ApisAutoTaskConstantsEnum.SD_CLAIM_CASE_STATUS_NOTIFY.getKey())) {
            try {
                List taskList = this.apisBusiTaskLogService.getNeedPushInstallmentPayRecord(ApisAutoTaskConstantsEnum.SD_CLAIM_CASE_STATUS_NOTIFY.getValue(), this.maxPushTimes);
                log.warn("\u7406\u8d54\u72b6\u6001\u540c\u6b65\u6c34\u6ef4\u4efb\u52a1\u5f00\u59cb=={}", (Object)taskList.size());
                taskList.forEach(t -> this.sdClaimInfoNotifyUtil.pushContentToUrl(t));
            }
            catch (Exception e) {
                log.error("pushCaseStatusToShuiDiTask error: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.SD_CLAIM_CASE_STATUS_NOTIFY.getKey());
            }
        }
    }

    @Scheduled(cron="0 3/6 * * * ?")
    public void pushSurveyInfoToShuiDiTask() {
        if (this.lock(ApisAutoTaskConstantsEnum.SD_CLAIM_SURVEY_INFO_NOTIFY.getKey())) {
            try {
                List taskList = this.apisBusiTaskLogService.getNeedPushInstallmentPayRecord(ApisAutoTaskConstantsEnum.SD_CLAIM_SURVEY_INFO_NOTIFY.getValue(), this.maxPushTimes);
                log.warn("\u8c03\u67e5\u72b6\u6001\u540c\u6b65\u6c34\u6ef4\u4efb\u52a1\u5f00\u59cb=={}", (Object)taskList.size());
                taskList.forEach(t -> this.sdClaimInfoNotifyUtil.pushContentToUrl(t));
            }
            catch (Exception e) {
                log.error("pushSurveyInfoToShuiDiTask error: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.SD_CLAIM_CASE_STATUS_NOTIFY.getKey());
            }
        }
    }
}

