/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.job;

import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.CommonPushUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.constants.ClaimBusinessConstants;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@ConditionalOnProperty(prefix="scheduling", name={"enabled"}, havingValue="true")
public class Task {
    private static final Logger log = LoggerFactory.getLogger(Task.class);
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;
    @Autowired
    private StringRedisTemplate redisTemplate;
    private Integer maxPushTimes = 3;
    @Autowired
    CommonPushUtil commonPushUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="0 */2 * * * ?")
    public void pushEcoCaseStatusTask() {
        if (this.lock("CLAIM_COMMON")) {
            try {
                for (String value : ClaimBusinessConstants.CASESTATUS_NEED_REPUSH) {
                    List taskList = this.apisBusiTaskLogService.getNeedPushInstallmentPayRecord(value, this.maxPushTimes);
                    log.warn("\u6848\u4ef6\u72b6\u6001\u4fe1\u606f\u63a8\u9001\u5f00\u59cb,\u5f53\u524d\u63a8\u9001\u7c7b\u578b\u4e3a\uff1a{},\u63a8\u9001\u7c7b\u578b\u4e3a:{}", (Object)value, (Object)taskList.size());
                    taskList.forEach(t -> this.commonPushUtil.pushContentToUrlAgent(t, (Class)ClaimBusinessConstants.TYPE_TO_RES.get(value)));
                }
            }
            catch (Exception e) {
                log.error("pushEcoCaseStatusTask error: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.CLAIM_CASE_STATUS_NOTIFY_YI_YAO_BAO.getKey());
            }
        }
    }

    public boolean lock(String key) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)key, 10L, TimeUnit.MINUTES);
    }

    public void deleteByKey(String key) {
        this.redisTemplate.delete((Object)key);
    }
}

