/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.service;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.consts.EcoErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.consts.ErrorCodeChangeEnum;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.response.ClaimOpenBillEcoResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.response.ClaimOpenBillServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.response.ClaimOpenBillServiceResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.response.EcoClaimInfoReturn;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.response.EcoGeneralInfoReturn;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.response.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiRequestRegist;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiRequestRegistService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClaimOpenBillService {
    @Autowired
    private ApisBusiRequestRegistService apisBusiRequestRegistService;

    public StanderResponse checkRequestId(StanderRequest request) {
        ApisBusiRequestRegist apisBusiRequestRegist = this.apisBusiRequestRegistService.getByRequestId(request.getClaimOpenBillServiceRequest().getHead().getTransID());
        if (ObjectUtil.isNotEmpty((Object)apisBusiRequestRegist)) {
            RequestHeadDTO requestHead = request.getClaimOpenBillServiceRequest().getHead();
            return StanderResponse.builder().header(request.getHeader()).claimOpenBillServiceResponse(ClaimOpenBillServiceResponse.builder().head(ResponseHeadDTO.builder().responseCode("1").password(requestHead.getPassword()).user(requestHead.getUser()).transDate(new Date()).transType(requestHead.getTransType()).transID(requestHead.getTransID()).build()).body(ClaimOpenBillServiceResponseDTO.builder().registNo(apisBusiRequestRegist.getRegistNo()).claimNo(apisBusiRequestRegist.getClaimNo()).currency(apisBusiRequestRegist.getCurrency()).endCaseNo(apisBusiRequestRegist.getEndCaseNo()).externalID(apisBusiRequestRegist.getExternalId()).sumRealPay(apisBusiRequestRegist.getSumRealPay()).build()).build()).build();
        }
        return null;
    }

    public void changeErrorCode(StanderResponse resp) {
        ErrorCodeChangeEnum enumByCode = ErrorCodeChangeEnum.getEnumBycode((String)resp.getClaimOpenBillServiceResponse().getHead().getErrorCode());
        if (enumByCode != null) {
            resp.getClaimOpenBillServiceResponse().getHead().setErrorCode(enumByCode.getApisCode());
            resp.getClaimOpenBillServiceResponse().getHead().setErrorMessage(enumByCode.getMessage() + enumByCode.getApisMessage());
        }
    }

    public StanderResponse checkUuid(StanderRequest request) {
        ApisBusiRequestRegist apisBusiRequestRegist = this.apisBusiRequestRegistService.getByRequestId(request.getClaimOpenBillEcoRequest().getGeneralInfo().getUuid());
        if (ObjectUtil.isNotEmpty((Object)apisBusiRequestRegist)) {
            return StanderResponse.builder().header(request.getHeader()).claimOpenBillEcoResponse(ClaimOpenBillEcoResponse.builder().generalInfoReturn(EcoGeneralInfoReturn.builder().uuid(request.getClaimOpenBillEcoRequest().getGeneralInfo().getUuid()).errorCode(EcoErrorCodeEnum.SUCCESS_C00.getKey()).errorMessage(EcoErrorCodeEnum.SUCCESS_C00.getValue()).build()).claimInfoReturn(EcoClaimInfoReturn.builder().registNo(apisBusiRequestRegist.getRegistNo()).damageFlag(request.getClaimOpenBillEcoRequest().getClaimOpenBillEco().getDamageFlag()).saveResult(EcoErrorCodeEnum.SUCCESS_C00.getKey()).saveMessage(EcoErrorCodeEnum.SUCCESS_C00.getValue()).saveTimes(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss")).build()).build()).build();
        }
        return null;
    }
}

