/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Base64Utils;

@Component
public class AesUtils {
    private static final Logger log = LoggerFactory.getLogger(AesUtils.class);
    private static final String KEY_ALGORITHM = "AES";
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";
    private static final String CODE = "utf-8";

    public String encrypt(String content, String key) {
        try {
            byte[] encrypted = this.encrypt2bytes(content, key);
            return Base64Utils.encodeToString((byte[])encrypted);
        }
        catch (Exception e) {
            log.error("failed to encrypt: {} of {}", (Object)content, (Object)e);
            return null;
        }
    }

    public byte[] encrypt2bytes(String content, String key) {
        try {
            log.warn("\u672c\u6b21\u52a0\u5bc6key\u4e3a\uff1a{}", (Object)key);
            byte[] raw = new byte[16];
            byte[] bytekeys = key.getBytes(CODE);
            int iv = bytekeys.length > 16 ? 16 : bytekeys.length;
            System.arraycopy(bytekeys, 0, raw, 0, iv);
            SecretKeySpec secretKeySpec = new SecretKeySpec(raw, KEY_ALGORITHM);
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            cipher.init(1, secretKeySpec);
            return cipher.doFinal(content.getBytes(CODE));
        }
        catch (Exception e) {
            log.error("failed to encrypt: {} of {}", (Object)content, (Object)e);
            return null;
        }
    }

    public String decrypt(String content, String key) throws Exception {
        return this.decrypt(Base64Utils.decodeFromString((String)content), key);
    }

    public String decrypt(byte[] content, String key) throws Exception {
        if (key == null) {
            log.error("AES key should not be null");
            return null;
        }
        byte[] raw = key.getBytes(CODE);
        SecretKeySpec keySpec = new SecretKeySpec(raw, KEY_ALGORITHM);
        Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
        cipher.init(2, keySpec);
        try {
            byte[] original = cipher.doFinal(content);
            return new String(original, CODE);
        }
        catch (Exception e) {
            log.error("failed to decrypt content: {}/ key: {}, e: {}", new Object[]{content, key, e});
            return null;
        }
    }
}

