/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils;

import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.OkHttpUtils;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.nonCarClaimQuery.claimQueryList.DocCodeAndName;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.SDCollectInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.request.ClaimMediaCommitResult;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ImgMetaDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.ImageQueryDownRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.ImageQueryDownRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.ImageQueryDownResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.ImageQueryDownResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.ImageSystemBaseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ePolicyDown.ImageSystemMetaDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ImgBatchUploadServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiReqmsgLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiGuaranteeMaterialService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiReqmsgLogService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelCode;
import com.jdaz.sinosoftgz.apis.commons.model.channel.mapper.ApisChannelCodeMapper;
import com.jdaz.sinosoftgz.apis.commons.utils.ImageUtils;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorBisCodeEnum;
import com.jdaz.sinosoftgz.coreapi.common.configs.CoreApiProperties;
import com.jdaz.sinosoftgz.coreapi.common.configs.CoreApiServProperties;
import com.jdaz.sinosoftgz.coreapi.common.factory.CoreDtoConverterFactory;
import com.jdaz.sinosoftgz.coreapi.common.handler.CoreDtoConverter;
import com.jdaz.sinosoftgz.coreapi.h5img.MediaUploadApi;
import com.sinosoft.image.client.dto.ImgBatchUploadMetaDTO;
import com.sinosoft.image.client.dto.ImgBatchUploadRequestDTO;
import com.sinosoft.image.client.dto.ImgBusiDTO;
import com.sinosoft.image.client.dto.RequestHeadDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class ClaimMediaUploadUtil {
    private Logger log = LoggerFactory.getLogger(ClaimMediaUploadUtil.class);
    @Autowired
    MediaUploadApi mediaUploadApi;
    @Autowired
    CoreApiProperties coreApiProperties;
    @Autowired
    ApisBusiReqmsgLogService apisBusiReqmsgLogService;
    @Autowired
    CoreDtoConverterFactory coreDtoConverterFactory;
    @Autowired
    ApisBusiGuaranteeMaterialService apisBusiGuaranteeMaterialService;
    @Autowired
    ApisChannelCodeMapper apisChannelCodeMapper;
    @Autowired
    private DocCodeAndName docCodeAndName;
    @Autowired
    private ImageUtils imageUtils;
    private final String SER_PROPERTIES_BATCH_UPLOAD_FILE = "batchUploadFile";
    private static String defaultImageCode = "999";
    @Value(value="${ePolicy.down.url}")
    private String ePolicyDownUrl;
    @Value(value="${ePolicy.down.newUrl}")
    private String ePolicyDownNewUrl;
    @Autowired
    private RestTemplate restTemplate;

    @Async(value="imgBatchUploadExecutor")
    public void syncUploadGuaranteeMaterial(StanderRequest request) throws ApisBusinessException {
        try {
            this.beforeGuaranteeMaterialUploadProcess(request);
        }
        catch (Exception e) {
            this.log.error("\u6c34\u6ef4\u7406\u8d54\u4e0a\u4f20\u8d44\u6599\u5931\u8d25\uff0c{}", (Throwable)e);
        }
    }

    private void beforeGuaranteeMaterialUploadProcess(StanderRequest request) throws ApisBusinessException {
        List sdCollectInfodtos = request.getSdInforSupplementServiceRequest().getBody().getCollectInfoList();
        for (SDCollectInfoDTO sdCollectInfoDTO : sdCollectInfodtos) {
            String valueDesc;
            String base64Str = OkHttpUtils.getBase64EncodeByUrl((String)sdCollectInfoDTO.getSectionUrl());
            this.log.warn("\u6c34\u6ef4\u7406\u8d54\u4e0b\u8f7d\u6587\u4ef6\uff0c\u6587\u4ef6\u540d:{}", (Object)sdCollectInfoDTO.getSectionName());
            if (StringUtils.isEmpty((CharSequence)base64Str)) {
                this.log.error("\u6c34\u6ef4\u7406\u8d54\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25,\u6587\u4ef6\u540d:{}", (Object)sdCollectInfoDTO.getSectionName());
                this.log.error("\u6c34\u6ef4\u7406\u8d54\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25,url:{}", (Object)sdCollectInfoDTO.getSectionUrl());
                continue;
            }
            String value = this.apisChannelCodeMapper.getValue("sdClaimMediatype", sdCollectInfoDTO.getSectionType());
            if (StringUtils.isEmpty((CharSequence)value)) {
                value = defaultImageCode;
            }
            QueryWrapper qw = new QueryWrapper();
            qw.eq((Object)"code", (Object)"sdClaimMediatype");
            qw.eq((Object)"value", (Object)value);
            List apisBusiInforSuppleLogList = this.apisChannelCodeMapper.selectList((Wrapper)qw);
            String string = valueDesc = ObjectUtil.isNotEmpty((Object)apisBusiInforSuppleLogList) ? ((ApisChannelCode)apisBusiInforSuppleLogList.get(0)).getValueDesc() : null;
            if (StringUtils.isEmpty((CharSequence)value) || StringUtils.isEmpty((CharSequence)valueDesc)) {
                this.log.error("\u6c34\u6ef4\u7406\u8d54\u6ca1\u627e\u5230\u5f71\u50cf\u6620\u5c04\u7c7b\u578b\uff0c\u6587\u4ef6\u540d:" + sdCollectInfoDTO.getSectionName());
                continue;
            }
            ImgMetaDTO imgMetaDTO = ImgMetaDTO.builder().fileOrgName(sdCollectInfoDTO.getSectionName()).imgType(value).imgTypeName(valueDesc).fileContentWithBase64Encode(base64Str).build();
            ArrayList<ImgMetaDTO> tarList = new ArrayList<ImgMetaDTO>();
            tarList.add(imgMetaDTO);
            request.getImgBatchUploadServiceRequest().getRequestBody().setImgList(tarList);
            this.imgBatchUpload(request, request.getSdInforSupplementServiceRequest().getBody().getRegistNo());
        }
    }

    private String getExtNameByUrl(String fileUrl) {
        int index = fileUrl.lastIndexOf("?");
        String extendName = index == -1 ? fileUrl.substring(fileUrl.lastIndexOf(".")) : fileUrl.substring(0, index).substring(fileUrl.lastIndexOf("."));
        return extendName;
    }

    public ClaimMediaCommitResult imgBatchUpload(StanderRequest request, String businessNo) throws ApisBusinessException {
        long time = System.currentTimeMillis();
        Optional properties = this.coreApiProperties.getServProperties("batchUploadFile");
        if (!properties.isPresent()) {
            throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B80001.getValue(), ErrorBisCodeEnum.ERR_B80001.getKey());
        }
        ImgBatchUploadRequestDTO imgBatchUploadRequestDTO = this.imgBatchUploadRequestBeforeProcess(request, properties, businessNo);
        ClaimMediaCommitResult responseDTO = this.mediaUploadApi.batchUpload(((CoreApiServProperties)properties.get()).getUrl(), imgBatchUploadRequestDTO, null);
        if (ObjectUtil.isEmpty((Object)responseDTO) || ObjectUtil.isEmpty((Object)responseDTO.getHeadDto())) {
            throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B80002.getValue(), ErrorBisCodeEnum.ERR_B80002.getKey());
        }
        if (responseDTO.getHeadDto().getStatus() < 0) {
            throw new ApisBusinessException("\u5f71\u50cf\u7cfb\u7edf\u8c03\u7528\u5931\u8d25\uff1a" + responseDTO.getHeadDto().getErrorMessage(), responseDTO.getHeadDto().getErrorCode());
        }
        ImgBatchUploadServiceResponse imgBatchUploadResponse = ImgBatchUploadServiceResponse.builder().build();
        imgBatchUploadResponse.setImgNodes(responseDTO.getImgNodes());
        int successSize = 0;
        try {
            successSize = responseDTO.getImgNodeList().size();
        }
        catch (NullPointerException e) {
            this.log.warn("\u5f71\u50cf\u8fd4\u56de\u7684nodeList\u4e3a\u7a7a");
        }
        this.log.warn("\u5f71\u50cf\u7cfb\u7edf\u8c03\u7528\u54cd\u5e94\u62a5\u6587\u6210\u529f\u6570:{}", (Object)successSize);
        this.insertImgBatchUploadLog(request, responseDTO);
        return responseDTO;
    }

    private ImgBatchUploadRequestDTO imgBatchUploadRequestBeforeProcess(StanderRequest request, Optional<CoreApiServProperties> properties, String businessNo) {
        ImgBatchUploadRequestDTO imgBatchUploadRequestDTO = new ImgBatchUploadRequestDTO();
        RequestHeadDTO requestHeadDTO = new RequestHeadDTO();
        requestHeadDTO.setSeqNo(UUID.randomUUID().toString().replace("-", ""));
        requestHeadDTO.setRequestTime(new Date());
        requestHeadDTO.setOptComCode("apis");
        requestHeadDTO.setOptUserCode("apis");
        requestHeadDTO.setOptUserName("apis");
        imgBatchUploadRequestDTO.setHeadDto(requestHeadDTO);
        ImgBusiDTO imgBusiDTO = new ImgBusiDTO();
        imgBusiDTO.setAppCode("CL");
        imgBusiDTO.setClassCode("CLA");
        imgBusiDTO.setBusinessNo(businessNo);
        imgBusiDTO.setBusiComCode("apis");
        imgBatchUploadRequestDTO.setBusiDto(imgBusiDTO);
        List imgBatchUploadMetaDTOS = this.compensateImgBatchUploadMeta(request);
        imgBatchUploadRequestDTO.setUploadMetas(imgBatchUploadMetaDTOS);
        requestHeadDTO.setConsumerID(properties.get().getUser());
        requestHeadDTO.setConsumerPWD(properties.get().getUserPwd());
        return imgBatchUploadRequestDTO;
    }

    public List<ImgBatchUploadMetaDTO> compensateImgBatchUploadMeta(StanderRequest request) {
        ArrayList<ImgBatchUploadMetaDTO> uploadMetaDTOList = new ArrayList<ImgBatchUploadMetaDTO>();
        try {
            this.log.warn("\u8fdb\u5165\u7ec4\u88c5\u56fe\u7247\u65b9\u6cd5");
            List imgMetaList = request.getImgBatchUploadServiceRequest().getRequestBody().getImgList();
            for (ImgMetaDTO imgMeta : imgMetaList) {
                int i = 0;
                this.log.warn("\u8fdb\u5165\u5faa\u73af{}", (Object)i++);
                ImgBatchUploadMetaDTO imgBatchUploadMetaDTO = new ImgBatchUploadMetaDTO();
                imgBatchUploadMetaDTO.setBase64FileContent(imgMeta.getFileContentWithBase64Encode());
                imgBatchUploadMetaDTO.setFileURL(imgMeta.getFileUrl());
                if (ObjectUtil.isEmpty((Object)imgMeta.getIsCovered())) {
                    imgBatchUploadMetaDTO.setCovered(true);
                } else {
                    imgBatchUploadMetaDTO.setCovered(imgMeta.getIsCovered().booleanValue());
                }
                if (ObjectUtil.isEmpty((Object)imgMeta.getFileOrgName())) {
                    if (ObjectUtil.isNotEmpty((Object)imgMeta.getFileName()) && ObjectUtil.isNotEmpty((Object)imgMeta.getExtendName())) {
                        imgBatchUploadMetaDTO.setFileOrgName(imgMeta.getFileName() + "." + imgMeta.getExtendName());
                    }
                } else {
                    imgBatchUploadMetaDTO.setFileOrgName(imgMeta.getFileOrgName());
                }
                if (ObjectUtil.isEmpty((Object)imgMeta.getImgType())) {
                    imgBatchUploadMetaDTO.setImgType("|999|");
                } else {
                    imgBatchUploadMetaDTO.setImgType("|" + imgMeta.getImgType() + "|");
                }
                if (ObjectUtil.isEmpty((Object)imgMeta.getImgTypeName())) {
                    imgBatchUploadMetaDTO.setImgTypeName("|\u5176\u4ed6|");
                } else {
                    imgBatchUploadMetaDTO.setImgTypeName("|" + imgMeta.getImgTypeName() + "|");
                }
                uploadMetaDTOList.add(imgBatchUploadMetaDTO);
            }
        }
        catch (Exception e) {
            this.log.error("\u5f02\u5e38", (Throwable)e);
        }
        return uploadMetaDTOList;
    }

    public void insertImgBatchUploadLog(StanderRequest request, ClaimMediaCommitResult responseDTO) throws ApisBusinessException {
        String orderNo = request.getImgBatchUploadServiceRequest().getRequestBody().getOrderNo();
        try {
            CoreDtoConverter converter = this.coreDtoConverterFactory.get("JSON");
            String api = "imgBatchUpload";
            String bodyStr = converter.toPacketStr((Object)responseDTO);
            ApisBusiReqmsgLog apisBusiReqmsgLog = new ApisBusiReqmsgLog();
            apisBusiReqmsgLog.setApiCode(api);
            apisBusiReqmsgLog.setLogContent(bodyStr);
            apisBusiReqmsgLog.setLogType("2");
            apisBusiReqmsgLog.setOrderNo(orderNo);
            apisBusiReqmsgLog.setCreator(request.getHeader().getUserCode());
            this.apisBusiReqmsgLogService.save((Object)apisBusiReqmsgLog);
        }
        catch (Exception e) {
            this.log.error("\u8bb0\u5f55\u5f71\u50cf\u4e0a\u4f20\u62a5\u6587\u65f6\u51fa\u9519\uff0c\u8ba2\u5355\u53f7\uff1a{}", (Object)orderNo, (Object)e);
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10006.getValue(), ChannelErrorCodeEnum.ERR_C10006.getKey());
        }
    }

    public ImageQueryDownResponseDTO getImageDown(String businessNo) {
        ImageQueryDownRequest imageQueryDownRequest = new ImageQueryDownRequest();
        ImageQueryDownRequestDTO requestDto = new ImageQueryDownRequestDTO();
        ImageSystemBaseDTO baseData = new ImageSystemBaseDTO();
        baseData.setComCode("000000");
        baseData.setNetType("http.inner");
        baseData.setOperator("test001");
        baseData.setOperatorName("\u67e5\u8be2\u4eba\u5458");
        baseData.setOperatorRole("CLA_R01");
        ImageSystemMetaDTO metaData = new ImageSystemMetaDTO();
        metaData.setAppCode("CL");
        metaData.setClassCode("CLA");
        metaData.setBusinessNo(businessNo);
        requestDto.setBaseData(baseData);
        requestDto.setMetaData(metaData);
        boolean encFlag = this.imageUtils.imgConsumerPwdEncFlag();
        imageQueryDownRequest.setRequestHead(this.imageUtils.initImageRequestHead(encFlag));
        imageQueryDownRequest.setRequestBody(requestDto);
        String apiUrl = encFlag ? this.ePolicyDownNewUrl : this.ePolicyDownUrl;
        String jsonData = JSONObject.toJSONString((Object)imageQueryDownRequest);
        this.log.warn("\u8bf7\u6c42\u4e0b\u8f7d\u5f71\u50cf\u53c2\u6570\uff1a{}", (Object)jsonData);
        try {
            OkHttpClient okHttpClient = new OkHttpClient();
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)JSON.toJSONString((Object)imageQueryDownRequest));
            Request okRequest = new Request.Builder().url(apiUrl).post(requestBody).build();
            Response okResponse = okHttpClient.newCall(okRequest).execute();
            String responseStr = okResponse.body().string();
            ImageQueryDownResponse response = (ImageQueryDownResponse)JSON.parseObject((String)responseStr, ImageQueryDownResponse.class);
            this.log.warn("\u7406\u8d54\u5f71\u50cf\u8d44\u6599\u67e5\u8be2\u8fd4\u56de\uff1a{}", (Object)responseStr);
            if (response != null && response.getResponseBody() != null) {
                return response.getResponseBody();
            }
            this.log.error("\u5f71\u50cf\u4e0b\u8f7d\u8fd4\u56de\u9519\u8bef\uff0c{}", (Object)JSON.toJSONString((Object)response));
        }
        catch (Exception e) {
            this.log.error("\u8c03\u7528\u5f71\u50cf\u67e5\u8be2\u4e0b\u8f7d\u5f02\u5e38,", (Throwable)e);
        }
        return null;
    }
}

