/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.spring.PropertyPreFilters;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.pushAgent.ResponseBaseDto;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.constant.ModelConstants;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class CommonPushUtil {
    private static final Logger log = LoggerFactory.getLogger(CommonPushUtil.class);
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;
    public static final MediaType JSON_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    static OkHttpClient client = new OkHttpClient.Builder().connectTimeout(60L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).build();

    @Async(value="scheduleTaskNotifyExecutor")
    public void asyncNoticeComment(ApisBusiTaskLog busiTaskLog) {
        this.pushContentToUrlComment(busiTaskLog);
    }

    @Async(value="scheduleTaskNotifyExecutor")
    public <T> void asyncNoticeAgent(ApisBusiTaskLog busiTaskLog, Class<T> respType) {
        this.pushContentToUrlAgent(busiTaskLog, respType);
    }

    public <T> void pushContentToUrlAgent(ApisBusiTaskLog busiTaskLog, Class<T> respType) {
        if (ObjectUtil.isEmpty((Object)busiTaskLog)) {
            return;
        }
        if (ObjectUtil.isEmpty((Object)busiTaskLog.getPushTargetUrl())) {
            log.warn("\u4efb\u52a1businessKey={},\u6ca1\u6709\u914d\u7f6e\u63a8\u9001\u7684URL", (Object)busiTaskLog.getBusinessKey());
        }
        boolean isUpdSuccess = false;
        try {
            busiTaskLog.setPushStatus("2");
            busiTaskLog.setPushStep(Integer.valueOf(busiTaskLog.getPushStep() + 1));
            busiTaskLog.setLastPushTime(LocalDateTime.now());
            isUpdSuccess = this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
            if (isUpdSuccess) {
                Object res = this.convertAndSendForCallback(busiTaskLog.getPushTargetUrl(), (Object)busiTaskLog.getPushContent(), respType);
                ResponseBaseDto resp = null;
                if (res instanceof ResponseBaseDto) {
                    resp = (ResponseBaseDto)res;
                }
                log.warn("\u5f02\u6b65\u56de\u8c03\u54cd\u5e94\uff1a{}", (Object)resp);
                if (ObjectUtil.isNull((Object)resp)) {
                    busiTaskLog.setPushStatus("4");
                    busiTaskLog.setErrMsg("\u6e20\u9053\u672a\u8fd4\u56de\u5185\u5bb9");
                    log.warn("\u5df2\u63a8\u9001\u672a\u8fd4\u56de\uff0c\u4e1a\u52a1\u53f7\u4e3a\u53f7\u4e3a{}", (Object)busiTaskLog.getBusinessKey());
                } else {
                    if (resp.isSuccess()) {
                        busiTaskLog.setPushStatus("1");
                    } else {
                        busiTaskLog.setPushStatus("4");
                    }
                    String[] includeList = (String[])Stream.of(respType.getDeclaredFields()).map(Field::getName).toArray(String[]::new);
                    PropertyPreFilters filters = new PropertyPreFilters();
                    PropertyPreFilters.MySimplePropertyPreFilter includefilter = filters.addFilter();
                    includefilter.addIncludes(includeList);
                    busiTaskLog.setErrMsg(JSON.toJSONString((Object)resp, (SerializeFilter)includefilter, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat}));
                }
            }
        }
        catch (Exception e) {
            busiTaskLog.setPushStatus("4");
            busiTaskLog.setErrMsg(ObjectUtil.isNotEmpty((Object)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT ? e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT) : e.getMessage());
            log.error("\u5f02\u6b65\u56de\u8c03\u901a\u77e5 error:", (Throwable)e);
        }
        if (isUpdSuccess) {
            this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
        }
    }

    public void pushContentToUrlComment(ApisBusiTaskLog busiTaskLog) {
        if (ObjectUtil.isEmpty((Object)busiTaskLog)) {
            return;
        }
        if (ObjectUtil.isEmpty((Object)busiTaskLog.getPushTargetUrl())) {
            log.warn("\u4efb\u52a1businessKey={},\u6ca1\u6709\u914d\u7f6e\u63a8\u9001\u7684URL", (Object)busiTaskLog.getBusinessKey());
        }
        boolean isUpdSuccess = false;
        try {
            busiTaskLog.setPushStatus("2");
            busiTaskLog.setPushStep(Integer.valueOf(busiTaskLog.getPushStep() + 1));
            busiTaskLog.setLastPushTime(LocalDateTime.now());
            isUpdSuccess = this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
            if (isUpdSuccess) {
                Response resp = (Response)this.convertAndSendForCallback(busiTaskLog.getPushTargetUrl(), (Object)busiTaskLog.getPushContent(), Response.class);
                log.warn("\u5f02\u6b65\u56de\u8c03\u54cd\u5e94\uff1a{}", (Object)resp);
                if (null != resp && resp.isSuccessful()) {
                    busiTaskLog.setPushStatus("1");
                } else {
                    busiTaskLog.setPushStatus("4");
                }
                if (null != resp) {
                    busiTaskLog.setErrMsg(resp.toString());
                }
            }
        }
        catch (Exception e) {
            busiTaskLog.setPushStatus("4");
            busiTaskLog.setErrMsg(ObjectUtil.isNotEmpty((Object)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT ? e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT) : e.getMessage());
            log.error("\u5f02\u6b65\u56de\u8c03\u901a\u77e5 error:", (Throwable)e);
        }
        if (isUpdSuccess) {
            this.apisBusiTaskLogService.updateById((Object)busiTaskLog);
        }
    }

    public <T> T convertAndSendForCallback(String url, Object body, Class<T> respType) {
        Date startDate = new Date();
        try {
            Object resp;
            String requestBodyStr = body instanceof String ? (String)body : JSON.toJSONString((Object)body);
            RequestBody requestBody = RequestBody.create((MediaType)JSON_TYPE, (String)requestBodyStr);
            Request request = new Request.Builder().url(url).post(requestBody).build();
            log.warn("\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)requestBodyStr);
            Call call = client.newCall(request);
            Response response = call.execute();
            if (respType == Response.class) {
                resp = response;
            } else if (respType == String.class) {
                resp = response.body().string();
            } else {
                String responseBodyStr = response.body().string();
                log.warn("\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)responseBodyStr);
                resp = JSON.parseObject((String)responseBodyStr, respType);
            }
            Response response2 = resp;
            return (T)response2;
        }
        catch (Exception e) {
            log.error("=============call api error :{}", (Object)url);
            throw new RuntimeException(e);
        }
        finally {
            log.warn("\u63a8\u9001\u7528\u65f6:{}", (Object)(System.currentTimeMillis() - startDate.getTime()));
        }
    }
}

