/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils;

import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.request.ClaimMediaCommitResult;
import com.jdaz.sinosoftgz.apis.constants.ErrorBisCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class DataCompletionUtil {
    private static Logger log = LoggerFactory.getLogger(DataCompletionUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkNotNull(Object object, String[] strings, Object[] objects, Map<Integer, Object> resultMap) {
        String methodName = "";
        Method method = null;
        Object obj = null;
        for (int i = 0; i < strings.length; ++i) {
            methodName = "get" + strings[i];
            method = BeanUtils.findMethod(object.getClass(), (String)methodName, (Class[])new Class[0]);
            try {
                obj = method.invoke(object, new Object[0]);
                continue;
            }
            catch (Exception e) {
                obj = null;
                log.error("\n\u7cfb\u7edf\u5f02\u5e38 ", (Throwable)e);
            }
            finally {
                if (!ObjectUtil.isEmpty((Object)obj) || !(objects[i] instanceof ErrorNullValueCodeEnum)) continue;
                resultMap.put(resultMap.size() + 1, objects[i]);
                break;
            }
        }
    }

    public static void verificationMediaSubmit(ClaimMediaCommitResult claimMediaCommitResult) throws ApisBusinessException {
        if (ObjectUtil.isNotEmpty((Object)claimMediaCommitResult)) {
            if (!(ObjectUtil.isNotEmpty((Object)claimMediaCommitResult.getHeadDto()) && ObjectUtil.isNotEmpty((Object)claimMediaCommitResult.getImgNodes()) && ObjectUtil.isNotEmpty((Object)claimMediaCommitResult.getSize()))) {
                log.error("\n\u8d44\u6599\u5173\u8054\u63a5\u53e3\uff0c\u8c03\u7528\u8d44\u6599\u4e0a\u4f20\u63a5\u53e3\u5fc5\u8fd4\u4fe1\u606f\u4e3a\u7a7a");
                throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N50001.getKey(), ErrorNullValueCodeEnum.ERR_N50001.getValue());
            }
        } else {
            log.error("\n\u8d44\u6599\u5173\u8054\u63a5\u53e3\uff0c\u8c03\u7528\u8d44\u6599\u4e0a\u4f20\u63a5\u53e3\u54cd\u5e94\u5b9e\u4f53\u4e3a\u7a7a");
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N00002.getKey(), ErrorNullValueCodeEnum.ERR_N00002.getValue());
        }
    }

    public static void verificationResponse(StanderResponse standerResponse, String proName) throws ApisBusinessException {
        Object serviceResponse;
        boolean flag = true;
        if (ObjectUtil.isNotEmpty((Object)standerResponse) && ObjectUtils.isNotEmpty((Object)(serviceResponse = DataCompletionUtil.getProperty((Object)standerResponse, (String)proName)))) {
            flag = false;
        }
        if (flag) {
            log.error("\n" + ErrorNullValueCodeEnum.ERR_N00002.getValue() + ":{}", (Object)proName);
            throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B00002.getKey(), ErrorBisCodeEnum.ERR_B00002.getValue());
        }
    }

    private static Object getProperty(Object object, String proName) throws ApisBusinessException {
        if (object == null || StringUtils.isEmpty((CharSequence)proName)) {
            log.error("getProperty\u65b9\u6cd5\u5165\u53c2\u5f02\u5e38, object:{}, proName:{}", object, (Object)proName);
            throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N50001.getValue(), ErrorNullValueCodeEnum.ERR_N50001.getKey());
        }
        Class<?> aClass = object.getClass();
        PropertyDescriptor propertyDp = BeanUtils.getPropertyDescriptor(aClass, (String)proName);
        assert (propertyDp != null);
        Method readMethod = propertyDp.getReadMethod();
        if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
            readMethod.setAccessible(true);
        }
        try {
            return readMethod.invoke(object, new Object[0]);
        }
        catch (Throwable ex) {
            log.error("\u83b7\u53d6{}\u7c7b\u4e2d\u7684{}\u5c5e\u6027\u65f6\u53d1\u751f\u5f02\u5e38", (Object)aClass.getName(), (Object)proName);
            log.error("\u5f02\u5e38\u5806\u6808", ex);
            return null;
        }
    }
}

