/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.consts.EcoConstants;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.consts.EcoErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.consts.ErrorCode;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.consts.config.CcustomerBeneficiaryInfoConfigJsonVo;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.consts.config.CcustomerCertifyInfoConfigJsonVo;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.consts.config.EcoClaimConfigJsonVo;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.EcoSignUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.CcustomerBeneficiaryInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.CcustomerCertifyInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.CcustomerInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.ClaimOpenBillEcoRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.ClaimOpenBillRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.ClaimOpenBillServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.CollectInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.CollectguideInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.CompensateInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.LossPropInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.PayPersonInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.RegistDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.RegistDamageInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.RegistInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.regist.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelUser;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelCodeService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelUserService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class EcoRegistDataCompletion {
    private static final Logger log = LoggerFactory.getLogger(EcoRegistDataCompletion.class);
    @Autowired
    ApisChannelCodeService apisChannelCodeService;
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    ApisChannelUserService apisChannelUserService;
    @Value(value="${yaopinbao.secretKey}")
    private String ecoSecret;
    private static EcoClaimConfigJsonVo ECO_CONFIG;

    public void checkSign(ClaimOpenBillEcoRequest claimOpenBillEcoRequest) throws ApisBusinessException {
        try {
            String uuid = claimOpenBillEcoRequest.getGeneralInfo().getUuid();
            String businessValue = claimOpenBillEcoRequest.getClaimOpenBillEco().getSumLoss().toString();
            String originSign = claimOpenBillEcoRequest.getGeneralInfo().getMd5Value();
            String sign = EcoSignUtil.sign((String)uuid, (String)this.ecoSecret, (String[])new String[]{businessValue});
            if (!originSign.equals(sign)) {
                throw new ApisBusinessException(EcoErrorCodeEnum.ERROR_C04.getValue(), EcoErrorCodeEnum.ERROR_C04.getKey());
            }
        }
        catch (Exception e) {
            throw new ApisBusinessException(EcoErrorCodeEnum.ERROR_C04.getValue(), EcoErrorCodeEnum.ERROR_C04.getKey());
        }
    }

    public void checkRequest(StanderRequest request) throws ApisBusinessException {
        if (ObjectUtils.isEmpty((Object)request)) {
            throw new ApisDataCompletionException("\u8bf7\u6c42\u62a5\u6587 " + ErrorCode.NOT_NULL.getMessage(), ErrorCode.NOT_NULL.getCode());
        }
        if (ObjectUtils.isEmpty((Object)request.getClaimOpenBillEcoRequest())) {
            throw new ApisDataCompletionException("\u8bf7\u6c42\u5bf9\u8c61\u3010claimOpenBillEcoRequest\u3011" + ErrorCode.NOT_NULL.getMessage(), ErrorCode.NOT_NULL.getCode());
        }
        if (ObjectUtils.isEmpty((Object)request.getClaimOpenBillEcoRequest().getGeneralInfo())) {
            throw new ApisDataCompletionException("\u8bf7\u6c42\u5bf9\u8c61\u3010generalInfo\u3011 " + ErrorCode.NOT_NULL.getMessage(), ErrorCode.NOT_NULL.getCode());
        }
        if (ObjectUtils.isEmpty((Object)request.getClaimOpenBillEcoRequest().getClaimOpenBillEco())) {
            throw new ApisDataCompletionException("\u8bf7\u6c42\u5bf9\u8c61\u3010claimOpenBillEco\u3011 " + ErrorCode.NOT_NULL.getMessage(), ErrorCode.NOT_NULL.getCode());
        }
    }

    public void checkData(ClaimOpenBillEcoRequest ecoRequest) throws ApisBusinessException {
        this.checkNotNull(ecoRequest);
        this.checkOrder(ecoRequest);
    }

    private void checkOrder(ClaimOpenBillEcoRequest ecoRequest) throws ApisDataCompletionException {
        if (!this.apisBusiChannelOrderService.isExistOrder(ecoRequest.getClaimOpenBillEco().getPolicyNo()).booleanValue()) {
            throw new ApisDataCompletionException(EcoErrorCodeEnum.ERROR_C07.getValue(), EcoErrorCodeEnum.ERROR_C07.getKey());
        }
    }

    private void checkNotNull(ClaimOpenBillEcoRequest ecoRequest) throws ApisBusinessException {
        if (StringUtils.isBlank((CharSequence)ecoRequest.getGeneralInfo().getUuid())) {
            throw new ApisDataCompletionException("\u6d41\u6c34\u53f7:UUID " + ErrorCode.NOT_NULL.getMessage(), ErrorCode.NOT_NULL.getCode());
        }
        if (StringUtils.isBlank((CharSequence)ecoRequest.getGeneralInfo().getMd5Value())) {
            throw new ApisDataCompletionException("\u7b7e\u540d:Md5Value " + ErrorCode.NOT_NULL.getMessage(), ErrorCode.NOT_NULL.getCode());
        }
        if (StringUtils.isBlank((CharSequence)ecoRequest.getClaimOpenBillEco().getPolicyNo())) {
            throw new ApisDataCompletionException("\u4fdd\u5355\u53f7:PolicyNo " + ErrorCode.NOT_NULL.getMessage(), ErrorCode.NOT_NULL.getCode());
        }
        if (StringUtils.isBlank((CharSequence)ecoRequest.getClaimOpenBillEco().getReportorName())) {
            throw new ApisDataCompletionException("\u62a5\u6848\u4eba\u59d3\u540d:ReportorName " + ErrorCode.NOT_NULL.getMessage(), ErrorCode.NOT_NULL.getCode());
        }
        if (StringUtils.isBlank((CharSequence)ecoRequest.getClaimOpenBillEco().getReportorMobile())) {
            throw new ApisDataCompletionException("\u62a5\u6848\u4eba\u7535\u8bdd:ReportorNumber " + ErrorCode.NOT_NULL.getMessage(), ErrorCode.NOT_NULL.getCode());
        }
        if (StringUtils.isBlank((CharSequence)ecoRequest.getClaimOpenBillEco().getDamageFlag())) {
            throw new ApisDataCompletionException("\u51fa\u9669\u6807\u8bc6:DamageFlag " + ErrorCode.NOT_NULL.getMessage(), ErrorCode.NOT_NULL.getCode());
        }
        if (StringUtils.isBlank((CharSequence)ecoRequest.getClaimOpenBillEco().getDamageTime())) {
            throw new ApisDataCompletionException("\u51fa\u9669\u65f6\u95f4:DamageTime " + ErrorCode.NOT_NULL.getMessage(), ErrorCode.NOT_NULL.getCode());
        }
        if (StringUtils.isBlank((CharSequence)ecoRequest.getClaimOpenBillEco().getDamageAddress())) {
            throw new ApisDataCompletionException("\u51fa\u9669\u5730\u70b9:DamageAddress " + ErrorCode.NOT_NULL.getMessage(), ErrorCode.NOT_NULL.getCode());
        }
        if (ObjectUtils.isEmpty((Object)ecoRequest.getClaimOpenBillEco().getSumLoss())) {
            throw new ApisDataCompletionException("\u6838\u635f\u91d1\u989d:SumLoss " + ErrorCode.NOT_NULL.getMessage(), ErrorCode.NOT_NULL.getCode());
        }
        if (StringUtils.isBlank((CharSequence)ecoRequest.getClaimOpenBillEco().getAccountName())) {
            throw new ApisDataCompletionException("\u8d26\u6237\u59d3\u540d:AccountName " + ErrorCode.NOT_NULL.getMessage(), ErrorCode.NOT_NULL.getCode());
        }
        if (StringUtils.isBlank((CharSequence)ecoRequest.getClaimOpenBillEco().getBankAccount())) {
            throw new ApisDataCompletionException("\u94f6\u884c\u8d26\u6237:BankAccount " + ErrorCode.NOT_NULL.getMessage(), ErrorCode.NOT_NULL.getCode());
        }
        if (StringUtils.isBlank((CharSequence)ecoRequest.getClaimOpenBillEco().getOpenBankName())) {
            throw new ApisDataCompletionException("\u5f00\u6237\u94f6\u884c:OpenBankName " + ErrorCode.NOT_NULL.getMessage(), ErrorCode.NOT_NULL.getCode());
        }
        if (StringUtils.isBlank((CharSequence)ecoRequest.getClaimOpenBillEco().getPayeeName())) {
            throw new ApisDataCompletionException("\u9886\u6b3e\u4eba\u59d3\u540d:PayeeName " + ErrorCode.NOT_NULL.getMessage(), ErrorCode.NOT_NULL.getCode());
        }
        if (StringUtils.isBlank((CharSequence)ecoRequest.getClaimOpenBillEco().getIdentifyNumber())) {
            throw new ApisDataCompletionException("\u9ed8\u8ba4\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801:IdentifyNumber " + ErrorCode.NOT_NULL.getMessage(), ErrorCode.NOT_NULL.getCode());
        }
    }

    public void completion(StanderRequest request) {
        ClaimOpenBillEcoRequest ecoRequest = request.getClaimOpenBillEcoRequest();
        ClaimOpenBillRequestDTO claimBody = new ClaimOpenBillRequestDTO();
        claimBody.setReportType("08");
        claimBody.setStep("endcase");
        claimBody.setExternalID(ecoRequest.getGeneralInfo().getUuid());
        claimBody.setStatus("1");
        claimBody.setPolicyNo(ecoRequest.getClaimOpenBillEco().getPolicyNo());
        RegistDTO registDTO = this.convertRegistDTO(ecoRequest);
        claimBody.setRegist(registDTO);
        List compensateInfoList = this.convertCompensateInfo(ecoRequest);
        claimBody.setCompensateInfoList(compensateInfoList);
        CollectInfoDTO collectInfoDTO = this.convertCollectInfo(ecoRequest);
        claimBody.setCollectInfo(collectInfoDTO);
        RequestHeadDTO head = this.convertHead(request);
        ClaimOpenBillServiceRequest claimRequest = ClaimOpenBillServiceRequest.builder().head(head).body(claimBody).build();
        request.setClaimOpenBillServiceRequest(claimRequest);
    }

    private RequestHeadDTO convertHead(StanderRequest request) {
        String transId = request.getClaimOpenBillEcoRequest().getGeneralInfo().getUuid();
        String user = request.getHeader().getUserCode();
        String password = null;
        ApisChannelUser channelUser = this.apisChannelUserService.getUserByUserCode(user);
        if (ObjectUtils.isNotEmpty((Object)channelUser)) {
            password = channelUser.getPwd();
        }
        return RequestHeadDTO.builder().transID(transId).transType("C001").transDate(new Date()).user(user).password(password).build();
    }

    private CollectInfoDTO convertCollectInfo(ClaimOpenBillEcoRequest ecoRequest) {
        CollectInfoDTO collectInfoDTO = new CollectInfoDTO();
        collectInfoDTO.setClaimApplyTime(new Date());
        collectInfoDTO.setNotifyTime(new Date());
        collectInfoDTO.setEndTime(new Date());
        collectInfoDTO.setSource("1");
        collectInfoDTO.setStatus("4");
        ArrayList<CollectguideInfoDTO> collectguideInfo = new ArrayList<CollectguideInfoDTO>();
        CollectguideInfoDTO collectguideInfoDTO = new CollectguideInfoDTO();
        collectguideInfoDTO.setDocCode("999");
        collectguideInfoDTO.setDocName("\u5176\u4ed6");
        collectguideInfoDTO.setPicCount("4");
        collectguideInfoDTO.setEndDate(new Date());
        collectguideInfo.add(collectguideInfoDTO);
        collectInfoDTO.setCollectguideInfo(collectguideInfo);
        return collectInfoDTO;
    }

    private List<CompensateInfoDTO> convertCompensateInfo(ClaimOpenBillEcoRequest ecoRequest) {
        ArrayList<CompensateInfoDTO> compensateInfoList = new ArrayList<CompensateInfoDTO>();
        CompensateInfoDTO compensateInfoDTO = new CompensateInfoDTO();
        compensateInfoDTO.setCaseType("0");
        compensateInfoDTO.setUnderwriteFlag("3");
        compensateInfoDTO.setCompensateType("1");
        compensateInfoDTO.setSumRealPay(ecoRequest.getClaimOpenBillEco().getSumLoss());
        ArrayList<LossPropInfoDTO> lossPropInfo = new ArrayList<LossPropInfoDTO>();
        LossPropInfoDTO lossPropInfoDTO = new LossPropInfoDTO();
        lossPropInfoDTO.setSumLoss(ecoRequest.getClaimOpenBillEco().getSumLoss());
        lossPropInfoDTO.setSumRealPay(ecoRequest.getClaimOpenBillEco().getSumLoss());
        lossPropInfoDTO.setLossName("\u836f\u54c1");
        lossPropInfoDTO.setCurrency("RMB");
        lossPropInfoDTO.setKindCode(this.getEcoConfig().getKindCode());
        lossPropInfo.add(lossPropInfoDTO);
        compensateInfoDTO.setLossPropInfo(lossPropInfo);
        ArrayList<PayPersonInfoDTO> payPersonInfoList = new ArrayList<PayPersonInfoDTO>();
        PayPersonInfoDTO payPersonInfoDTO = new PayPersonInfoDTO();
        payPersonInfoDTO.setCertifyType("74");
        payPersonInfoDTO.setCertifyNo(ecoRequest.getClaimOpenBillEco().getIdentifyNumber());
        if (this.getEcoConfig().getCcustomerInfo().getInsureComName().equals(ecoRequest.getClaimOpenBillEco().getPayeeName())) {
            payPersonInfoDTO.setPayObjectKind("01");
        } else {
            payPersonInfoDTO.setPayObjectKind("99");
            payPersonInfoDTO.setOtherCause("01");
        }
        payPersonInfoDTO.setNationFlag("1");
        payPersonInfoDTO.setPayeeName(ecoRequest.getClaimOpenBillEco().getAccountName());
        payPersonInfoDTO.setBankCode(ecoRequest.getClaimOpenBillEco().getOpenBankCode());
        payPersonInfoDTO.setBankName(ecoRequest.getClaimOpenBillEco().getOpenBankBranchName());
        payPersonInfoDTO.setAccountNo(ecoRequest.getClaimOpenBillEco().getBankAccount());
        payPersonInfoDTO.setCurrency("RMB");
        payPersonInfoDTO.setPayment("02");
        payPersonInfoDTO.setPayObjectType("2");
        payPersonInfoDTO.setPayNowFlag("0");
        payPersonInfoDTO.setPayeeNationality("\u4e2d\u56fd");
        payPersonInfoDTO.setPaymentType("02");
        payPersonInfoDTO.setPayeeFee(ecoRequest.getClaimOpenBillEco().getSumLoss());
        if (ecoRequest.getClaimOpenBillEco().getSumLoss().compareTo(EcoConstants.CLAIM_NEED_FXQ_MAX) > -1) {
            CcustomerInfo ccustomerInfo = new CcustomerInfo();
            ccustomerInfo.setInsureComName(this.getEcoConfig().getCcustomerInfo().getInsureComName());
            ccustomerInfo.setIndustryName(this.getEcoConfig().getCcustomerInfo().getIndustryName());
            ccustomerInfo.setInsureComAddress(this.getEcoConfig().getCcustomerInfo().getInsureComAddress());
            ccustomerInfo.setInsureComBussScope(this.getEcoConfig().getCcustomerInfo().getInsureComBussScope());
            ccustomerInfo.setInsureComBusinessCode(this.getEcoConfig().getCcustomerInfo().getInsureComBusinessCode());
            ccustomerInfo.setRegistCapitalAmount(this.getEcoConfig().getCcustomerInfo().getRegistCapitalAmount());
            ccustomerInfo.setRegistCapitalCurrency(this.getEcoConfig().getCcustomerInfo().getRegistCapitalCurrency());
            ArrayList<CcustomerCertifyInfo> certifyInfoList = new ArrayList<CcustomerCertifyInfo>();
            for (int i = 0; i < this.getEcoConfig().getCcustomerInfo().getCcustomerCertifyInfo().size(); ++i) {
                CcustomerCertifyInfo certifyInfo = new CcustomerCertifyInfo();
                certifyInfo.setCertifyOrPersonFlag(((CcustomerCertifyInfoConfigJsonVo)this.getEcoConfig().getCcustomerInfo().getCcustomerCertifyInfo().get(i)).getCertifyOrPersonFlag());
                certifyInfo.setCertifyOrPersonType(((CcustomerCertifyInfoConfigJsonVo)this.getEcoConfig().getCcustomerInfo().getCcustomerCertifyInfo().get(i)).getCertifyOrPersonType());
                certifyInfo.setCertifyType(((CcustomerCertifyInfoConfigJsonVo)this.getEcoConfig().getCcustomerInfo().getCcustomerCertifyInfo().get(i)).getCertifyType());
                certifyInfo.setCertifyName(((CcustomerCertifyInfoConfigJsonVo)this.getEcoConfig().getCcustomerInfo().getCcustomerCertifyInfo().get(i)).getCertifyName());
                certifyInfo.setCertifyNo(((CcustomerCertifyInfoConfigJsonVo)this.getEcoConfig().getCcustomerInfo().getCcustomerCertifyInfo().get(i)).getCertifyNo());
                certifyInfo.setValidDate(((CcustomerCertifyInfoConfigJsonVo)this.getEcoConfig().getCcustomerInfo().getCcustomerCertifyInfo().get(i)).getValidDate());
                certifyInfoList.add(certifyInfo);
            }
            ccustomerInfo.setCcustomerCertifyInfo(certifyInfoList);
            ArrayList<CcustomerBeneficiaryInfo> beneficiaryInfoList = new ArrayList<CcustomerBeneficiaryInfo>();
            for (int i = 0; i < this.getEcoConfig().getCcustomerInfo().getCcustomerBeneficiaryInfo().size(); ++i) {
                CcustomerBeneficiaryInfo beneficiaryInfo = new CcustomerBeneficiaryInfo();
                beneficiaryInfo.setBeneficiaryName(((CcustomerBeneficiaryInfoConfigJsonVo)this.getEcoConfig().getCcustomerInfo().getCcustomerBeneficiaryInfo().get(i)).getBeneficiaryName());
                beneficiaryInfo.setBeneficiaryNationality(((CcustomerBeneficiaryInfoConfigJsonVo)this.getEcoConfig().getCcustomerInfo().getCcustomerBeneficiaryInfo().get(i)).getBeneficiaryNationality());
                beneficiaryInfo.setBeneficiaryOccupation(((CcustomerBeneficiaryInfoConfigJsonVo)this.getEcoConfig().getCcustomerInfo().getCcustomerBeneficiaryInfo().get(i)).getBeneficiaryOccupation());
                beneficiaryInfo.setBeneficiaryAddressType(((CcustomerBeneficiaryInfoConfigJsonVo)this.getEcoConfig().getCcustomerInfo().getCcustomerBeneficiaryInfo().get(i)).getBeneficiaryAddressType());
                beneficiaryInfo.setBeneficiaryAddress(((CcustomerBeneficiaryInfoConfigJsonVo)this.getEcoConfig().getCcustomerInfo().getCcustomerBeneficiaryInfo().get(i)).getBeneficiaryAddress());
                beneficiaryInfo.setBeneficiaryCertifyType(((CcustomerBeneficiaryInfoConfigJsonVo)this.getEcoConfig().getCcustomerInfo().getCcustomerBeneficiaryInfo().get(i)).getBeneficiaryCertifyType());
                beneficiaryInfo.setBeneficiaryCertifyNo(((CcustomerBeneficiaryInfoConfigJsonVo)this.getEcoConfig().getCcustomerInfo().getCcustomerBeneficiaryInfo().get(i)).getBeneficiaryCertifyNo());
                beneficiaryInfo.setBeneficiaryCertifyValidDate(((CcustomerBeneficiaryInfoConfigJsonVo)this.getEcoConfig().getCcustomerInfo().getCcustomerBeneficiaryInfo().get(i)).getBeneficiaryCertifyValidDate());
                beneficiaryInfo.setInsuredRelationCode(((CcustomerBeneficiaryInfoConfigJsonVo)this.getEcoConfig().getCcustomerInfo().getCcustomerBeneficiaryInfo().get(i)).getInsuredRelationCode());
                beneficiaryInfo.setInsuredRelationName(((CcustomerBeneficiaryInfoConfigJsonVo)this.getEcoConfig().getCcustomerInfo().getCcustomerBeneficiaryInfo().get(i)).getInsuredRelationName());
                beneficiaryInfo.setInsuredRelationDetail(((CcustomerBeneficiaryInfoConfigJsonVo)this.getEcoConfig().getCcustomerInfo().getCcustomerBeneficiaryInfo().get(i)).getInsuredRelationDetail());
                beneficiaryInfo.setPayeeRelationCode(((CcustomerBeneficiaryInfoConfigJsonVo)this.getEcoConfig().getCcustomerInfo().getCcustomerBeneficiaryInfo().get(i)).getPayeeRelationCode());
                beneficiaryInfo.setPayeeRelationName(((CcustomerBeneficiaryInfoConfigJsonVo)this.getEcoConfig().getCcustomerInfo().getCcustomerBeneficiaryInfo().get(i)).getPayeeRelationName());
                beneficiaryInfo.setPayeeRelationDetail(((CcustomerBeneficiaryInfoConfigJsonVo)this.getEcoConfig().getCcustomerInfo().getCcustomerBeneficiaryInfo().get(i)).getPayeeRelationDetail());
                beneficiaryInfoList.add(beneficiaryInfo);
            }
            ccustomerInfo.setCcustomerBeneficiaryInfo(beneficiaryInfoList);
            String jsonString = JSON.toJSONString((Object)ccustomerInfo);
            log.warn(jsonString);
            payPersonInfoDTO.setCcustomerInfo(ccustomerInfo);
        }
        payPersonInfoList.add(payPersonInfoDTO);
        compensateInfoDTO.setPayPersonInfo(payPersonInfoList);
        compensateInfoDTO.setClaimOpinionInfo((List)Lists.newArrayList());
        compensateInfoList.add(compensateInfoDTO);
        return compensateInfoList;
    }

    private RegistDTO convertRegistDTO(ClaimOpenBillEcoRequest ecoRequest) {
        RegistInfoDTO registInfoDTO = new RegistInfoDTO();
        registInfoDTO.setReportTime(new Date());
        registInfoDTO.setReportType("08");
        registInfoDTO.setReportChannel(this.getEcoConfig().getReportChannel());
        registInfoDTO.setReportorName(ecoRequest.getClaimOpenBillEco().getReportorName());
        registInfoDTO.setReportorPhone("13333333333");
        registInfoDTO.setReportorRelation("99");
        registInfoDTO.setLinkerName(ecoRequest.getClaimOpenBillEco().getReportorName());
        registInfoDTO.setLinkerPhone("13333333333");
        RegistDamageInfoDTO registDamageInfoDTO = new RegistDamageInfoDTO();
        registDamageInfoDTO.setDamageTime((Date)DateUtil.parse((CharSequence)ecoRequest.getClaimOpenBillEco().getDamageTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        registDamageInfoDTO.setDamageReasonType("9");
        registDamageInfoDTO.setDamageCode("199");
        registDamageInfoDTO.setDamageResult("99");
        registDamageInfoDTO.setNationFlag("1");
        registDamageInfoDTO.setProvinceCode("999999");
        registDamageInfoDTO.setProvinceName("\u5168\u4e2d\u56fd");
        registDamageInfoDTO.setCityCode("999999");
        registDamageInfoDTO.setCityName("\u5168\u4e2d\u56fd");
        registDamageInfoDTO.setCountyCode("999999");
        registDamageInfoDTO.setCountyName("\u5168\u4e2d\u56fd");
        registDamageInfoDTO.setAccidentAddress(ecoRequest.getClaimOpenBillEco().getDamageAddress());
        registDamageInfoDTO.setCurrency("RMB");
        registDamageInfoDTO.setReportedLoss(ecoRequest.getClaimOpenBillEco().getSumLoss());
        return RegistDTO.builder().registInfo(registInfoDTO).registDamageInfo(registDamageInfoDTO).build();
    }

    private EcoClaimConfigJsonVo getEcoConfig() {
        if (ObjectUtils.isEmpty((Object)ECO_CONFIG)) {
            String configJson = this.apisChannelConfigsService.getConfigValue("ECO_CLAIM_JSON_CONFIG");
            ECO_CONFIG = (EcoClaimConfigJsonVo)JSON.parseObject((String)configJson, EcoClaimConfigJsonVo.class);
        }
        return ECO_CONFIG;
    }
}

