/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderMapRequestWrapper
extends HttpServletRequestWrapper {
    private Logger log = LoggerFactory.getLogger(HeaderMapRequestWrapper.class);
    private Map<String, String> headerMap = new HashMap();

    public HeaderMapRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public void addHeader(String name, String value) {
        this.headerMap.put(name, value);
    }

    public String getHeader(String name) {
        this.log.warn("getHeader --->{}", (Object)name);
        String headerValue = super.getHeader(name);
        if (this.headerMap.containsKey(name)) {
            headerValue = (String)this.headerMap.get(name);
        }
        return headerValue;
    }

    public Enumeration<String> getHeaderNames() {
        ArrayList names = Collections.list(super.getHeaderNames());
        for (String name : this.headerMap.keySet()) {
            names.add(name);
        }
        return Collections.enumeration(names);
    }

    public Enumeration<String> getHeaders(String name) {
        this.log.warn("getHeaders --->>>>>>{}", (Object)name);
        List<Object> values = Collections.list(super.getHeaders(name));
        this.log.warn("getHeaders --->>>>>>{}", values);
        if (this.headerMap.containsKey(name)) {
            this.log.warn("getHeaders --->{}", this.headerMap.get(name));
            values = Arrays.asList((String)this.headerMap.get(name));
        }
        return Collections.enumeration(values);
    }
}

