/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.claimsapp.utils.CommonPushUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.constants.BusinessConstants;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.claimCaseStatus.ClaimCaseStatusRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.claimDocCollectInfo.ClaimDocCollectInfoDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.claimRegistInfo.ClaimRegistInfoRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.huiZe.CaseType;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.huiZe.CaseTypeInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.huiZe.DangerInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.huiZe.ExtendInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.huiZe.FileInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.huiZe.HzCaseInfoRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.huiZe.HzCaseStatusDto;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.huiZe.HzCaseStatusRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.huiZe.HzRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.huiZe.HzResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiRequestRegist;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.mapper.ApisChannelCodeMapper;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HuiZeUtil {
    private static final Logger log = LoggerFactory.getLogger(HuiZeUtil.class);
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    private ApisChannelCodeMapper apisChannelCodeMapper;
    @Autowired
    private CommonPushUtil commonPushUtil;
    @Autowired
    ApisBusiTaskLogService apisBusiTaskLogService;
    public static String CHANNEL_CODE = "JDAL";

    public String dealRegistPushMessage(ApisBusiRequestRegist apisBusiRequestRegist, ClaimRegistInfoRequestDTO mqBody) {
        if (!this.isHuiZeCase(apisBusiRequestRegist.getChannelCode())) {
            return null;
        }
        HzCaseInfoRequest request = HzCaseInfoRequest.builder().companyCaseId(mqBody.getRegistNo()).policyNo(mqBody.getPolicyNo()).reportTime(mqBody.getReportTime()).reporterName(mqBody.getReportorName()).reporterMobile(mqBody.getReportorPhone()).reporterEmail(mqBody.getReportorEmail()).relationship((Integer)BusinessConstants.HUI_ZE_CONSTANTS.RELATIONSHIP_MAP.get(mqBody.getReportorRelation())).dangerTime(mqBody.getDamageTime()).dangerAddress(mqBody.getDamageAddress()).dangerDetail(mqBody.getDamageRemark()).linkEmail(mqBody.getLinkerEmail()).linkName(mqBody.getLinkerName()).linkMobile(mqBody.getLinkerPhone()).hospital(this.apisChannelCodeMapper.getCoreValue(null, "hospital", mqBody.getHospitalCode())).caseNature(Integer.valueOf(1)).build();
        if ("1".equals(mqBody.getNationFlag())) {
            request.setDangerCountryCode("0");
            request.setDangerCountry("\u4e2d\u56fd");
        } else {
            request.setDangerCountryCode("1");
            String countryName = this.apisChannelCodeMapper.getValueDesc(null, "PRPDCOUNTRY", mqBody.getCountryCode());
            request.setDangerCountry(countryName);
        }
        String provinceName = this.apisChannelCodeMapper.getValueDesc(null, "province", mqBody.getProvinceCode());
        String cityName = this.apisChannelCodeMapper.getValueDesc(null, "city", mqBody.getCityCode());
        String countyName = this.apisChannelCodeMapper.getValueDesc(null, "subCity", mqBody.getCountyCode());
        request.setDangerProvince(provinceName);
        request.setDangerProvinceCode(mqBody.getProvinceCode());
        request.setDangerCityCode(mqBody.getCityCode());
        request.setDangerCity(cityName);
        request.setDangerDistrictCode(mqBody.getCountyCode());
        request.setDangerDistrict(countyName);
        ArrayList<DangerInfo> list = new ArrayList<DangerInfo>();
        list.add(DangerInfo.builder().insurant(mqBody.getDamagePersonName()).cardNumber(mqBody.getIdentifyNo()).policyCompanyNum(mqBody.getPolicyNo()).build());
        request.setDangerInfoList(list);
        if (BusinessConstants.HUI_ZE_CONSTANTS.SECOND_CASE_SET.contains(mqBody.getDamageReasonType()) || BusinessConstants.HUI_ZE_CONSTANTS.SECOND_CASE_SET.contains(mqBody.getDamageResult())) {
            String key = "";
            key = ObjectUtil.isEmpty((Object)mqBody.getDamageReasonType()) || "9".equals(mqBody.getDamageReasonType()) ? mqBody.getDamageResult() : mqBody.getDamageReasonType();
            String mapValue = (String)BusinessConstants.HUI_ZE_CONSTANTS.SECOND_CASE_MAP.get(key = key + "," + mqBody.getDamageResult());
            if (ObjectUtil.isEmpty((Object)mapValue)) {
                request.setCaseTypes(this.getCaseTypes("64", "65"));
            } else {
                String[] values = mapValue.split(",");
                if (ObjectUtil.isEmpty((Object)values)) {
                    request.setCaseTypes(this.getCaseTypes("64", "65"));
                } else {
                    request.setCaseTypes(this.getCaseTypes(values[1], values[0]));
                }
            }
        } else {
            request.setCaseTypes(this.getCaseTypes("64", "65"));
        }
        return JSON.toJSONString((Object)request);
    }

    private List<CaseType> getCaseTypes(String code1, String code2) {
        CaseTypeInfo frist = CaseTypeInfo.builder().id(Integer.valueOf(code1)).name((String)BusinessConstants.HUI_ZE_CONSTANTS.CASE_CODE_NAME.get(code1)).build();
        CaseTypeInfo second = CaseTypeInfo.builder().id(Integer.valueOf(code2)).name(((String)BusinessConstants.HUI_ZE_CONSTANTS.CASE_CODE_NAME.get(code2)).split(",")[0]).alias(((String)BusinessConstants.HUI_ZE_CONSTANTS.CASE_CODE_NAME.get(code2)).split(",")[1]).build();
        CaseType caseType = CaseType.builder().firstCaseType(frist).secondCaseType(second).build();
        ArrayList<CaseType> caseTypes = new ArrayList<CaseType>();
        caseTypes.add(caseType);
        return caseTypes;
    }

    public String dealMessage(ApisBusiRequestRegist apisBusiRequestRegist, ClaimCaseStatusRequestDTO mqBody, String businessType) {
        if (!this.isHuiZeCase(apisBusiRequestRegist.getChannelCode())) {
            return null;
        }
        String status = this.getStatus(mqBody.getCaseStatus(), businessType);
        if (ObjectUtil.isEmpty((Object)status)) {
            return null;
        }
        if ("2".equals(businessType)) {
            return this.getPayStatusContent(apisBusiRequestRegist, status, mqBody);
        }
        if ("0".equals(businessType)) {
            return this.getCaseStatusContent(apisBusiRequestRegist, status, mqBody);
        }
        if ("1".equals(businessType)) {
            return this.getDocStatusContent(apisBusiRequestRegist, status, mqBody);
        }
        return null;
    }

    private String getDocStatusContent(ApisBusiRequestRegist apisBusiRequestRegist, String status, ClaimCaseStatusRequestDTO mqBody) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        Date date = new Date();
        HzRequest request = HzRequest.builder().request(HzCaseStatusRequest.builder().body(HzCaseStatusDto.builder().channelNo(CHANNEL_CODE).companyCaseId(apisBusiRequestRegist.getRegistNo()).transTime(simpleDateFormat.format(date)).caseStatus(status).actionContext(this.getActionContextList(mqBody)).build()).build()).build();
        return JSON.toJSONString((Object)request);
    }

    private List<ExtendInfo> getActionContextList(ClaimCaseStatusRequestDTO mqBody) {
        ArrayList<ExtendInfo> extendList = new ArrayList<ExtendInfo>();
        ArrayList<FileInfo> fileInfoList = new ArrayList<FileInfo>();
        for (ClaimDocCollectInfoDTO dto : mqBody.getCollectInfoList()) {
            if (!"0".equals(dto.getCollectInd())) continue;
            FileInfo fileInfo = FileInfo.builder().name(dto.getDocName()).reason("\u7ecf\u5ba1\u6838\uff0c\u6848\u4ef6\u5b58\u5728\u8d44\u6599\u7f3a\u5931\uff0c\u9700\u8981\u8865\u4ea4\u4ee5\u4e0b\u8d44\u6599").build();
            fileInfoList.add(fileInfo);
        }
        ExtendInfo extendInfo = ExtendInfo.builder().fileInfoList(fileInfoList).build();
        extendList.add(extendInfo);
        return extendList;
    }

    private String getCaseStatusContent(ApisBusiRequestRegist apisBusiRequestRegist, String status, ClaimCaseStatusRequestDTO mqBody) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        Date date = new Date();
        HzRequest request = HzRequest.builder().request(HzCaseStatusRequest.builder().body(HzCaseStatusDto.builder().channelNo(CHANNEL_CODE).companyCaseId(apisBusiRequestRegist.getRegistNo()).transTime(simpleDateFormat.format(date)).caseStatus(status).endCaseTime(simpleDateFormat.format(date)).build()).build()).build();
        return JSON.toJSONString((Object)request);
    }

    private String getPayStatusContent(ApisBusiRequestRegist apisBusiRequestRegist, String status, ClaimCaseStatusRequestDTO mqBody) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        HzRequest request = HzRequest.builder().request(HzCaseStatusRequest.builder().body(HzCaseStatusDto.builder().channelNo(CHANNEL_CODE).companyCaseId(apisBusiRequestRegist.getRegistNo()).transTime(simpleDateFormat.format(new Date())).caseStatus(status).endCaseTime(simpleDateFormat.format(new Date())).adjustmentExplain(mqBody.getIcText()).payAmount(mqBody.getSumRealPay().setScale(2, 5).toPlainString()).payStatus("01".equals(mqBody.getPayStatus()) ? "1" : "0").build()).build()).build();
        return JSON.toJSONString((Object)request);
    }

    private String getAgence() {
        ApisChannelConfigs channelConfigsCondition = new ApisChannelConfigs();
        channelConfigsCondition.setConfigCode("HUIZE-DEFAULT_CHANNEL");
        ApisChannelConfigs accs = this.apisChannelConfigsService.getChannelConfig(channelConfigsCondition);
        return ObjectUtil.isNotEmpty((Object)accs) ? accs.getChannelCode() : null;
    }

    private String getStatus(String value, String businessType) {
        String result = null;
        if ("2".equals(businessType)) {
            result = "5";
        }
        if ("1".equals(businessType)) {
            result = (String)BusinessConstants.CLAIM_CASE_STATUS_MQ.HUI_ZE_DOC_MAP.get(value);
        }
        if ("0".equals(businessType)) {
            result = (String)BusinessConstants.CLAIM_CASE_STATUS_MQ.HUI_ZE_CASESTATUS_MAP.get(value);
        }
        return result;
    }

    public boolean isHuiZePush(String businessType, String channelCode) {
        if (!this.isHuiZeCase(channelCode)) {
            return false;
        }
        return BusinessConstants.CLAIM_CASE_STATUS_MQ.HUI_ZE_SET.contains(businessType);
    }

    public boolean isHuiZeCase(String channelCode) {
        if (ObjectUtil.isEmpty((Object)channelCode)) {
            return false;
        }
        ApisChannelConfigs channelConfigsCondition = new ApisChannelConfigs();
        channelConfigsCondition.setConfigCode("HUIZE-DEFAULT_CHANNEL");
        channelConfigsCondition.setChannelCode(channelCode);
        ApisChannelConfigs accs = this.apisChannelConfigsService.getChannelConfig(channelConfigsCondition);
        return ObjectUtil.isNotEmpty((Object)accs);
    }

    public void notify(ApisBusiTaskLog busiTaskLog) {
        this.commonPushUtil.asyncNoticeAgent(busiTaskLog, HzResponseDTO.class);
    }
}

